/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.file.internal.FileCredentialStorage;
import org.picketlink.idm.file.internal.FilePartition;
import org.picketlink.idm.file.internal.FileRelationshipStorage;
import org.picketlink.idm.file.internal.FileUtils;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;

public class FileDataSource {
    private static final String DEFAULT_WORKING_DIR = System.getProperty("java.io.tmpdir", File.separator + "tmp") + File.separator + "pl-idm";
    private static final String GROUPS_FILE_NAME = "pl-idm-groups.db";
    private static final String CREDENTIALS_FILE_NAME = "pl-idm-credentials.db";
    private static final String RELATIONSHIPS_FILE_NAME = "pl-idm-relationships.db";
    private static final String ROLES_FILE_NAME = "pl-idm-roles.db";
    private static final String AGENTS_FILE_NAME = "pl-idm-agents.db";
    private String workingDir = DEFAULT_WORKING_DIR;
    private boolean alwaysCreateFiles = true;
    private Map<String, FilePartition> partitions = new HashMap<String, FilePartition>();
    private boolean initialized;
    private File partitionsFile;

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public boolean isAlwaysCreateFiles() {
        return this.alwaysCreateFiles;
    }

    public void setAlwaysCreateFiles(boolean alwaysCreateFiles) {
        this.alwaysCreateFiles = alwaysCreateFiles;
    }

    Map<String, Agent> getAgents(IdentityStoreInvocationContext context) {
        FilePartition partition;
        String realmId = "default";
        if (context.getRealm() != null) {
            realmId = context.getRealm().getId();
        }
        if ((partition = this.partitions.get(realmId)) == null) {
            partition = this.initPartition(realmId);
        }
        return partition.getAgents();
    }

    Map<String, Role> getRoles(String realmId) {
        FilePartition partition = this.partitions.get(realmId);
        if (partition == null) {
            partition = this.initPartition(realmId);
        }
        return partition.getRoles();
    }

    Map<String, List<FileRelationshipStorage>> getRelationships(IdentityStoreInvocationContext context) {
        String realmId = context.getPartition().getId();
        FilePartition partition = this.partitions.get(realmId);
        if (partition == null) {
            partition = this.initPartition(realmId);
        }
        return partition.getRelationships();
    }

    public FilePartition initPartition(String realmId) {
        String credentialsPath;
        File credentialsFile;
        Map credentials;
        String groupsPath;
        File groupsFile;
        Map groups;
        String rolesPath;
        File rolesFile;
        Map roles;
        String agentsPath;
        File agentsFile;
        Map agents;
        FilePartition partition = new FilePartition();
        String relationshipFilePath = this.getWorkingDir() + File.separator + realmId + File.separator + RELATIONSHIPS_FILE_NAME;
        File relationshipFile = FileUtils.createFileIfNotExists(new File(relationshipFilePath));
        Map relationships = (Map)FileUtils.readObject(relationshipFile);
        if (relationships != null) {
            partition.setRelationships(relationships);
        }
        if ((agents = (Map)FileUtils.readObject(agentsFile = FileUtils.createFileIfNotExists(new File(agentsPath = this.getWorkingDir() + File.separator + realmId + File.separator + AGENTS_FILE_NAME)))) != null) {
            partition.setAgents(agents);
        }
        if ((roles = (Map)FileUtils.readObject(rolesFile = FileUtils.createFileIfNotExists(new File(rolesPath = this.getWorkingDir() + File.separator + realmId + File.separator + ROLES_FILE_NAME)))) != null) {
            partition.setRoles(roles);
        }
        if ((groups = (Map)FileUtils.readObject(groupsFile = FileUtils.createFileIfNotExists(new File(groupsPath = this.getWorkingDir() + File.separator + realmId + File.separator + GROUPS_FILE_NAME)))) != null) {
            partition.setGroups(groups);
        }
        if ((credentials = (Map)FileUtils.readObject(credentialsFile = FileUtils.createFileIfNotExists(new File(credentialsPath = this.getWorkingDir() + File.separator + realmId + File.separator + CREDENTIALS_FILE_NAME)))) != null) {
            partition.setCredentials(credentials);
        }
        this.partitions.put(realmId, partition);
        return partition;
    }

    Map<String, Map<String, List<FileCredentialStorage>>> getCredentials(IdentityStoreInvocationContext context) {
        String realmId = context.getPartition().getId();
        FilePartition partition = this.partitions.get(realmId);
        if (partition == null) {
            partition = this.initPartition(realmId);
        }
        return partition.getCredentials();
    }

    Map<String, Group> getGroups(String realmId) {
        FilePartition partition = this.partitions.get(realmId);
        if (partition == null) {
            partition = this.initPartition(realmId);
        }
        return partition.getGroups();
    }

    void flushAgents(IdentityStoreInvocationContext context) {
        String realmId = "default";
        if (context.getRealm() != null) {
            realmId = context.getRealm().getId();
        }
        this.flush(realmId, AGENTS_FILE_NAME, this.partitions.get(realmId).getAgents());
    }

    synchronized void flushPartitions() {
        try {
            FileOutputStream fos = new FileOutputStream(this.partitionsFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.getPartitions());
            oos.close();
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error flushing partitions changes to file system.", (Throwable)e);
        }
    }

    void flushRoles(IdentityStoreInvocationContext context) {
        this.flush(context, ROLES_FILE_NAME, this.partitions.get(context.getPartition().getId()).getRoles());
    }

    void flushGroups(IdentityStoreInvocationContext context) {
        this.flush(context, GROUPS_FILE_NAME, this.partitions.get(context.getPartition().getId()).getGroups());
    }

    void flushCredentials(IdentityStoreInvocationContext context) {
        this.flush(context, CREDENTIALS_FILE_NAME, this.partitions.get(context.getPartition().getId()).getCredentials());
    }

    void flushRelationships(IdentityStoreInvocationContext context) {
        this.flush(context, RELATIONSHIPS_FILE_NAME, this.partitions.get(context.getPartition().getId()).getRelationships());
    }

    void flush(IdentityStoreInvocationContext context, String fileName, Object object) {
        try {
            String filePath = this.getWorkingDir() + File.separator + context.getPartition().getId() + File.separator + fileName;
            FileOutputStream fos = new FileOutputStream(filePath);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(object);
            oos.close();
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error flushing changes to file system.", (Throwable)e);
        }
    }

    void flush(String realmId, String fileName, Object object) {
        try {
            FileOutputStream fos = new FileOutputStream(this.getWorkingDir() + File.separator + realmId + File.separator + fileName);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(object);
            oos.close();
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error flushing changes to file system.", (Throwable)e);
        }
    }

    void initWorkingDirectory() {
        String workingDir = this.getWorkingDir();
        File workingDirectoryFile = new File(workingDir);
        if (workingDirectoryFile.exists() && this.isAlwaysCreateFiles()) {
            FileUtils.delete(workingDirectoryFile);
        }
        workingDirectoryFile.mkdirs();
        this.partitionsFile = FileUtils.createFileIfNotExists(new File(workingDirectoryFile.getPath() + "/pl-idm-partitions.db"));
    }

    public void init() {
        if (!this.initialized) {
            this.initWorkingDirectory();
            this.initialized = true;
        }
    }

    public Map<String, FilePartition> getPartitions() {
        return this.partitions;
    }

    public Map<String, Agent> getAgents(String realmId) {
        FilePartition partition = this.partitions.get(realmId);
        if (partition == null) {
            partition = this.initPartition(realmId);
        }
        return partition.getAgents();
    }
}

