/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.util.List;
import java.util.Map;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.file.internal.FileCredentialStorage;
import org.picketlink.idm.file.internal.FileDataSource;
import org.picketlink.idm.file.internal.FilePartition;
import org.picketlink.idm.file.internal.FileRelationshipStorage;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;

public class FileIdentityStoreConfiguration
extends IdentityStoreConfiguration {
    private IdentityStoreConfiguration.FeatureSet featureSet = new IdentityStoreConfiguration.FeatureSet((IdentityStoreConfiguration)this);
    private FileDataSource dataSource = new FileDataSource();

    public void init() throws SecurityConfigurationException {
        this.configureFeatureSet();
        this.dataSource.init();
    }

    private void configureFeatureSet() {
        this.featureSet.addSupportedFeature(IdentityStoreConfiguration.Feature.all);
    }

    public IdentityStoreConfiguration.FeatureSet getFeatureSet() {
        return this.featureSet;
    }

    public Map<String, List<FileRelationshipStorage>> getRelationships(IdentityStoreInvocationContext context) {
        return this.dataSource.getRelationships(context);
    }

    public Map<String, Role> getRoles(String realmId) {
        return this.dataSource.getRoles(realmId);
    }

    public Map<String, Group> getGroups(String realmId) {
        return this.dataSource.getGroups(realmId);
    }

    public Map<String, Agent> getAgents(IdentityStoreInvocationContext context) {
        return this.dataSource.getAgents(context);
    }

    public Map<String, Agent> getAgents(String realmId) {
        return this.dataSource.getAgents(realmId);
    }

    public Map<String, Map<String, List<FileCredentialStorage>>> getCredentials(IdentityStoreInvocationContext context) {
        return this.dataSource.getCredentials(context);
    }

    public void flushAgents(IdentityStoreInvocationContext context) {
        this.dataSource.flushAgents(context);
    }

    public void flushRoles(IdentityStoreInvocationContext context) {
        this.dataSource.flushRoles(context);
    }

    public void flushCredentials(IdentityStoreInvocationContext context) {
        this.dataSource.flushCredentials(context);
    }

    public void flushGroups(IdentityStoreInvocationContext context) {
        this.dataSource.flushGroups(context);
    }

    public void flushRelationships(IdentityStoreInvocationContext context) {
        this.dataSource.flushRelationships(context);
    }

    public void setDataSource(FileDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public FileDataSource getDataSource() {
        return this.dataSource;
    }

    public Map<String, FilePartition> getPartitions() {
        return this.getDataSource().getPartitions();
    }
}

