/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.StoreConfiguration;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.internal.DefaultStoreFactory;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupMembership;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.Tier;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.internal.DefaultIdentityQuery;
import org.picketlink.idm.query.internal.DefaultRelationshipQuery;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.IdentityStoreInvocationContextFactory;
import org.picketlink.idm.spi.PartitionStore;
import org.picketlink.idm.spi.StoreFactory;

public class DefaultIdentityManager
implements IdentityManager {
    private static final long serialVersionUID = -2835518073812662628L;
    private Map<String, Map<IdentityStoreConfiguration.Feature, Set<IdentityStoreConfiguration>>> realmStores = new HashMap<String, Map<IdentityStoreConfiguration.Feature, Set<IdentityStoreConfiguration>>>();
    private StoreFactory storeFactory = new DefaultStoreFactory();
    private IdentityStoreInvocationContextFactory contextFactory;
    private ThreadLocal<Realm> currentRealm = new ThreadLocal();
    private ThreadLocal<Tier> currentTier = new ThreadLocal();

    public IdentityManager forRealm(final Realm realm) {
        final DefaultIdentityManager proxied = this;
        final Tier tier = this.currentTier.get();
        return (IdentityManager)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IdentityManager.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result = null;
                try {
                    DefaultIdentityManager.this.currentRealm.set(realm);
                    DefaultIdentityManager.this.currentTier.set(tier);
                    result = method.invoke((Object)proxied, args);
                }
                catch (Exception e) {
                    if (e.getCause() != null) {
                        throw e.getCause();
                    }
                    throw e;
                }
                finally {
                    DefaultIdentityManager.this.currentRealm.remove();
                    DefaultIdentityManager.this.currentTier.remove();
                }
                return result;
            }
        });
    }

    public IdentityManager forTier(final Tier tier) {
        final DefaultIdentityManager proxied = this;
        final Realm realm = this.currentRealm.get();
        return (IdentityManager)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IdentityManager.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result = null;
                try {
                    DefaultIdentityManager.this.currentRealm.set(realm);
                    DefaultIdentityManager.this.currentTier.set(tier);
                    result = method.invoke((Object)proxied, args);
                }
                catch (Exception e) {
                    if (e.getCause() != null) {
                        throw e.getCause();
                    }
                    throw e;
                }
                finally {
                    DefaultIdentityManager.this.currentRealm.remove();
                    DefaultIdentityManager.this.currentTier.remove();
                }
                return result;
            }
        });
    }

    public void bootstrap(IdentityConfiguration identityConfig, IdentityStoreInvocationContextFactory contextFactory) {
        if (identityConfig == null) {
            throw new IllegalArgumentException("identityConfig is null");
        }
        if (contextFactory == null) {
            throw new IllegalArgumentException("contextFactory is null");
        }
        for (StoreConfiguration config : identityConfig.getConfiguredStores()) {
            Map<Object, Object> featureToStoreMap;
            config.init();
            if (!IdentityStoreConfiguration.class.isInstance(config)) continue;
            IdentityStoreConfiguration identityStoreConfig = (IdentityStoreConfiguration)config;
            if (identityStoreConfig.getFeatureSet() == null) {
                throw new SecurityConfigurationException("A feature set has not been configured for IdentityStoreConfiguration: " + config);
            }
            String realm = identityStoreConfig.getRealm();
            if (realm == null || realm.isEmpty()) {
                realm = "default";
            }
            if (this.realmStores.containsKey(realm)) {
                featureToStoreMap = this.realmStores.get(realm);
            } else {
                featureToStoreMap = new HashMap();
                this.realmStores.put(realm, featureToStoreMap);
            }
            for (IdentityStoreConfiguration.Feature f : IdentityStoreConfiguration.Feature.values()) {
                if (!identityStoreConfig.getFeatureSet().supports(f)) continue;
                if (!featureToStoreMap.containsKey(f)) {
                    featureToStoreMap.put(f, new HashSet());
                }
                ((Set)featureToStoreMap.get(f)).add(identityStoreConfig);
            }
        }
        this.contextFactory = contextFactory;
    }

    public void setIdentityStoreFactory(StoreFactory factory) {
        this.storeFactory = factory;
    }

    private IdentityStore<?> getContextualStoreForFeature(IdentityStoreInvocationContext ctx, IdentityStoreConfiguration.Feature feature) {
        return this.getContextualStoreForFeature(ctx, feature, null);
    }

    private IdentityStore<?> getContextualStoreForFeature(IdentityStoreInvocationContext ctx, IdentityStoreConfiguration.Feature feature, Class<? extends Relationship> relationshipClass) {
        Set<IdentityStoreConfiguration> stores;
        String realm;
        String string = realm = ctx.getRealm() != null ? ctx.getRealm().getName() : "default";
        if (!this.realmStores.containsKey(realm)) {
            throw new SecurityException("The specified realm '" + realm + "' has not been configured.");
        }
        IdentityStoreConfiguration config = null;
        Map<IdentityStoreConfiguration.Feature, Set<IdentityStoreConfiguration>> featureToStoreMap = this.realmStores.get(realm);
        if (featureToStoreMap.containsKey(feature)) {
            stores = featureToStoreMap.get(feature);
        } else if (featureToStoreMap.containsKey(IdentityStoreConfiguration.Feature.all)) {
            stores = featureToStoreMap.get(IdentityStoreConfiguration.Feature.all);
        } else {
            throw new SecurityConfigurationException("No identity store configuration found for requested feature [" + feature + "]");
        }
        if (stores.size() > 1) {
            throw new SecurityConfigurationException("Ambiguous security configuration - multiple identity stores have been configured for feature [" + feature + "]");
        }
        config = stores.iterator().next();
        if (config == null) {
            throw new SecurityConfigurationException("No identity store configuration found for requested feature [" + feature + "]");
        }
        if (relationshipClass != null && !config.getFeatureSet().supportsRelationship(relationshipClass)) {
            throw new SecurityConfigurationException("No identity store configuration found for requested feature [" + feature + "] with relationship type [" + relationshipClass.getName() + "]");
        }
        IdentityStore store = this.storeFactory.createIdentityStore(config, ctx);
        this.getContextFactory().initContextForStore(ctx, store);
        store.setup(config, ctx);
        return store;
    }

    private IdentityStoreInvocationContext createContext() {
        IdentityStoreInvocationContext context = this.getContextFactory().createContext();
        context.setRealm(this.currentRealm.get());
        context.setTier(this.currentTier.get());
        return context;
    }

    public void add(IdentityType identityType) {
        IdentityStoreConfiguration.Feature feature;
        IdentityStoreInvocationContext ctx = this.createContext();
        if (User.class.isInstance(identityType)) {
            feature = IdentityStoreConfiguration.Feature.createUser;
        } else if (Group.class.isInstance(identityType)) {
            if (ctx.getRealm() != null && ctx.getTier() != null) {
                throw new IllegalStateException("Ambiguous context state - Group may only be managed in either the scope of a Realm or a Tier, however both have been set.");
            }
            feature = IdentityStoreConfiguration.Feature.createGroup;
        } else if (Role.class.isInstance(identityType)) {
            if (ctx.getRealm() != null && ctx.getTier() != null) {
                throw new IllegalStateException("Ambiguous context state - Role may only be managed in either the scope of a Realm or a Tier, however both have been set.");
            }
            feature = IdentityStoreConfiguration.Feature.createRole;
        } else if (Agent.class.isInstance(identityType)) {
            feature = IdentityStoreConfiguration.Feature.createAgent;
        } else if (Relationship.class.isInstance(identityType)) {
            feature = IdentityStoreConfiguration.Feature.createRelationship;
        } else {
            throw new IllegalArgumentException("Unsupported IdentityType:" + identityType.getClass().getName());
        }
        this.getContextualStoreForFeature(ctx, feature).add((AttributedType)identityType);
    }

    public void add(Relationship relationship) {
        IdentityStoreConfiguration.Feature feature = IdentityStoreConfiguration.Feature.createRelationship;
        IdentityStoreInvocationContext ctx = this.createContext();
        this.getContextualStoreForFeature(ctx, feature).add((AttributedType)relationship);
    }

    public void update(IdentityType identityType) {
        IdentityStoreConfiguration.Feature feature;
        if (identityType.getId() == null) {
            throw new IdentityManagementException("No identifier was specified.");
        }
        IdentityStoreInvocationContext ctx = this.createContext();
        if (User.class.isInstance(identityType)) {
            feature = IdentityStoreConfiguration.Feature.updateUser;
        } else if (Agent.class.isInstance(identityType)) {
            feature = IdentityStoreConfiguration.Feature.updateAgent;
        } else if (Group.class.isInstance(identityType)) {
            if (ctx.getRealm() != null && ctx.getTier() != null) {
                throw new IllegalStateException("Ambiguous context state - Group may only be managed in either the scope of a Realm or a Tier, however both have been set.");
            }
            feature = IdentityStoreConfiguration.Feature.updateGroup;
        } else if (Role.class.isInstance(identityType)) {
            if (ctx.getRealm() != null && ctx.getTier() != null) {
                throw new IllegalStateException("Ambiguous context state - Role may only be managed in either the scope of a Realm or a Tier, however both have been set.");
            }
            feature = IdentityStoreConfiguration.Feature.updateRole;
        } else {
            throw new IllegalArgumentException("Unsupported IdentityType");
        }
        this.getContextualStoreForFeature(this.createContext(), feature).update((AttributedType)identityType);
    }

    public void update(Relationship relationship) {
        IdentityStoreConfiguration.Feature feature = IdentityStoreConfiguration.Feature.updateRelationship;
        IdentityStoreInvocationContext ctx = this.createContext();
        this.getContextualStoreForFeature(ctx, feature).update((AttributedType)relationship);
    }

    public void remove(IdentityType identityType) {
        IdentityStoreConfiguration.Feature feature;
        if (identityType.getId() == null) {
            throw new IdentityManagementException("No identifier was specified.");
        }
        IdentityStoreInvocationContext ctx = this.createContext();
        if (User.class.isInstance(identityType)) {
            feature = IdentityStoreConfiguration.Feature.deleteUser;
        } else if (Agent.class.isInstance(identityType)) {
            feature = IdentityStoreConfiguration.Feature.deleteAgent;
        } else if (Group.class.isInstance(identityType)) {
            if (ctx.getRealm() != null && ctx.getTier() != null) {
                throw new IllegalStateException("Ambiguous context state - Group may only be managed in either the scope of a Realm or a Tier, however both have been set.");
            }
            feature = IdentityStoreConfiguration.Feature.deleteGroup;
        } else if (Role.class.isInstance(identityType)) {
            if (ctx.getRealm() != null && ctx.getTier() != null) {
                throw new IllegalStateException("Ambiguous context state - Role may only be managed in either the scope of a Realm or a Tier, however both have been set.");
            }
            feature = IdentityStoreConfiguration.Feature.deleteRole;
        } else {
            throw new IllegalArgumentException("Unsupported IdentityType");
        }
        this.getContextualStoreForFeature(ctx, feature).remove((AttributedType)identityType);
    }

    public void remove(Relationship relationship) {
        IdentityStoreConfiguration.Feature feature = IdentityStoreConfiguration.Feature.deleteRelationship;
        IdentityStoreInvocationContext ctx = this.createContext();
        this.getContextualStoreForFeature(ctx, feature).remove((AttributedType)relationship);
    }

    public Agent getAgent(String id) {
        return this.getContextualStoreForFeature(this.createContext(), IdentityStoreConfiguration.Feature.readAgent).getAgent(id);
    }

    public User getUser(String id) {
        return this.getContextualStoreForFeature(this.createContext(), IdentityStoreConfiguration.Feature.readUser).getUser(id);
    }

    public Group getGroup(String groupId) {
        IdentityStoreInvocationContext ctx = this.createContext();
        if (ctx.getRealm() != null && ctx.getTier() != null) {
            throw new IllegalStateException("Ambiguous context state - Group may only be managed in either the scope of a Realm or a Tier, however both have been set.");
        }
        return this.getContextualStoreForFeature(ctx, IdentityStoreConfiguration.Feature.readGroup).getGroup(groupId);
    }

    public Group getGroup(String groupName, Group parent) {
        IdentityStoreInvocationContext ctx = this.createContext();
        if (ctx.getRealm() != null && ctx.getTier() != null) {
            throw new IllegalStateException("Ambiguous context state - Group may only be managed in either the scope of a Realm or a Tier, however both have been set.");
        }
        return this.getContextualStoreForFeature(ctx, IdentityStoreConfiguration.Feature.readGroup).getGroup(groupName, parent);
    }

    public boolean isMember(IdentityType identityType, Group group) {
        return this.getGroupMembership(identityType, group) != null;
    }

    private GroupMembership getGroupMembership(IdentityType identityType, Group group) {
        RelationshipQuery<GroupMembership> query = this.createRelationshipQuery(GroupMembership.class);
        query.setParameter((QueryParameter)GroupMembership.MEMBER, new Object[]{identityType});
        query.setParameter((QueryParameter)GroupMembership.GROUP, new Object[]{group});
        List result = query.getResultList();
        GroupMembership groupMembership = null;
        if (!result.isEmpty()) {
            groupMembership = (GroupMembership)result.get(0);
        }
        return groupMembership;
    }

    public void addToGroup(IdentityType member, Group group) {
        if (this.getGroupMembership(member, group) == null) {
            this.add((Relationship)new GroupMembership(member, group));
        }
    }

    public void removeFromGroup(IdentityType identityType, Group group) {
        GroupMembership groupMembership = this.getGroupMembership(identityType, group);
        if (groupMembership != null) {
            this.getContextualStoreForFeature(this.createContext(), IdentityStoreConfiguration.Feature.deleteRelationship).remove((AttributedType)groupMembership);
        }
    }

    public Role getRole(String name) {
        return this.getContextualStoreForFeature(this.createContext(), IdentityStoreConfiguration.Feature.readRole).getRole(name);
    }

    public boolean hasGroupRole(IdentityType identityType, Role role, Group group) {
        return this.getGroupRole(identityType, role, group) != null;
    }

    private GroupRole getGroupRole(IdentityType identityType, Role role, Group group) {
        RelationshipQuery<GroupRole> query = this.createRelationshipQuery(GroupRole.class);
        query.setParameter((QueryParameter)GroupRole.MEMBER, new Object[]{identityType});
        query.setParameter((QueryParameter)GroupRole.ROLE, new Object[]{role});
        query.setParameter((QueryParameter)GroupRole.GROUP, new Object[]{group});
        List result = query.getResultList();
        GroupRole groupRole = null;
        if (!result.isEmpty()) {
            groupRole = (GroupRole)result.get(0);
        }
        return groupRole;
    }

    public void grantGroupRole(IdentityType member, Role role, Group group) {
        if (this.getGroupRole(member, role, group) == null) {
            this.add((Relationship)new GroupRole(member, group, role));
        }
    }

    public void revokeGroupRole(IdentityType identityType, Role role, Group group) {
        GroupRole groupRole = this.getGroupRole(identityType, role, group);
        if (groupRole != null) {
            this.getContextualStoreForFeature(this.createContext(), IdentityStoreConfiguration.Feature.deleteRelationship).remove((AttributedType)groupRole);
        }
    }

    public boolean hasRole(IdentityType identityType, Role role) {
        return this.getGrant(identityType, role) != null;
    }

    private Grant getGrant(IdentityType identityType, Role role) {
        RelationshipQuery<Grant> query = this.createRelationshipQuery(Grant.class);
        query.setParameter((QueryParameter)Grant.ASSIGNEE, new Object[]{identityType});
        query.setParameter((QueryParameter)Grant.ROLE, new Object[]{role});
        List result = query.getResultList();
        Grant grant = null;
        if (!result.isEmpty()) {
            grant = (Grant)result.get(0);
        }
        return grant;
    }

    public void grantRole(IdentityType identityType, Role role) {
        if (this.getGrant(identityType, role) == null) {
            this.add((Relationship)new Grant(identityType, role));
        }
    }

    public void revokeRole(IdentityType identityType, Role role) {
        Grant grant = this.getGrant(identityType, role);
        if (grant != null) {
            this.getContextualStoreForFeature(this.createContext(), IdentityStoreConfiguration.Feature.deleteRelationship).remove((AttributedType)grant);
        }
    }

    public void validateCredentials(Credentials credentials) {
        IdentityStore<?> store = this.getContextualStoreForFeature(this.createContext(), IdentityStoreConfiguration.Feature.manageCredentials);
        store.validateCredentials(credentials);
    }

    public void updateCredential(Agent agent, Object value) {
        this.updateCredential(agent, value, new Date(), null);
    }

    public void updateCredential(Agent agent, Object credential, Date effectiveDate, Date expiryDate) {
        IdentityStore<?> store = this.getContextualStoreForFeature(this.createContext(), IdentityStoreConfiguration.Feature.manageCredentials);
        store.updateCredential(agent, credential, effectiveDate, expiryDate);
    }

    public IdentityStoreInvocationContextFactory getContextFactory() {
        return this.contextFactory;
    }

    public <T extends IdentityType> IdentityQuery<T> createIdentityQuery(Class<T> identityType) {
        return new DefaultIdentityQuery<T>(identityType, this.getContextualStoreForFeature(this.createContext(), IdentityStoreConfiguration.Feature.readUser));
    }

    public <T extends Relationship> RelationshipQuery<T> createRelationshipQuery(Class<T> relationshipType) {
        return new DefaultRelationshipQuery<T>(relationshipType, this.getContextualStoreForFeature(this.createContext(), IdentityStoreConfiguration.Feature.readRelationship));
    }

    public void createRealm(Realm realm) {
        this.checkCreateNullPartition((Partition)realm);
        this.checkCreateNullPartitionName((Partition)realm);
        this.getContextualPartitionStore().createPartition((Partition)realm);
    }

    private void checkCreateNullPartitionName(Partition partition) {
        if (partition.getName() == null) {
            throw new IdentityManagementException("Realm name must not be null");
        }
    }

    private void checkCreateNullPartition(Partition partition) {
        if (partition == null) {
            throw new IdentityManagementException("Partition must not be null.");
        }
    }

    public void removeRealm(Realm realm) {
        this.checkNotNullId((Partition)realm);
        this.getContextualPartitionStore().removePartition((Partition)realm);
    }

    private void checkNotNullId(Partition partition) {
        if (partition.getId() == null) {
            throw new IdentityManagementException("No identifier provided.");
        }
    }

    public Realm getRealm(String name) {
        return this.getContextualPartitionStore().getRealm(name);
    }

    public void createTier(Tier tier) {
        this.checkCreateNullPartition((Partition)tier);
        this.checkCreateNullPartitionName((Partition)tier);
        this.getContextualPartitionStore().createPartition((Partition)tier);
    }

    private PartitionStore getContextualPartitionStore() {
        IdentityStore<?> store = this.getContextualStoreForFeature(this.createContext(), IdentityStoreConfiguration.Feature.managePartitions);
        if (PartitionStore.class.isInstance(store)) {
            return (PartitionStore)store;
        }
        throw new IdentityManagementException("No PartitionStore configured.");
    }

    public void removeTier(Tier tier) {
        this.checkNotNullId((Partition)tier);
        this.getContextualPartitionStore().removePartition((Partition)tier);
    }

    public Tier getTier(String id) {
        return this.getContextualPartitionStore().getTier(id);
    }

    public void loadAttribute(IdentityType identityType, String attributeName) {
    }

    public <T extends IdentityType> T lookupIdentityById(Class<T> identityType, String id) {
        IdentityQuery<T> query = this.createIdentityQuery(identityType);
        query.setParameter(IdentityType.ID, new Object[]{id});
        List result = query.getResultList();
        IdentityType identity = null;
        if (!result.isEmpty()) {
            if (result.size() > 1) {
                throw new IdentityManagementException("Ambiguous IdentityType for identifier [" + id + "].");
            }
            identity = (IdentityType)result.get(0);
        }
        return (T)identity;
    }
}

