/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.picketlink.idm.DefaultIdentityCache;
import org.picketlink.idm.IdGenerator;
import org.picketlink.idm.IdentityCache;
import org.picketlink.idm.credential.internal.DefaultCredentialHandlerFactory;
import org.picketlink.idm.credential.spi.CredentialHandlerFactory;
import org.picketlink.idm.event.EventBridge;
import org.picketlink.idm.internal.DefaultIdGenerator;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.IdentityStoreInvocationContextFactory;
import org.picketlink.idm.spi.PartitionStore;

public class DefaultIdentityStoreInvocationContextFactory
implements IdentityStoreInvocationContextFactory {
    private EntityManagerFactory emf;
    private EventBridge eventBridge = new EventBridge(){

        public void raiseEvent(Object event) {
        }
    };
    private CredentialHandlerFactory credentialHandlerFactory = new DefaultCredentialHandlerFactory();
    private IdentityCache identityCache = new DefaultIdentityCache();
    private IdGenerator idGenerator = new DefaultIdGenerator();
    private EntityManager entityManager;
    public static DefaultIdentityStoreInvocationContextFactory DEFAULT = new DefaultIdentityStoreInvocationContextFactory(null, new DefaultCredentialHandlerFactory());

    public DefaultIdentityStoreInvocationContextFactory() {
    }

    public DefaultIdentityStoreInvocationContextFactory(EntityManagerFactory emf) {
        this();
        this.emf = emf;
    }

    public DefaultIdentityStoreInvocationContextFactory(EntityManagerFactory emf, CredentialHandlerFactory chf) {
        this(emf);
        this.credentialHandlerFactory = chf;
    }

    public DefaultIdentityStoreInvocationContextFactory(EntityManagerFactory emf, CredentialHandlerFactory chf, IdentityCache identityCache) {
        this(emf, chf);
        this.identityCache = identityCache;
    }

    public IdentityStoreInvocationContext createContext() {
        return new IdentityStoreInvocationContext(this.identityCache, this.eventBridge, this.credentialHandlerFactory, this.idGenerator);
    }

    public void initContextForStore(IdentityStoreInvocationContext ctx, IdentityStore<?> store) {
        if (store instanceof JPAIdentityStore && !ctx.isParameterSet("CTX_ENTITY_MANAGER")) {
            ctx.setParameter("CTX_ENTITY_MANAGER", (Object)this.getEntityManager());
        }
    }

    public EntityManager getEntityManager() {
        if (this.entityManager == null) {
            this.entityManager = this.emf.createEntityManager();
        }
        return this.entityManager;
    }

    public void setEntityManager(EntityManager em) {
        this.entityManager = em;
    }

    public void initContextForStore(IdentityStoreInvocationContext ctx, PartitionStore store) {
        if (store instanceof JPAIdentityStore && !ctx.isParameterSet("CTX_ENTITY_MANAGER")) {
            ctx.setParameter("CTX_ENTITY_MANAGER", (Object)this.getEntityManager());
        }
    }
}

