/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.jpa.annotations.PropertyType;
import org.picketlink.idm.jpa.internal.JPACriteriaQueryBuilder;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.jpa.internal.JPAIdentityStoreConfiguration;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.GroupMembership;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Tier;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.internal.DefaultRelationshipQuery;

public abstract class IdentityTypeHandler<T extends IdentityType> {
    private JPAIdentityStoreConfiguration config;

    public IdentityTypeHandler(JPAIdentityStoreConfiguration config) {
        this.config = config;
    }

    public T createIdentityType(Object identity, JPAIdentityStore store) {
        T identityType = this.doCreateIdentityType(identity, store);
        identityType.setId(this.getConfig().getModelPropertyValue(String.class, identity, PropertyType.IDENTITY_ID));
        identityType.setEnabled(this.getConfig().getModelPropertyValue(Boolean.class, identity, PropertyType.IDENTITY_ENABLED).booleanValue());
        Object partitionObject = this.getConfig().getModelPropertyValue(this.getConfig().getPartitionClass(), identity, PropertyType.IDENTITY_PARTITION);
        Partition partition = store.convertPartitionEntityToPartition(partitionObject);
        identityType.setPartition(partition);
        identityType.setExpirationDate(this.getConfig().getModelPropertyValue(Date.class, identity, PropertyType.IDENTITY_EXPIRY_DATE));
        identityType.setCreatedDate(this.getConfig().getModelPropertyValue(Date.class, identity, PropertyType.IDENTITY_CREATION_DATE));
        return identityType;
    }

    public Object createEntity(T fromIdentityType, JPAIdentityStore store) {
        Object identity = null;
        try {
            identity = this.getConfig().getIdentityClass().newInstance();
            String id = store.getContext().getIdGenerator().generate();
            this.getConfig().getModelProperty(PropertyType.IDENTITY_ID).setValue(identity, id);
            fromIdentityType.setId(id);
            this.populateEntity(identity, fromIdentityType, store);
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error creating/populating Identity instance from IdentityType.", (Throwable)e);
        }
        return identity;
    }

    protected void populateEntity(Object toIdentity, T fromIdentityType, JPAIdentityStore store) {
        String identityDiscriminator = this.getConfig().getIdentityDiscriminator(fromIdentityType.getClass());
        this.getConfig().setModelPropertyValue(toIdentity, PropertyType.IDENTITY_DISCRIMINATOR, identityDiscriminator, true);
        this.getConfig().setModelPropertyValue(toIdentity, PropertyType.IDENTITY_ENABLED, fromIdentityType.isEnabled(), true);
        this.getConfig().setModelPropertyValue(toIdentity, PropertyType.IDENTITY_CREATION_DATE, fromIdentityType.getCreatedDate(), true);
        this.getConfig().setModelPropertyValue(toIdentity, PropertyType.IDENTITY_EXPIRY_DATE, fromIdentityType.getExpirationDate());
        this.doPopulateIdentityInstance(toIdentity, fromIdentityType, store);
    }

    void remove(Object identity, T identityType, JPAIdentityStore store) {
    }

    public List<Predicate> getPredicate(JPACriteriaQueryBuilder criteria, JPAIdentityStore store) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.findById(criteria, predicates);
        this.findByPartition(criteria, store, predicates);
        this.findByEnabled(criteria, predicates);
        this.findByCreationDate(criteria, predicates);
        this.findByExpiryDate(criteria, predicates);
        this.findByCreatedAfter(criteria, predicates);
        this.findByExpiryAfter(criteria, predicates);
        this.findByCreatedBefore(criteria, predicates);
        this.findByExpiryBefore(criteria, predicates);
        this.findByGroupRole(criteria, store, predicates);
        this.findByMemberOf(criteria, store, predicates);
        this.findByHasRole(criteria, store, predicates);
        this.findByAttributes(criteria, predicates);
        return predicates;
    }

    protected abstract T doCreateIdentityType(Object var1, JPAIdentityStore var2);

    protected abstract void doPopulateIdentityInstance(Object var1, T var2, JPAIdentityStore var3);

    protected abstract AbstractBaseEvent raiseCreatedEvent(T var1);

    protected abstract AbstractBaseEvent raiseUpdatedEvent(T var1);

    protected abstract AbstractBaseEvent raiseDeletedEvent(T var1);

    public void validate(T identityType, JPAIdentityStore store) {
    }

    private void findByAttributes(JPACriteriaQueryBuilder criteria, List<Predicate> predicates) {
        Map parameters = criteria.getIdentityQuery().getParameters(AttributedType.AttributeParameter.class);
        Set entrySet = parameters.entrySet();
        for (Map.Entry entry : entrySet) {
            AttributedType.AttributeParameter customParameter = (AttributedType.AttributeParameter)entry.getKey();
            Object[] attributeValues = (Object[])entry.getValue();
            Subquery subquery = criteria.getCriteria().subquery(this.getConfig().getAttributeClass());
            Root fromProject = subquery.from(this.getConfig().getAttributeClass());
            subquery.select((Expression)fromProject.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY).getName()));
            Predicate conjunction = criteria.getBuilder().conjunction();
            conjunction.getExpressions().add(criteria.getBuilder().equal((Expression)fromProject.get(this.getConfig().getModelProperty(PropertyType.ATTRIBUTE_NAME).getName()), (Object)customParameter.getName()));
            conjunction.getExpressions().add(fromProject.get(this.getConfig().getModelProperty(PropertyType.ATTRIBUTE_VALUE).getName()).in(attributeValues));
            subquery.where((Expression)conjunction);
            subquery.groupBy(new Expression[]{subquery.getSelection()}).having((Expression)criteria.getBuilder().equal(criteria.getBuilder().count(subquery.getSelection()), (Object)attributeValues.length));
            predicates.add((Predicate)criteria.getBuilder().in(criteria.getRoot()).value((Expression)subquery));
        }
    }

    private void findByHasRole(JPACriteriaQueryBuilder criteria, JPAIdentityStore store, List<Predicate> predicates) {
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(IdentityType.HAS_ROLE);
        if (parameterValues != null) {
            for (Object roleName : parameterValues) {
                DefaultRelationshipQuery<Grant> query = new DefaultRelationshipQuery<Grant>(Grant.class, store);
                query.setParameter((QueryParameter)Grant.ROLE, store.getRole(roleName.toString()));
                List<Grant> resultList = query.getResultList();
                if (!resultList.isEmpty()) {
                    ArrayList<String> relIds = new ArrayList<String>();
                    for (Grant memberships : resultList) {
                        relIds.add(memberships.getId());
                    }
                    Subquery subquery = criteria.getCriteria().subquery(store.getConfig().getRelationshipIdentityClass());
                    Root fromProject = subquery.from(store.getConfig().getRelationshipIdentityClass());
                    subquery.select((Expression)fromProject.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY).getName()));
                    Join join = fromProject.join(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY_RELATIONSHIP).getName());
                    ArrayList<Object> subqueryPredicates = new ArrayList<Object>();
                    subqueryPredicates.add(criteria.getBuilder().equal((Expression)fromProject.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_DESCRIPTOR).getName()), (Object)Grant.ASSIGNEE.getName()));
                    subqueryPredicates.add(criteria.getBuilder().equal((Expression)fromProject.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY).getName()), criteria.getRoot()));
                    subqueryPredicates.add(criteria.getBuilder().in((Expression)join.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ID).getName())).value(relIds));
                    subquery.where(subqueryPredicates.toArray(new Predicate[subqueryPredicates.size()]));
                    predicates.add((Predicate)criteria.getBuilder().in(criteria.getRoot()).value((Expression)subquery));
                    continue;
                }
                predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(this.getConfig().getModelProperty(PropertyType.IDENTITY_ID).getName()), (Object)"-1"));
            }
        }
    }

    private void findByMemberOf(JPACriteriaQueryBuilder criteria, JPAIdentityStore store, List<Predicate> predicates) {
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(IdentityType.MEMBER_OF);
        if (parameterValues != null) {
            for (Object groupName : parameterValues) {
                DefaultRelationshipQuery<GroupMembership> query = new DefaultRelationshipQuery<GroupMembership>(GroupMembership.class, store);
                query.setParameter((QueryParameter)GroupMembership.GROUP, store.getGroup(groupName.toString()));
                List<GroupMembership> resultList = query.getResultList();
                if (!resultList.isEmpty()) {
                    ArrayList<String> relIds = new ArrayList<String>();
                    for (GroupMembership memberships : resultList) {
                        relIds.add(memberships.getId());
                    }
                    Subquery subquery = criteria.getCriteria().subquery(store.getConfig().getRelationshipIdentityClass());
                    Root fromProject = subquery.from(store.getConfig().getRelationshipIdentityClass());
                    subquery.select((Expression)fromProject.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY).getName()));
                    Join join = fromProject.join(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY_RELATIONSHIP).getName());
                    ArrayList<Object> subqueryPredicates = new ArrayList<Object>();
                    subqueryPredicates.add(criteria.getBuilder().equal((Expression)fromProject.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_DESCRIPTOR).getName()), (Object)GroupMembership.MEMBER.getName()));
                    subqueryPredicates.add(criteria.getBuilder().equal((Expression)fromProject.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY).getName()), criteria.getRoot()));
                    subqueryPredicates.add(criteria.getBuilder().in((Expression)join.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ID).getName())).value(relIds));
                    subquery.where(subqueryPredicates.toArray(new Predicate[subqueryPredicates.size()]));
                    predicates.add((Predicate)criteria.getBuilder().in(criteria.getRoot()).value((Expression)subquery));
                    continue;
                }
                predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(this.getConfig().getModelProperty(PropertyType.IDENTITY_ID).getName()), (Object)"-1"));
            }
        }
    }

    private void findByGroupRole(JPACriteriaQueryBuilder criteria, JPAIdentityStore store, List<Predicate> predicates) {
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(IdentityType.HAS_GROUP_ROLE);
        if (parameterValues != null) {
            for (Object object : parameterValues) {
                GroupRole groupRole = (GroupRole)object;
                DefaultRelationshipQuery<GroupRole> query = new DefaultRelationshipQuery<GroupRole>(GroupRole.class, store);
                query.setParameter((QueryParameter)GroupRole.MEMBER, groupRole.getMember());
                query.setParameter((QueryParameter)GroupRole.GROUP, groupRole.getGroup());
                query.setParameter((QueryParameter)GroupRole.ROLE, groupRole.getRole());
                List<GroupRole> resultList = query.getResultList();
                if (!resultList.isEmpty()) {
                    ArrayList<String> relIds = new ArrayList<String>();
                    for (GroupRole memberships : resultList) {
                        relIds.add(memberships.getId());
                    }
                    Subquery subquery = criteria.getCriteria().subquery(store.getConfig().getRelationshipIdentityClass());
                    Root fromProject = subquery.from(store.getConfig().getRelationshipIdentityClass());
                    subquery.select((Expression)fromProject.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY).getName()));
                    Join join = fromProject.join(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY_RELATIONSHIP).getName());
                    ArrayList<Object> subqueryPredicates = new ArrayList<Object>();
                    subqueryPredicates.add(criteria.getBuilder().equal((Expression)fromProject.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_DESCRIPTOR).getName()), (Object)GroupRole.MEMBER.getName()));
                    subqueryPredicates.add(criteria.getBuilder().equal((Expression)fromProject.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY).getName()), criteria.getRoot()));
                    subqueryPredicates.add(criteria.getBuilder().in((Expression)join.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ID).getName())).value(relIds));
                    subquery.where(subqueryPredicates.toArray(new Predicate[subqueryPredicates.size()]));
                    predicates.add((Predicate)criteria.getBuilder().in(criteria.getRoot()).value((Expression)subquery));
                    continue;
                }
                predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(this.getConfig().getModelProperty(PropertyType.IDENTITY_ID).getName()), (Object)"-1"));
            }
        }
    }

    private void findByExpiryBefore(JPACriteriaQueryBuilder criteria, List<Predicate> predicates) {
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(IdentityType.EXPIRY_BEFORE);
        if (parameterValues != null) {
            predicates.add(criteria.getBuilder().lessThanOrEqualTo((Expression)criteria.getRoot().get(this.getConfig().getModelProperty(PropertyType.IDENTITY_EXPIRY_DATE).getName()), (Comparable)((Date)parameterValues[0])));
        }
    }

    private void findByCreatedBefore(JPACriteriaQueryBuilder criteria, List<Predicate> predicates) {
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(IdentityType.CREATED_BEFORE);
        if (parameterValues != null) {
            predicates.add(criteria.getBuilder().lessThanOrEqualTo((Expression)criteria.getRoot().get(this.getConfig().getModelProperty(PropertyType.IDENTITY_CREATION_DATE).getName()), (Comparable)((Date)parameterValues[0])));
        }
    }

    private void findByExpiryAfter(JPACriteriaQueryBuilder criteria, List<Predicate> predicates) {
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(IdentityType.EXPIRY_AFTER);
        if (parameterValues != null) {
            predicates.add(criteria.getBuilder().greaterThanOrEqualTo((Expression)criteria.getRoot().get(this.getConfig().getModelProperty(PropertyType.IDENTITY_EXPIRY_DATE).getName()), (Comparable)((Date)parameterValues[0])));
        }
    }

    private void findByCreatedAfter(JPACriteriaQueryBuilder criteria, List<Predicate> predicates) {
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(IdentityType.CREATED_AFTER);
        if (parameterValues != null) {
            predicates.add(criteria.getBuilder().greaterThanOrEqualTo((Expression)criteria.getRoot().get(this.getConfig().getModelProperty(PropertyType.IDENTITY_CREATION_DATE).getName()), (Comparable)((Date)parameterValues[0])));
        }
    }

    private void findByExpiryDate(JPACriteriaQueryBuilder criteria, List<Predicate> predicates) {
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(IdentityType.EXPIRY_DATE);
        if (parameterValues != null) {
            predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(this.getConfig().getModelProperty(PropertyType.IDENTITY_EXPIRY_DATE).getName()), parameterValues[0]));
        }
    }

    private void findByCreationDate(JPACriteriaQueryBuilder criteria, List<Predicate> predicates) {
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(IdentityType.CREATED_DATE);
        if (parameterValues != null) {
            predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(this.getConfig().getModelProperty(PropertyType.IDENTITY_CREATION_DATE).getName()), parameterValues[0]));
        }
    }

    private void findByEnabled(JPACriteriaQueryBuilder criteria, List<Predicate> predicates) {
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(IdentityType.ENABLED);
        if (parameterValues != null) {
            predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(this.getConfig().getModelProperty(PropertyType.IDENTITY_ENABLED).getName()), parameterValues[0]));
        }
    }

    private void findByPartition(JPACriteriaQueryBuilder criteria, JPAIdentityStore store, List<Predicate> predicates) {
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(IdentityType.PARTITION);
        if (parameterValues != null) {
            Partition partition = (Partition)parameterValues[0];
            predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(this.getConfig().getModelProperty(PropertyType.IDENTITY_PARTITION).getName()), store.lookupPartitionObject(partition)));
        } else {
            Join joinPartition = criteria.getRoot().join(this.getConfig().getModelProperty(PropertyType.IDENTITY_PARTITION).getName());
            if (criteria.getIdentityQuery().getParameter(IdentityType.PARTITION) == null) {
                ArrayList<String> partitionIds = new ArrayList<String>();
                partitionIds.add(store.getCurrentRealm().getId());
                if (Tier.class.isInstance(store.getCurrentPartition())) {
                    this.populateAllowedTierIds(partitionIds, (Tier)store.getCurrentPartition());
                }
                predicates.add((Predicate)criteria.getBuilder().in((Expression)joinPartition.get(this.getConfig().getModelProperty(PropertyType.PARTITION_ID).getName())).value(partitionIds));
            }
        }
    }

    private void findById(JPACriteriaQueryBuilder criteria, List<Predicate> predicates) {
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(IdentityType.ID);
        if (parameterValues != null) {
            predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(this.getConfig().getModelProperty(PropertyType.IDENTITY_ID).getName()), parameterValues[0]));
        }
    }

    protected JPAIdentityStoreConfiguration getConfig() {
        return this.config;
    }

    private void populateAllowedTierIds(List<String> partitionIds, Tier currentPartition) {
        partitionIds.add(currentPartition.getId());
        if (currentPartition.getParent() != null) {
            this.populateAllowedTierIds(partitionIds, currentPartition.getParent());
        }
    }
}

