/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.internal.util.properties.Property;
import org.picketlink.idm.jpa.annotations.PropertyType;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.jpa.internal.JPAIdentityStoreConfiguration;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Tier;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.PartitionStore;

public class JPAPartitionStore
implements PartitionStore {
    private JPAIdentityStore identityStore;

    public JPAPartitionStore(JPAIdentityStore identityStore) {
        this.identityStore = identityStore;
        if (this.getRealm("default") == null) {
            this.createDefaultRealm();
        }
    }

    public void createPartition(Partition partition) {
        Tier tier;
        Tier parentTier;
        Property<Object> idProperty = this.getConfig().getModelProperty(PropertyType.PARTITION_ID);
        Property<Object> nameProperty = this.getConfig().getModelProperty(PropertyType.PARTITION_NAME);
        Property<Object> typeProperty = this.getConfig().getModelProperty(PropertyType.PARTITION_TYPE);
        Class<?> partitionClass = this.getConfig().getPartitionClass();
        Object partitionObject = null;
        try {
            partitionObject = partitionClass.newInstance();
        }
        catch (Exception e) {
            throw new IdentityManagementException("Could not instantiate Partition class [" + partitionClass.getName() + "]");
        }
        String id = this.getContext().getIdGenerator().generate();
        partition.setId(id);
        idProperty.setValue(partitionObject, partition.getId());
        nameProperty.setValue(partitionObject, partition.getName());
        typeProperty.setValue(partitionObject, partition.getClass().getName());
        if (Tier.class.isInstance(partition) && (parentTier = (tier = (Tier)partition).getParent()) != null) {
            Property<Object> parentProperty = this.getConfig().getModelProperty(PropertyType.PARTITION_PARENT);
            parentProperty.setValue(partitionObject, this.lookupPartitionObject((Partition)parentTier));
        }
        EntityManager em = this.getEntityManager();
        em.persist(partitionObject);
        em.flush();
    }

    private IdentityStoreInvocationContext getContext() {
        return this.identityStore.getContext();
    }

    private JPAIdentityStoreConfiguration getConfig() {
        return this.identityStore.getConfig();
    }

    public Realm getRealm(String realmName) {
        return this.convertPartitionEntityToRealm(this.lookupPartitionEntityByName(Realm.class, realmName));
    }

    public Tier getTier(String tierName) {
        return this.convertPartitionEntityToTier(this.lookupPartitionEntityByName(Tier.class, tierName));
    }

    public void removePartition(Partition partition) {
        if (partition.getId() == null) {
            throw new IdentityManagementException("No identifier provided.");
        }
        Object partitionObject = this.lookupPartitionObject(partition);
        if (partitionObject == null) {
            throw new IdentityManagementException("No Partition found with the given id [" + partition.getId() + "].");
        }
        EntityManager entityManager = this.getEntityManager();
        List<?> associatedIdentityTypes = this.getIdentityTypesForPartition(partitionObject);
        if (!associatedIdentityTypes.isEmpty()) {
            throw new IdentityManagementException("Partition could not be removed. There are IdentityTypes associated with it. Remove them first.");
        }
        List<?> childPartitions = this.getChildPartitions(partitionObject);
        if (!childPartitions.isEmpty()) {
            throw new IdentityManagementException("Partition could not be removed. There are child partitions associated with it. Remove them first.");
        }
        entityManager.remove(partitionObject);
        entityManager.flush();
    }

    protected Object lookupPartitionEntityByName(Class<? extends Partition> partitionType, String name) {
        if (name == null) {
            throw new IdentityManagementException("Tier name was not provided.");
        }
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        Class<?> partitionClass = this.getConfig().getPartitionClass();
        CriteriaQuery criteria = builder.createQuery(partitionClass);
        Root root = criteria.from(partitionClass);
        Predicate whereType = builder.equal((Expression)root.get(this.getConfig().getModelProperty(PropertyType.PARTITION_TYPE).getName()), (Object)partitionType.getName());
        Predicate whereName = builder.equal((Expression)root.get(this.getConfig().getModelProperty(PropertyType.PARTITION_NAME).getName()), (Object)name);
        criteria.where(new Predicate[]{whereName, whereType});
        Object partitionObject = null;
        try {
            partitionObject = entityManager.createQuery(criteria).getSingleResult();
        }
        catch (NonUniqueResultException nuoe) {
            throw new IdentityManagementException("Abiguous Tier found with the given name [" + name + "]");
        }
        catch (NoResultException ignore) {
            // empty catch block
        }
        return partitionObject;
    }

    private void createDefaultRealm() {
        this.createPartition((Partition)new Realm("default"));
    }

    protected Partition convertPartitionEntityToPartition(Object partitionObject) {
        Property<Object> typeProperty = this.getConfig().getModelProperty(PropertyType.PARTITION_TYPE);
        String type = typeProperty.getValue(partitionObject).toString();
        Realm partition = null;
        if (Realm.class.getName().equals(type)) {
            partition = this.convertPartitionEntityToRealm(partitionObject);
        } else if (Tier.class.getName().equals(type)) {
            partition = this.convertPartitionEntityToTier(partitionObject);
        } else {
            throw new IdentityManagementException("Unsupported Partition type [" + type + "].");
        }
        return partition;
    }

    protected Object lookupPartitionObject(Partition partition) {
        EntityManager entityManager = this.getEntityManager();
        return entityManager.find(this.getConfig().getPartitionClass(), (Object)partition.getId());
    }

    private List<?> getChildPartitions(Object partitionObject) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getPartitionClass());
        Root root = criteria.from(this.getConfig().getPartitionClass());
        Predicate wherePartition = builder.equal((Expression)root.get(this.getConfig().getModelProperty(PropertyType.PARTITION_PARENT).getName()), partitionObject);
        criteria.where((Expression)wherePartition);
        return entityManager.createQuery(criteria).getResultList();
    }

    private List<?> getIdentityTypesForPartition(Object partitionObject) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getIdentityClass());
        Root root = criteria.from(this.getConfig().getIdentityClass());
        Predicate wherePartition = builder.equal((Expression)root.get(this.getConfig().getModelProperty(PropertyType.IDENTITY_PARTITION).getName()), partitionObject);
        criteria.where((Expression)wherePartition);
        return entityManager.createQuery(criteria).getResultList();
    }

    private Realm convertPartitionEntityToRealm(Object partitionObject) {
        Realm realm = null;
        if (partitionObject != null) {
            Property<Object> typeProperty = this.getConfig().getModelProperty(PropertyType.PARTITION_TYPE);
            if (Realm.class.getName().equals(typeProperty.getValue(partitionObject).toString())) {
                Property<Object> idProperty = this.getConfig().getModelProperty(PropertyType.PARTITION_ID);
                Property<Object> nameProperty = this.getConfig().getModelProperty(PropertyType.PARTITION_NAME);
                realm = new Realm(nameProperty.getValue(partitionObject).toString());
                realm.setId(idProperty.getValue(partitionObject).toString());
            }
        }
        return realm;
    }

    private Tier convertPartitionEntityToTier(Object partitionObject) {
        Tier tier = null;
        if (partitionObject != null) {
            Property<Object> typeProperty = this.getConfig().getModelProperty(PropertyType.PARTITION_TYPE);
            if (Tier.class.getName().equals(typeProperty.getValue(partitionObject).toString())) {
                Property<Object> idProperty = this.getConfig().getModelProperty(PropertyType.PARTITION_ID);
                Property<Object> nameProperty = this.getConfig().getModelProperty(PropertyType.PARTITION_NAME);
                Property<Object> parentProperty = this.getConfig().getModelProperty(PropertyType.PARTITION_PARENT);
                Object parentTierObject = parentProperty.getValue(partitionObject);
                tier = parentTierObject != null ? new Tier(nameProperty.getValue(partitionObject).toString(), this.convertPartitionEntityToTier(parentTierObject)) : new Tier(nameProperty.getValue(partitionObject).toString());
                tier.setId(idProperty.getValue(partitionObject).toString());
            }
        }
        return tier;
    }

    private EntityManager getEntityManager() {
        if (!this.getContext().isParameterSet("CTX_ENTITY_MANAGER")) {
            throw new IllegalStateException("Error while trying to determine EntityManager - context parameter not set.");
        }
        return (EntityManager)this.getContext().getParameter("CTX_ENTITY_MANAGER");
    }
}

