/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import org.picketlink.idm.ldap.internal.LDAPEntry;
import org.picketlink.idm.model.Group;

public class LDAPGroup
extends LDAPEntry
implements Group {
    private static final long serialVersionUID = 1L;
    private Group parent;
    private String groupName;

    public LDAPGroup() {
        this(null);
    }

    public LDAPGroup(String groupDNSuffix) {
        super(groupDNSuffix);
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add("top");
        oc.add("groupOfNames");
        this.getLDAPAttributes().put(oc);
    }

    public LDAPGroup(Attributes attributes, String groupDNSuffix) {
        super(groupDNSuffix);
        this.setLDAPAttributes(attributes);
    }

    public void setName(String name) {
        this.groupName = name;
        Attribute theAttribute = this.getLDAPAttributes().get("cn");
        if (theAttribute == null) {
            this.getLDAPAttributes().put("cn", this.groupName);
        } else {
            theAttribute.set(0, this.groupName);
        }
        this.getLDAPAttributes().put("member", " ");
    }

    public String getName() {
        Attribute cnAttribute;
        if (this.groupName == null && (cnAttribute = this.getLDAPAttributes().get("cn")) != null) {
            try {
                this.groupName = (String)cnAttribute.get();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return this.groupName;
    }

    public void setParentGroup(Group parent) {
        this.parent = parent;
    }

    public Group getParentGroup() {
        return this.parent;
    }

    public void addChildGroup(LDAPGroup childGroup) {
        Attribute memberAttribute = this.getLDAPAttributes().get("member");
        if (memberAttribute == null) {
            memberAttribute = new BasicAttribute("member");
            this.getLDAPAttributes().put(memberAttribute);
        }
        memberAttribute.add(this.getDN(childGroup.getName()));
    }

    @Override
    public void setId(String id) {
    }
}

