/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.internal.X509CertificateCredentialHandler;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.credential.spi.annotations.CredentialHandlers;
import org.picketlink.idm.credential.spi.annotations.Stored;
import org.picketlink.idm.event.GroupCreatedEvent;
import org.picketlink.idm.event.GroupDeletedEvent;
import org.picketlink.idm.event.GroupUpdatedEvent;
import org.picketlink.idm.event.RoleCreatedEvent;
import org.picketlink.idm.event.RoleDeletedEvent;
import org.picketlink.idm.event.RoleUpdatedEvent;
import org.picketlink.idm.event.UserCreatedEvent;
import org.picketlink.idm.event.UserDeletedEvent;
import org.picketlink.idm.event.UserUpdatedEvent;
import org.picketlink.idm.internal.util.IDMUtil;
import org.picketlink.idm.internal.util.properties.Property;
import org.picketlink.idm.internal.util.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.idm.internal.util.properties.query.PropertyQueries;
import org.picketlink.idm.ldap.internal.LDAPConfiguration;
import org.picketlink.idm.ldap.internal.LDAPCustomAttributes;
import org.picketlink.idm.ldap.internal.LDAPEntry;
import org.picketlink.idm.ldap.internal.LDAPGroup;
import org.picketlink.idm.ldap.internal.LDAPOperationManager;
import org.picketlink.idm.ldap.internal.LDAPPlainTextPasswordCredentialHandler;
import org.picketlink.idm.ldap.internal.LDAPQuery;
import org.picketlink.idm.ldap.internal.LDAPRole;
import org.picketlink.idm.ldap.internal.LDAPSearchCallback;
import org.picketlink.idm.ldap.internal.LDAPUser;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;

@CredentialHandlers(value={LDAPPlainTextPasswordCredentialHandler.class, X509CertificateCredentialHandler.class})
public class LDAPIdentityStore
implements IdentityStore<LDAPConfiguration>,
CredentialStore {
    private LDAPConfiguration configuration;
    private IdentityStoreInvocationContext context;

    public void setup(LDAPConfiguration config, IdentityStoreInvocationContext context) {
        this.configuration = config;
        this.context = context;
    }

    public LDAPConfiguration getConfig() {
        return this.configuration;
    }

    public IdentityStoreInvocationContext getContext() {
        return this.context;
    }

    public void add(AttributedType value) {
        if (value instanceof IdentityType) {
            IdentityType identityType = (IdentityType)value;
            Class<?> identityTypeClass = identityType.getClass();
            if (IDMUtil.isUserType(identityTypeClass)) {
                User storedUser = this.addUser((User)identityType);
                UserCreatedEvent event = new UserCreatedEvent(storedUser);
                this.getContext().getEventBridge().raiseEvent((Object)event);
            } else if (IDMUtil.isGroupType(identityTypeClass)) {
                Group storedGroup = this.addGroup((Group)identityType);
                GroupCreatedEvent event = new GroupCreatedEvent(storedGroup);
                this.getContext().getEventBridge().raiseEvent((Object)event);
            } else if (IDMUtil.isRoleType(identityTypeClass)) {
                Role storedRole = this.addRole((Role)identityType);
                RoleCreatedEvent event = new RoleCreatedEvent(storedRole);
                this.getContext().getEventBridge().raiseEvent((Object)event);
            }
        }
    }

    public void update(AttributedType value) {
        if (value instanceof IdentityType) {
            IdentityType identityType = (IdentityType)value;
            Class<?> identityTypeClass = identityType.getClass();
            if (IDMUtil.isUserType(identityTypeClass)) {
                User updatedUser = (User)identityType;
                if (updatedUser.getId() == null) {
                    throw new IdentityManagementException("No identifier was provided.");
                }
                User storedUser = this.getUser(updatedUser.getId());
                if (storedUser == null) {
                    throw new RuntimeException("User [" + updatedUser.getId() + "] does not exists.");
                }
                this.updateUser(updatedUser, storedUser);
                UserUpdatedEvent event = new UserUpdatedEvent(storedUser);
                this.getContext().getEventBridge().raiseEvent((Object)event);
            } else if (IDMUtil.isGroupType(identityTypeClass)) {
                Group updatedGroup = (Group)identityType;
                if (updatedGroup.getName() == null) {
                    throw new IdentityManagementException("No identifier was provided.");
                }
                Group storedGroup = this.getGroup(updatedGroup.getName());
                if (storedGroup == null) {
                    throw new RuntimeException("No group found with the given name [" + updatedGroup.getName() + "].");
                }
                this.updateGroup(updatedGroup, storedGroup);
                GroupUpdatedEvent event = new GroupUpdatedEvent(storedGroup);
                this.getContext().getEventBridge().raiseEvent((Object)event);
            } else if (IDMUtil.isRoleType(identityTypeClass)) {
                Role updatedRole = (Role)identityType;
                if (updatedRole.getName() == null) {
                    throw new IdentityManagementException("No identifier was provided.");
                }
                Role storedRole = this.getRole(updatedRole.getName());
                if (storedRole == null) {
                    throw new RuntimeException("No role found with the given name [" + updatedRole.getName() + "].");
                }
                this.updateRole(updatedRole, storedRole);
                RoleUpdatedEvent event = new RoleUpdatedEvent(storedRole);
                this.getContext().getEventBridge().raiseEvent((Object)event);
            }
        }
    }

    public void remove(AttributedType value) {
        if (value instanceof IdentityType) {
            IdentityType identityType = (IdentityType)value;
            Class<?> identityTypeClass = identityType.getClass();
            if (IDMUtil.isUserType(identityTypeClass)) {
                User user = (User)identityType;
                if (user.getId() == null) {
                    throw new IdentityManagementException("No identifier was provided.");
                }
                User storedUser = this.getUser(user.getId());
                if (storedUser == null) {
                    throw new RuntimeException("User [" + user.getId() + "] doest not exists.");
                }
                this.removeUser(storedUser);
                UserDeletedEvent event = new UserDeletedEvent(storedUser);
                this.getContext().getEventBridge().raiseEvent((Object)event);
            } else if (IDMUtil.isGroupType(identityTypeClass)) {
                Group group = (Group)identityType;
                if (group.getName() == null) {
                    throw new IdentityManagementException("No identifier was provided.");
                }
                Group storedGroup = this.getGroup(group.getName());
                if (storedGroup == null) {
                    throw new RuntimeException("Group [" + group.getName() + "] doest not exists.");
                }
                this.removeGroup(storedGroup);
                GroupDeletedEvent event = new GroupDeletedEvent(storedGroup);
                this.getContext().getEventBridge().raiseEvent((Object)event);
            } else if (IDMUtil.isRoleType(identityTypeClass)) {
                Role role = (Role)identityType;
                if (role.getName() == null) {
                    throw new IdentityManagementException("No identifier was provided.");
                }
                Role storedRole = this.getRole(role.getName());
                if (storedRole == null) {
                    throw new RuntimeException("Role [" + role.getName() + "] doest not exists.");
                }
                this.removeRole(storedRole);
                RoleDeletedEvent event = new RoleDeletedEvent(storedRole);
                this.getContext().getEventBridge().raiseEvent((Object)event);
            }
        }
    }

    public Agent getAgent(String id) {
        return this.getUser(id);
    }

    public User getUser(String id) {
        final String baseDN = this.configuration.getUserDNSuffix();
        List<User> answer = this.getLdapManager().searchByAttribute(baseDN, "uid", id, new LDAPSearchCallback<User>(){

            @Override
            public User processResult(SearchResult sr) {
                LDAPUser user = new LDAPUser(baseDN, sr.getAttributes());
                user.setCustomAttributes(LDAPIdentityStore.this.getCustomAttributes(user.getDN()));
                return user;
            }
        });
        return answer.isEmpty() ? null : answer.get(0);
    }

    public Group getGroup(String name) {
        final String baseDN = this.configuration.getGroupDNSuffix();
        List<Group> answer = this.getLdapManager().searchByAttribute(baseDN, "cn", name, new LDAPSearchCallback<Group>(){

            @Override
            public Group processResult(SearchResult sr) {
                LDAPGroup ldapGroup = new LDAPGroup(sr.getAttributes(), baseDN);
                ldapGroup.setCustomAttributes(LDAPIdentityStore.this.getCustomAttributes(ldapGroup.getDN()));
                Group parentGroup = LDAPIdentityStore.this.getParentGroup(ldapGroup);
                if (parentGroup != null) {
                    ldapGroup.setParentGroup(parentGroup);
                }
                return ldapGroup;
            }
        });
        return answer.isEmpty() ? null : answer.get(0);
    }

    public Role getRole(String name) {
        final String baseDN = this.configuration.getRoleDNSuffix();
        List<Role> answer = this.getLdapManager().searchByAttribute(baseDN, "cn", name, new LDAPSearchCallback<Role>(){

            @Override
            public Role processResult(SearchResult sr) {
                LDAPRole ldapRole = new LDAPRole(sr.getAttributes(), baseDN);
                ldapRole.setCustomAttributes(LDAPIdentityStore.this.getCustomAttributes(ldapRole.getDN()));
                return ldapRole;
            }
        });
        return answer.isEmpty() ? null : answer.get(0);
    }

    public Group getGroup(String name, Group parent) {
        Group ldapGroup = this.getGroup(name);
        Group ldapGroupParent = ldapGroup.getParentGroup();
        if (parent != null && ldapGroup != null && ldapGroupParent != null && ldapGroupParent.getName().equals(parent.getName())) {
            return ldapGroup;
        }
        return null;
    }

    public <T extends IdentityType> List<T> fetchQueryResults(IdentityQuery<T> identityQuery) {
        ArrayList<Object> result = new ArrayList<Object>();
        String filter = this.getSearchFilter(identityQuery);
        Class typeClass = identityQuery.getIdentityType();
        NamingEnumeration<SearchResult> answer = null;
        if (filter == null) {
            return result;
        }
        LDAPQuery ldapQuery = new LDAPQuery(identityQuery.getParameters());
        String idAttribute = this.getIdAttribute(typeClass);
        String dnSuffix = this.getBaseDN(typeClass);
        try {
            answer = this.getLdapManager().search(dnSuffix, filter);
            while (answer.hasMoreElements()) {
                long providedDateInMillis;
                Object[] values;
                SearchResult sr = (SearchResult)answer.nextElement();
                Attributes attributes = sr.getAttributes();
                String uid = (String)attributes.get(idAttribute).get();
                LDAPCustomAttributes customAttributes = this.getCustomAttributes(idAttribute + "=" + uid + "," + dnSuffix);
                if (ldapQuery.hasCustomAttributes() && customAttributes == null) continue;
                if (identityQuery.getParameters().containsKey(IdentityType.ENABLED)) {
                    values = (Object[])identityQuery.getParameters().get(IdentityType.ENABLED);
                    String enabled = String.valueOf(customAttributes.getAttribute("enabled"));
                    if (!enabled.equals(values[0].toString())) continue;
                }
                if (identityQuery.getParameters().containsKey(IdentityType.CREATED_DATE)) {
                    values = (Object[])identityQuery.getParameters().get(IdentityType.CREATED_DATE);
                    long storedDateInMillis = Long.valueOf(customAttributes.getAttribute("createDate").toString());
                    if (storedDateInMillis != (providedDateInMillis = ((Date)values[0]).getTime())) continue;
                }
                if (identityQuery.getParameters().containsKey(IdentityType.CREATED_BEFORE)) {
                    values = (Object[])identityQuery.getParameters().get(IdentityType.CREATED_BEFORE);
                    long storedDateInMillis = Long.valueOf(customAttributes.getAttribute("createDate").toString());
                    if (storedDateInMillis > (providedDateInMillis = ((Date)values[0]).getTime())) continue;
                }
                if (identityQuery.getParameters().containsKey(IdentityType.CREATED_AFTER)) {
                    values = (Object[])identityQuery.getParameters().get(IdentityType.CREATED_AFTER);
                    long storedDateInMillis = Long.valueOf(customAttributes.getAttribute("createDate").toString());
                    if (storedDateInMillis < (providedDateInMillis = ((Date)values[0]).getTime())) continue;
                }
                if (identityQuery.getParameters().containsKey(IdentityType.EXPIRY_DATE) || identityQuery.getParameters().containsKey(IdentityType.EXPIRY_BEFORE) || identityQuery.getParameters().containsKey(IdentityType.EXPIRY_AFTER)) {
                    long providedDateInMillis2;
                    long storedDateInMillis;
                    Object[] values2;
                    Object expiryAttribute = customAttributes.getAttribute("expiryDate");
                    if (expiryAttribute == null) continue;
                    if (identityQuery.getParameters().containsKey(IdentityType.EXPIRY_DATE)) {
                        values2 = (Object[])identityQuery.getParameters().get(IdentityType.EXPIRY_DATE);
                        storedDateInMillis = Long.valueOf(expiryAttribute.toString());
                        if (storedDateInMillis != (providedDateInMillis2 = ((Date)values2[0]).getTime())) continue;
                    }
                    if (identityQuery.getParameters().containsKey(IdentityType.EXPIRY_BEFORE)) {
                        values2 = (Object[])identityQuery.getParameters().get(IdentityType.EXPIRY_BEFORE);
                        storedDateInMillis = Long.valueOf(expiryAttribute.toString());
                        if (storedDateInMillis > (providedDateInMillis2 = ((Date)values2[0]).getTime())) continue;
                    }
                    if (identityQuery.getParameters().containsKey(IdentityType.EXPIRY_AFTER)) {
                        values2 = (Object[])identityQuery.getParameters().get(IdentityType.EXPIRY_AFTER);
                        storedDateInMillis = Long.valueOf(expiryAttribute.toString());
                        if (storedDateInMillis < (providedDateInMillis2 = ((Date)values2[0]).getTime())) continue;
                    }
                }
                boolean match = true;
                for (Map.Entry ldapQueryParameter : identityQuery.getParameters().entrySet()) {
                    QueryParameter queryParameter = (QueryParameter)ldapQueryParameter.getKey();
                    Object[] values3 = (Object[])ldapQueryParameter.getValue();
                    if (!(queryParameter instanceof AttributedType.AttributeParameter)) continue;
                    match = false;
                    Object[] queryParameterValues = values3;
                    AttributedType.AttributeParameter customParameter = (AttributedType.AttributeParameter)queryParameter;
                    Object customParameterValue = customAttributes.getAttribute(customParameter.getName());
                    if (customParameterValue == null) continue;
                    int count = queryParameterValues.length;
                    for (Object parameterValue : queryParameterValues) {
                        if (customParameterValue.getClass().isArray()) {
                            Object[] customParameterValues;
                            for (Object value : customParameterValues = (Object[])customParameterValue) {
                                if (!value.equals(parameterValue)) continue;
                                --count;
                            }
                            continue;
                        }
                        if (!parameterValue.equals(customParameterValue)) continue;
                        --count;
                    }
                    if (count > 0) continue;
                    match = true;
                }
                if (!match) continue;
                if (IDMUtil.isUserType(typeClass)) {
                    result.add(this.getUser(uid));
                    continue;
                }
                if (IDMUtil.isRoleType(typeClass)) {
                    result.add(this.getRole(uid));
                    continue;
                }
                if (!IDMUtil.isGroupType(typeClass)) continue;
                result.add(this.getGroup(uid));
            }
        }
        catch (NamingException ne) {
            throw new RuntimeException(ne);
        }
        finally {
            if (answer != null) {
                try {
                    answer.close();
                }
                catch (NamingException e) {}
            }
        }
        return result;
    }

    public void validateCredentials(Credentials credentials) {
        CredentialHandler handler = this.getContext().getCredentialValidator(credentials.getClass(), (IdentityStore)this);
        if (handler == null) {
            throw new SecurityConfigurationException("No suitable CredentialHandler available for validating Credentials of type [" + credentials.getClass() + "] for IdentityStore [" + this.getClass() + "]");
        }
        handler.validate(credentials, (IdentityStore)this);
    }

    public void updateCredential(Agent agent, Object credential, Date effectiveDate, Date expiryDate) {
        CredentialHandler handler = this.getContext().getCredentialUpdater(credential.getClass(), (IdentityStore)this);
        if (handler == null) {
            throw new SecurityConfigurationException("No suitable CredentialHandler available for updating Credentials of type [" + credential.getClass() + "] for IdentityStore [" + this.getClass() + "]");
        }
        handler.update(agent, credential, (IdentityStore)this, effectiveDate, expiryDate);
    }

    public void storeCredential(Agent agent, CredentialStorage storage) {
        List annotatedTypes = PropertyQueries.createQuery(storage.getClass()).addCriteria(new AnnotatedPropertyCriteria(Stored.class)).getResultList();
        if (annotatedTypes.isEmpty()) {
            throw new IdentityManagementException("Could not find any @Stored annotated method for CredentialStorage type [" + storage.getClass().getName() + "].");
        }
        Property storedProperty = annotatedTypes.get(0);
        Object credential = storedProperty.getValue(storage);
        if (!Serializable.class.isInstance(credential)) {
            throw new IdentityManagementException("Credential storage property [" + storedProperty.getName() + "] in class [" + storage.getClass().getName() + "] must implement Serializable");
        }
        Attribute credentialAttribute = new Attribute(storage.getClass().getName(), (Serializable)credential);
        agent.setAttribute(credentialAttribute);
        this.update((AttributedType)agent);
    }

    public <T extends CredentialStorage> T retrieveCurrentCredential(Agent agent, Class<T> storageClass) {
        CredentialStorage storage = null;
        List annotatedTypes = PropertyQueries.createQuery(storageClass).addCriteria(new AnnotatedPropertyCriteria(Stored.class)).getResultList();
        if (annotatedTypes.isEmpty()) {
            throw new IdentityManagementException("Could not find any @Stored annotated method for CredentialStorage type [" + storageClass.getName() + "].");
        }
        Property<Serializable> storedProperty = annotatedTypes.get(0);
        Attribute credentialAttribute = agent.getAttribute(storageClass.getName());
        if (credentialAttribute != null) {
            try {
                storage = (CredentialStorage)storageClass.newInstance();
            }
            catch (Exception e) {
                throw new IdentityManagementException("Error while creating a " + storageClass.getName() + " storage instance.", (Throwable)e);
            }
        } else {
            throw new IdentityManagementException("Methods annotated with @Stored should aways return a serializable object.");
        }
        storedProperty.setValue(storage, credentialAttribute.getValue());
        return (T)storage;
    }

    public <T extends IdentityType> int countQueryResults(IdentityQuery<T> identityQuery) {
        throw this.createNotImplementedYetException();
    }

    public <T extends Serializable> Attribute<T> getAttribute(IdentityType identityType, String attributeName) {
        throw this.createNotImplementedYetException();
    }

    public void setAttribute(IdentityType identity, Attribute<? extends Serializable> attribute) {
        throw this.createNotImplementedYetException();
    }

    public void removeAttribute(IdentityType identity, String name) {
        throw this.createNotImplementedYetException();
    }

    private LDAPUser convert(User user) {
        LDAPUser ldapUser = null;
        if (user instanceof LDAPUser) {
            ldapUser = (LDAPUser)user;
        } else {
            ldapUser = new LDAPUser(this.configuration.getUserDNSuffix());
            ldapUser.setId(user.getId());
            ldapUser.setFirstName(" ");
            ldapUser.setLastName(" ");
            if (user.getFirstName() != null) {
                ldapUser.setFirstName(user.getFirstName());
            }
            if (user.getLastName() != null) {
                ldapUser.setLastName(user.getLastName());
            }
            if (user.getEmail() != null) {
                ldapUser.setEmail(user.getEmail());
            }
            if (user.getExpirationDate() != null) {
                ldapUser.setExpirationDate(user.getExpirationDate());
            }
            for (Attribute attrib : user.getAttributes()) {
                ldapUser.setAttribute((Attribute<? extends Serializable>)attrib);
            }
        }
        return ldapUser;
    }

    private LDAPCustomAttributes getCustomAttributes(String parentDN) {
        String customDN = this.getCustomAttributesDN(parentDN);
        LDAPCustomAttributes customAttributes = null;
        try {
            customAttributes = (LDAPCustomAttributes)this.getLdapManager().lookup(customDN);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return customAttributes;
    }

    private String getCustomAttributesDN(String parentDN) {
        return "cn=custom-attributes," + parentDN;
    }

    private void store(LDAPEntry ldapEntry) {
        this.getLdapManager().bind(ldapEntry.getDN(), ldapEntry);
        this.getLdapManager().bind(this.getCustomAttributesDN(ldapEntry.getDN()), ldapEntry.getCustomAttributes());
    }

    private void addMember(LDAPEntry parentEntry, LDAPEntry childEntry) {
        parentEntry.addMember(childEntry);
        this.getLdapManager().modifyAttribute(parentEntry.getDN(), parentEntry.getLDAPAttributes().get("member"));
    }

    private void removeMember(LDAPEntry parentEntry, LDAPEntry childEntry) {
        parentEntry.removeMember(childEntry);
        this.getLdapManager().modifyAttribute(parentEntry.getDN(), parentEntry.getLDAPAttributes().get("member"));
    }

    private void removeEntry(LDAPEntry ldapEntry) {
        this.getLdapManager().destroySubcontext(ldapEntry.getDN());
    }

    private Group getParentGroup(LDAPGroup childGroup) {
        BasicAttributes matchAttrs = new BasicAttributes(true);
        matchAttrs.put(new BasicAttribute("member", "cn=" + childGroup.getName() + "," + this.configuration.getGroupDNSuffix()));
        NamingEnumeration<SearchResult> answer = null;
        try {
            answer = this.getLdapManager().search(this.configuration.getGroupDNSuffix(), matchAttrs, new String[]{"cn"});
            if (answer.hasMoreElements()) {
                SearchResult sr = (SearchResult)answer.nextElement();
                Attributes attributes = sr.getAttributes();
                String cn = (String)attributes.get("cn").get();
                Group group = this.getGroup(cn);
                return group;
            }
        }
        catch (NamingException e) {
            throw new RuntimeException("Error looking parent group for [" + childGroup.getDN() + "]", e);
        }
        finally {
            if (answer != null) {
                try {
                    answer.close();
                }
                catch (NamingException e) {}
            }
        }
        return null;
    }

    private void updateAttributes(LDAPEntry updatedEntryEntry, LDAPEntry storedEntry) {
        try {
            javax.naming.directory.Attribute updatedAttribute;
            NamingEnumeration<? extends javax.naming.directory.Attribute> storedAttributes = storedEntry.getLDAPAttributes().getAll();
            while (storedAttributes.hasMore()) {
                javax.naming.directory.Attribute storedAttribute = storedAttributes.next();
                updatedAttribute = updatedEntryEntry.getLDAPAttributes().get(storedAttribute.getID());
                if (updatedAttribute != null) {
                    this.getLdapManager().modifyAttribute(storedEntry.getDN(), updatedAttribute);
                    continue;
                }
                this.getLdapManager().removeAttribute(storedEntry.getDN(), storedAttribute);
            }
            NamingEnumeration<? extends javax.naming.directory.Attribute> enumUpdatedAttributes = updatedEntryEntry.getLDAPAttributes().getAll();
            while (enumUpdatedAttributes.hasMore()) {
                updatedAttribute = enumUpdatedAttributes.next();
                javax.naming.directory.Attribute storedAttribute = storedEntry.getLDAPAttributes().get(updatedAttribute.getID());
                if (storedAttribute != null || !this.getLdapManager().isManagedAttribute(updatedAttribute.getID())) continue;
                this.getLdapManager().addAttribute(storedEntry.getDN(), updatedAttribute);
            }
            LDAPCustomAttributes attributes = updatedEntryEntry.getCustomAttributes();
            this.getLdapManager().rebind(this.getCustomAttributesDN(updatedEntryEntry.getDN()), attributes);
        }
        catch (NamingException e) {
            throw new IdentityManagementException("Error updating custom attributes for IdentityType [" + storedEntry + "].", (Throwable)e);
        }
    }

    private NamingEnumeration<SearchResult> findParentEntries(String dnSuffix, LDAPEntry member) {
        String filter = "(member=" + member.getDN() + ")";
        return this.getLdapManager().search(dnSuffix, filter);
    }

    private void removeFromParent(String dnSuffix, LDAPEntry member) {
        NamingEnumeration<SearchResult> results = null;
        try {
            results = this.findParentEntries(dnSuffix, member);
            while (results.hasMoreElements()) {
                SearchResult searchResult = (SearchResult)results.nextElement();
                javax.naming.directory.Attribute memberAttribute = searchResult.getAttributes().get("member");
                if (memberAttribute != null) {
                    memberAttribute.remove(member.getDN());
                }
                if (memberAttribute.getAll().hasMoreElements()) continue;
                memberAttribute.add(" ");
            }
        }
        catch (NamingException ne) {
            throw new IdentityManagementException((Throwable)ne);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (NamingException e) {}
            }
        }
    }

    private void storeMembershipEntry(LDAPEntry ldapEntry, LDAPEntry member) {
        String dn = ldapEntry.getDN();
        LDAPEntry storedGroupRole = (LDAPEntry)this.getLdapManager().lookup(dn);
        if (storedGroupRole == null) {
            storedGroupRole = ldapEntry;
            this.getLdapManager().bind(dn, storedGroupRole);
        } else {
            javax.naming.directory.Attribute memberAttribute = storedGroupRole.getLDAPAttributes().get("member");
            if (!memberAttribute.contains(member.getDN())) {
                memberAttribute.add(member.getDN());
                this.getLdapManager().modifyAttribute(dn, memberAttribute);
                this.getLdapManager().rebind(dn, storedGroupRole);
            }
        }
    }

    private void removeMemberShipEntry(LDAPEntry ldapEntry, LDAPEntry member) {
        javax.naming.directory.Attribute memberAttribute;
        String dn = ldapEntry.getDN();
        LDAPEntry storedGroupRole = (LDAPEntry)this.getLdapManager().lookup(dn);
        if (storedGroupRole != null && (memberAttribute = storedGroupRole.getLDAPAttributes().get("member")).contains(member.getDN())) {
            memberAttribute.remove(member.getDN());
            memberAttribute.add(" ");
            this.getLdapManager().modifyAttribute(dn, memberAttribute);
            this.getLdapManager().rebind(dn, storedGroupRole);
        }
    }

    public LDAPOperationManager getLdapManager() {
        return this.configuration.getLdapManager();
    }

    protected Role addRole(Role role) {
        if (role.getName() == null) {
            throw new IdentityManagementException("No identifier was provided.");
        }
        LDAPRole ldapRole = new LDAPRole(this.configuration.getRoleDNSuffix());
        ldapRole.setName(role.getName());
        this.store(ldapRole);
        return ldapRole;
    }

    protected Group addGroup(Group group) {
        if (group.getName() == null) {
            throw new IdentityManagementException("No identifier was provided.");
        }
        LDAPGroup ldapGroup = new LDAPGroup(this.configuration.getGroupDNSuffix());
        ldapGroup.setName(group.getName());
        if (group.getParentGroup() != null) {
            String parentName = group.getParentGroup().getName();
            LDAPGroup parentGroup = (LDAPGroup)this.getGroup(parentName);
            if (parentGroup == null) {
                throw new RuntimeException("Parent group [" + parentName + "] does not exists.");
            }
            parentGroup.addChildGroup(ldapGroup);
            ldapGroup.setParentGroup(parentGroup);
            this.getLdapManager().modifyAttribute(parentGroup.getDN(), parentGroup.getLDAPAttributes().get("member"));
        }
        this.store(ldapGroup);
        return ldapGroup;
    }

    protected User addUser(User user) {
        if (user.getId() == null) {
            throw new IdentityManagementException("No identifier was provided.");
        }
        LDAPUser ldapUser = null;
        ldapUser = !(user instanceof LDAPUser) ? this.convert(user) : (LDAPUser)user;
        ldapUser.setFullName(ldapUser.getUserCN());
        this.store(ldapUser);
        return ldapUser;
    }

    protected Group updateGroup(Group updatedGroup, Group storedGroup) {
        this.updateAttributes((LDAPGroup)updatedGroup, (LDAPGroup)storedGroup);
        return updatedGroup;
    }

    protected Role updateRole(Role updatedRole, Role storedRole) {
        this.updateAttributes((LDAPRole)updatedRole, (LDAPRole)storedRole);
        return updatedRole;
    }

    protected User updateUser(User user, User storedUser) {
        LDAPUser updatedUser = this.convert(user);
        updatedUser.setFullName(updatedUser.getUserCN());
        this.updateAttributes(updatedUser, (LDAPEntry)storedUser);
        return updatedUser;
    }

    protected Role removeRole(Role role) {
        this.removeEntry((LDAPEntry)role);
        this.removeFromParent(this.configuration.getGroupDNSuffix(), (LDAPEntry)role);
        return role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Group removeGroup(Group group) {
        NamingEnumeration<SearchResult> results = null;
        try {
            results = this.getLdapManager().search(this.configuration.getUserDNSuffix(), "(&(cn= " + group.getName() + "*))");
            while (results.hasMoreElements()) {
                SearchResult searchResult = (SearchResult)results.nextElement();
                String dn = searchResult.getNameInNamespace();
                this.getLdapManager().destroySubcontext(dn);
            }
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (NamingException namingException) {}
            }
        }
        this.removeEntry((LDAPEntry)group);
        return group;
    }

    protected User removeUser(User user) {
        this.removeFromParent(this.configuration.getRoleDNSuffix(), (LDAPEntry)user);
        this.removeFromParent(this.configuration.getGroupDNSuffix(), (LDAPEntry)user);
        this.removeEntry((LDAPEntry)user);
        return user;
    }

    private String getSearchFilter(IdentityQuery<IdentityType> identityQuery) {
        LDAPQuery ldapQuery;
        StringBuffer filter;
        Agent[] agents;
        Object[] values;
        Class typeClass = identityQuery.getIdentityType();
        StringBuffer additionalFilter = new StringBuffer();
        if (IDMUtil.isUserType(typeClass)) {
            String usersFilterMemberOf;
            Object name;
            if (identityQuery.getParameters().containsKey(User.HAS_ROLE)) {
                Object[] roleNames = (Object[])identityQuery.getParameters().get(User.HAS_ROLE);
                LDAPEntry[] roles = new LDAPEntry[roleNames.length];
                for (int i = 0; i < roleNames.length; ++i) {
                    name = roleNames[i];
                    roles[i] = (LDAPEntry)this.getRole(name.toString());
                }
                usersFilterMemberOf = this.getUsersFilterMemberOf(roles);
                if (usersFilterMemberOf.length() == 0) {
                    return null;
                }
                additionalFilter.append(usersFilterMemberOf);
            }
            if (identityQuery.getParameters().containsKey(User.MEMBER_OF)) {
                Object[] groupNames = (Object[])identityQuery.getParameters().get(User.MEMBER_OF);
                LDAPEntry[] groups = new LDAPEntry[groupNames.length];
                for (int i = 0; i < groupNames.length; ++i) {
                    name = groupNames[i];
                    groups[i] = (LDAPEntry)this.getGroup(name.toString());
                }
                usersFilterMemberOf = this.getUsersFilterMemberOf(groups);
                if (usersFilterMemberOf.length() == 0) {
                    return null;
                }
                additionalFilter.append(usersFilterMemberOf);
            }
            if (identityQuery.getParameters().containsKey(IdentityType.HAS_GROUP_ROLE)) {
                Object[] groupRoles = (Object[])identityQuery.getParameters().get(User.HAS_GROUP_ROLE);
                NamingEnumeration<SearchResult> search = null;
                try {
                    for (Object group : groupRoles) {
                        GroupRole groupRole = (GroupRole)group;
                        search = this.getLdapManager().search(this.configuration.getUserDNSuffix(), "(cn=" + groupRole.getGroup().getName() + ")");
                        if (!search.hasMoreElements()) continue;
                        while (search.hasMoreElements()) {
                            SearchResult searchResult = search.next();
                            String[] nameInNamespace = searchResult.getNameInNamespace().split(",");
                            String userId = nameInNamespace[1];
                            javax.naming.directory.Attribute member = searchResult.getAttributes().get("member");
                            if (!member.contains("cn=" + groupRole.getRole().getName() + "," + this.configuration.getRoleDNSuffix())) continue;
                            additionalFilter.append("(").append(userId).append(")");
                        }
                    }
                    if (additionalFilter.length() == 0) {
                        Object[] arr$ = null;
                        return arr$;
                    }
                }
                catch (Exception e) {
                    throw new IdentityManagementException((Throwable)e);
                }
                finally {
                    if (search != null) {
                        try {
                            search.close();
                        }
                        catch (NamingException e) {}
                    }
                }
            }
        } else if (IDMUtil.isRoleType(typeClass)) {
            if (identityQuery.getParameters().containsKey(Role.ROLE_OF)) {
                values = (Object[])identityQuery.getParameters().get(Role.ROLE_OF);
                agents = new Agent[values.length];
                for (int j = 0; j < values.length; ++j) {
                    Object value = values[j];
                    agents[j] = (Agent)value;
                }
                String filter2 = this.getEntryFilterForMembers(agents, this.configuration.getRoleDNSuffix());
                if (filter2.length() == 0) {
                    return null;
                }
                additionalFilter.append(filter2);
            }
        } else if (IDMUtil.isGroupType(typeClass)) {
            if (identityQuery.getParameters().containsKey(Group.HAS_MEMBER)) {
                values = (Object[])identityQuery.getParameters().get(Group.HAS_MEMBER);
                agents = new Agent[values.length];
                for (int j = 0; j < values.length; ++j) {
                    Object value = values[j];
                    agents[j] = (Agent)value;
                }
                String filter3 = this.getEntryFilterForMembers(agents, this.configuration.getGroupDNSuffix());
                if (filter3.length() == 0) {
                    return null;
                }
                additionalFilter.append(filter3);
            }
            if (identityQuery.getParameters().containsKey(Group.PARENT)) {
                String parentName = ((Object[])identityQuery.getParameters().get(Group.PARENT))[0].toString();
                LDAPGroup parentGroup = (LDAPGroup)this.getGroup(parentName);
                NamingEnumeration<?> members = null;
                try {
                    members = parentGroup.getLDAPAttributes().get("member").getAll();
                    while (members.hasMoreElements()) {
                        String groupDN = (String)members.nextElement();
                        if (groupDN.toString().trim().isEmpty()) continue;
                        String groupName = groupDN.split(",")[0];
                        additionalFilter.append("(").append(groupName).append(")");
                    }
                }
                catch (NamingException e) {
                    throw new IdentityManagementException((Throwable)e);
                }
                finally {
                    if (members != null) {
                        try {
                            members.close();
                        }
                        catch (NamingException e) {}
                    }
                }
            }
        }
        if (additionalFilter.length() > 0) {
            additionalFilter.insert(0, "(|");
            additionalFilter.insert(additionalFilter.length() - 1, ")");
        }
        if ((filter = (ldapQuery = new LDAPQuery(identityQuery.getParameters())).createManagedAttributesFilter()) == null) {
            filter = new StringBuffer("(&(objectClass=*)(" + this.getIdAttribute(typeClass) + "=*)(!(cn=custom-attributes)))");
        }
        filter.insert(filter.length() - 1, additionalFilter.toString());
        return filter.toString();
    }

    private String getIdAttribute(Class<? extends IdentityType> identityTypeClass) {
        String idAttribute = null;
        if (IDMUtil.isUserType(identityTypeClass)) {
            idAttribute = "uid";
        } else if (IDMUtil.isRoleType(identityTypeClass)) {
            idAttribute = "cn";
        } else if (IDMUtil.isGroupType(identityTypeClass)) {
            idAttribute = "cn";
        }
        return idAttribute;
    }

    private String getBaseDN(Class<? extends IdentityType> identityTypeClass) {
        String baseDN = null;
        if (IDMUtil.isUserType(identityTypeClass)) {
            baseDN = this.configuration.getUserDNSuffix();
        } else if (IDMUtil.isRoleType(identityTypeClass)) {
            baseDN = this.configuration.getRoleDNSuffix();
        } else if (IDMUtil.isGroupType(identityTypeClass)) {
            baseDN = this.configuration.getGroupDNSuffix();
        }
        return baseDN;
    }

    private String getEntryFilterForMembers(Agent[] members, String baseDN) {
        StringBuffer additionalFilter = new StringBuffer();
        String hasMemberFilter = "";
        for (Agent agent : members) {
            LDAPUser ldapUser = (LDAPUser)this.getUser(agent.getId());
            hasMemberFilter = hasMemberFilter + "(member=" + ldapUser.getDN() + ")";
        }
        NamingEnumeration<SearchResult> search = null;
        try {
            search = this.getLdapManager().search(baseDN, hasMemberFilter.toString());
            while (search.hasMoreElements()) {
                SearchResult searchResult = search.next();
                String entryCN = searchResult.getAttributes().get("cn").get().toString();
                additionalFilter.append("(").append("cn").append("=").append(entryCN).append(")");
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException((Throwable)e);
        }
        finally {
            if (search != null) {
                try {
                    search.close();
                }
                catch (NamingException e) {}
            }
        }
        return additionalFilter.toString();
    }

    private String getUsersFilterMemberOf(LDAPEntry[] parents) {
        StringBuffer additionalFilter = new StringBuffer();
        HashMap<String, Integer> userCount = new HashMap<String, Integer>();
        for (LDAPEntry ldapEntry : parents) {
            javax.naming.directory.Attribute memberAttribute = null;
            memberAttribute = ldapEntry.getLDAPAttributes().get("member");
            NamingEnumeration<?> members = null;
            try {
                members = memberAttribute.getAll();
                while (members.hasMoreElements()) {
                    String memberDN = (String)members.nextElement();
                    if (memberDN.trim().isEmpty()) continue;
                    String userId = memberDN.split(",")[0];
                    if (!userCount.containsKey(userId)) {
                        userCount.put(userId, 1);
                    } else {
                        Integer count = (Integer)userCount.get(userId);
                        userCount.put(userId, count + 1);
                    }
                    additionalFilter.append("(").append(userId).append(")");
                }
            }
            catch (NamingException e) {
                throw new IdentityManagementException((Throwable)e);
            }
            finally {
                if (members != null) {
                    try {
                        members.close();
                    }
                    catch (NamingException e) {}
                }
            }
        }
        Set entrySet = userCount.entrySet();
        for (Map.Entry entry : entrySet) {
            if (((Integer)entry.getValue()).equals(parents.length)) continue;
            String filterTmp = additionalFilter.toString();
            filterTmp = filterTmp.replaceAll("\\(" + (String)entry.getKey() + "\\)", "");
            additionalFilter = new StringBuffer(filterTmp);
        }
        return additionalFilter.toString();
    }

    private IdentityManagementException createNotImplementedYetException() {
        return new IdentityManagementException("Not implemented yet.");
    }

    public <T extends CredentialStorage> List<T> retrieveCredentials(Agent agent, Class<T> storageClass) {
        return null;
    }

    public <T extends Relationship> List<T> fetchQueryResults(RelationshipQuery<T> query) {
        return null;
    }

    public <T extends Relationship> int countQueryResults(RelationshipQuery<T> query) {
        return 0;
    }
}

