/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.picketlink.idm.ldap.internal.LDAPSearchCallback;

public class LDAPOperationManager {
    private List<String> managedAttributes = new ArrayList<String>();
    private Properties properties;
    private DirContext context;
    private DirContext authenticationContext;

    public LDAPOperationManager(Properties properties) throws NamingException {
        this.context = new InitialLdapContext(properties, null);
        this.authenticationContext = new InitialLdapContext(properties, null);
        this.properties = properties;
    }

    public void bind(String dn, Object object) {
        try {
            this.context.bind(dn, object);
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                try {
                    this.context.close();
                    this.context = new InitialLdapContext(this.properties, null);
                    this.context.bind(dn, object);
                }
                catch (NamingException e1) {
                    throw new RuntimeException(e1);
                }
            }
            throw new RuntimeException(e);
        }
    }

    public void modifyAttribute(String dn, Attribute attribute) {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, attribute)};
        this.modifyAttributes(dn, mods);
    }

    public void removeAttribute(String dn, Attribute attribute) {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, attribute)};
        this.modifyAttributes(dn, mods);
    }

    public void addAttribute(String dn, Attribute attribute) {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(1, attribute)};
        this.modifyAttributes(dn, mods);
    }

    public void rebind(String dn, Object object) {
        try {
            this.context.rebind(dn, object);
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                try {
                    this.context.close();
                    this.context = new InitialLdapContext(this.properties, null);
                    this.context.rebind(dn, object);
                }
                catch (NamingException e1) {
                    throw new RuntimeException(e1);
                }
            }
            throw new RuntimeException(e);
        }
    }

    public <T> T lookup(String dn) {
        try {
            return (T)this.context.lookup(dn);
        }
        catch (NamingException e) {
            return null;
        }
    }

    public <T> List<T> searchByAttribute(String baseDN, String attributeName, String attributeValue, LDAPSearchCallback<T> searchCallback) {
        ArrayList<T> result = new ArrayList<T>();
        NamingEnumeration<SearchResult> answer = null;
        try {
            BasicAttributes attributesToSearch = new BasicAttributes(true);
            attributesToSearch.put(new BasicAttribute(attributeName, attributeValue));
            answer = this.context.search(baseDN, (Attributes)attributesToSearch);
            while (answer.hasMore()) {
                result.add(searchCallback.processResult(answer.next()));
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (answer != null) {
                try {
                    answer.close();
                }
                catch (NamingException e) {}
            }
        }
        return result;
    }

    public NamingEnumeration<SearchResult> search(String baseDN, Attributes attributesToSearch, String[] attributesToReturn) {
        try {
            return this.context.search(baseDN, attributesToSearch, attributesToReturn);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public NamingEnumeration<SearchResult> search(String baseDN, String filter, String[] attributesToReturn, SearchControls searchControls) {
        try {
            return this.context.search(baseDN, filter, (Object[])attributesToReturn, searchControls);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public NamingEnumeration<SearchResult> search(String baseDN, String filter) {
        try {
            SearchControls cons = new SearchControls();
            cons.setSearchScope(2);
            cons.setReturningObjFlag(true);
            return this.context.search(baseDN, filter, cons);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public void destroySubcontext(String dn) {
        try {
            this.destroyRecursively(dn);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void destroyRecursively(String dn) {
        NamingEnumeration<Binding> enumeration = null;
        try {
            enumeration = this.context.listBindings(dn);
            while (enumeration.hasMore()) {
                Binding binding = enumeration.next();
                String name = binding.getNameInNamespace();
                this.destroyRecursively(name);
            }
            this.context.unbind(dn);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                enumeration.close();
            }
            catch (Exception e) {}
        }
    }

    public boolean isManagedAttribute(String attributeName) {
        if (this.managedAttributes.contains(attributeName)) {
            return true;
        }
        if (this.checkAttributePresence(attributeName)) {
            this.managedAttributes.add(attributeName);
            return true;
        }
        return false;
    }

    public boolean checkAttributePresence(String attributeName) {
        try {
            DirContext schema = this.context.getSchema("");
            DirContext cnSchema = (DirContext)schema.lookup("AttributeDefinition/" + attributeName);
            if (cnSchema != null) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public boolean authenticate(String dn, String password) {
        try {
            this.authenticationContext.addToEnvironment("java.naming.security.principal", dn);
            this.authenticationContext.addToEnvironment("java.naming.security.credentials", password);
            this.authenticationContext.lookup(dn);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void modifyAttributes(String dn, ModificationItem[] mods) {
        try {
            this.context.modifyAttributes(dn, mods);
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                try {
                    this.context.close();
                    this.context = new InitialLdapContext(this.properties, null);
                    this.context.modifyAttributes(dn, mods);
                }
                catch (NamingException e1) {
                    throw new RuntimeException(e1);
                }
            }
            throw new RuntimeException(e);
        }
    }
}

