/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.util.Date;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.internal.Password;
import org.picketlink.idm.credential.internal.UsernamePasswordCredentials;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.annotations.SupportsCredentials;
import org.picketlink.idm.ldap.internal.LDAPIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPUser;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.spi.IdentityStore;

@SupportsCredentials(value={UsernamePasswordCredentials.class, Password.class})
public class LDAPPlainTextPasswordCredentialHandler
implements CredentialHandler {
    private static final String USER_PASSWORD_ATTRIBUTE = "userpassword";

    public void validate(Credentials credentials, IdentityStore<?> identityStore) {
        this.checkIdentityStoreInstance(identityStore);
        if (!UsernamePasswordCredentials.class.isInstance(credentials)) {
            throw new IllegalArgumentException("Credentials class [" + credentials.getClass().getName() + "] not supported by this handler.");
        }
        UsernamePasswordCredentials usernamePassword = (UsernamePasswordCredentials)credentials;
        usernamePassword.setStatus(Credentials.Status.INVALID);
        Agent agent = identityStore.getAgent(usernamePassword.getUsername());
        if (agent != null) {
            LDAPIdentityStore ldapIdentityStore = (LDAPIdentityStore)identityStore;
            LDAPUser ldapUser = (LDAPUser)ldapIdentityStore.getUser(agent.getId());
            char[] password = usernamePassword.getPassword().getValue();
            boolean isValid = ldapIdentityStore.getLdapManager().authenticate(ldapUser.getDN(), new String(password));
            if (isValid) {
                usernamePassword.setStatus(Credentials.Status.VALID);
            }
        }
    }

    public void update(Agent agent, Object credential, IdentityStore<?> identityStore, Date effectiveDate, Date expiryDate) {
        this.checkIdentityStoreInstance(identityStore);
        if (!Password.class.isInstance(credential)) {
            throw new IllegalArgumentException("Credential class [" + credential.getClass().getName() + "] not supported by this handler.");
        }
        Password password = (Password)credential;
        LDAPIdentityStore ldapIdentityStore = (LDAPIdentityStore)identityStore;
        LDAPUser ldapuser = (LDAPUser)ldapIdentityStore.getUser(agent.getId());
        if (ldapIdentityStore.getConfig().isActiveDirectory()) {
            this.updateADPassword(ldapuser, new String(password.getValue()), ldapIdentityStore);
        } else {
            ModificationItem[] mods = new ModificationItem[1];
            try {
                BasicAttribute mod0 = new BasicAttribute(USER_PASSWORD_ATTRIBUTE, new String(password.getValue()));
                mods[0] = new ModificationItem(2, mod0);
                ldapIdentityStore.getLdapManager().modifyAttribute(ldapuser.getDN(), mod0);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void checkIdentityStoreInstance(IdentityStore<?> store) {
        if (!LDAPIdentityStore.class.isInstance(store)) {
            throw new IllegalArgumentException("IdentityStore class [" + store.getClass() + "] not supported by this handler.");
        }
    }

    private void updateADPassword(LDAPUser user, String password, LDAPIdentityStore store) {
        try {
            String newQuotedPassword = "\"" + password + "\"";
            byte[] newUnicodePassword = newQuotedPassword.getBytes("UTF-16LE");
            BasicAttribute unicodePwd = new BasicAttribute("unicodePwd", newUnicodePassword);
            store.getLdapManager().modifyAttribute(user.getDN(), unicodePwd);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

