/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.DirectoryClassPathRoot;
import org.pitest.functional.FCollection;
import org.pitest.maven.AbstractPitMojo;
import org.pitest.maven.SurefireConfigConverter;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.testapi.TestGroupConfig;
import org.pitest.util.Glob;

public class MojoToReportOptionsConverter {
    private final AbstractPitMojo mojo;
    private final Predicate<Artifact> dependencyFilter;
    private final Log log;
    private final SurefireConfigConverter surefireConverter;

    public MojoToReportOptionsConverter(AbstractPitMojo mojo, SurefireConfigConverter surefireConverter, Predicate<Artifact> dependencyFilter) {
        this.mojo = mojo;
        this.dependencyFilter = dependencyFilter;
        this.log = mojo.getLog();
        this.surefireConverter = surefireConverter;
    }

    public ReportOptions convert() {
        ArrayList<String> classPath = new ArrayList<String>();
        try {
            classPath.addAll(this.mojo.getProject().getTestClasspathElements());
        }
        catch (DependencyResolutionRequiredException e1) {
            this.log.info((Throwable)e1);
        }
        this.addOwnDependenciesToClassPath(classPath);
        classPath.addAll(this.mojo.getAdditionalClasspathElements());
        for (Object artifact : this.mojo.getProject().getArtifacts()) {
            Artifact dependency = (Artifact)artifact;
            if (!this.mojo.getClasspathDependencyExcludes().contains(dependency.getGroupId() + ":" + dependency.getArtifactId())) continue;
            classPath.remove(dependency.getFile().getPath());
        }
        ReportOptions option = this.parseReportOptions(classPath);
        return this.updateFromSurefire(option);
    }

    private ReportOptions parseReportOptions(List<String> classPath) {
        ReportOptions data = new ReportOptions();
        if (this.mojo.getProject().getBuild() != null) {
            this.log.info((CharSequence)("Mutating from " + this.mojo.getProject().getBuild().getOutputDirectory()));
            data.setCodePaths(Collections.singleton(this.mojo.getProject().getBuild().getOutputDirectory()));
        }
        data.setTestPlugin(this.mojo.getTestPlugin());
        data.setClassPathElements(classPath);
        data.setDependencyAnalysisMaxDistance(this.mojo.getMaxDependencyDistance());
        data.setFailWhenNoMutations(this.shouldFailWhenNoMutations());
        data.setTargetClasses(this.determineTargetClasses());
        data.setTargetTests(this.determineTargetTests());
        data.setExcludedMethods(this.mojo.getExcludedMethods());
        data.setExcludedClasses(this.mojo.getExcludedClasses());
        data.setExcludedTestClasses(this.globStringsToPredicates(this.mojo.getExcludedTestClasses()));
        data.setNumberOfThreads(this.mojo.getThreads());
        data.setExcludedRunners(this.mojo.getExcludedRunners());
        data.setReportDir(this.mojo.getReportsDirectory().getAbsolutePath());
        data.setVerbose(this.mojo.isVerbose());
        if (this.mojo.getJvmArgs() != null) {
            data.addChildJVMArgs(this.mojo.getJvmArgs());
        }
        data.setMutators(this.determineMutators());
        data.setFeatures(this.determineFeatures());
        data.setTimeoutConstant(this.mojo.getTimeoutConstant());
        data.setTimeoutFactor(this.mojo.getTimeoutFactor());
        if (this.hasValue(this.mojo.getAvoidCallsTo())) {
            data.setLoggingClasses(this.mojo.getAvoidCallsTo());
        }
        ArrayList<String> sourceRoots = new ArrayList<String>();
        sourceRoots.addAll(this.mojo.getProject().getCompileSourceRoots());
        sourceRoots.addAll(this.mojo.getProject().getTestCompileSourceRoots());
        data.setSourceDirs(this.stringsTofiles(sourceRoots));
        data.addOutputFormats(this.determineOutputFormats());
        this.setTestGroups(data);
        data.setMutationUnitSize(this.mojo.getMutationUnitSize());
        data.setShouldCreateTimestampedReports(this.mojo.isTimestampedReports());
        data.setDetectInlinedCode(this.mojo.isDetectInlinedCode());
        this.determineHistory(data);
        data.setExportLineCoverage(this.mojo.isExportLineCoverage());
        data.setMutationEngine(this.mojo.getMutationEngine());
        data.setJavaExecutable(this.mojo.getJavaExecutable());
        data.setFreeFormProperties(this.createPluginProperties());
        data.setIncludedTestMethods(this.mojo.getIncludedTestMethods());
        return data;
    }

    private void determineHistory(ReportOptions data) {
        if (this.mojo.useHistory()) {
            this.useHistoryFileInTempDir(data);
        } else {
            data.setHistoryInputLocation(this.mojo.getHistoryInputFile());
            data.setHistoryOutputLocation(this.mojo.getHistoryOutputFile());
        }
    }

    private void useHistoryFileInTempDir(ReportOptions data) {
        String tempDir = System.getProperty("java.io.tmpdir");
        MavenProject project = this.mojo.project;
        String name = project.getGroupId() + "." + project.getArtifactId() + "." + project.getVersion() + "_pitest_history.bin";
        File historyFile = new File(tempDir, name);
        this.log.info((CharSequence)("Will read and write history at " + historyFile));
        if (this.mojo.getHistoryInputFile() == null) {
            data.setHistoryInputLocation(historyFile);
        }
        if (this.mojo.getHistoryOutputFile() == null) {
            data.setHistoryOutputLocation(historyFile);
        }
    }

    private ReportOptions updateFromSurefire(ReportOptions option) {
        Collection<Plugin> plugins = this.lookupPlugin("org.apache.maven.plugins:maven-surefire-plugin");
        if (!this.mojo.isParseSurefireConfig()) {
            return option;
        }
        if (plugins.isEmpty()) {
            this.log.warn((CharSequence)"Could not find surefire configuration in pom");
            return option;
        }
        Plugin surefire = plugins.iterator().next();
        if (surefire != null) {
            return this.surefireConverter.update(option, (Xpp3Dom)surefire.getConfiguration());
        }
        return option;
    }

    private Collection<Plugin> lookupPlugin(String key) {
        List plugins = this.mojo.getProject().getBuildPlugins();
        return FCollection.filter((Iterable)plugins, MojoToReportOptionsConverter.hasKey(key));
    }

    private static Predicate<Plugin> hasKey(final String key) {
        return new Predicate<Plugin>(){

            @Override
            public boolean test(Plugin a) {
                return a.getKey().equals(key);
            }
        };
    }

    private boolean shouldFailWhenNoMutations() {
        return this.mojo.isFailWhenNoMutations();
    }

    private void setTestGroups(ReportOptions data) {
        TestGroupConfig conf = new TestGroupConfig(this.mojo.getExcludedGroups(), this.mojo.getIncludedGroups());
        data.setGroupConfig(conf);
    }

    private void addOwnDependenciesToClassPath(List<String> classPath) {
        for (Artifact dependency : this.filteredDependencies()) {
            this.log.info((CharSequence)("Adding " + dependency.getGroupId() + ":" + dependency.getArtifactId() + " to SUT classpath"));
            classPath.add(dependency.getFile().getAbsolutePath());
        }
    }

    private Collection<Predicate<String>> globStringsToPredicates(List<String> excludedMethods) {
        return FCollection.map(excludedMethods, (Function)Glob.toGlobPredicate());
    }

    private Collection<Predicate<String>> determineTargetTests() {
        return FCollection.map(this.mojo.getTargetTests(), (Function)Glob.toGlobPredicate());
    }

    private Collection<Artifact> filteredDependencies() {
        return FCollection.filter(this.mojo.getPluginArtifactMap().values(), this.dependencyFilter);
    }

    private Collection<String> determineMutators() {
        if (this.mojo.getMutators() != null) {
            return this.mojo.getMutators();
        }
        return Collections.emptyList();
    }

    private Collection<String> determineFeatures() {
        if (this.mojo.getFeatures() != null) {
            return this.mojo.getFeatures();
        }
        return Collections.emptyList();
    }

    private Collection<String> determineTargetClasses() {
        return this.useConfiguredTargetClassesOrFindOccupiedPackages(this.mojo.getTargetClasses());
    }

    private Collection<String> useConfiguredTargetClassesOrFindOccupiedPackages(Collection<String> filters) {
        if (!this.hasValue(filters)) {
            this.mojo.getLog().info((CharSequence)"Defaulting target classes to match packages in build directory");
            return this.findOccupiedPackages();
        }
        return filters;
    }

    private Collection<String> findOccupiedPackages() {
        String outputDirName = this.mojo.getProject().getBuild().getOutputDirectory();
        File outputDir = new File(outputDirName);
        return MojoToReportOptionsConverter.findOccupiedPackagesIn(outputDir);
    }

    public static Collection<String> findOccupiedPackagesIn(File dir) {
        if (dir.exists()) {
            DirectoryClassPathRoot root = new DirectoryClassPathRoot(dir);
            HashSet<String> occupiedPackages = new HashSet<String>();
            FCollection.mapTo((Iterable)root.classNames(), MojoToReportOptionsConverter.classToPackageGlob(), occupiedPackages);
            return occupiedPackages;
        }
        return Collections.emptyList();
    }

    private static Function<String, String> classToPackageGlob() {
        return a -> ClassName.fromString((String)a).getPackage().asJavaName() + ".*";
    }

    private Collection<File> stringsTofiles(List<String> sourceRoots) {
        return FCollection.map(sourceRoots, this.stringToFile());
    }

    private Function<String, File> stringToFile() {
        return a -> new File((String)a);
    }

    private Collection<String> determineOutputFormats() {
        if (this.hasValue(this.mojo.getOutputFormats())) {
            return this.mojo.getOutputFormats();
        }
        return Arrays.asList("HTML");
    }

    private boolean hasValue(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    private Properties createPluginProperties() {
        Properties p = new Properties();
        if (this.mojo.getPluginProperties() != null) {
            p.putAll(this.mojo.getPluginProperties());
        }
        return p;
    }
}

