/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.classloader.javassist;

import java.security.ProtectionDomain;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.powermock.core.classloader.MockClassLoader;
import org.powermock.core.classloader.MockClassLoaderConfiguration;
import org.powermock.core.classloader.annotations.UseClassPathAdjuster;
import org.powermock.core.classloader.javassist.ClassPoolFactory;
import org.powermock.core.classloader.javassist.JavaAssistClassMarkerFactory;
import org.powermock.core.transformers.ClassWrapper;
import org.powermock.core.transformers.javassist.support.JavaAssistClassWrapperFactory;

public class JavassistMockClassLoader
extends MockClassLoader {
    public static final String CGLIB_ENHANCER = "net.sf.cglib.proxy.Enhancer$EnhancerKey$$KeyFactoryByCGLIB$$";
    public static final String CGLIB_METHOD_WRAPPER = "net.sf.cglib.core.MethodWrapper$MethodWrapperKey$$KeyFactoryByCGLIB";
    private final ClassPool classPool;

    public JavassistMockClassLoader(String[] classesToMock) {
        this(classesToMock, new String[0], null);
    }

    public JavassistMockClassLoader(String[] classesToMock, String[] packagesToDefer, UseClassPathAdjuster useClassPathAdjuster) {
        this(new MockClassLoaderConfiguration(classesToMock, packagesToDefer), useClassPathAdjuster);
    }

    public JavassistMockClassLoader(MockClassLoaderConfiguration configuration) {
        this(configuration, (UseClassPathAdjuster)null);
    }

    public JavassistMockClassLoader(MockClassLoaderConfiguration configuration, UseClassPathAdjuster useClassPathAdjuster) {
        super(configuration, new JavaAssistClassWrapperFactory());
        this.classPool = new ClassPoolFactory(useClassPathAdjuster).create();
        this.classMarker = JavaAssistClassMarkerFactory.createClassMarker(this.classPool);
    }

    @Override
    protected Class<?> loadUnmockedClass(String name, ProtectionDomain protectionDomain) throws ClassFormatError, ClassNotFoundException {
        byte[] bytes = null;
        try {
            if (!name.startsWith(CGLIB_ENHANCER) && !name.startsWith(CGLIB_METHOD_WRAPPER)) {
                CtClass ctClass = this.classPool.get(name);
                if (ctClass.isFrozen()) {
                    ctClass.defrost();
                }
                bytes = ctClass.toBytecode();
            }
        }
        catch (NotFoundException e) {
            return ClassLoader.getSystemClassLoader().loadClass(name);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to loaded class " + name, e);
        }
        return bytes == null ? null : this.defineClass(name, bytes, 0, bytes.length, protectionDomain);
    }

    @Override
    protected byte[] defineAndTransformClass(String name, ProtectionDomain protectionDomain) {
        byte[] clazz;
        ClassPool.doPruning = false;
        try {
            CtClass type = this.classPool.get(name);
            ClassWrapper<CtClass> wrappedType = this.classWrapperFactory.wrap(type);
            wrappedType = this.transformClass(wrappedType);
            type = wrappedType.unwrap();
            type.detach();
            clazz = type.toBytecode();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to transform class with name " + name + ". Reason: " + e.getMessage(), e);
        }
        return clazz;
    }
}

