/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.transformers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.powermock.core.transformers.MethodSignatureWriter;
import org.powermock.core.transformers.MockTransformer;

public abstract class TestClassTransformer<T, M>
implements MockTransformer<T> {
    private final Class<?> testClass;
    private final Class<? extends Annotation> testMethodAnnotationType;
    private final MethodSignatureWriter<M> methodSignatureWriter;

    public TestClassTransformer(Class<?> testClass, Class<? extends Annotation> testMethodAnnotationType, MethodSignatureWriter<M> methodSignatureWriter) {
        this.testClass = testClass;
        this.testMethodAnnotationType = testMethodAnnotationType;
        this.methodSignatureWriter = methodSignatureWriter;
    }

    protected String signatureOf(M method) {
        return this.methodSignatureWriter.signatureFor(method);
    }

    protected String signatureOf(Method m) {
        return this.methodSignatureWriter.signatureForReflection(m);
    }

    protected Class<? extends Annotation> getTestMethodAnnotationType() {
        return this.testMethodAnnotationType;
    }

    protected Class<?> getTestClass() {
        return this.testClass;
    }
}

