/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.transformers.javassist.testclass;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtPrimitiveType;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import org.powermock.core.IndicateReloadClass;
import org.powermock.core.testlisteners.GlobalNotificationBuildSupport;
import org.powermock.core.transformers.ClassWrapper;
import org.powermock.core.transformers.MethodSignatureWriter;
import org.powermock.core.transformers.TestClassTransformer;
import org.powermock.core.transformers.javassist.support.Primitives;

public abstract class JavaAssistTestClassTransformer
extends TestClassTransformer<CtClass, CtMethod> {
    JavaAssistTestClassTransformer(Class<?> testClass, Class<? extends Annotation> testMethodAnnotationType, MethodSignatureWriter<CtMethod> signatureWriter) {
        super(testClass, testMethodAnnotationType, signatureWriter);
    }

    protected abstract boolean mustHaveTestAnnotationRemoved(CtMethod var1) throws Exception;

    @Override
    public ClassWrapper<CtClass> transform(ClassWrapper<CtClass> clazz) throws Exception {
        this.transform(clazz.unwrap());
        return clazz;
    }

    private void transform(CtClass clazz) throws Exception {
        if (clazz.isFrozen()) {
            clazz.defrost();
        }
        if (this.isTestClass(clazz)) {
            this.removeTestAnnotationsForTestMethodsThatRunOnOtherClassLoader(clazz);
            this.addLifeCycleNotifications(clazz);
            this.makeDeferConstructorNonPublic(clazz);
            this.restoreOriginalConstructorsAccesses(clazz);
        } else if (this.isNestedWithinTestClass(clazz)) {
            this.makeDeferConstructorNonPublic(clazz);
            this.restoreOriginalConstructorsAccesses(clazz);
        }
    }

    private boolean isTestClass(CtClass clazz) {
        try {
            return Class.forName(clazz.getName(), false, this.getTestClass().getClassLoader()).isAssignableFrom(this.getTestClass());
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private boolean isNestedWithinTestClass(CtClass clazz) {
        String clazzName = clazz.getName();
        return clazzName.startsWith(this.getTestClass().getName()) && '$' == clazzName.charAt(this.getTestClass().getName().length());
    }

    private Class<?> asOriginalClass(CtClass type) throws Exception {
        try {
            return type.isArray() ? Array.newInstance(this.asOriginalClass(type.getComponentType()), 0).getClass() : (type.isPrimitive() ? Primitives.getClassFor((CtPrimitiveType)type) : Class.forName(type.getName(), true, this.getTestClass().getClassLoader()));
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot resolve type: " + type, ex);
        }
    }

    private Class<?>[] asOriginalClassParams(CtClass[] parameterTypes) throws Exception {
        Class[] classParams = new Class[parameterTypes.length];
        for (int i = 0; i < classParams.length; ++i) {
            classParams[i] = this.asOriginalClass(parameterTypes[i]);
        }
        return classParams;
    }

    private void removeTestMethodAnnotationFrom(CtMethod m) {
        AnnotationsAttribute attr = (AnnotationsAttribute)m.getMethodInfo().getAttribute("RuntimeVisibleAnnotations");
        javassist.bytecode.annotation.Annotation[] newAnnotations = new javassist.bytecode.annotation.Annotation[attr.numAnnotations() - 1];
        int i = -1;
        for (javassist.bytecode.annotation.Annotation a : attr.getAnnotations()) {
            if (a.getTypeName().equals(this.getTestMethodAnnotationType().getName())) continue;
            newAnnotations[++i] = a;
        }
        attr.setAnnotations(newAnnotations);
    }

    private void removeTestAnnotationsForTestMethodsThatRunOnOtherClassLoader(CtClass clazz) throws Exception {
        for (CtMethod m : clazz.getDeclaredMethods()) {
            if (!m.hasAnnotation(this.getTestMethodAnnotationType()) || !this.mustHaveTestAnnotationRemoved(m)) continue;
            this.removeTestMethodAnnotationFrom(m);
        }
    }

    private void addLifeCycleNotifications(CtClass clazz) {
        try {
            this.addClassInitializerNotification(clazz);
            this.addConstructorNotification(clazz);
        }
        catch (CannotCompileException ex) {
            throw new Error("Powermock error: " + ex.getMessage(), ex);
        }
    }

    private void addClassInitializerNotification(CtClass clazz) throws CannotCompileException {
        if (null == clazz.getClassInitializer()) {
            clazz.makeClassInitializer();
        }
        clazz.getClassInitializer().insertBefore(GlobalNotificationBuildSupport.class.getName() + ".testClassInitiated(" + clazz.getName() + ".class);");
    }

    private static boolean hasSuperClass(CtClass clazz) {
        try {
            CtClass superClazz = clazz.getSuperclass();
            return null != superClazz && !"java.lang.Object".equals(superClazz.getName());
        }
        catch (NotFoundException noWasSuperClassFound) {
            return false;
        }
    }

    private void addConstructorNotification(CtClass clazz) throws CannotCompileException {
        String notificationCode = GlobalNotificationBuildSupport.class.getName() + ".testInstanceCreated(this);";
        boolean asFinally = !JavaAssistTestClassTransformer.hasSuperClass(clazz);
        for (CtConstructor constr : clazz.getDeclaredConstructors()) {
            constr.insertAfter(notificationCode, asFinally);
        }
    }

    private void restoreOriginalConstructorsAccesses(CtClass clazz) throws Exception {
        Class<?> originalClass = this.getTestClass().getName().equals(clazz.getName()) ? this.getTestClass() : Class.forName(clazz.getName(), true, this.getTestClass().getClassLoader());
        for (CtConstructor ctConstr : clazz.getConstructors()) {
            int ctModifiers = ctConstr.getModifiers();
            if (!Modifier.isPublic((int)ctModifiers)) continue;
            int desiredAccessModifiers = originalClass.getDeclaredConstructor(this.asOriginalClassParams(ctConstr.getParameterTypes())).getModifiers();
            if (Modifier.isPrivate((int)desiredAccessModifiers)) {
                ctConstr.setModifiers(Modifier.setPrivate((int)ctModifiers));
                continue;
            }
            if (Modifier.isProtected((int)desiredAccessModifiers)) {
                ctConstr.setModifiers(Modifier.setProtected((int)ctModifiers));
                continue;
            }
            if (Modifier.isPublic((int)desiredAccessModifiers)) continue;
            ctConstr.setModifiers(Modifier.setPackage((int)ctModifiers));
        }
    }

    private void makeDeferConstructorNonPublic(CtClass clazz) {
        block2: for (CtConstructor constr : clazz.getConstructors()) {
            try {
                for (CtClass paramType : constr.getParameterTypes()) {
                    if (!IndicateReloadClass.class.getName().equals(paramType.getName())) continue;
                    int modifiers = constr.getModifiers();
                    if (!Modifier.isPublic((int)modifiers)) continue block2;
                    constr.setModifiers(Modifier.setProtected((int)modifiers));
                    continue block2;
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }
}

