/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.testng.internal;

import java.util.ArrayList;
import java.util.List;
import org.powermock.core.classloader.MockClassLoaderBuilders;
import org.powermock.core.transformers.MockTransformer;
import org.powermock.core.transformers.impl.ClassMockTransformer;
import org.powermock.core.transformers.impl.InterfaceMockTransformer;
import org.powermock.modules.testng.internal.ExpectedExceptionsExtractor;
import org.powermock.modules.testng.internal.PowerMockExpectedExceptionsExtractorImpl;
import org.powermock.tests.utils.IgnorePackagesExtractor;
import org.powermock.tests.utils.TestClassesExtractor;
import org.powermock.tests.utils.impl.PowerMockIgnorePackagesExtractorImpl;
import org.powermock.tests.utils.impl.PrepareForTestExtractorImpl;
import org.powermock.tests.utils.impl.StaticConstructorSuppressExtractorImpl;

class ClassLoaderFactory {
    private final TestClassesExtractor testClassesExtractor = new PrepareForTestExtractorImpl();
    private final IgnorePackagesExtractor ignorePackagesExtractor = new PowerMockIgnorePackagesExtractorImpl();
    private final StaticConstructorSuppressExtractorImpl staticConstructorSuppressExtractor;
    private final ExpectedExceptionsExtractor expectedExceptionsExtractor = new PowerMockExpectedExceptionsExtractorImpl();
    private final List<MockTransformer> mockTransformerChain;

    ClassLoaderFactory() {
        this.staticConstructorSuppressExtractor = new StaticConstructorSuppressExtractorImpl();
        this.mockTransformerChain = this.getMockTransformers();
    }

    private List<MockTransformer> getMockTransformers() {
        ArrayList<MockTransformer> mockTransformerChain = new ArrayList<MockTransformer>();
        mockTransformerChain.add((MockTransformer)new ClassMockTransformer());
        mockTransformerChain.add((MockTransformer)new InterfaceMockTransformer());
        return mockTransformerChain;
    }

    ClassLoader createClassLoader(Class<?> testClass) {
        return MockClassLoaderBuilders.mockClassLoaderBuilder().addMockTransformerChain(this.mockTransformerChain).addIgnorePackage(this.ignorePackagesExtractor.getPackagesToIgnore(testClass)).addIgnorePackage(this.expectedExceptionsExtractor.getPackagesToIgnore(testClass)).addClassesToModify(this.testClassesExtractor.getTestClasses(testClass)).addClassesToModify(this.staticConstructorSuppressExtractor.getClassesToModify(testClass)).build();
    }
}

