/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.core;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.location.Location;
import android.location.LocationManager;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Calendar;
import org.prebid.mobile.core.LogUtil;

public class TargetingParams {
    private static final String TAG = LogUtil.getTagWithBase("TP");
    private static int yob = 0;
    private static GENDER gender = GENDER.UNKNOWN;
    private static boolean locationEnabled = false;
    private static int locationDecimalDigits = -1;
    private static ArrayList<String> appKeywords = new ArrayList();
    private static ArrayList<String> userKeywords = new ArrayList();
    private static Location location;
    private static String domain;
    private static String storeUrl;
    private static int privacyPolicy;
    private static String bundleName;
    static final String PREBID_CONSENT_STRING_KEY = "Prebid_GDPR_consent_strings";
    static final String IABConsent_ConsentString = "IABConsent_ConsentString";
    static final String PREBID_GDPR_KEY = "Prebid_GDPR";
    static final String IABConsent_SubjectToGDPR = "IABConsent_SubjectToGDPR";

    private TargetingParams() {
    }

    @SuppressLint(value={"MissingPermission"})
    static void fetchLocationUpdates(Context appContext) {
        if (appContext != null) {
            Location lastLocation = null;
            if (locationEnabled) {
                LogUtil.d(TAG, "Updating location.");
                if (location != null) {
                    lastLocation = location;
                }
                if (appContext != null && (appContext.checkCallingOrSelfPermission("android.permission.ACCESS_FINE_LOCATION") == 0 || appContext.checkCallingOrSelfPermission("android.permission.ACCESS_COARSE_LOCATION") == 0)) {
                    LocationManager lm = (LocationManager)appContext.getSystemService("location");
                    for (String provider_name : lm.getProviders(true)) {
                        LogUtil.v(TAG, "Location provider_name::" + provider_name);
                        Location l = lm.getLastKnownLocation(provider_name);
                        if (l == null) continue;
                        if (lastLocation == null) {
                            lastLocation = l;
                            continue;
                        }
                        if (l.getTime() <= 0L || lastLocation.getTime() <= 0L || l.getTime() <= lastLocation.getTime()) continue;
                        lastLocation = l;
                    }
                } else {
                    LogUtil.d(TAG, "Location permissions ACCESS_COARSE_LOCATION and/or ACCESS_FINE_LOCATION aren\\'t set in the host app. Unable to update location data.");
                }
            }
            if (location != lastLocation) {
                location = lastLocation;
            }
        }
    }

    public static void setGDPRConsentString(Context context, String string) {
        if (!TextUtils.isEmpty((CharSequence)string) && context != null) {
            SharedPreferences pref = PreferenceManager.getDefaultSharedPreferences((Context)context);
            SharedPreferences.Editor editor = pref.edit();
            editor.putString(PREBID_CONSENT_STRING_KEY, string);
            editor.apply();
        }
    }

    public static String getGDPRConsentString(Context context) {
        if (context != null) {
            SharedPreferences pref = PreferenceManager.getDefaultSharedPreferences((Context)context);
            if (pref.contains(PREBID_CONSENT_STRING_KEY)) {
                return pref.getString(PREBID_CONSENT_STRING_KEY, "");
            }
            if (pref.contains(IABConsent_ConsentString)) {
                return pref.getString(IABConsent_ConsentString, "");
            }
        }
        return null;
    }

    public static void setSubjectToGDPR(Context context, boolean consent) {
        if (context != null) {
            SharedPreferences pref = PreferenceManager.getDefaultSharedPreferences((Context)context);
            SharedPreferences.Editor editor = pref.edit();
            editor.putBoolean(PREBID_GDPR_KEY, consent);
            editor.apply();
        }
    }

    public static Boolean isSubjectToGDPR(Context context) {
        if (context != null) {
            SharedPreferences pref = PreferenceManager.getDefaultSharedPreferences((Context)context);
            if (pref.contains(PREBID_GDPR_KEY)) {
                return pref.getBoolean(PREBID_GDPR_KEY, false);
            }
            if (pref.contains(IABConsent_SubjectToGDPR)) {
                String value = pref.getString(IABConsent_SubjectToGDPR, "");
                if ("1".equals(value)) {
                    return true;
                }
                if ("0".equals(value)) {
                    return false;
                }
            }
        }
        return null;
    }

    public static int getYearOfBirth() {
        return yob;
    }

    public static void setYearOfBirth(int yob) {
        if (yob > 0 && yob <= Calendar.getInstance().get(1)) {
            TargetingParams.yob = yob;
        }
    }

    public static GENDER getGender() {
        return gender;
    }

    public static void setGender(GENDER gender) {
        TargetingParams.gender = gender;
    }

    public static void setLocationEnabled(boolean enabled) {
        locationEnabled = enabled;
    }

    public static boolean getLocationEnabled() {
        return locationEnabled;
    }

    public static Location getLocation() {
        return location;
    }

    public static void setLocation(Location locationData) {
        location = locationData;
    }

    public static synchronized int getLocationDecimalDigits() {
        return locationDecimalDigits;
    }

    public static void setLocationDecimalDigits(int digitsAfterDecimal) {
        if (digitsAfterDecimal > 6) {
            locationDecimalDigits = 6;
            LogUtil.w(TAG, "Out of range input " + digitsAfterDecimal + ", set location digits after decimal to maximum 6");
        } else if (digitsAfterDecimal >= -1) {
            locationDecimalDigits = digitsAfterDecimal;
        } else {
            locationDecimalDigits = -1;
            LogUtil.w(TAG, "Invalid input " + digitsAfterDecimal + ", set location digits after decimal to default");
        }
    }

    @Deprecated
    public static void setAppKeywords(ArrayList<String> appKeywords) {
        if (appKeywords != null) {
            TargetingParams.appKeywords = appKeywords;
        }
    }

    @Deprecated
    public static ArrayList<String> getAppKeywords() {
        return appKeywords;
    }

    @Deprecated
    public static void clearAppKeywords() {
        appKeywords.clear();
    }

    @Deprecated
    public static void addAppKeywords(String keyword) {
        if (!appKeywords.contains(keyword)) {
            appKeywords.add(keyword);
        }
    }

    @Deprecated
    public static void removeAppKeyword(String keyword) {
        appKeywords.remove(keyword);
    }

    @Deprecated
    public static void setUserKeywords(ArrayList<String> userKeywords) {
        if (userKeywords != null) {
            TargetingParams.userKeywords = userKeywords;
        }
    }

    @Deprecated
    public static void addUserKeyword(String keyword) {
        if (!userKeywords.contains(keyword)) {
            userKeywords.add(keyword);
        }
    }

    public static void setUserTargeting(String key, String value) {
        if (userKeywords != null) {
            if (!TextUtils.isEmpty((CharSequence)key) && !TextUtils.isEmpty((CharSequence)value)) {
                userKeywords.add(key + "=" + value);
            } else if (!TextUtils.isEmpty((CharSequence)key)) {
                userKeywords.add(key);
            }
        }
    }

    public static ArrayList<String> getUserKeywords() {
        return userKeywords;
    }

    public static void clearUserKeywords() {
        userKeywords.clear();
    }

    public static void removeUserKeyword(String keyword) {
        if (userKeywords != null) {
            ArrayList<String> toBeRemoved = new ArrayList<String>();
            for (String key : userKeywords) {
                String[] keyValuePair = key.split("=");
                if (TextUtils.isEmpty((CharSequence)keyword) || !keyword.equals(keyValuePair[0])) continue;
                toBeRemoved.add(key);
            }
            userKeywords.removeAll(toBeRemoved);
        }
    }

    public static synchronized String getBundleName() {
        return bundleName;
    }

    public static synchronized void setBundleName(String bundleName) {
        TargetingParams.bundleName = bundleName;
    }

    public static synchronized void setDomain(String domain) {
        TargetingParams.domain = domain;
    }

    public static synchronized String getDomain() {
        return domain;
    }

    public static synchronized void setStoreUrl(String storeUrl) {
        TargetingParams.storeUrl = storeUrl;
    }

    public static synchronized String getStoreUrl() {
        return storeUrl;
    }

    public static synchronized void setPrivacyPolicy(int privacyPolicy) {
        if (privacyPolicy == 0 || privacyPolicy == 1) {
            TargetingParams.privacyPolicy = privacyPolicy;
        }
    }

    public static synchronized int getPrivacyPolicy() {
        return privacyPolicy;
    }

    static {
        domain = "";
        storeUrl = "";
        privacyPolicy = 0;
        bundleName = null;
    }

    public static enum GENDER {
        FEMALE,
        MALE,
        UNKNOWN;

    }
}

