/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.util;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import javax.faces.application.FacesMessage;
import javax.faces.convert.ConverterException;
import org.primefaces.extensions.util.MessageFactory;
import org.primefaces.util.LangUtils;

public class PhoneNumberUtilWrapper {
    private static final String MESSAGE_INVALID_VALUE_KEY = "primefaces.extensions.inputphone.INVALID";

    private PhoneNumberUtilWrapper() {
    }

    public static void validate(String number, String country, String validatorMessage) {
        try {
            PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
            Phonenumber.PhoneNumber phoneNumber = phoneNumberUtil.parse((CharSequence)number, country);
            if (!phoneNumberUtil.isValidNumber(phoneNumber)) {
                throw PhoneNumberUtilWrapper.getInvalidValueConverterException(validatorMessage);
            }
        }
        catch (NumberParseException e) {
            throw PhoneNumberUtilWrapper.getInvalidValueConverterException(validatorMessage);
        }
    }

    private static ConverterException getInvalidValueConverterException(String validatorMessage) {
        return new ConverterException(PhoneNumberUtilWrapper.getInvalidValueFacesMessage(validatorMessage));
    }

    private static FacesMessage getInvalidValueFacesMessage(String validatorMessage) {
        if (LangUtils.isEmpty((String)validatorMessage)) {
            return MessageFactory.getMessage(MESSAGE_INVALID_VALUE_KEY, FacesMessage.SEVERITY_ERROR, new Object[0]);
        }
        return new FacesMessage(FacesMessage.SEVERITY_ERROR, validatorMessage, null);
    }
}

