/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import java.util.Collection;
import lombok.AccessLevel;
import lombok.Setter;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.TransformationsUtil;
import lombok.eclipse.Eclipse;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseHandlerUtil;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandleSetter
extends EclipseAnnotationHandler<Setter> {
    public boolean generateSetterForType(EclipseNode typeNode, EclipseNode pos, AccessLevel level, boolean checkForTypeLevelSetter) {
        boolean notAClass;
        if (checkForTypeLevelSetter && typeNode != null) {
            for (EclipseNode child : typeNode.down()) {
                if (child.getKind() != AST.Kind.ANNOTATION || !EclipseHandlerUtil.annotationTypeMatches(Setter.class, child)) continue;
                return true;
            }
        }
        TypeDeclaration typeDecl = null;
        if (typeNode.get() instanceof TypeDeclaration) {
            typeDecl = (TypeDeclaration)typeNode.get();
        }
        int modifiers = typeDecl == null ? 0 : typeDecl.modifiers;
        boolean bl = notAClass = (modifiers & 0x6200) != 0;
        if (typeDecl == null || notAClass) {
            pos.addError("@Setter is only supported on a class or a field.");
            return false;
        }
        for (EclipseNode field : typeNode.down()) {
            FieldDeclaration fieldDecl;
            if (field.getKind() != AST.Kind.FIELD || !EclipseHandlerUtil.filterField(fieldDecl = (FieldDeclaration)field.get()) || (fieldDecl.modifiers & 0x10) != 0) continue;
            this.generateSetterForField(field, (ASTNode)pos.get(), level);
        }
        return true;
    }

    public void generateSetterForField(EclipseNode fieldNode, ASTNode pos, AccessLevel level) {
        for (EclipseNode child : fieldNode.down()) {
            if (child.getKind() != AST.Kind.ANNOTATION || !EclipseHandlerUtil.annotationTypeMatches(Setter.class, child)) continue;
            return;
        }
        this.createSetterForField(level, fieldNode, fieldNode, pos, false);
    }

    @Override
    public void handle(AnnotationValues<Setter> annotation, Annotation ast, EclipseNode annotationNode) {
        EclipseNode node = (EclipseNode)annotationNode.up();
        AccessLevel level = annotation.getInstance().value();
        if (level == AccessLevel.NONE || node == null) {
            return;
        }
        switch (node.getKind()) {
            case FIELD: {
                this.createSetterForFields(level, annotationNode.upFromAnnotationToFields(), annotationNode, (ASTNode)annotationNode.get(), true);
                break;
            }
            case TYPE: {
                this.generateSetterForType(node, annotationNode, level, false);
            }
        }
    }

    private void createSetterForFields(AccessLevel level, Collection<EclipseNode> fieldNodes, EclipseNode errorNode, ASTNode source, boolean whineIfExists) {
        for (EclipseNode fieldNode : fieldNodes) {
            this.createSetterForField(level, fieldNode, errorNode, source, whineIfExists);
        }
    }

    private void createSetterForField(AccessLevel level, EclipseNode fieldNode, EclipseNode errorNode, ASTNode source, boolean whineIfExists) {
        if (fieldNode.getKind() != AST.Kind.FIELD) {
            errorNode.addError("@Setter is only supported on a class or a field.");
            return;
        }
        FieldDeclaration field = (FieldDeclaration)fieldNode.get();
        TypeReference fieldType = EclipseHandlerUtil.copyType(field.type, source);
        boolean isBoolean = Eclipse.nameEquals(fieldType.getTypeName(), "boolean") && fieldType.dimensions() == 0;
        String setterName = TransformationsUtil.toSetterName(new String(field.name), isBoolean);
        int modifier = EclipseHandlerUtil.toEclipseModifier(level) | field.modifiers & 8;
        for (String altName : TransformationsUtil.toAllSetterNames(new String(field.name), isBoolean)) {
            switch (EclipseHandlerUtil.methodExists(altName, fieldNode, false)) {
                case EXISTS_BY_LOMBOK: {
                    return;
                }
                case EXISTS_BY_USER: {
                    if (whineIfExists) {
                        String altNameExpl = "";
                        if (!altName.equals(setterName)) {
                            altNameExpl = String.format(" (%s)", altName);
                        }
                        errorNode.addWarning(String.format("Not generating %s(): A method with that name already exists%s", setterName, altNameExpl));
                    }
                    return;
                }
            }
        }
        MethodDeclaration method = this.generateSetter((TypeDeclaration)((EclipseNode)fieldNode.up()).get(), fieldNode, setterName, modifier, source);
        EclipseHandlerUtil.injectMethod((EclipseNode)fieldNode.up(), (AbstractMethodDeclaration)method);
    }

    private MethodDeclaration generateSetter(TypeDeclaration parent, EclipseNode fieldNode, String name, int modifier, ASTNode source) {
        Statement nullCheck;
        FieldDeclaration field = (FieldDeclaration)fieldNode.get();
        int pS = source.sourceStart;
        int pE = source.sourceEnd;
        long p = (long)pS << 32 | (long)pE;
        MethodDeclaration method = new MethodDeclaration(parent.compilationResult);
        EclipseHandlerUtil.setGeneratedBy((ASTNode)method, source);
        method.modifiers = modifier;
        method.returnType = TypeReference.baseTypeReference((int)6, (int)0);
        method.returnType.sourceStart = pS;
        method.returnType.sourceEnd = pE;
        EclipseHandlerUtil.setGeneratedBy((ASTNode)method.returnType, source);
        method.annotations = null;
        Argument param = new Argument(field.name, p, EclipseHandlerUtil.copyType(field.type, source), 16);
        param.sourceStart = pS;
        param.sourceEnd = pE;
        EclipseHandlerUtil.setGeneratedBy((ASTNode)param, source);
        method.arguments = new Argument[]{param};
        method.selector = name.toCharArray();
        method.binding = null;
        method.thrownExceptions = null;
        method.typeParameters = null;
        method.bits |= 0x800000;
        Expression fieldRef = EclipseHandlerUtil.createFieldAccessor(fieldNode, EclipseHandlerUtil.FieldAccess.ALWAYS_FIELD, source);
        SingleNameReference fieldNameRef = new SingleNameReference(field.name, p);
        EclipseHandlerUtil.setGeneratedBy((ASTNode)fieldNameRef, source);
        Assignment assignment = new Assignment(fieldRef, (Expression)fieldNameRef, (int)p);
        assignment.sourceStart = pS;
        assignment.sourceEnd = assignment.statementEnd = pE;
        EclipseHandlerUtil.setGeneratedBy((ASTNode)assignment, source);
        method.declarationSourceStart = method.sourceStart = source.sourceStart;
        method.bodyStart = method.sourceStart;
        method.declarationSourceEnd = method.sourceEnd = source.sourceEnd;
        method.bodyEnd = method.sourceEnd;
        Annotation[] nonNulls = Eclipse.findAnnotations(field, TransformationsUtil.NON_NULL_PATTERN);
        Annotation[] nullables = Eclipse.findAnnotations(field, TransformationsUtil.NULLABLE_PATTERN);
        method.statements = nonNulls.length == 0 ? new Statement[]{assignment} : ((nullCheck = EclipseHandlerUtil.generateNullCheck((AbstractVariableDeclaration)field, source)) != null ? new Statement[]{nullCheck, assignment} : new Statement[]{assignment});
        Annotation[] copiedAnnotations = EclipseHandlerUtil.copyAnnotations(source, nonNulls, nullables);
        if (copiedAnnotations.length != 0) {
            param.annotations = copiedAnnotations;
        }
        return method;
    }
}

