/*
 * Decompiled with CFR 0.152.
 */
package lombok.installer.netbeans;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.installer.CorruptedIdeLocationException;
import lombok.installer.IdeFinder;
import lombok.installer.IdeLocation;
import lombok.installer.netbeans.NetbeansLocation;
import lombok.installer.netbeans.NetbeansLocationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetbeansFinder
extends IdeFinder {
    private void findNetbeansOnWindows(List<IdeLocation> locations, List<CorruptedIdeLocationException> problems) {
        List<String> driveLetters = Arrays.asList("C");
        try {
            driveLetters = NetbeansFinder.getDrivesOnWindows();
        }
        catch (Throwable ignore) {
            ignore.printStackTrace();
        }
        for (String letter : driveLetters) {
            try {
                File f = new File(letter + ":\\");
                for (File dir : f.listFiles()) {
                    block16: {
                        if (!dir.isDirectory()) continue;
                        try {
                            String netbeansLocation;
                            if (!dir.getName().toLowerCase().contains("netbeans") || (netbeansLocation = this.findNetbeansOnWindows1(dir)) == null) break block16;
                            try {
                                NetbeansLocation newLocation = NetbeansLocationProvider.create0(netbeansLocation);
                                if (newLocation != null) {
                                    locations.add(newLocation);
                                }
                            }
                            catch (CorruptedIdeLocationException e) {
                                problems.add(e);
                            }
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                    }
                    try {
                        if (!dir.getName().toLowerCase().contains("program files")) continue;
                        for (File dir2 : dir.listFiles()) {
                            String netbeansLocation;
                            if (!dir2.isDirectory() || !dir2.getName().toLowerCase().contains("netbeans") || (netbeansLocation = this.findNetbeansOnWindows1(dir2)) == null) continue;
                            try {
                                NetbeansLocation newLocation = NetbeansLocationProvider.create0(netbeansLocation);
                                if (newLocation == null) continue;
                                locations.add(newLocation);
                            }
                            catch (CorruptedIdeLocationException e) {
                                problems.add(e);
                            }
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
            }
            catch (Exception ignore) {
            }
        }
    }

    private String findNetbeansOnWindows1(File dir) {
        if (new File(dir, "bin/netbeans.exe").isFile()) {
            return dir.getAbsolutePath();
        }
        return null;
    }

    @Override
    public void findIdes(List<IdeLocation> locations, List<CorruptedIdeLocationException> problems) {
        switch (NetbeansFinder.getOS()) {
            case WINDOWS: {
                this.findNetbeansOnWindows(locations, problems);
                break;
            }
            case MAC_OS_X: {
                NetbeansFinder.findNetbeansOnMac(locations, problems);
                break;
            }
            default: {
                this.findNetbeansOnUnix(locations, problems);
            }
        }
    }

    private void findNetbeansOnUnix(List<IdeLocation> locations, List<CorruptedIdeLocationException> problems) {
        ArrayList<String> guesses = new ArrayList<String>();
        File d = new File("/usr/bin/netbeans");
        if (d.exists()) {
            guesses.add(d.getPath());
        }
        if ((d = new File("/usr/local/bin/netbeans")).exists()) {
            guesses.add(d.getPath());
        }
        if ((d = new File(System.getProperty("user.home", "."), "bin/netbeans")).exists()) {
            guesses.add(d.getPath());
        }
        NetbeansFinder.findNetbeansInSubDir("/usr/local/share", guesses);
        NetbeansFinder.findNetbeansInSubDir("/usr/local", guesses);
        NetbeansFinder.findNetbeansInSubDir("/usr/share", guesses);
        NetbeansFinder.findNetbeansInSubDir(System.getProperty("user.home", "."), guesses);
        for (String guess : guesses) {
            try {
                NetbeansLocation newLocation = NetbeansLocationProvider.create0(guess);
                if (newLocation == null) continue;
                locations.add(newLocation);
            }
            catch (CorruptedIdeLocationException e) {
                problems.add(e);
            }
        }
    }

    private static void findNetbeansInSubDir(String dir, List<String> guesses) {
        File d = new File(dir);
        if (!d.isDirectory()) {
            return;
        }
        for (File f : d.listFiles()) {
            File possible;
            if (!f.isDirectory() || !f.getName().toLowerCase().contains("netbeans") || !(possible = new File(f, "bin/netbeans")).exists()) continue;
            guesses.add(possible.getAbsolutePath());
        }
    }

    private static void findNetbeansOnMac(List<IdeLocation> locations, List<CorruptedIdeLocationException> problems) {
        for (File dir : new File("/Applications").listFiles()) {
            if (!dir.isDirectory()) continue;
            if (dir.getName().toLowerCase().startsWith("netbeans") && dir.getName().toLowerCase().endsWith(".app")) {
                try {
                    NetbeansLocation newLocation = NetbeansLocationProvider.create0(dir.getAbsolutePath());
                    if (newLocation != null) {
                        locations.add(newLocation);
                    }
                }
                catch (CorruptedIdeLocationException e) {
                    problems.add(e);
                }
            }
            if (!dir.getName().toLowerCase().contains("netbeans")) continue;
            for (File dir2 : dir.listFiles()) {
                if (!dir2.isDirectory() || !dir2.getName().toLowerCase().startsWith("netbeans") || !dir2.getName().toLowerCase().endsWith(".app")) continue;
                try {
                    NetbeansLocation newLocation = NetbeansLocationProvider.create0(dir2.getAbsolutePath());
                    if (newLocation == null) continue;
                    locations.add(newLocation);
                }
                catch (CorruptedIdeLocationException e) {
                    problems.add(e);
                }
            }
        }
    }
}

