/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.frp.functions;

import java.util.function.Supplier;
import org.rapidpm.frp.ExceptionFunctions;
import org.rapidpm.frp.model.Result;

@FunctionalInterface
public interface CheckedSupplier<T>
extends Supplier<Result<T>> {
    @Override
    default public Result<T> get() {
        try {
            return Result.success(this.getWithException());
        }
        catch (Exception e) {
            return Result.failure(ExceptionFunctions.message().apply(e));
        }
    }

    public T getWithException() throws Exception;

    default public T getOrElse(Supplier<T> supplier) {
        return this.get().getOrElse(supplier);
    }
}

