/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.frp.memoizer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.rapidpm.frp.Transformations;
import org.rapidpm.frp.functions.TriFunction;

public class Memoizer<T, U> {
    private final Map<T, U> memoizationCache = new ConcurrentHashMap<T, U>();

    private Supplier<T> doMemoize(final Supplier<T> function) {
        return new Supplier<T>(){
            private T value;

            @Override
            public T get() {
                if (this.value == null) {
                    this.value = function.get();
                }
                return this.value;
            }
        };
    }

    private Function<T, U> doMemoize(Function<T, U> function) {
        return input -> this.memoizationCache.computeIfAbsent(input, function);
    }

    public static <T> Supplier<T> memoize(Supplier<T> function) {
        return super.doMemoize(function);
    }

    public static <T, U> Function<T, U> memoize(Function<T, U> function) {
        return super.doMemoize(function);
    }

    public static <T1, T2, R> BiFunction<T1, T2, R> memoize(BiFunction<T1, T2, R> biFunc) {
        Function<Object, Function> transformed = Memoizer.memoize((T x) -> Memoizer.memoize((T y) -> biFunc.apply(x, y)));
        return Transformations.unCurryBifunction().apply(transformed);
    }

    public static <T1, T2, T3, R> TriFunction<T1, T2, T3, R> memoize(TriFunction<T1, T2, T3, R> threeFunc) {
        Function<Object, Function> transformed = Memoizer.memoize((T x) -> Memoizer.memoize((T y) -> Memoizer.memoize((T z) -> threeFunc.apply(x, y, z))));
        return Transformations.unCurryTrifunction().apply(transformed);
    }
}

