/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.flv.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;
import java.nio.channels.ClosedChannelException;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.codec.AudioCodec;
import org.red5.io.IStreamableFile;
import org.red5.io.ITag;
import org.red5.io.ITagWriter;
import org.red5.io.amf.Input;
import org.red5.io.amf.Output;
import org.red5.io.flv.FLVHeader;
import org.red5.io.flv.IFLV;
import org.red5.io.flv.impl.FLVReader;
import org.red5.io.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLVWriter
implements ITagWriter {
    private static Logger log = LoggerFactory.getLogger(FLVWriter.class);
    private static final int HEADER_LENGTH = 9;
    private static final int TAG_HEADER_LENGTH = 11;
    private static final int META_POSITION = 13;
    private static final byte[] DEFAULT_STREAM_ID = new byte[]{0, 0, 0};
    private IFLV flv;
    private volatile long bytesWritten;
    private int offset;
    private int timeOffset;
    private volatile int videoCodecId = -1;
    private volatile int audioCodecId = -1;
    private volatile int soundRate;
    private volatile int soundSize;
    private volatile boolean soundType;
    private boolean append;
    private int duration;
    private int videoDataSize = 0;
    private int audioDataSize = 0;
    private RandomAccessFile file;
    private RandomAccessFile dataFile;
    private Map<Long, ITag> metaTags = new HashMap<Long, ITag>();
    private String filePath;
    private final Semaphore lock = new Semaphore(1, true);
    private volatile int lastTagSize;

    public FLVWriter(String filePath) {
        this.filePath = filePath;
        log.debug("Writing to: {}", (Object)filePath);
        try {
            File dat = new File(filePath + ".ser");
            this.dataFile = new RandomAccessFile(dat, "rw");
        }
        catch (Exception e) {
            log.error("Failed to create FLV writer", (Throwable)e);
        }
    }

    public FLVWriter(File file, boolean append) {
        this.filePath = file.getAbsolutePath();
        log.debug("Writing to: {}", (Object)this.filePath);
        try {
            this.append = append;
            if (append) {
                this.duration = this.timeOffset = FLVReader.getDuration(file);
                log.debug("Duration: {}", (Object)this.timeOffset);
                this.dataFile = new RandomAccessFile(file, "rw");
                if (!(file.exists() && file.canRead() && file.canWrite())) {
                    log.warn("File does not exist or cannot be accessed");
                } else {
                    log.trace("File size: {} last modified: {}", (Object)file.length(), (Object)file.lastModified());
                    this.bytesWritten = file.length();
                }
                if (this.duration == 0) {
                    this.dataFile.seek(13L);
                }
            } else {
                File dat = new File(this.filePath + ".ser");
                if (dat.exists()) {
                    dat.delete();
                    dat.createNewFile();
                }
                this.dataFile = new RandomAccessFile(dat, "rw");
            }
        }
        catch (Exception e) {
            log.error("Failed to create FLV writer", (Throwable)e);
        }
    }

    @Override
    public void writeHeader() throws IOException {
        FLVHeader flvHeader = new FLVHeader();
        flvHeader.setFlagAudio(this.audioCodecId != -1);
        flvHeader.setFlagVideo(this.videoCodecId != -1);
        ByteBuffer header = ByteBuffer.allocate(13);
        flvHeader.write(header);
        this.file = new RandomAccessFile(this.filePath, "rw");
        this.file.setLength(13L);
        if (header.hasArray()) {
            log.debug("Header bytebuffer has a backing array");
            this.file.write(header.array());
        } else {
            log.debug("Header bytebuffer does not have a backing array");
            byte[] tmp = new byte[13];
            header.get(tmp);
            this.file.write(tmp);
        }
        this.bytesWritten = this.file.length();
        assert (13L - this.bytesWritten == 0L);
        log.debug("Header size: {} bytes written: {}", (Object)13, (Object)this.bytesWritten);
        header.clear();
        header = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeTag(ITag tag) throws IOException {
        try {
            this.lock.acquire();
            log.trace("writeTag: {}", (Object)tag);
            long prevBytesWritten = this.bytesWritten;
            log.trace("Previous bytes written: {}", (Object)prevBytesWritten);
            int bodySize = tag.getBodySize();
            log.debug("Tag body size: {}", (Object)bodySize);
            int previousTagSize = tag.getPreviousTagSize();
            if (previousTagSize != this.lastTagSize) {
                log.debug("Incoming previous tag size: {} does not match current value for last tag size: {}", (Object)previousTagSize, (Object)this.lastTagSize);
            }
            if (this.dataFile != null) {
                log.debug("Current file position: {}", (Object)this.dataFile.getChannel().position());
                byte dataType = tag.getDataType();
                IoBuffer tagBody = tag.getBody();
                if (dataType != 18) {
                    long fileOffset = this.dataFile.getFilePointer();
                    log.debug("Current file offset: {} expected offset: {}", (Object)fileOffset, (Object)prevBytesWritten);
                    if (fileOffset < prevBytesWritten) {
                        log.debug("Seeking to expected offset");
                        this.dataFile.seek(prevBytesWritten);
                        log.debug("New file position: {}", (Object)this.dataFile.getChannel().position());
                    }
                } else {
                    tagBody.mark();
                    Input metadata = new Input(tagBody);
                    metadata.readDataType();
                    String metaType = metadata.readString();
                    log.debug("Metadata tag type: {}", (Object)metaType);
                    try {
                        tagBody.reset();
                    }
                    catch (InvalidMarkException e) {
                        log.debug("Exception reseting position of buffer: {}", (Object)e.getMessage(), (Object)e);
                    }
                    if (!"onCuePoint".equals(metaType)) {
                        this.metaTags.put(System.currentTimeMillis(), tag);
                        boolean e = true;
                        return e;
                    }
                }
                int totalTagSize = 11 + bodySize + 4;
                this.dataFile.setLength(this.dataFile.length() + (long)totalTagSize);
                ByteBuffer tagBuffer = ByteBuffer.allocate(totalTagSize);
                int timestamp = tag.getTimestamp() + this.timeOffset;
                byte[] bodyBuf = null;
                if (bodySize > 0) {
                    int id;
                    bodyBuf = new byte[bodySize];
                    tagBody.get(bodyBuf);
                    if (dataType == 8) {
                        this.audioDataSize += bodySize;
                        if (this.audioCodecId == -1) {
                            id = bodyBuf[0] & 0xFF;
                            this.audioCodecId = (id & 0xF0) >> 4;
                            log.debug("Audio codec id: {}", (Object)this.audioCodecId);
                            if (this.audioCodecId == AudioCodec.AAC.getId()) {
                                log.trace("AAC audio type");
                                this.soundRate = 44100;
                                this.soundSize = 16;
                                this.soundType = true;
                            } else if (this.audioCodecId == AudioCodec.SPEEX.getId()) {
                                log.trace("Speex audio type");
                                this.soundRate = 5500;
                                this.soundSize = 16;
                                this.soundType = false;
                            } else {
                                switch ((id & 0xC) >> 2) {
                                    case 0: {
                                        this.soundRate = 5500;
                                        break;
                                    }
                                    case 1: {
                                        this.soundRate = 11000;
                                        break;
                                    }
                                    case 2: {
                                        this.soundRate = 22000;
                                        break;
                                    }
                                    case 3: {
                                        this.soundRate = 44100;
                                    }
                                }
                                log.debug("Sound rate: {}", (Object)this.soundRate);
                                switch ((id & 2) >> 1) {
                                    case 0: {
                                        this.soundSize = 8;
                                        break;
                                    }
                                    case 1: {
                                        this.soundSize = 16;
                                    }
                                }
                                log.debug("Sound size: {}", (Object)this.soundSize);
                                this.soundType = (id & 1) > 0;
                                log.debug("Sound type: {}", (Object)this.soundType);
                            }
                        }
                    } else if (dataType == 9) {
                        this.videoDataSize += bodySize;
                        if (this.videoCodecId == -1) {
                            id = bodyBuf[0] & 0xFF;
                            this.videoCodecId = id & 0xF;
                            log.debug("Video codec id: {}", (Object)this.videoCodecId);
                        }
                    }
                }
                IOUtils.writeUnsignedByte(tagBuffer, dataType);
                IOUtils.writeMediumInt(tagBuffer, bodySize);
                IOUtils.writeExtendedMediumInt(tagBuffer, timestamp);
                tagBuffer.put(DEFAULT_STREAM_ID);
                if (log.isTraceEnabled()) {
                    log.trace("Tag buffer (after tag header) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
                }
                if (bodyBuf != null) {
                    tagBuffer.put(bodyBuf);
                    if (log.isTraceEnabled()) {
                        log.trace("Tag buffer (after body) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
                    }
                }
                tagBuffer.putInt(11 + bodySize);
                if (log.isTraceEnabled()) {
                    log.trace("Tag buffer (after prev tag size) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
                }
                tagBuffer.flip();
                if (log.isDebugEnabled()) {
                    // empty if block
                }
                this.dataFile.write(tagBuffer.array());
                this.bytesWritten = this.dataFile.length();
                if (log.isTraceEnabled()) {
                    log.trace("Tag written, check value: {} (should be 0)", (Object)(this.bytesWritten - prevBytesWritten - (long)totalTagSize));
                }
                this.lastTagSize = 11 + bodySize;
                tagBuffer.clear();
                this.duration = Math.max(this.duration, timestamp);
                log.debug("Writer duration: {}", (Object)this.duration);
                if (this.bytesWritten - prevBytesWritten != (long)totalTagSize) {
                    log.debug("Not all of the bytes appear to have been written, prev-current: {}", (Object)(this.bytesWritten - prevBytesWritten));
                }
                boolean bl = true;
                return bl;
            }
            try {
                throw new IOException("FLV write channel has been closed", new ClosedChannelException());
            }
            catch (InterruptedException e) {
                log.warn("Exception acquiring lock", (Throwable)e);
            }
        }
        finally {
            this.updateInfoFile();
            this.lock.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeTag(byte dataType, IoBuffer data) throws IOException {
        if (this.timeOffset == 0) {
            this.timeOffset = (int)System.currentTimeMillis();
        }
        try {
            this.lock.acquire();
            if (log.isTraceEnabled()) {
                log.trace("writeTag - type: {} data: {}", (Object)dataType, (Object)data);
            }
            long prevBytesWritten = this.bytesWritten;
            log.trace("Previous bytes written: {}", (Object)prevBytesWritten);
            int bodySize = data.limit();
            log.debug("Tag body size: {}", (Object)bodySize);
            if (this.dataFile != null) {
                log.debug("Current file position: {}", (Object)this.dataFile.getChannel().position());
                if (dataType != 18) {
                    long fileOffset = this.dataFile.getFilePointer();
                    log.debug("Current file offset: {} expected offset: {}", (Object)fileOffset, (Object)prevBytesWritten);
                    if (fileOffset < prevBytesWritten) {
                        log.debug("Seeking to expected offset");
                        this.dataFile.seek(prevBytesWritten);
                        log.debug("New file position: {}", (Object)this.dataFile.getChannel().position());
                    }
                } else {
                    data.mark();
                    Input metadata = new Input(data);
                    metadata.readDataType();
                    String metaType = metadata.readString();
                    log.debug("Metadata tag type: {}", (Object)metaType);
                    data.reset();
                    if (!"onCuePoint".equals(metaType)) {
                        boolean bl = true;
                        return bl;
                    }
                }
                int totalTagSize = 11 + bodySize + 4;
                this.dataFile.setLength(this.dataFile.length() + (long)totalTagSize);
                ByteBuffer tagBuffer = ByteBuffer.allocate(totalTagSize);
                IOUtils.writeUnsignedByte(tagBuffer, dataType);
                IOUtils.writeMediumInt(tagBuffer, bodySize);
                int timestamp = (int)(System.currentTimeMillis() - (long)this.timeOffset);
                IOUtils.writeExtendedMediumInt(tagBuffer, timestamp);
                tagBuffer.put(DEFAULT_STREAM_ID);
                log.trace("Tag buffer (after tag header) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
                if (data.hasArray()) {
                    tagBuffer.put(data.array());
                    log.trace("Tag buffer (after body) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
                }
                tagBuffer.putInt(11 + bodySize);
                log.trace("Tag buffer (after prev tag size) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
                tagBuffer.flip();
                if (log.isDebugEnabled()) {
                    // empty if block
                }
                this.dataFile.write(tagBuffer.array());
                this.bytesWritten = this.dataFile.length();
                if (log.isTraceEnabled()) {
                    log.trace("Tag written, check value: {} (should be 0)", (Object)(this.bytesWritten - prevBytesWritten - (long)totalTagSize));
                }
                this.lastTagSize = 11 + bodySize;
                tagBuffer.clear();
                this.duration = Math.max(this.duration, timestamp);
                log.debug("Writer duration: {}", (Object)this.duration);
                if (this.bytesWritten - prevBytesWritten != (long)totalTagSize) {
                    log.debug("Not all of the bytes appear to have been written, prev-current: {}", (Object)(this.bytesWritten - prevBytesWritten));
                }
                boolean bl = true;
                return bl;
            }
            try {
                throw new IOException("FLV write channel has been closed", new ClosedChannelException());
            }
            catch (InterruptedException e) {
                log.warn("Exception acquiring lock", (Throwable)e);
            }
        }
        finally {
            this.updateInfoFile();
            this.lock.release();
        }
        return false;
    }

    @Override
    public boolean writeStream(byte[] b) {
        try {
            this.dataFile.write(b);
            return true;
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            return false;
        }
    }

    private void writeMetadataTag(double duration, int videoCodecId, int audioCodecId) throws IOException {
        log.debug("writeMetadataTag - duration: {} video codec: {} audio codec: {}", new Object[]{duration, videoCodecId, audioCodecId});
        IoBuffer buf = IoBuffer.allocate((int)1024);
        buf.setAutoExpand(true);
        Output out = new Output(buf);
        out.writeString("onMetaData");
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        params.put("server", "Red5");
        params.put("creationdate", GregorianCalendar.getInstance().getTime().toString());
        params.put("duration", duration);
        if (videoCodecId != -1) {
            params.put("videocodecid", videoCodecId == 7 ? "avc1" : Integer.valueOf(videoCodecId));
            if (this.videoDataSize > 0) {
                params.put("videodatarate", (double)(8 * this.videoDataSize / 1024) / duration);
            }
        } else {
            params.put("novideocodec", 0);
        }
        if (audioCodecId != -1) {
            params.put("audiocodecid", audioCodecId == 10 ? "mp4a" : Integer.valueOf(audioCodecId));
            if (audioCodecId == AudioCodec.AAC.getId()) {
                params.put("audiosamplerate", 44100);
                params.put("audiosamplesize", 16);
            } else if (audioCodecId == AudioCodec.SPEEX.getId()) {
                params.put("audiosamplerate", 16000);
                params.put("audiosamplesize", 16);
            } else {
                params.put("audiosamplerate", this.soundRate);
                params.put("audiosamplesize", this.soundSize);
            }
            params.put("stereo", this.soundType);
            if (this.audioDataSize > 0) {
                params.put("audiodatarate", (double)(8 * this.audioDataSize / 1024) / duration);
            }
        } else {
            params.put("noaudiocodec", 0);
        }
        params.put("canSeekToEnd", true);
        out.writeMap(params);
        buf.flip();
        int bodySize = buf.limit();
        log.debug("Metadata size: {}", (Object)bodySize);
        int totalTagSize = 11 + bodySize + 4;
        this.file.setLength(this.file.length() + (long)totalTagSize);
        ByteBuffer tagBuffer = ByteBuffer.allocate(totalTagSize);
        int timestamp = 0;
        byte[] bodyBuf = new byte[bodySize];
        buf.get(bodyBuf);
        IOUtils.writeUnsignedByte(tagBuffer, (byte)18);
        IOUtils.writeMediumInt(tagBuffer, bodySize);
        IOUtils.writeExtendedMediumInt(tagBuffer, timestamp);
        tagBuffer.put(DEFAULT_STREAM_ID);
        if (log.isTraceEnabled()) {
            log.trace("Tag buffer (after tag header) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
        }
        tagBuffer.put(bodyBuf);
        if (log.isTraceEnabled()) {
            log.trace("Tag buffer (after body) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
        }
        tagBuffer.putInt(11 + bodySize);
        if (log.isTraceEnabled()) {
            log.trace("Tag buffer (after prev tag size) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
        }
        tagBuffer.flip();
        this.file.write(tagBuffer.array());
        this.bytesWritten = this.file.length();
        tagBuffer.clear();
        buf.clear();
    }

    private void updateMetadataTag(RandomAccessFile flvFile, double duration, int videoCodecId, int audioCodecId) throws IOException {
        log.debug("updateMetadataTag - duration: {} video codec: {} audio codec: {}", new Object[]{duration, videoCodecId, audioCodecId});
        IoBuffer buf = IoBuffer.allocate((int)512);
        buf.setAutoExpand(true);
        Output out = new Output(buf);
        out.writeString("onMetaData");
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        params.put("server", "Red5");
        params.put("creationdate", GregorianCalendar.getInstance().getTime().toString());
        params.put("duration", duration);
        if (videoCodecId != -1) {
            params.put("videocodecid", videoCodecId == 7 ? "avc1" : Integer.valueOf(videoCodecId));
            if (this.videoDataSize > 0) {
                params.put("videodatarate", (double)(8 * this.videoDataSize / 1024) / duration);
            }
        } else {
            params.put("novideocodec", 0);
        }
        if (audioCodecId != -1) {
            params.put("audiocodecid", audioCodecId == 10 ? "mp4a" : Integer.valueOf(audioCodecId));
            if (audioCodecId == AudioCodec.AAC.getId()) {
                params.put("audiosamplerate", 44100);
                params.put("audiosamplesize", 16);
            } else if (audioCodecId == AudioCodec.SPEEX.getId()) {
                params.put("audiosamplerate", 16000);
                params.put("audiosamplesize", 16);
            } else {
                params.put("audiosamplerate", this.soundRate);
                params.put("audiosamplesize", this.soundSize);
            }
            params.put("stereo", this.soundType);
            if (this.audioDataSize > 0) {
                params.put("audiodatarate", (double)(8 * this.audioDataSize / 1024) / duration);
            }
        } else {
            params.put("noaudiocodec", 0);
        }
        params.put("canSeekToEnd", true);
        out.writeMap(params);
        buf.flip();
        int bodySize = buf.limit();
        log.debug("Metadata size: {}", (Object)bodySize);
        int totalTagSize = 11 + bodySize + 4;
        ByteBuffer tagBuffer = ByteBuffer.allocate(totalTagSize);
        int timestamp = 0;
        byte[] bodyBuf = new byte[bodySize];
        buf.get(bodyBuf);
        IOUtils.writeUnsignedByte(tagBuffer, (byte)18);
        IOUtils.writeMediumInt(tagBuffer, bodySize);
        IOUtils.writeExtendedMediumInt(tagBuffer, timestamp);
        tagBuffer.put(DEFAULT_STREAM_ID);
        if (log.isTraceEnabled()) {
            log.trace("Tag buffer (after tag header) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
        }
        tagBuffer.put(bodyBuf);
        if (log.isTraceEnabled()) {
            log.trace("Tag buffer (after body) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
        }
        tagBuffer.putInt(11 + bodySize);
        if (log.isTraceEnabled()) {
            log.trace("Tag buffer (after prev tag size) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
        }
        tagBuffer.flip();
        flvFile.seek(13L);
        flvFile.write(tagBuffer.array());
        tagBuffer.clear();
        buf.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long finalizeFlv() {
        log.debug("Finalizing {}", (Object)this.filePath);
        long bytesTransferred = 0L;
        try {
            File tmpFile = new File(this.filePath + ".info");
            if (tmpFile.exists()) {
                int[] info = this.readInfoFile(tmpFile);
                if (this.audioCodecId == -1 && info[0] > 0) {
                    this.audioCodecId = info[0];
                }
                if (this.videoCodecId == -1 && info[1] > 0) {
                    this.videoCodecId = info[1];
                }
                if (this.duration == 0 && info[2] > 0) {
                    this.duration = info[2];
                }
                if (this.audioDataSize == 0 && info[3] > 0) {
                    this.audioDataSize = info[3];
                }
                if (this.soundRate == 0 && info[4] > 0) {
                    this.soundRate = info[4];
                }
                if (this.soundSize == 0 && info[5] > 0) {
                    this.soundSize = info[5];
                }
                if (!this.soundType && info[6] > 0) {
                    this.soundType = true;
                }
                if (this.videoDataSize == 0 && info[7] > 0) {
                    this.videoDataSize = info[7];
                }
            } else {
                log.debug("Flv info file not found");
            }
            tmpFile = null;
            if (!this.append) {
                this.writeHeader();
                this.writeMetadataTag((double)this.duration * 0.001, this.videoCodecId, this.audioCodecId);
                if (this.dataFile == null) {
                    this.dataFile = new RandomAccessFile(this.filePath + ".ser", "r");
                }
                this.dataFile.seek(0L);
                bytesTransferred = this.file.getChannel().transferFrom(this.dataFile.getChannel(), this.bytesWritten, this.dataFile.length());
            } else {
                this.updateMetadataTag(this.dataFile, (double)this.duration * 0.001, this.videoCodecId, this.audioCodecId);
                bytesTransferred = 1L;
            }
            if (this.dataFile != null && bytesTransferred > 0L) {
                this.dataFile.close();
                this.dataFile = null;
                if (bytesTransferred > 0L) {
                    File inf;
                    File dat = new File(this.filePath + ".ser");
                    if (dat.exists()) {
                        dat.delete();
                    }
                    if ((inf = new File(this.filePath + ".info")).exists()) {
                        inf.delete();
                    }
                } else {
                    log.warn("FLV serial file not deleted due to transfer error");
                }
            }
        }
        catch (Exception e) {
            log.warn("Finalization of flv file failed; new finalize job will be spawned", (Throwable)e);
        }
        finally {
            if (this.file != null) {
                try {
                    this.file.close();
                }
                catch (Exception exception) {}
            }
        }
        return bytesTransferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] readInfoFile(File tmpFile) {
        int[] info = new int[8];
        RandomAccessFile infoFile = null;
        try {
            infoFile = new RandomAccessFile(tmpFile, "r");
            info[0] = infoFile.readInt();
            info[1] = infoFile.readInt();
            info[2] = infoFile.readInt();
            info[3] = infoFile.readInt();
            info[4] = infoFile.readInt();
            info[5] = infoFile.readInt();
            info[6] = infoFile.readInt();
            info[7] = infoFile.readInt();
        }
        catch (Exception e) {
            log.warn("Exception reading flv file information data", (Throwable)e);
        }
        finally {
            if (infoFile != null) {
                try {
                    infoFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInfoFile() {
        RandomAccessFile infoFile = null;
        try {
            infoFile = new RandomAccessFile(this.filePath + ".info", "rw");
            infoFile.writeInt(this.audioCodecId);
            infoFile.writeInt(this.videoCodecId);
            infoFile.writeInt(this.duration);
            infoFile.writeInt(this.audioDataSize);
            infoFile.writeInt(this.soundRate);
            infoFile.writeInt(this.soundSize);
            infoFile.writeInt(this.soundType ? 1 : 0);
            infoFile.writeInt(this.videoDataSize);
        }
        catch (Exception e) {
            log.warn("Exception writing flv file information data", (Throwable)e);
        }
        finally {
            if (infoFile != null) {
                try {
                    infoFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        log.debug("close");
        log.debug("Meta tags: {}", this.metaTags);
        boolean locked = false;
        long bytesTransferred = 0L;
        try {
            locked = this.lock.tryAcquire(500L, TimeUnit.MILLISECONDS);
            if (locked) {
                bytesTransferred = this.finalizeFlv();
            }
        }
        catch (InterruptedException e) {
            log.warn("Exception acquiring lock", (Throwable)e);
        }
        finally {
            if (locked) {
                this.lock.release();
            }
            log.debug("{} closed", (Object)this.filePath);
            if (bytesTransferred == 0L) {
                log.info("Spawning flv finalizer for {}", (Object)this.filePath);
                this.spawnFinalizer().start();
            }
        }
    }

    Thread spawnFinalizer() {
        return new Thread((Runnable)new FLVFinalizer(), "FLVFinalizer#" + System.currentTimeMillis());
    }

    @Override
    public IStreamableFile getFile() {
        return this.flv;
    }

    public void setFLV(IFLV flv) {
        this.flv = flv;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public void setVideoCodecId(int videoCodecId) {
        this.videoCodecId = videoCodecId;
    }

    public void setAudioCodecId(int audioCodecId) {
        this.audioCodecId = audioCodecId;
    }

    public void setSoundRate(int soundRate) {
        this.soundRate = soundRate;
    }

    public void setSoundSize(int soundSize) {
        this.soundSize = soundSize;
    }

    public void setSoundType(boolean soundType) {
        this.soundType = soundType;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setVideoDataSize(int videoDataSize) {
        this.videoDataSize = videoDataSize;
    }

    public void setAudioDataSize(int audioDataSize) {
        this.audioDataSize = audioDataSize;
    }

    public static boolean repair(String path, Integer audioId, Integer videoId) throws InterruptedException {
        boolean result = false;
        FLVWriter writer = null;
        log.debug("Serial file path: " + path);
        System.out.println("Serial file path: " + path);
        if (path.endsWith(".ser")) {
            File ser = new File(path);
            if (ser.exists() && ser.canRead()) {
                ser = null;
                String flvPath = path.substring(0, path.lastIndexOf(46));
                log.debug("Flv file path: " + flvPath);
                System.out.println("Flv file path: " + flvPath);
                File inf = new File(flvPath + ".info");
                if (inf.exists() && inf.canRead()) {
                    inf = null;
                    writer = new FLVWriter(flvPath);
                } else {
                    log.debug("Info file was not found or could not be read, using dummy data");
                    System.err.println("Info file was not found or could not be read, using dummy data");
                    writer = new FLVWriter(flvPath);
                    int acid = audioId == null ? 11 : audioId;
                    int vcid = videoId == null ? 7 : videoId;
                    writer.setAudioCodecId(acid);
                    writer.setVideoCodecId(vcid);
                    writer.setDuration(Integer.MAX_VALUE);
                    writer.setSoundRate(16000);
                    writer.setSoundSize(16);
                }
            } else {
                log.error("Serial file was not found or could not be read");
                System.err.println("Serial file was not found or could not be read");
            }
        } else {
            log.error("Provide the path to your .ser file");
            System.err.println("Serial file was not found or could not be read");
        }
        if (writer != null) {
            Thread job = writer.spawnFinalizer();
            job.start();
            job.join();
            log.debug("File repair completed");
            System.out.println("File repair completed");
            result = true;
        }
        return result;
    }

    public static void main(String[] args) throws InterruptedException {
        if (args == null || args[0] == null) {
            System.err.println("Provide the path to your .ser file");
        } else {
            FLVWriter.repair(args[0], args.length > 1 && args[1] != null ? Integer.valueOf(args[1]) : null, args.length > 2 && args[2] != null ? Integer.valueOf(args[2]) : null);
        }
        System.exit(0);
    }

    private final class FLVFinalizer
    implements Runnable {
        private FLVFinalizer() {
        }

        @Override
        public void run() {
            log.debug("Finalizer run");
            try {
                FLVWriter.this.file = null;
                File tmp = new File(FLVWriter.this.filePath);
                boolean deleted = tmp.delete();
                log.info("Deleted ({}) incomplete file: {}", (Object)deleted, (Object)FLVWriter.this.filePath);
                tmp = null;
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                log.error("Error on cleanup of flv", (Throwable)e);
            }
            FLVWriter.this.finalizeFlv();
            log.debug("Finalizer exit");
        }
    }
}

