/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.flv.meta;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.io.ITag;
import org.red5.io.amf.Input;
import org.red5.io.amf.Output;
import org.red5.io.flv.impl.FLVReader;
import org.red5.io.flv.impl.FLVWriter;
import org.red5.io.flv.impl.Tag;
import org.red5.io.flv.meta.IMeta;
import org.red5.io.flv.meta.IMetaCue;
import org.red5.io.flv.meta.IMetaData;
import org.red5.io.flv.meta.IMetaService;
import org.red5.io.flv.meta.MetaCue;
import org.red5.io.flv.meta.MetaData;
import org.red5.io.object.Deserializer;
import org.red5.io.object.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaService
implements IMetaService {
    protected static Logger log = LoggerFactory.getLogger(MetaService.class);
    File file;

    public MetaService() {
    }

    public MetaService(File poFil) {
        this();
        this.file = poFil;
    }

    @Override
    public void write(IMetaData<?, ?> meta) throws IOException {
        Object[] metaArr = meta.getMetaCue();
        FLVReader reader = new FLVReader(this.file, false);
        FLVWriter writer = new FLVWriter(this.file, false);
        ITag tag = null;
        if (reader.hasMoreTags() && (tag = reader.readTag()).getDataType() == 18 && !reader.hasMoreTags()) {
            throw new IOException("File we're writing is metadata only?");
        }
        if (tag == null) {
            throw new IOException("Tag was null");
        }
        meta.setDuration((double)reader.getDuration() / 1000.0);
        meta.setVideoCodecId(reader.getVideoCodecId());
        meta.setAudioCodecId(reader.getAudioCodecId());
        ITag injectedTag = this.injectMetaData(meta, tag);
        injectedTag.setPreviousTagSize(0);
        tag.setPreviousTagSize(injectedTag.getBodySize());
        try {
            writer.writeTag(injectedTag);
            writer.writeTag(tag);
        }
        catch (Exception e) {
            log.warn("Metadata insert failed", (Throwable)e);
            return;
        }
        int cuePointTimeStamp = 0;
        int counter = 0;
        if (metaArr != null) {
            Arrays.sort(metaArr);
            cuePointTimeStamp = this.getTimeInMilliseconds((IMetaCue)metaArr[0]);
        }
        while (reader.hasMoreTags()) {
            tag = reader.readTag();
            if (counter < metaArr.length) {
                while (tag.getTimestamp() > cuePointTimeStamp) {
                    injectedTag = this.injectMetaCue((IMetaCue)metaArr[counter], tag);
                    writer.writeTag(injectedTag);
                    tag.setPreviousTagSize(injectedTag.getBodySize());
                    if (++counter > metaArr.length - 1) break;
                    cuePointTimeStamp = this.getTimeInMilliseconds((IMetaCue)metaArr[counter]);
                }
            }
            if (tag.getDataType() == 18) continue;
            writer.writeTag(tag);
        }
        writer.close();
    }

    public static IMeta mergeMeta(IMetaData<?, ?> metaData1, IMetaData<?, ?> metaData2) {
        Map map1 = (Map)((Object)metaData1);
        Set set1 = map1.entrySet();
        Map map2 = (Map)((Object)metaData2);
        Set set2 = map2.entrySet();
        HashMap rep = new HashMap();
        for (Map.Entry entry1 : set1) {
            String key1 = (String)entry1.getKey();
            if (!map2.containsKey(key1)) continue;
            Object value1 = map1.get(key1);
            Object value2 = map2.get(key1);
            if (value1 instanceof Double) {
                if (Double.valueOf(value1.toString()) < Double.valueOf(value2.toString())) {
                    rep.put(key1, value2);
                }
            } else if (value1 instanceof Integer) {
                if (Integer.valueOf(value1.toString()) < Integer.valueOf(value2.toString())) {
                    rep.put(key1, value2);
                }
            } else if (value1 instanceof Long && Long.valueOf(value1.toString()) < Long.valueOf(value2.toString())) {
                rep.put(key1, value2);
            }
            if (!(value1 instanceof Boolean) || Boolean.valueOf(value1.toString()).booleanValue() || !Boolean.valueOf(value2.toString()).booleanValue()) continue;
            rep.put(key1, value2);
        }
        set1.removeAll(rep.entrySet());
        set1.addAll(rep.entrySet());
        set1.addAll(set2);
        return metaData1;
    }

    private ITag injectMetaData(IMetaData<?, ?> meta, ITag tag) {
        IoBuffer bb = IoBuffer.allocate((int)1000);
        bb.setAutoExpand(true);
        Output out = new Output(bb);
        Serializer.serialize(out, "onMetaData");
        Serializer.serialize(out, meta);
        IoBuffer tmpBody = out.buf().flip();
        int tmpBodySize = out.buf().limit();
        int tmpPreviousTagSize = tag.getPreviousTagSize();
        return new Tag(18, 0, tmpBodySize, tmpBody, tmpPreviousTagSize);
    }

    private ITag injectMetaCue(IMetaCue meta, ITag tag) {
        Output out = new Output(IoBuffer.allocate((int)1000));
        Serializer.serialize(out, "onCuePoint");
        Serializer.serialize(out, meta);
        IoBuffer tmpBody = out.buf().flip();
        int tmpBodySize = out.buf().limit();
        int tmpPreviousTagSize = tag.getPreviousTagSize();
        int tmpTimestamp = this.getTimeInMilliseconds(meta);
        return new Tag(18, tmpTimestamp, tmpBodySize, tmpBody, tmpPreviousTagSize);
    }

    private int getTimeInMilliseconds(IMetaCue metaCue) {
        return (int)(metaCue.getTime() * 1000.0);
    }

    @Override
    public void writeMetaData(IMetaData<?, ?> metaData) {
        MetaCue meta = (MetaCue)((Object)metaData);
        Output out = new Output(IoBuffer.allocate((int)1000));
        Serializer.serialize(out, "onCuePoint");
        Serializer.serialize(out, meta);
    }

    @Override
    public void writeMetaCue() {
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public MetaData<?, ?> readMetaData(IoBuffer buffer) {
        MetaData retMeta = new MetaData();
        Input input = new Input(buffer);
        String metaType = (String)Deserializer.deserialize(input, String.class);
        log.debug("Metadata type: {}", (Object)metaType);
        Map m = (Map)Deserializer.deserialize(input, Map.class);
        retMeta.putAll(m);
        return retMeta;
    }

    @Override
    public IMetaCue[] readMetaCue() {
        return null;
    }
}

