/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.matroska.dtd;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.red5.io.matroska.ConverterException;
import org.red5.io.matroska.VINT;
import org.red5.io.matroska.dtd.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagFactory {
    private static Logger log = LoggerFactory.getLogger(TagFactory.class);
    private static final Map<Long, NameTag> tagsById = new Hashtable<Long, NameTag>();
    private static final Map<String, IdTag> tagsByName = new Hashtable<String, IdTag>();

    public static Tag createTag(VINT id, VINT size, InputStream inputStream) throws ConverterException {
        NameTag nt = tagsById.get(id.getBinary());
        if (null == nt) {
            throw new ConverterException("not supported matroska tag: " + id.getBinary());
        }
        try {
            return (Tag)nt.clazz.getConstructor(String.class, VINT.class, VINT.class, InputStream.class).newInstance(nt.name, id, size, inputStream);
        }
        catch (Exception e) {
            log.error("Unexpected exception while creating tag", (Throwable)e);
            return null;
        }
    }

    public static Tag createTag(String tagName) throws ConverterException {
        log.debug("Tag: " + tagName);
        IdTag it = tagsByName.get(tagName);
        if (null == it) {
            throw new ConverterException("not supported matroska tag: " + tagName);
        }
        VINT typeVint = VINT.fromBinary(it.id);
        try {
            Tag newTag = (Tag)it.clazz.getConstructor(String.class, VINT.class).newInstance(tagName, typeVint);
            return newTag;
        }
        catch (Exception e) {
            log.error("Can not find property", (Throwable)e);
            return null;
        }
    }

    public static <T> T create(String tagName) throws ConverterException {
        return (T)TagFactory.createTag(tagName);
    }

    static {
        Properties props = new Properties();
        try (InputStream input = TagFactory.class.getResourceAsStream("matroska_type_by_id_definition.properties");){
            props.load(input);
            log.trace("Properties are loaded");
            for (Map.Entry<Object, Object> e : props.entrySet()) {
                if (log.isTraceEnabled()) {
                    log.trace("Processing property: {} -> {}", e.getKey(), e.getValue());
                }
                Long id = Long.valueOf("" + e.getKey(), 16);
                NameTag nt = new NameTag(e.getValue());
                tagsById.put(id, nt);
                tagsByName.put(nt.name, new IdTag(id, nt.clazz));
            }
        }
        catch (Exception e) {
            log.error("Unexpected exception while reading properties", (Throwable)e);
        }
    }

    private static class IdTag {
        private final Long id;
        private final Class<? extends Tag> clazz;

        private IdTag(Long id, Class<? extends Tag> clazz) {
            this.id = id;
            this.clazz = clazz;
        }

        private IdTag(Object prop) throws ClassNotFoundException {
            String[] parameters = ((String)prop).split(",");
            this.id = Long.valueOf("" + parameters[0], 16);
            this.clazz = Class.forName(TagFactory.class.getPackage().getName() + "." + parameters[1]);
        }
    }

    private static class NameTag {
        private final String name;
        private final Class<? extends Tag> clazz;

        private NameTag(Object prop) throws ClassNotFoundException {
            String[] parameters = ((String)prop).split(",");
            this.name = parameters[0];
            this.clazz = Class.forName(TagFactory.class.getPackage().getName() + "." + parameters[1]);
        }
    }
}

