/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.object;

import org.red5.io.object.UnsignedNumber;

public final class UnsignedInt
extends UnsignedNumber {
    static final long serialVersionUID = 1L;
    private long value;

    public UnsignedInt(byte c) {
        this.value = c;
    }

    public UnsignedInt(short c) {
        this.value = c;
    }

    public UnsignedInt(int c) {
        this.value = c;
    }

    public UnsignedInt(long c) {
        this.value = c & 0xFFFFFFFFL;
    }

    private UnsignedInt() {
        this.value = 0L;
    }

    public static UnsignedInt fromBytes(byte[] c) {
        return UnsignedInt.fromBytes(c, 0);
    }

    public static UnsignedInt fromBytes(byte[] c, int idx) {
        UnsignedInt number = new UnsignedInt();
        if (c.length - idx < 4) {
            throw new IllegalArgumentException("An UnsignedInt number is composed of 4 bytes.");
        }
        number.value = c[0] << 24 | c[1] << 16 | c[2] << 8 | c[3];
        return number;
    }

    public static UnsignedInt fromString(String c) {
        return UnsignedInt.fromString(c, 10);
    }

    public static UnsignedInt fromString(String c, int radix) {
        UnsignedInt number = new UnsignedInt();
        long v = Long.parseLong(c, radix);
        number.value = v & 0xFFFFFFFFL;
        return number;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)(this.value & 0xFFFFFFFFL);
    }

    @Override
    public long longValue() {
        return this.value & 0xFFFFFFFFL;
    }

    @Override
    public byte[] getBytes() {
        byte[] c = new byte[]{(byte)(this.value >> 24 & 0xFFL), (byte)(this.value >> 16 & 0xFFL), (byte)(this.value >> 8 & 0xFFL), (byte)(this.value >> 0 & 0xFFL)};
        return c;
    }

    @Override
    public int compareTo(UnsignedNumber other) {
        long otherValue = other.longValue();
        if (this.value > otherValue) {
            return 1;
        }
        if (this.value < otherValue) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Number)) {
            return false;
        }
        return this.value == ((Number)other).longValue();
    }

    @Override
    public String toString() {
        return Long.toString(this.value & 0xFFFFFFFFL);
    }

    @Override
    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    public void shiftRight(int nBits) {
        if (Math.abs(nBits) > 32) {
            throw new IllegalArgumentException("Cannot right shift " + nBits + " an UnsignedInt.");
        }
        this.value >>>= nBits;
    }

    @Override
    public void shiftLeft(int nBits) {
        if (Math.abs(nBits) > 32) {
            throw new IllegalArgumentException("Cannot left shift " + nBits + " an UnsignedInt.");
        }
        this.value <<= nBits;
    }
}

