/*
 * Decompiled with CFR 0.152.
 */
package org.red5.codec;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.codec.IVideoStreamCodec;
import org.red5.codec.VideoCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AVCVideo
implements IVideoStreamCodec {
    private static Logger log = LoggerFactory.getLogger(AVCVideo.class);
    static final String CODEC_NAME = "AVC";
    private IVideoStreamCodec.FrameData keyframe;
    private IVideoStreamCodec.FrameData decoderConfiguration;
    private final CopyOnWriteArrayList<IVideoStreamCodec.FrameData> interframes = new CopyOnWriteArrayList();
    private final AtomicInteger numInterframes = new AtomicInteger(0);

    public AVCVideo() {
        this.reset();
    }

    @Override
    public String getName() {
        return CODEC_NAME;
    }

    @Override
    public boolean canDropFrames() {
        return true;
    }

    @Override
    public void reset() {
        this.keyframe = new IVideoStreamCodec.FrameData();
        this.decoderConfiguration = new IVideoStreamCodec.FrameData();
    }

    @Override
    public boolean canHandleData(IoBuffer data) {
        boolean result = false;
        if (data.limit() > 0) {
            result = (data.get() & 0xF) == VideoCodec.AVC.getId();
            data.rewind();
        }
        return result;
    }

    @Override
    public boolean addData(IoBuffer data) {
        if (data.limit() > 0) {
            byte frameType = data.get();
            if ((frameType & 0xF) == VideoCodec.AVC.getId()) {
                if ((frameType & 0xF0) == 16) {
                    log.trace("Key frame found");
                    this.numInterframes.set(0);
                    this.interframes.clear();
                    byte AVCPacketType = data.get();
                    data.rewind();
                    log.debug("AVCPacketType: {}", (Object)AVCPacketType);
                    if (AVCPacketType == 0) {
                        log.trace("Decoder configuration found");
                        this.decoderConfiguration.setData(data);
                        data.rewind();
                    }
                    this.keyframe.setData(data);
                } else {
                    data.rewind();
                    try {
                        int lastInterframe = this.numInterframes.getAndIncrement();
                        log.trace("Buffering interframe #{}", (Object)lastInterframe);
                        if (lastInterframe < this.interframes.size()) {
                            this.interframes.get(lastInterframe).setData(data);
                        } else {
                            this.interframes.add(new IVideoStreamCodec.FrameData(data));
                        }
                    }
                    catch (Throwable e) {
                        log.error("Failed to buffer interframe", e);
                    }
                }
                data.rewind();
            } else {
                log.debug("Non-AVC data, rejecting");
                return false;
            }
        }
        return true;
    }

    @Override
    public IoBuffer getKeyframe() {
        return this.keyframe.getFrame();
    }

    @Override
    public IoBuffer getDecoderConfiguration() {
        return this.decoderConfiguration.getFrame();
    }

    @Override
    public int getNumInterframes() {
        return this.numInterframes.get();
    }

    @Override
    public IVideoStreamCodec.FrameData getInterframe(int index) {
        if (index < this.numInterframes.get()) {
            return this.interframes.get(index);
        }
        return null;
    }
}

