/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.flv.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.cache.ICacheStore;
import org.red5.cache.ICacheable;
import org.red5.cache.impl.NoCacheImpl;
import org.red5.io.ITag;
import org.red5.io.ITagReader;
import org.red5.io.ITagWriter;
import org.red5.io.flv.IFLV;
import org.red5.io.flv.impl.FLVReader;
import org.red5.io.flv.impl.FLVWriter;
import org.red5.io.flv.meta.IMetaData;
import org.red5.io.flv.meta.IMetaService;
import org.red5.io.flv.meta.MetaData;
import org.red5.io.flv.meta.MetaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLV
implements IFLV {
    protected static Logger log = LoggerFactory.getLogger(FLV.class);
    private static ICacheStore cache;
    private File file;
    private boolean generateMetadata;
    private IMetaService metaService;
    private IMetaData<?, ?> metaData;

    public FLV() {
    }

    public FLV(File file) {
        this(file, false);
    }

    public FLV(File file, boolean generateMetadata) {
        this.file = file;
        this.generateMetadata = generateMetadata;
        int count = 0;
        if (!generateMetadata) {
            try {
                FLVReader reader = new FLVReader(this.file);
                ITag tag = null;
                while (reader.hasMoreTags() && ++count < 5) {
                    tag = reader.readTag();
                    if (tag.getDataType() != 18) continue;
                    if (this.metaService == null) {
                        this.metaService = new MetaService();
                    }
                    this.metaData = this.metaService.readMetaData(tag.getBody());
                }
                reader.close();
            }
            catch (Exception e) {
                log.error("An error occured looking for metadata", (Throwable)e);
            }
        }
    }

    @Override
    public void setCache(ICacheStore cache) {
        FLV.cache = cache;
    }

    @Override
    public boolean hasMetaData() {
        return this.metaData != null;
    }

    @Override
    public IMetaData getMetaData() throws FileNotFoundException {
        this.metaService.setFile(this.file);
        return null;
    }

    @Override
    public boolean hasKeyFrameData() {
        return false;
    }

    @Override
    public void setKeyFrameData(Map keyframedata) {
        Map.Entry entry;
        Map.Entry o;
        Iterator i$;
        if (!this.hasMetaData()) {
            this.metaData = new MetaData();
        }
        HashMap times = new HashMap();
        HashMap filepositions = new HashMap();
        if (keyframedata.containsKey("times")) {
            Map inTimes = (Map)keyframedata.get("times");
            i$ = inTimes.entrySet().iterator();
            while (i$.hasNext()) {
                entry = o = i$.next();
                times.put(entry.getKey(), entry.getValue());
            }
        }
        ((MetaData)this.metaData).put("times", times);
        if (keyframedata.containsKey("filepositions")) {
            Map inPos = (Map)keyframedata.get("filepositions");
            i$ = inPos.entrySet().iterator();
            while (i$.hasNext()) {
                entry = o = i$.next();
                filepositions.put(entry.getKey(), entry.getValue());
            }
        }
        ((MetaData)this.metaData).put("filepositions", filepositions);
    }

    @Override
    public Map getKeyFrameData() {
        Map keyframes = null;
        return keyframes;
    }

    @Override
    public void refreshHeaders() throws IOException {
    }

    @Override
    public void flushHeaders() throws IOException {
    }

    @Override
    public ITagReader getReader() throws IOException {
        ICacheable ic;
        FLVReader reader = null;
        String fileName = this.file.getName();
        if (cache == null) {
            log.info("FLV cache is null, forcing NoCacheImpl instance");
            cache = NoCacheImpl.getInstance();
        }
        if (null == (ic = cache.get(fileName)) || null == ic.getByteBuffer()) {
            if (this.file.exists()) {
                log.debug("File size: {}", (Object)this.file.length());
                reader = new FLVReader(this.file, this.generateMetadata);
                IoBuffer fileData = reader.getFileData();
                if (fileData != null && cache.offer(fileName, fileData)) {
                    log.debug("Item accepted by the cache: {}", (Object)fileName);
                } else {
                    log.debug("Item will not be cached: {}", (Object)fileName);
                }
            } else {
                log.info("Creating new file: {}", (Object)this.file);
                this.file.createNewFile();
            }
        } else {
            IoBuffer fileData = IoBuffer.wrap((byte[])ic.getBytes());
            reader = new FLVReader(fileData, this.generateMetadata);
        }
        return reader;
    }

    @Override
    public ITagReader readerFromNearestKeyFrame(int seekPoint) {
        return null;
    }

    @Override
    public ITagWriter getWriter() throws IOException {
        if (this.file.exists()) {
            this.file.delete();
        }
        this.file.createNewFile();
        FLVWriter writer = new FLVWriter(this.file, false);
        return writer;
    }

    @Override
    public ITagWriter getAppendWriter() throws IOException {
        if (!this.file.exists()) {
            log.info("File does not exist, calling writer. This will create a new file.");
            return this.getWriter();
        }
        FLVWriter writer = new FLVWriter(this.file, true);
        return writer;
    }

    @Override
    public ITagWriter writerFromNearestKeyFrame(int seekPoint) {
        return null;
    }

    @Override
    public void setMetaData(IMetaData meta) throws IOException {
        if (this.metaService == null) {
            this.metaService = new MetaService(this.file);
        }
        if (this.metaService.getFile() == null) {
            this.metaService.setFile(this.file);
        }
        this.metaService.write(meta);
        this.metaData = meta;
    }

    @Override
    public void setMetaService(IMetaService service) {
        this.metaService = service;
    }
}

