/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.matroska.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.red5.io.matroska.ConverterException;
import org.red5.io.matroska.ParserUtils;
import org.red5.io.matroska.dtd.Tag;
import org.red5.io.matroska.parser.TagHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagCrawler {
    private static Logger log = LoggerFactory.getLogger(TagCrawler.class);
    private final Map<String, TagHandler> handlers = new HashMap<String, TagHandler>();
    private final TagHandler skipHandler = this.createSkipHandler();

    public TagCrawler addHandler(String name, TagHandler handler) {
        this.handlers.put(name, handler);
        return this;
    }

    public TagCrawler removeHandler(String name) {
        if (this.handlers.containsKey(name)) {
            this.handlers.remove(name);
        }
        return this;
    }

    public TagHandler getHandler(Tag tag) {
        if (this.handlers.containsKey(tag.getName())) {
            return this.handlers.get(tag.getName());
        }
        return null;
    }

    public TagHandler createSkipHandler() {
        return new TagHandler(){

            @Override
            public void handle(Tag tag, InputStream input) throws IOException, ConverterException {
                log.debug("Going to skip tag: " + tag.getName());
                for (long size = tag.getSize(); size > 0L; size -= input.skip(size)) {
                }
            }
        };
    }

    public void process(InputStream input) throws IOException, ConverterException {
        while (0 != input.available()) {
            Tag tag = ParserUtils.parseTag(input);
            TagHandler handler = this.getHandler(tag);
            if (null == handler) {
                this.skipHandler.handle(tag, input);
                continue;
            }
            handler.handle(tag, input);
        }
    }
}

