/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.mp4.impl;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.AbstractMediaHeaderBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ChunkOffset64BitBox;
import com.coremedia.iso.boxes.ChunkOffsetBox;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.Container;
import com.coremedia.iso.boxes.HandlerBox;
import com.coremedia.iso.boxes.MediaBox;
import com.coremedia.iso.boxes.MediaHeaderBox;
import com.coremedia.iso.boxes.MediaInformationBox;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.MovieHeaderBox;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SampleSizeBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.SampleToChunkBox;
import com.coremedia.iso.boxes.SoundMediaHeaderBox;
import com.coremedia.iso.boxes.SyncSampleBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.TrackHeaderBox;
import com.coremedia.iso.boxes.VideoMediaHeaderBox;
import com.coremedia.iso.boxes.apple.AppleWaveBox;
import com.coremedia.iso.boxes.fragment.MovieExtendsBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentHeaderBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentRandomAccessBox;
import com.coremedia.iso.boxes.fragment.TrackExtendsBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentHeaderBox;
import com.coremedia.iso.boxes.fragment.TrackRunBox;
import com.coremedia.iso.boxes.mdat.MediaDataBox;
import com.coremedia.iso.boxes.sampleentry.AbstractSampleEntry;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.coremedia.iso.boxes.sampleentry.VisualSampleEntry;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.FileDataSourceImpl;
import com.googlecode.mp4parser.boxes.adobe.ActionMessageFormat0SampleEntryBox;
import com.googlecode.mp4parser.boxes.mp4.ESDescriptorBox;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.AudioSpecificConfig;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.DecoderConfigDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.DecoderSpecificInfo;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ESDescriptor;
import com.googlecode.mp4parser.util.Path;
import com.mp4parser.iso14496.part15.AvcConfigurationBox;
import com.mp4parser.iso14496.part15.AvcDecoderConfigurationRecord;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.io.IStreamableFile;
import org.red5.io.ITag;
import org.red5.io.ITagReader;
import org.red5.io.IoConstants;
import org.red5.io.amf.Output;
import org.red5.io.flv.IKeyFrameDataAnalyzer;
import org.red5.io.flv.impl.Tag;
import org.red5.io.mp4.MP4Frame;
import org.red5.io.utils.HexDump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MP4Reader
implements IoConstants,
ITagReader,
IKeyFrameDataAnalyzer {
    private static Logger log = LoggerFactory.getLogger(MP4Reader.class);
    public static final byte[] PREFIX_AUDIO_CONFIG_FRAME = new byte[]{-81, 0};
    public static final byte[] PREFIX_AUDIO_FRAME = new byte[]{-81, 1};
    public static final byte[] EMPTY_AAC = new byte[]{33, 16, 4, 96, -116, 28};
    public static final byte[] PREFIX_VIDEO_CONFIG_FRAME = new byte[]{23, 0, 0, 0, 0};
    public static final byte[] PREFIX_VIDEO_KEYFRAME = new byte[]{23, 1};
    public static final byte[] PREFIX_VIDEO_FRAME = new byte[]{39, 1};
    private FileDataSourceImpl dataSource;
    private IsoFile isoFile;
    private HashMap<Integer, Long> timePosMap;
    private HashMap<Integer, Long> samplePosMap;
    private boolean hasVideo = false;
    private boolean hasAudio = false;
    private String videoCodecId = "avc1";
    private String audioCodecId = "mp4a";
    private byte[] audioDecoderBytes;
    private byte[] videoDecoderBytes;
    private long duration;
    private long timeScale;
    private int width;
    private int height;
    private double audioTimeScale;
    private int audioChannels;
    private int audioCodecType = 1;
    private long videoSampleCount;
    private double fps;
    private double videoTimeScale;
    private int avcLevel;
    private int avcProfile;
    private String formattedDuration;
    private long mdatOffset;
    private List<SampleToChunkBox.Entry> videoSamplesToChunks;
    private List<SampleToChunkBox.Entry> audioSamplesToChunks;
    private long[] syncSamples;
    private long[] videoSamples;
    private long[] audioSamples;
    private long audioSampleSize;
    private long[] videoChunkOffsets;
    private long[] audioChunkOffsets;
    private long videoSampleDuration = 125L;
    private long audioSampleDuration = 1024L;
    private int currentFrame = 0;
    private int prevFrameSize = 0;
    private int prevVideoTS = -1;
    private List<MP4Frame> frames = new ArrayList<MP4Frame>();
    private long audioCount;
    private long videoCount;
    private List<CompositionTimeToSample.Entry> compositionTimes;
    private LinkedList<ITag> firstTags = new LinkedList();
    private LinkedList<Integer> seekPoints;
    private final Semaphore lock = new Semaphore(1, true);

    MP4Reader() {
    }

    public MP4Reader(File f) throws IOException {
        if (null == f) {
            log.warn("Reader was passed a null file");
            log.debug("{}", (Object)ToStringBuilder.reflectionToString((Object)this));
        }
        if (f.exists() && f.canRead()) {
            this.dataSource = new FileDataSourceImpl(f);
            this.isoFile = new IsoFile((DataSource)this.dataSource);
            this.decodeHeader();
            this.analyzeFrames();
            this.firstTags.add(this.createFileMeta());
            this.createPreStreamingTags(0, false);
        } else {
            log.warn("Reader was passed an unreadable or non-existant file");
        }
    }

    @Override
    public void decodeHeader() {
        try {
            MovieBox moov = (MovieBox)this.isoFile.getBoxes(MovieBox.class).get(0);
            if (log.isDebugEnabled()) {
                log.debug("moov children: {}", (Object)moov.getBoxes().size());
                MP4Reader.dumpBox((Container)moov);
            }
            MovieHeaderBox mvhd = moov.getMovieHeaderBox();
            this.timeScale = mvhd.getTimescale();
            this.duration = mvhd.getDuration();
            log.debug("Time scale {} Duration {}", (Object)this.timeScale, (Object)this.duration);
            double lengthInSeconds = (double)this.duration / (double)this.timeScale;
            log.debug("Seconds {}", (Object)lengthInSeconds);
            log.debug("Tracks: {}", (Object)moov.getTrackCount());
            List tracks = moov.getBoxes(TrackBox.class);
            for (TrackBox trak : tracks) {
                AbstractSampleEntry entry;
                SampleDescriptionBox stsd;
                SampleTableBox stbl;
                if (log.isDebugEnabled()) {
                    log.debug("trak children: {}", (Object)trak.getBoxes().size());
                    MP4Reader.dumpBox((Container)trak);
                }
                TrackHeaderBox tkhd = trak.getTrackHeaderBox();
                log.debug("Track id: {}", (Object)tkhd.getTrackId());
                if (tkhd != null && tkhd.getWidth() > 0.0) {
                    this.width = (int)tkhd.getWidth();
                    this.height = (int)tkhd.getHeight();
                    log.debug("Width {} x Height {}", (Object)this.width, (Object)this.height);
                }
                MediaBox mdia = trak.getMediaBox();
                long scale = 0L;
                boolean isAudio = false;
                boolean isVideo = false;
                if (mdia != null) {
                    MediaInformationBox minf;
                    HandlerBox hdlr;
                    MediaHeaderBox mdhd;
                    if (log.isDebugEnabled()) {
                        log.debug("mdia children: {}", (Object)mdia.getBoxes().size());
                        MP4Reader.dumpBox((Container)mdia);
                    }
                    if ((mdhd = mdia.getMediaHeaderBox()) != null) {
                        log.debug("Media data header atom found");
                        scale = mdhd.getTimescale();
                        log.debug("Time scale {}", (Object)scale);
                    }
                    if ((hdlr = mdia.getHandlerBox()) != null) {
                        String hdlrType = hdlr.getHandlerType();
                        if ("vide".equals(hdlrType)) {
                            this.hasVideo = true;
                            if (scale > 0L) {
                                this.videoTimeScale = (double)scale * 1.0;
                                log.debug("Video time scale: {}", (Object)this.videoTimeScale);
                            }
                        } else if ("soun".equals(hdlrType)) {
                            this.hasAudio = true;
                            if (scale > 0L) {
                                this.audioTimeScale = (double)scale * 1.0;
                                log.debug("Audio time scale: {}", (Object)this.audioTimeScale);
                            }
                        } else {
                            log.debug("Unhandled handler type: {}", (Object)hdlrType);
                        }
                    }
                    if ((minf = mdia.getMediaInformationBox()) != null) {
                        AbstractMediaHeaderBox abs;
                        if (log.isDebugEnabled()) {
                            log.debug("minf children: {}", (Object)minf.getBoxes().size());
                            MP4Reader.dumpBox((Container)minf);
                        }
                        if ((abs = minf.getMediaHeaderBox()) != null) {
                            if (abs instanceof SoundMediaHeaderBox) {
                                log.debug("Sound header atom found");
                                isAudio = true;
                            } else if (abs instanceof VideoMediaHeaderBox) {
                                log.debug("Video header atom found");
                                isVideo = true;
                            } else {
                                log.debug("Unhandled media header box: {}", (Object)abs.getType());
                            }
                        } else {
                            log.debug("Null media header box");
                        }
                    }
                }
                if ((stbl = trak.getSampleTableBox()) == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("stbl children: {}", (Object)stbl.getBoxes().size());
                    MP4Reader.dumpBox((Container)stbl);
                }
                if ((stsd = stbl.getSampleDescriptionBox()) == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("stsd children: {}", (Object)stsd.getBoxes().size());
                    MP4Reader.dumpBox((Container)stsd);
                }
                if ((entry = stsd.getSampleEntry()) != null) {
                    log.debug("Sample entry type: {}", (Object)entry.getType());
                    if (entry instanceof AudioSampleEntry) {
                        this.processAudioBox(stbl, (AudioSampleEntry)entry, scale);
                        continue;
                    }
                    if (!(entry instanceof VisualSampleEntry)) continue;
                    this.processVideoBox(stbl, (VisualSampleEntry)entry, scale);
                    continue;
                }
                log.debug("Sample entry was null");
                if (isVideo) {
                    this.processVideoBox(stbl, scale);
                    continue;
                }
                if (!isAudio) continue;
                this.processAudioBox(stbl, scale);
            }
            this.fps = (double)(this.videoSampleCount * this.timeScale) / (double)this.duration;
            log.debug("FPS calc: ({} * {}) / {}", new Object[]{this.videoSampleCount, this.timeScale, this.duration});
            log.debug("FPS: {}", (Object)this.fps);
            StringBuilder sb = new StringBuilder();
            double videoTime = (double)this.duration / (double)this.timeScale;
            log.debug("Video time: {}", (Object)videoTime);
            int minutes = (int)(videoTime / 60.0);
            if (minutes > 0) {
                sb.append(minutes);
                sb.append('.');
            }
            NumberFormat df = DecimalFormat.getInstance();
            df.setMaximumFractionDigits(2);
            sb.append(df.format(videoTime % 60.0));
            this.formattedDuration = sb.toString();
            log.debug("Time: {}", (Object)this.formattedDuration);
            List mdats = this.isoFile.getBoxes(MediaDataBox.class);
            if (mdats != null && !mdats.isEmpty()) {
                log.debug("mdat count: {}", (Object)mdats.size());
                MediaDataBox mdat = (MediaDataBox)mdats.get(0);
                if (mdat != null) {
                    this.mdatOffset = mdat.getOffset();
                }
            }
            log.debug("Offset - mdat: {}", (Object)this.mdatOffset);
            boolean fragmented = false;
            List moofs = this.isoFile.getBoxes(MovieFragmentBox.class);
            if (moofs != null && !moofs.isEmpty()) {
                log.info("Movie contains {} framents", (Object)moofs.size());
                fragmented = true;
                for (MovieFragmentBox moof : moofs) {
                    int i;
                    MP4Reader.dumpBox((Container)moof);
                    MovieFragmentHeaderBox mfhd = (MovieFragmentHeaderBox)moof.getBoxes(MovieFragmentHeaderBox.class).get(0);
                    if (mfhd != null) {
                        log.debug("Sequence: {} path: {}", (Object)mfhd.getSequenceNumber(), (Object)mfhd.getPath());
                    }
                    List trafs = moof.getBoxes(TrackFragmentBox.class);
                    for (TrackFragmentBox traf : trafs) {
                        TrackFragmentHeaderBox tfhd = traf.getTrackFragmentHeaderBox();
                        log.debug("tfhd: {}", (Object)tfhd);
                    }
                    List trexs = moof.getBoxes(TrackExtendsBox.class);
                    for (TrackExtendsBox trex : trexs) {
                        log.debug("trex - track id: {} duration: {} sample size: {}", new Object[]{trex.getTrackId(), trex.getDefaultSampleDuration(), trex.getDefaultSampleSize()});
                    }
                    if (this.compositionTimes == null) {
                        this.compositionTimes = new ArrayList<CompositionTimeToSample.Entry>();
                    }
                    LinkedList<Integer> dataOffsets = new LinkedList<Integer>();
                    LinkedList<Long> sampleSizes = new LinkedList<Long>();
                    List truns = moof.getTrackRunBoxes();
                    log.info("Fragment contains {} TrackRunBox entries", (Object)truns.size());
                    for (TrackRunBox trun : truns) {
                        log.debug("trun - {}", (Object)trun);
                        if (trun.isDataOffsetPresent()) {
                            dataOffsets.add(trun.getDataOffset());
                        }
                        this.videoSampleCount += trun.getSampleCount();
                        List recs = trun.getEntries();
                        log.info("TrackRunBox contains {} entries", (Object)recs.size());
                        for (TrackRunBox.Entry rec : recs) {
                            log.info("Entry: {}", (Object)rec);
                            if (trun.isSampleCompositionTimeOffsetPresent()) {
                                CompositionTimeToSample.Entry ctts = new CompositionTimeToSample.Entry((int)trun.getSampleCount(), (int)rec.getSampleCompositionTimeOffset());
                                this.compositionTimes.add(ctts);
                            }
                            sampleSizes.add(rec.getSampleSize());
                            if (!trun.isSampleDurationPresent()) continue;
                            this.videoSampleDuration += rec.getSampleDuration();
                        }
                    }
                    log.info("Video duration: {}", (Object)this.videoSampleDuration);
                    this.videoSamples = new long[sampleSizes.size()];
                    for (i = 0; i < this.videoSamples.length; ++i) {
                        this.videoSamples[i] = (Long)sampleSizes.remove();
                    }
                    log.info("Video samples: {}", (Object)Arrays.toString(this.videoSamples));
                    this.videoChunkOffsets = new long[dataOffsets.size()];
                    for (i = 0; i < this.videoChunkOffsets.length; ++i) {
                        this.videoChunkOffsets[i] = ((Integer)dataOffsets.remove()).intValue();
                    }
                    log.info("Video chunk offsets: {}", (Object)Arrays.toString(this.videoChunkOffsets));
                }
            }
            if (this.isoFile.getBoxes(MovieFragmentRandomAccessBox.class).size() > 0) {
                log.info("Movie contains frament random access info");
            }
            if (this.isoFile.getBoxes(ActionMessageFormat0SampleEntryBox.class).size() > 0) {
                log.info("Movie contains AMF entries");
            }
            if (fragmented) {
                MovieExtendsBox mvex = (MovieExtendsBox)moov.getBoxes(MovieExtendsBox.class).get(0);
                MP4Reader.dumpBox((Container)mvex);
                List trexs = mvex.getBoxes(TrackExtendsBox.class);
                for (TrackExtendsBox trex : trexs) {
                    log.debug("trex - track id: {} duration: {} sample size: {}", new Object[]{trex.getTrackId(), trex.getDefaultSampleDuration(), trex.getDefaultSampleSize()});
                }
            }
        }
        catch (Exception e) {
            log.error("Exception decoding header / atoms", (Throwable)e);
        }
    }

    public static void dumpBox(Container box) {
        log.debug("Dump box: {}", (Object)box);
        for (Box bx : box.getBoxes()) {
            log.debug("{} child: {}", (Object)box, (Object)bx.getType());
        }
    }

    private void processVideoBox(SampleTableBox stbl, VisualSampleEntry vse, long scale) {
        String codecName = vse.getType();
        this.setVideoCodecId(codecName);
        if ("avc1".equals(codecName)) {
            AvcConfigurationBox avc1 = (AvcConfigurationBox)vse.getBoxes(AvcConfigurationBox.class).get(0);
            this.avcLevel = avc1.getAvcLevelIndication();
            log.debug("AVC level: {}", (Object)this.avcLevel);
            this.avcProfile = avc1.getAvcProfileIndication();
            log.debug("AVC Profile: {}", (Object)this.avcProfile);
            AvcDecoderConfigurationRecord avcC = avc1.getavcDecoderConfigurationRecord();
            if (avcC != null) {
                long videoConfigContentSize = avcC.getContentSize();
                log.debug("AVCC size: {}", (Object)videoConfigContentSize);
                ByteBuffer byteBuffer = ByteBuffer.allocate((int)videoConfigContentSize);
                avc1.avcDecoderConfigurationRecord.getContent(byteBuffer);
                byteBuffer.flip();
                this.videoDecoderBytes = new byte[byteBuffer.limit()];
                byteBuffer.get(this.videoDecoderBytes);
            } else {
                log.warn("avcC atom not found; we may need to modify this to support pasp atom");
            }
        } else if ("mp4v".equals(codecName)) {
            DecoderConfigDescriptor decConf;
            ESDescriptor descriptor;
            ESDescriptorBox esds;
            if (vse.getBoxes(ESDescriptorBox.class).size() > 0 && (esds = (ESDescriptorBox)vse.getBoxes(ESDescriptorBox.class).get(0)) != null && (descriptor = esds.getEsDescriptor()) != null && (decConf = descriptor.getDecoderConfigDescriptor()) != null) {
                DecoderSpecificInfo decInfo = decConf.getDecoderSpecificInfo();
                ByteBuffer byteBuffer = decInfo.serialize();
                this.videoDecoderBytes = new byte[byteBuffer.limit()];
                byteBuffer.get(this.videoDecoderBytes);
            }
        } else {
            log.debug("Unrecognized video codec: {} compressor name: {}", (Object)codecName, (Object)vse.getCompressorname());
        }
        this.processVideoStbl(stbl, scale);
    }

    private void processVideoBox(SampleTableBox stbl, long scale) {
        AvcConfigurationBox avcC = (AvcConfigurationBox)Path.getPath((Container)this.isoFile, (String)"/moov/trak/mdia/minf/stbl/stsd/drmi/avcC");
        if (avcC != null) {
            long videoConfigContentSize = avcC.getContentSize();
            log.debug("AVCC size: {}", (Object)videoConfigContentSize);
        } else {
            log.warn("avcC atom not found");
        }
        this.processVideoStbl(stbl, scale);
    }

    private void processVideoStbl(SampleTableBox stbl, long scale) {
        SampleDependencyTypeBox sdtp;
        CompositionTimeToSample ctts;
        TimeToSampleBox stts;
        ChunkOffsetBox stco;
        SampleSizeBox stsz;
        SampleToChunkBox stsc = stbl.getSampleToChunkBox();
        if (stsc != null) {
            log.debug("Sample to chunk atom found");
            this.videoSamplesToChunks = stsc.getEntries();
            log.debug("Video samples to chunks: {}", (Object)this.videoSamplesToChunks.size());
            for (SampleToChunkBox.Entry s2c : this.videoSamplesToChunks) {
                log.info("Entry: {}", (Object)s2c);
            }
        }
        if ((stsz = stbl.getSampleSizeBox()) != null) {
            log.debug("Sample size atom found");
            this.videoSamples = stsz.getSampleSizes();
            log.debug("Sample size: {}", (Object)stsz.getSampleSize());
            this.videoSampleCount = stsz.getSampleCount();
            log.debug("Sample count: {}", (Object)this.videoSampleCount);
        }
        if ((stco = stbl.getChunkOffsetBox()) != null) {
            log.debug("Chunk offset atom found");
            this.videoChunkOffsets = stco.getChunkOffsets();
            log.debug("Chunk count: {}", (Object)this.videoChunkOffsets.length);
        } else {
            ChunkOffset64BitBox co64;
            List stblBoxes = stbl.getBoxes(ChunkOffset64BitBox.class);
            if (stblBoxes != null && !stblBoxes.isEmpty() && (co64 = (ChunkOffset64BitBox)stblBoxes.get(0)) != null) {
                log.debug("Chunk offset (64) atom found");
                this.videoChunkOffsets = co64.getChunkOffsets();
                log.debug("Chunk count: {}", (Object)this.videoChunkOffsets.length);
            }
        }
        SyncSampleBox stss = stbl.getSyncSampleBox();
        if (stss != null) {
            log.debug("Sync sample atom found");
            this.syncSamples = stss.getSampleNumber();
            log.debug("Keyframes: {}", (Object)this.syncSamples.length);
        }
        if ((stts = stbl.getTimeToSampleBox()) != null) {
            log.debug("Time to sample atom found");
            List records = stts.getEntries();
            log.debug("Video time to samples: {}", (Object)records.size());
            if (records.size() > 0) {
                TimeToSampleBox.Entry rec = (TimeToSampleBox.Entry)records.get(0);
                log.debug("Samples = {} delta = {}", (Object)rec.getCount(), (Object)rec.getDelta());
                this.videoSampleDuration = rec.getDelta();
            }
        }
        if ((ctts = stbl.getCompositionTimeToSample()) != null) {
            log.debug("Composition time to sample atom found");
            this.compositionTimes = ctts.getEntries();
            log.debug("Record count: {}", (Object)this.compositionTimes.size());
            if (log.isTraceEnabled()) {
                for (CompositionTimeToSample.Entry rec : this.compositionTimes) {
                    double offset = rec.getOffset();
                    if ((double)scale > 0.0) {
                        offset = offset / (double)scale * 1000.0;
                        rec.setOffset((int)offset);
                    }
                    log.trace("Samples = {} offset = {}", (Object)rec.getCount(), (Object)rec.getOffset());
                }
            }
        }
        if ((sdtp = stbl.getSampleDependencyTypeBox()) != null) {
            log.debug("Independent and disposable samples atom found");
            List recs = sdtp.getEntries();
            for (SampleDependencyTypeBox.Entry rec : recs) {
                log.debug("{}", (Object)rec);
            }
        }
    }

    private void processAudioBox(SampleTableBox stbl, AudioSampleEntry ase, long scale) {
        String codecName = ase.getType();
        this.setAudioCodecId(codecName);
        log.debug("Sample size: {}", (Object)ase.getSampleSize());
        long ats = ase.getSampleRate();
        if (ats > 0L) {
            this.audioTimeScale = (double)ats * 1.0;
        }
        log.debug("Sample rate (audio time scale): {}", (Object)this.audioTimeScale);
        this.audioChannels = ase.getChannelCount();
        log.debug("Channels: {}", (Object)this.audioChannels);
        if (ase.getBoxes(ESDescriptorBox.class).size() > 0) {
            ESDescriptorBox esds = (ESDescriptorBox)ase.getBoxes(ESDescriptorBox.class).get(0);
            if (esds == null) {
                log.debug("esds not found in default path");
                AppleWaveBox wave = (AppleWaveBox)ase.getBoxes(AppleWaveBox.class).get(0);
                if (wave != null) {
                    log.debug("wave atom found");
                    esds = (ESDescriptorBox)wave.getBoxes(ESDescriptorBox.class).get(0);
                    if (esds == null) {
                        log.debug("esds not found in wave");
                    }
                }
            }
            if (esds != null) {
                ESDescriptor descriptor = esds.getEsDescriptor();
                if (descriptor != null) {
                    DecoderConfigDescriptor configDescriptor = descriptor.getDecoderConfigDescriptor();
                    AudioSpecificConfig audioInfo = configDescriptor.getAudioSpecificInfo();
                    if (audioInfo != null) {
                        this.audioDecoderBytes = audioInfo.getConfigBytes();
                        byte audioCoderType = this.audioDecoderBytes[0];
                        switch (audioCoderType) {
                            case 2: {
                                log.debug("Audio type AAC LC");
                            }
                            case 17: {
                                log.debug("Audio type ER AAC LC");
                            }
                            default: {
                                this.audioCodecType = 1;
                                break;
                            }
                            case 1: {
                                log.debug("Audio type AAC Main");
                                this.audioCodecType = 0;
                                break;
                            }
                            case 3: {
                                log.debug("Audio type AAC SBR");
                                this.audioCodecType = 2;
                                break;
                            }
                            case 5: 
                            case 29: {
                                log.debug("Audio type AAC HE");
                                this.audioCodecType = 3;
                                break;
                            }
                            case 32: 
                            case 33: 
                            case 34: {
                                log.debug("Audio type MP3");
                                this.audioCodecType = 33;
                                this.audioCodecId = "mp3";
                            }
                        }
                        log.debug("Audio coder type: {} {} id: {}", new Object[]{audioCoderType, Integer.toBinaryString(audioCoderType), this.audioCodecId});
                    } else {
                        log.debug("Audio specific config was not found");
                        DecoderSpecificInfo info = configDescriptor.getDecoderSpecificInfo();
                        if (info != null) {
                            log.debug("Decoder info found: {}", (Object)info.getTag());
                        }
                    }
                } else {
                    log.debug("No ES descriptor found");
                }
            }
        } else {
            log.debug("Audio sample entry had no descriptor");
        }
        this.processAudioStbl(stbl, scale);
    }

    private void processAudioBox(SampleTableBox stbl, long scale) {
        this.processAudioStbl(stbl, scale);
    }

    private void processAudioStbl(SampleTableBox stbl, long scale) {
        SampleDependencyTypeBox sdtp;
        ChunkOffsetBox stco;
        SampleSizeBox stsz;
        SampleToChunkBox stsc = stbl.getSampleToChunkBox();
        if (stsc != null) {
            log.debug("Sample to chunk atom found");
            this.audioSamplesToChunks = stsc.getEntries();
            log.debug("Audio samples to chunks: {}", (Object)this.audioSamplesToChunks.size());
        }
        if ((stsz = stbl.getSampleSizeBox()) != null) {
            log.debug("Sample size atom found");
            this.audioSamples = stsz.getSampleSizes();
            log.debug("Samples: {}", (Object)this.audioSamples.length);
            this.audioSampleSize = stsz.getSampleSize();
            log.debug("Sample size: {}", (Object)this.audioSampleSize);
            long audioSampleCount = stsz.getSampleCount();
            log.debug("Sample count: {}", (Object)audioSampleCount);
        }
        if ((stco = stbl.getChunkOffsetBox()) != null) {
            log.debug("Chunk offset atom found");
            this.audioChunkOffsets = stco.getChunkOffsets();
            log.debug("Chunk count: {}", (Object)this.audioChunkOffsets.length);
        } else {
            ChunkOffset64BitBox co64 = (ChunkOffset64BitBox)stbl.getBoxes(ChunkOffset64BitBox.class).get(0);
            if (co64 != null) {
                log.debug("Chunk offset (64) atom found");
                this.audioChunkOffsets = co64.getChunkOffsets();
                log.debug("Chunk count: {}", (Object)this.audioChunkOffsets.length);
            }
        }
        TimeToSampleBox stts = stbl.getTimeToSampleBox();
        if (stts != null) {
            log.debug("Time to sample atom found");
            List records = stts.getEntries();
            log.debug("Audio time to samples: {}", (Object)records.size());
            if (records.size() > 0) {
                TimeToSampleBox.Entry rec = (TimeToSampleBox.Entry)records.get(0);
                log.debug("Samples = {} delta = {}", (Object)rec.getCount(), (Object)rec.getDelta());
                this.audioSampleDuration = rec.getDelta();
            }
        }
        if ((sdtp = stbl.getSampleDependencyTypeBox()) != null) {
            log.debug("Independent and disposable samples atom found");
            List recs = sdtp.getEntries();
            for (SampleDependencyTypeBox.Entry rec : recs) {
                log.debug("{}", (Object)rec);
            }
        }
    }

    @Override
    public long getTotalBytes() {
        try {
            return this.dataSource.size();
        }
        catch (Exception e) {
            log.error("Error getTotalBytes", (Throwable)e);
            return 0L;
        }
    }

    private long getCurrentPosition() {
        try {
            if (this.dataSource.position() == this.dataSource.size()) {
                log.debug("Reached end of file, going back to data offset");
                this.dataSource.position(this.mdatOffset);
            }
            return this.dataSource.position();
        }
        catch (Exception e) {
            log.error("Error getCurrentPosition", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public boolean hasVideo() {
        return this.hasVideo;
    }

    public IoBuffer getFileData() {
        return null;
    }

    @Override
    public IStreamableFile getFile() {
        return null;
    }

    @Override
    public int getOffset() {
        return 0;
    }

    @Override
    public long getBytesRead() {
        return this.getCurrentPosition();
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    public String getVideoCodecId() {
        return this.videoCodecId;
    }

    public String getAudioCodecId() {
        return this.audioCodecId;
    }

    @Override
    public boolean hasMoreTags() {
        return this.currentFrame < this.frames.size();
    }

    ITag createFileMeta() {
        HashMap<String, String> sampleMap;
        ArrayList desc;
        log.debug("Creating onMetaData");
        IoBuffer buf = IoBuffer.allocate((int)1024);
        buf.setAutoExpand(true);
        Output out = new Output(buf);
        out.writeString("onMetaData");
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        props.put("duration", (double)this.duration / (double)this.timeScale);
        props.put("width", this.width);
        props.put("height", this.height);
        props.put("videocodecid", this.videoCodecId);
        props.put("avcprofile", this.avcProfile);
        props.put("avclevel", this.avcLevel);
        props.put("videoframerate", this.fps);
        props.put("audiocodecid", this.audioCodecId);
        props.put("aacaot", this.audioCodecType);
        props.put("audiosamplerate", this.audioTimeScale);
        props.put("audiochannels", this.audioChannels);
        if (this.seekPoints != null) {
            log.debug("Seekpoint list size: {}", (Object)this.seekPoints.size());
            props.put("seekpoints", this.seekPoints);
        }
        ArrayList arr = new ArrayList(2);
        if (this.hasAudio) {
            HashMap<String, Object> audioMap = new HashMap<String, Object>(4);
            audioMap.put("timescale", this.audioTimeScale);
            audioMap.put("language", "und");
            desc = new ArrayList(1);
            audioMap.put("sampledescription", desc);
            sampleMap = new HashMap<String, String>(1);
            sampleMap.put("sampletype", this.audioCodecId);
            desc.add(sampleMap);
            if (this.audioSamples != null) {
                if (this.audioSampleDuration > 0L) {
                    audioMap.put("length_property", this.audioSampleDuration * (long)this.audioSamples.length);
                }
                this.audioSamples = null;
            }
            arr.add(audioMap);
        }
        if (this.hasVideo) {
            HashMap<String, Object> videoMap = new HashMap<String, Object>(3);
            videoMap.put("timescale", this.videoTimeScale);
            videoMap.put("language", "und");
            desc = new ArrayList(1);
            videoMap.put("sampledescription", desc);
            sampleMap = new HashMap(1);
            sampleMap.put("sampletype", this.videoCodecId);
            desc.add(sampleMap);
            if (this.videoSamples != null) {
                if (this.videoSampleDuration > 0L) {
                    videoMap.put("length_property", this.videoSampleDuration * (long)this.videoSamples.length);
                }
                this.videoSamples = null;
            }
            arr.add(videoMap);
        }
        props.put("trackinfo", arr);
        props.put("canSeekToEnd", this.seekPoints != null);
        out.writeMap(props);
        buf.flip();
        this.duration = Math.round((double)this.duration * 1000.0);
        Tag result = new Tag(18, 0, buf.limit(), null, 0);
        result.setBody(buf);
        return result;
    }

    private void createPreStreamingTags(int timestamp, boolean clear) {
        log.debug("Creating pre-streaming tags");
        if (clear) {
            this.firstTags.clear();
        }
        Tag tag = null;
        IoBuffer body = null;
        if (this.hasVideo) {
            body = IoBuffer.allocate((int)41);
            body.setAutoExpand(true);
            body.put(PREFIX_VIDEO_CONFIG_FRAME);
            if (this.videoDecoderBytes != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Video decoder bytes: {}", (Object)HexDump.byteArrayToHexString(this.videoDecoderBytes));
                }
                body.put(this.videoDecoderBytes);
            }
            tag = new Tag(9, timestamp, body.position(), null, 0);
            body.flip();
            tag.setBody(body);
            this.firstTags.add(tag);
        }
        if (this.hasAudio) {
            if (this.audioDecoderBytes != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Audio decoder bytes: {}", (Object)HexDump.byteArrayToHexString(this.audioDecoderBytes));
                }
                body = IoBuffer.allocate((int)(this.audioDecoderBytes.length + 3));
                body.setAutoExpand(true);
                body.put(PREFIX_AUDIO_CONFIG_FRAME);
                body.put(this.audioDecoderBytes);
                body.put((byte)6);
                tag = new Tag(8, timestamp, body.position(), null, 0);
                body.flip();
                tag.setBody(body);
                this.firstTags.add(tag);
            } else {
                log.info("Audio decoder bytes were not available");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ITag readTag() {
        Tag tag = null;
        if (log.isTraceEnabled()) {
            log.trace("Read tag - prevFrameSize {} audio: {} video: {}", new Object[]{this.prevFrameSize, this.audioCount, this.videoCount});
        }
        if (!this.frames.isEmpty()) {
            try {
                this.lock.acquire();
                if (!this.firstTags.isEmpty()) {
                    ITag iTag = this.firstTags.removeFirst();
                    return iTag;
                }
                MP4Frame frame = this.frames.get(this.currentFrame);
                if (frame == null) return tag;
                log.debug("Playback #{} {}", (Object)this.currentFrame, (Object)frame);
                int sampleSize = frame.getSize();
                int time = (int)Math.round(frame.getTime() * 1000.0);
                long samplePos = frame.getOffset();
                byte type = frame.getType();
                int pad = 5;
                if (type == 8) {
                    pad = 2;
                }
                ByteBuffer data = ByteBuffer.allocate(sampleSize + pad);
                try {
                    if (type == 9) {
                        if (frame.isKeyFrame()) {
                            data.put(PREFIX_VIDEO_KEYFRAME);
                        } else {
                            data.put(PREFIX_VIDEO_FRAME);
                        }
                        int timeOffset = this.prevVideoTS != -1 ? time - this.prevVideoTS : 0;
                        data.put((byte)(timeOffset >>> 16 & 0xFF));
                        data.put((byte)(timeOffset >>> 8 & 0xFF));
                        data.put((byte)(timeOffset & 0xFF));
                        if (log.isTraceEnabled()) {
                            byte[] prefix = new byte[5];
                            int p = data.position();
                            data.position(0);
                            data.get(prefix);
                            data.position(p);
                            log.trace("{}", (Object)prefix);
                        }
                        ++this.videoCount;
                        this.prevVideoTS = time;
                    } else {
                        data.put(PREFIX_AUDIO_FRAME);
                        ++this.audioCount;
                    }
                    this.dataSource.position(samplePos);
                    this.dataSource.read(data);
                }
                catch (IOException e) {
                    log.error("Error on channel position / read", (Throwable)e);
                }
                IoBuffer payload = IoBuffer.wrap((byte[])data.array());
                tag = new Tag(type, time, payload.limit(), payload, this.prevFrameSize);
                ++this.currentFrame;
                this.prevFrameSize = tag.getBodySize();
                return tag;
            }
            catch (InterruptedException e) {
                log.warn("Exception acquiring lock", (Throwable)e);
                return tag;
            }
            finally {
                this.lock.release();
            }
        }
        log.warn("No frames are available for the requested item");
        return tag;
    }

    public void analyzeFrames() {
        log.debug("Analyzing frames - video samples/chunks: {}", this.videoSamplesToChunks);
        this.timePosMap = new HashMap();
        this.samplePosMap = new HashMap();
        int sample = 1;
        Long pos = null;
        if (this.videoSamplesToChunks != null) {
            int compositeIndex = 0;
            CompositionTimeToSample.Entry compositeTimeEntry = null;
            if (this.compositionTimes != null && !this.compositionTimes.isEmpty()) {
                compositeTimeEntry = this.compositionTimes.remove(0);
            }
            for (int i = 0; i < this.videoSamplesToChunks.size(); ++i) {
                SampleToChunkBox.Entry record = this.videoSamplesToChunks.get(i);
                long firstChunk = record.getFirstChunk();
                long lastChunk = this.videoChunkOffsets.length;
                if (i < this.videoSamplesToChunks.size() - 1) {
                    SampleToChunkBox.Entry nextRecord = this.videoSamplesToChunks.get(i + 1);
                    lastChunk = nextRecord.getFirstChunk() - 1L;
                }
                for (long chunk = firstChunk; chunk <= lastChunk; ++chunk) {
                    long sampleCount = record.getSamplesPerChunk();
                    pos = this.videoChunkOffsets[(int)(chunk - 1L)];
                    while (sampleCount > 0L) {
                        this.samplePosMap.put(sample, pos);
                        double ts = (double)(this.videoSampleDuration * (long)(sample - 1)) / this.videoTimeScale;
                        boolean keyframe = false;
                        if (this.syncSamples != null) {
                            keyframe = ArrayUtils.contains((long[])this.syncSamples, (long)sample);
                            if (this.seekPoints == null) {
                                this.seekPoints = new LinkedList();
                            }
                            int frameTs = (int)Math.round(ts * 1000.0);
                            if (keyframe) {
                                this.seekPoints.add(frameTs);
                            }
                            this.timePosMap.put(frameTs, pos);
                        } else {
                            log.debug("No sync samples available");
                        }
                        int size = (int)this.videoSamples[sample - 1];
                        MP4Frame frame = new MP4Frame();
                        frame.setKeyFrame(keyframe);
                        frame.setOffset(pos);
                        frame.setSize(size);
                        frame.setTime(ts);
                        frame.setType((byte)9);
                        if (compositeTimeEntry != null) {
                            int consecutiveSamples = compositeTimeEntry.getCount();
                            frame.setTimeOffset(compositeTimeEntry.getOffset());
                            if (++compositeIndex - consecutiveSamples == 0) {
                                if (!this.compositionTimes.isEmpty()) {
                                    compositeTimeEntry = this.compositionTimes.remove(0);
                                }
                                compositeIndex = 0;
                            }
                            log.debug("Composite sample #{} {}", (Object)sample, (Object)frame);
                        }
                        this.frames.add(frame);
                        log.debug("Sample #{} {}", (Object)sample, (Object)frame);
                        pos = pos + (long)size;
                        --sampleCount;
                        ++sample;
                    }
                }
            }
            log.debug("Sample position map (video): {}", this.samplePosMap);
        }
        if (this.audioSamplesToChunks != null) {
            sample = 1;
            for (int i = 0; i < this.audioSamplesToChunks.size(); ++i) {
                SampleToChunkBox.Entry record = this.audioSamplesToChunks.get(i);
                long firstChunk = record.getFirstChunk();
                long lastChunk = this.audioChunkOffsets.length;
                if (i < this.audioSamplesToChunks.size() - 1) {
                    SampleToChunkBox.Entry nextRecord = this.audioSamplesToChunks.get(i + 1);
                    lastChunk = nextRecord.getFirstChunk() - 1L;
                }
                for (long chunk = firstChunk; chunk <= lastChunk; ++chunk) {
                    long sampleCount = record.getSamplesPerChunk();
                    pos = this.audioChunkOffsets[(int)(chunk - 1L)];
                    while (sampleCount > 0L) {
                        double ts = (double)(this.audioSampleDuration * (long)(sample - 1)) / this.audioTimeScale;
                        int size = 0;
                        if (this.audioSamples.length > 0) {
                            size = (int)this.audioSamples[sample - 1];
                            log.trace("Audio sample - size: {} pos: {}", (Object)size, (Object)pos);
                            if (size == 6) {
                                try {
                                    long position = this.dataSource.position();
                                    this.dataSource.position(pos.longValue());
                                    ByteBuffer dst = ByteBuffer.allocate(6);
                                    this.dataSource.read(dst);
                                    dst.flip();
                                    this.dataSource.position(position);
                                    byte[] tmp = dst.array();
                                    log.trace("Audio bytes: {} equal: {}", (Object)HexDump.byteArrayToHexString(tmp), (Object)Arrays.equals(EMPTY_AAC, tmp));
                                    if (Arrays.equals(EMPTY_AAC, tmp)) {
                                        log.trace("Skipping empty AAC data frame");
                                        pos = pos + (long)size;
                                        --sampleCount;
                                        ++sample;
                                        continue;
                                    }
                                }
                                catch (IOException e) {
                                    log.warn("Exception during audio analysis", (Throwable)e);
                                }
                            }
                        }
                        size = (int)(size != 0 ? (long)size : this.audioSampleSize);
                        if (pos >= this.mdatOffset) {
                            MP4Frame frame = new MP4Frame();
                            frame.setOffset(pos);
                            frame.setSize(size);
                            frame.setTime(ts);
                            frame.setType((byte)8);
                            this.frames.add(frame);
                        } else {
                            log.warn("Skipping audio frame with invalid position");
                        }
                        pos = pos + (long)size;
                        --sampleCount;
                        ++sample;
                    }
                }
            }
        }
        Collections.sort(this.frames);
        log.debug("Frames count: {}", (Object)this.frames.size());
        if (this.audioSamplesToChunks != null) {
            this.audioChunkOffsets = null;
            this.audioSamplesToChunks.clear();
            this.audioSamplesToChunks = null;
        }
        if (this.videoSamplesToChunks != null) {
            this.videoChunkOffsets = null;
            this.videoSamplesToChunks.clear();
            this.videoSamplesToChunks = null;
        }
        if (this.syncSamples != null) {
            this.syncSamples = null;
        }
    }

    @Override
    public void position(long pos) {
        log.debug("Position: {}", (Object)pos);
        log.debug("Current frame: {}", (Object)this.currentFrame);
        int len = this.frames.size();
        MP4Frame frame = null;
        for (int f = 0; f < len; ++f) {
            frame = this.frames.get(f);
            long offset = frame.getOffset();
            if (pos == offset || offset > pos && frame.isKeyFrame()) {
                if (!frame.isKeyFrame()) {
                    log.debug("Frame #{} was not a key frame, so trying again..", (Object)f);
                    continue;
                }
                log.info("Frame #{} found for seek: {}", (Object)f, (Object)frame);
                this.createPreStreamingTags((int)(frame.getTime() * 1000.0), true);
                this.currentFrame = f;
                break;
            }
            this.prevVideoTS = (int)(frame.getTime() * 1000.0);
        }
        log.debug("Setting current frame: {}", (Object)this.currentFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        log.debug("Close");
        if (this.dataSource != null) {
            try {
                this.dataSource.close();
            }
            catch (IOException e) {
                log.error("Channel close {}", (Throwable)e);
            }
            finally {
                if (this.frames != null) {
                    this.frames.clear();
                    this.frames = null;
                }
            }
        }
    }

    public void setVideoCodecId(String videoCodecId) {
        this.videoCodecId = videoCodecId;
    }

    public void setAudioCodecId(String audioCodecId) {
        this.audioCodecId = audioCodecId;
    }

    public ITag readTagHeader() {
        return null;
    }

    @Override
    public IKeyFrameDataAnalyzer.KeyFrameMeta analyzeKeyFrames() {
        IKeyFrameDataAnalyzer.KeyFrameMeta result = new IKeyFrameDataAnalyzer.KeyFrameMeta();
        result.audioOnly = this.hasAudio && !this.hasVideo;
        result.duration = this.duration;
        if (result.audioOnly) {
            result.positions = new long[this.frames.size()];
            result.timestamps = new int[this.frames.size()];
            result.audioOnly = true;
            for (int i = 0; i < result.positions.length; ++i) {
                this.frames.get(i).setKeyFrame(true);
                result.positions[i] = this.frames.get(i).getOffset();
                result.timestamps[i] = (int)Math.round(this.frames.get(i).getTime() * 1000.0);
            }
        } else if (this.seekPoints != null) {
            int seekPointCount = this.seekPoints.size();
            result.positions = new long[seekPointCount];
            result.timestamps = new int[seekPointCount];
            for (int idx = 0; idx < seekPointCount; ++idx) {
                Integer ts = this.seekPoints.get(idx);
                result.positions[idx] = this.timePosMap.get(ts);
                result.timestamps[idx] = ts;
            }
        } else {
            log.warn("Seek points array was null");
        }
        return result;
    }
}

