/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.sctp.packet.chunks;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.red5.io.sctp.IAssociationControl;
import org.red5.io.sctp.IServerChannelControl;
import org.red5.io.sctp.SctpException;
import org.red5.io.sctp.packet.chunks.ChunkType;

public abstract class Chunk {
    protected static final int CHUNK_HEADER_SIZE = 4;
    private ChunkType type;
    private byte flags;
    private int length;

    public Chunk(byte[] data, int offset, int length) throws SctpException {
        if (length < 4) {
            throw new SctpException("not enough data for parse chunk common header " + data);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(data, offset, 4);
        this.type = ChunkType.values()[byteBuffer.get()];
        this.flags = byteBuffer.get();
        this.length = byteBuffer.getShort() & 0xFFFF;
    }

    public Chunk(ChunkType type, byte flags, short length) {
        this.type = type;
        this.flags = flags;
        this.length = length;
    }

    public Chunk(ChunkType type, byte flags) {
        this.type = type;
        this.flags = flags;
    }

    public abstract void apply(IAssociationControl var1) throws SctpException, IOException, InvalidKeyException, NoSuchAlgorithmException;

    public abstract void apply(InetSocketAddress var1, IServerChannelControl var2) throws SctpException, InvalidKeyException, NoSuchAlgorithmException, IOException;

    public int getSize() {
        return 4;
    }

    public byte[] getBytes() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.put((byte)this.type.getValue());
        byteBuffer.put(this.flags);
        byteBuffer.putShort((short)(this.getSize() & 0xFFFF));
        byteBuffer.clear();
        byte[] result = new byte[byteBuffer.capacity()];
        byteBuffer.get(result, 0, result.length);
        return result;
    }

    protected void setLength(int length) {
        this.length = length;
    }
}

