/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.utils;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConversionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversionUtils {
    private static final Logger log = LoggerFactory.getLogger(ConversionUtils.class);
    private static final Class<?>[] PRIMITIVES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private static final Class<?>[] WRAPPERS = new Class[]{Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class};
    private static final String NUMERIC_TYPE = "[-]?\\b\\d+\\b|[-]?\\b[0-9]*\\.?[0-9]+(?:[eE][-+]?[0-9]+)?\\b";
    private static final Class<?>[][] PARAMETER_CHAINS = new Class[][]{{Boolean.TYPE, null}, {Byte.TYPE, Short.class}, {Character.TYPE, Integer.class}, {Short.TYPE, Integer.class}, {Integer.TYPE, Long.class}, {Long.TYPE, Float.class}, {Float.TYPE, Double.class}, {Double.TYPE, null}};
    private static Map<Class<?>, Class<?>> primitiveMap = new HashMap();
    private static Map<Class<?>, Class<?>> wrapperMap = new HashMap();
    private static Map<Class<?>, Class<?>[]> parameterMap = new HashMap();
    private static String ignoredMethodNames;

    public static Object convert(Object source, Class<?> target) throws ConversionException {
        if (target == null) {
            throw new ConversionException("Unable to perform conversion, target was null");
        }
        if (source == null) {
            if (target.isPrimitive()) {
                throw new ConversionException(String.format("Unable to convert null to primitive value of %s", target));
            }
            return source;
        }
        if (source instanceof Float && ((Float)source).isNaN() || source instanceof Double && ((Double)source).isNaN()) {
            return source;
        }
        if (target.isInstance(source)) {
            return source;
        }
        if (target.isAssignableFrom(source.getClass())) {
            return source;
        }
        if (target.isArray()) {
            return ConversionUtils.convertToArray(source, target);
        }
        if (target.equals(String.class)) {
            return source.toString();
        }
        if (target.isPrimitive()) {
            return ConversionUtils.convertToWrappedPrimitive(source, primitiveMap.get(target));
        }
        if (wrapperMap.containsKey(target)) {
            return ConversionUtils.convertToWrappedPrimitive(source, target);
        }
        if (target.equals(Map.class)) {
            return ConversionUtils.convertBeanToMap(source);
        }
        if (target.equals(List.class) || target.equals(Collection.class)) {
            if (source.getClass().equals(LinkedHashMap.class)) {
                return ConversionUtils.convertMapToList((LinkedHashMap)source);
            }
            if (source.getClass().isArray()) {
                return ConversionUtils.convertArrayToList((Object[])source);
            }
        }
        if (target.equals(Set.class) && source.getClass().isArray()) {
            return ConversionUtils.convertArrayToSet((Object[])source);
        }
        if (target.equals(Set.class) && source instanceof List) {
            return new HashSet((List)source);
        }
        if (source instanceof Map) {
            return ConversionUtils.convertMapToBean((Map)source, target);
        }
        throw new ConversionException(String.format("Unable to preform conversion from %s to %s", source, target));
    }

    public static Object convertToArray(Object source, Class<?> target) throws ConversionException {
        try {
            Class<?> targetType = target.getComponentType();
            if (source.getClass().isArray()) {
                Object targetInstance = Array.newInstance(targetType, Array.getLength(source));
                for (int i = 0; i < Array.getLength(source); ++i) {
                    Array.set(targetInstance, i, ConversionUtils.convert(Array.get(source, i), targetType));
                }
                return targetInstance;
            }
            if (source instanceof Collection) {
                Collection sourceCollection = (Collection)source;
                Object targetInstance = Array.newInstance(target.getComponentType(), sourceCollection.size());
                Iterator it = sourceCollection.iterator();
                int i = 0;
                while (it.hasNext()) {
                    Array.set(targetInstance, i++, ConversionUtils.convert(it.next(), targetType));
                }
                return targetInstance;
            }
            throw new ConversionException("Unable to convert to array");
        }
        catch (Exception ex) {
            throw new ConversionException("Error converting to array", (Throwable)ex);
        }
    }

    public static List<Object> convertMapToList(Map<?, ?> map) {
        ArrayList<Object> list = new ArrayList<Object>(map.size());
        list.addAll(map.values());
        return list;
    }

    public static Object convertToWrappedPrimitive(Object source, Class<?> wrapper) {
        if (source == null || wrapper == null) {
            return null;
        }
        if (wrapper.isInstance(source)) {
            return source;
        }
        if (wrapper.isAssignableFrom(source.getClass())) {
            return source;
        }
        if (source instanceof Number) {
            return ConversionUtils.convertNumberToWrapper((Number)source, wrapper);
        }
        if (Number.class.isAssignableFrom(wrapper) && !source.toString().matches(NUMERIC_TYPE)) {
            throw new ConversionException(String.format("Unable to convert string %s its not a number type: %s", source, wrapper));
        }
        return ConversionUtils.convertStringToWrapper(source.toString(), wrapper);
    }

    public static Object convertStringToWrapper(String str, Class<?> wrapper) {
        log.trace("String: {} to wrapper: {}", (Object)str, wrapper);
        if (wrapper.equals(String.class)) {
            return str;
        }
        if (wrapper.equals(Boolean.class)) {
            return Boolean.valueOf(str);
        }
        if (wrapper.equals(Double.class)) {
            return Double.valueOf(str);
        }
        if (wrapper.equals(Long.class)) {
            return Long.valueOf(str);
        }
        if (wrapper.equals(Float.class)) {
            return Float.valueOf(str);
        }
        if (wrapper.equals(Integer.class)) {
            return Integer.valueOf(str);
        }
        if (wrapper.equals(Short.class)) {
            return Short.valueOf(str);
        }
        if (wrapper.equals(Byte.class)) {
            return Byte.valueOf(str);
        }
        throw new ConversionException(String.format("Unable to convert string to: %s", wrapper));
    }

    public static Object convertNumberToWrapper(Number num, Class<?> wrapper) {
        if (wrapper.equals(String.class)) {
            return num.toString();
        }
        if (wrapper.equals(Boolean.class)) {
            return num.intValue() == 1;
        }
        if (wrapper.equals(Double.class)) {
            return num.doubleValue();
        }
        if (wrapper.equals(Long.class)) {
            return num.longValue();
        }
        if (wrapper.equals(Float.class)) {
            return Float.valueOf(num.floatValue());
        }
        if (wrapper.equals(Integer.class)) {
            return num.intValue();
        }
        if (wrapper.equals(Short.class)) {
            return num.shortValue();
        }
        if (wrapper.equals(Byte.class)) {
            return num.byteValue();
        }
        throw new ConversionException(String.format("Unable to convert number to: %s", wrapper));
    }

    public static List<Method> findMethodsByNameAndNumParams(Object object, String method, int numParam) {
        Method[] methods;
        LinkedList<Method> list = new LinkedList<Method>();
        for (Method m : methods = object.getClass().getMethods()) {
            String methodName = m.getName();
            if (ignoredMethodNames.indexOf(methodName) > -1) {
                log.debug("Skipping method: {}", (Object)methodName);
                continue;
            }
            if (log.isDebugEnabled()) {
                Class<?>[] params = m.getParameterTypes();
                log.debug("Method name: {} parameter count: {}", (Object)methodName, (Object)params.length);
                for (Class<?> param : params) {
                    log.debug("Parameter: {}", param);
                }
            }
            if (m.getParameterTypes().length != numParam) {
                log.debug("Param length not the same");
                continue;
            }
            if (!methodName.equals(method)) {
                log.trace("Method name not the same");
                continue;
            }
            list.add(m);
        }
        return list;
    }

    public static Object[] convertParams(Object[] source, Class<?>[] target) throws ConversionException {
        Object[] converted = new Object[target.length];
        for (int i = 0; i < target.length; ++i) {
            converted[i] = ConversionUtils.convert(source[i], target[i]);
        }
        return converted;
    }

    public static Class<?>[] convertParams(Object[] source) {
        Object[] converted = null;
        if (source != null) {
            converted = new Class[source.length];
            for (int i = 0; i < source.length; ++i) {
                converted[i] = source[i] != null ? source[i].getClass() : null;
            }
        } else {
            converted = new Class[]{};
        }
        if (log.isTraceEnabled()) {
            log.trace("Converted parameters: {}", (Object)Arrays.toString(converted));
        }
        return converted;
    }

    public static List<?> convertArrayToList(Object[] source) throws ConversionException {
        ArrayList<Object> list = new ArrayList<Object>(source.length);
        for (Object element : source) {
            list.add(element);
        }
        return list;
    }

    public static Object convertMapToBean(Map<String, ? extends Object> source, Class<?> target) throws ConversionException {
        Object bean = ConversionUtils.newInstance(target);
        if (bean == null && (bean = ConversionUtils.newInstance(target.getName())) == null) {
            throw new ConversionException("Unable to create bean using empty constructor");
        }
        try {
            BeanUtils.populate((Object)bean, source);
        }
        catch (Exception e) {
            throw new ConversionException("Error populating bean", (Throwable)e);
        }
        return bean;
    }

    public static Map<?, ?> convertBeanToMap(Object source) {
        return new BeanMap(source);
    }

    public static Set<?> convertArrayToSet(Object[] source) {
        HashSet<Object> set = new HashSet<Object>();
        for (Object element : source) {
            set.add(element);
        }
        return set;
    }

    protected static Object newInstance(String className) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        log.debug("Conversion utils classloader: {}", (Object)cl);
        Object instance = null;
        try {
            Class<?> clazz = cl.loadClass(className);
            instance = clazz.newInstance();
        }
        catch (Exception ex) {
            log.error("Error loading class: {}", (Object)className, (Object)ex);
        }
        return instance;
    }

    private static Object newInstance(Class<?> clazz) {
        Object instance = null;
        try {
            instance = clazz.newInstance();
        }
        catch (Exception ex) {
            log.error("Error loading class: {}", (Object)clazz.getName(), (Object)ex);
        }
        return instance;
    }

    static {
        for (int i = 0; i < PRIMITIVES.length; ++i) {
            primitiveMap.put(PRIMITIVES[i], WRAPPERS[i]);
            wrapperMap.put(WRAPPERS[i], PRIMITIVES[i]);
            parameterMap.put(WRAPPERS[i], PARAMETER_CHAINS[i]);
        }
        ignoredMethodNames = new String("equals,hashCode,toString,wait,notifyAll,getClass,clone,compareTo");
    }
}

