/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.util.Properties;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.spring.data.connection.RedissonReactiveServerCommands;
import org.springframework.data.redis.connection.ReactiveClusterServerCommands;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.convert.StringToRedisClientInfoConverter;
import org.springframework.data.redis.core.types.RedisClientInfo;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedissonReactiveClusterServerCommands
extends RedissonReactiveServerCommands
implements ReactiveClusterServerCommands {
    private static final RedisStrictCommand<String> FLUSHDB = new RedisStrictCommand("FLUSHDB");
    private static final RedisStrictCommand<String> FLUSHALL = new RedisStrictCommand("FLUSHALL");
    private static final StringToRedisClientInfoConverter CONVERTER = new StringToRedisClientInfoConverter();

    RedissonReactiveClusterServerCommands(CommandReactiveExecutor executorService) {
        super(executorService);
    }

    public Mono<String> bgReWriteAof(RedisClusterNode node) {
        return this.execute(node, BGREWRITEAOF, new Object[0]);
    }

    public Mono<String> bgSave(RedisClusterNode node) {
        return this.execute(node, BGSAVE, new Object[0]);
    }

    public Mono<Long> lastSave(RedisClusterNode node) {
        return this.execute(node, RedisCommands.LASTSAVE, new Object[0]);
    }

    public Mono<String> save(RedisClusterNode node) {
        return this.execute(node, SAVE, new Object[0]);
    }

    public Mono<Long> dbSize(RedisClusterNode node) {
        return this.execute(node, RedisCommands.DBSIZE, new Object[0]);
    }

    public Mono<String> flushDb(RedisClusterNode node) {
        return this.execute(node, FLUSHDB, new Object[0]);
    }

    public Mono<String> flushAll(RedisClusterNode node) {
        return this.execute(node, FLUSHALL, new Object[0]);
    }

    @Override
    public Mono<Properties> info() {
        return this.read(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)INFO_DEFAULT, new Object[0]);
    }

    @Override
    public Mono<Properties> info(String section) {
        return this.read(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)INFO, section);
    }

    public Mono<Properties> info(RedisClusterNode node) {
        return this.execute(node, INFO_DEFAULT, new Object[0]);
    }

    public Mono<Properties> info(RedisClusterNode node, String section) {
        return this.execute(node, INFO, new Object[]{section});
    }

    public Mono<Properties> getConfig(RedisClusterNode node, String pattern) {
        return this.execute(node, CONFIG_GET, new Object[]{pattern});
    }

    public Mono<String> setConfig(RedisClusterNode node, String param, String value) {
        return this.execute(node, CONFIG_SET, new Object[]{param, value});
    }

    public Mono<String> resetConfigStats(RedisClusterNode node) {
        return this.execute(node, CONFIG_RESETSTAT, new Object[0]);
    }

    public Mono<Long> time(RedisClusterNode node) {
        return this.execute(node, TIME, new Object[0]);
    }

    public Flux<RedisClientInfo> getClientList(RedisClusterNode node) {
        MasterSlaveEntry entry = this.getEntry(node);
        Mono m = this.executorService.reactive(() -> this.executorService.readAsync(entry, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CLIENT_LIST, new Object[0]));
        return m.flatMapMany(s -> Flux.fromIterable((Iterable)CONVERTER.convert(s.toArray(new String[s.size()]))));
    }
}

