/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.servlet;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Reference;
import org.restlet.engine.Engine;
import org.restlet.engine.adapter.HttpRequest;
import org.restlet.engine.adapter.HttpResponse;
import org.restlet.engine.adapter.ServerCall;
import org.restlet.ext.servlet.internal.ServletCall;
import org.restlet.ext.servlet.internal.ServletServerAdapter;

public class ServletAdapter
extends ServletServerAdapter {
    private volatile Restlet next;

    public ServletAdapter(ServletContext context) {
        this(context, null);
    }

    public ServletAdapter(ServletContext context, Restlet next) {
        super(new Context());
        this.next = next;
    }

    public Reference getBaseRef(HttpServletRequest request) {
        int baseIndex;
        Reference result = null;
        String basePath = request.getContextPath() + request.getServletPath();
        String baseUri = request.getRequestURL().toString();
        int pathStart = baseUri.indexOf("/", request.getScheme().length() + 3);
        if (basePath.length() == 0) {
            result = pathStart != -1 ? new Reference(baseUri.substring(0, pathStart)) : new Reference(baseUri);
        } else if (pathStart != -1 && (baseIndex = baseUri.indexOf(basePath, pathStart)) != -1) {
            result = new Reference(baseUri.substring(0, baseIndex + basePath.length()));
        }
        return result;
    }

    public Restlet getNext() {
        return this.next;
    }

    public Reference getRootRef(HttpServletRequest request) {
        return this.getBaseRef(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) {
        if (this.getNext() != null) {
            try {
                Context.setCurrent((Context)this.getContext());
                ServletCall servletCall = new ServletCall(request.getLocalAddr(), request.getLocalPort(), request, response);
                HttpRequest httpRequest = this.toRequest(servletCall);
                HttpResponse httpResponse = new HttpResponse((ServerCall)servletCall, (Request)httpRequest);
                httpRequest.getResourceRef().setBaseRef(this.getBaseRef(request));
                httpRequest.setRootRef(this.getRootRef(request));
                this.getNext().handle((Request)httpRequest, (Response)httpResponse);
                this.commit(httpResponse);
            }
            finally {
                Engine.clearThreadLocalVariables();
            }
        } else {
            this.getLogger().warning("Unable to find the Restlet target");
        }
    }

    public void setNext(Restlet next) {
        this.next = next;
    }
}

