/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth.internal;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.restlet.ext.oauth.OAuthException;
import org.restlet.ext.oauth.internal.Client;
import org.restlet.ext.oauth.internal.Token;
import org.restlet.ext.oauth.internal.TokenManager;

public abstract class AbstractTokenManager
implements TokenManager {
    public static final int RESEED_TOKENS = 1000;
    public static final int DEFAULT_TOKEN_EXPIRE_PERIOD = 3600;
    private SecureRandom random;
    private int expirePeriod = 3600;
    private boolean updateRefreshToken = true;
    private volatile int count = 0;

    public AbstractTokenManager() {
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected String generateRawCode() {
        StringBuilder raw = new StringBuilder(this.generate(20));
        raw.append('|').append(System.currentTimeMillis());
        return raw.toString();
    }

    protected String generateRawToken() {
        return this.generate(40);
    }

    protected String generate(int len) {
        if (this.count++ > 1000) {
            this.count = 0;
            this.random.setSeed(this.random.generateSeed(20));
        }
        byte[] token = new byte[len];
        this.random.nextBytes(token);
        return AbstractTokenManager.toHex(token);
    }

    protected static String toHex(byte[] input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length; ++i) {
            String d = Integer.toHexString(new Byte(input[i]).intValue() & 0xFF);
            if (d.length() == 1) {
                sb.append('0');
            }
            sb.append(d);
        }
        return sb.toString();
    }

    @Override
    public Token generateToken(Client client, String[] scope) throws OAuthException {
        return this.generateToken(client, null, scope);
    }

    @Override
    public Token findToken(Client client) {
        return this.findToken(client, null);
    }

    @Override
    public void revokeToken(Client client) {
        this.revokeToken(client, null);
    }

    public int getExpirePeriod() {
        return this.expirePeriod;
    }

    public void setExpirePeriod(int expirePeriod) {
        this.expirePeriod = expirePeriod;
    }

    public boolean isUpdateRefreshToken() {
        return this.updateRefreshToken;
    }

    public void setUpdateRefreshToken(boolean updateRefreshToken) {
        this.updateRefreshToken = updateRefreshToken;
    }
}

