/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.rdf;

import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Reference;
import org.restlet.ext.rdf.Graph;
import org.restlet.ext.rdf.GraphBuilder;
import org.restlet.ext.rdf.GraphHandler;
import org.restlet.ext.rdf.Link;
import org.restlet.ext.rdf.internal.n3.RdfN3Reader;
import org.restlet.ext.rdf.internal.n3.RdfN3Writer;
import org.restlet.ext.rdf.internal.ntriples.RdfNTriplesReader;
import org.restlet.ext.rdf.internal.ntriples.RdfNTriplesWriter;
import org.restlet.ext.rdf.internal.turtle.RdfTurtleReader;
import org.restlet.ext.rdf.internal.turtle.RdfTurtleWriter;
import org.restlet.ext.rdf.internal.xml.RdfXmlReader;
import org.restlet.ext.rdf.internal.xml.RdfXmlWriter;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;

public class RdfRepresentation
extends WriterRepresentation {
    private Graph graph;
    private Representation rdfRepresentation;

    public RdfRepresentation() {
        super(MediaType.TEXT_XML);
    }

    public RdfRepresentation(Graph linkSet, MediaType mediaType) {
        super(mediaType);
        this.graph = linkSet;
    }

    public RdfRepresentation(MediaType mediaType) {
        super(mediaType);
    }

    public RdfRepresentation(Representation rdfRepresentation) throws IOException {
        super(rdfRepresentation.getMediaType());
        this.rdfRepresentation = rdfRepresentation;
    }

    public GraphHandler createBuilder(Graph graph) {
        return new GraphBuilder(this.graph);
    }

    public GraphHandler createWriter(MediaType mediaType, Writer writer) throws IOException {
        if (MediaType.TEXT_RDF_N3.equals((Object)this.getMediaType())) {
            return new RdfN3Writer(writer);
        }
        if (MediaType.TEXT_XML.equals((Object)this.getMediaType())) {
            return new RdfXmlWriter(writer);
        }
        if (MediaType.APPLICATION_ALL_XML.includes((Metadata)this.getMediaType())) {
            return new RdfXmlWriter(writer);
        }
        if (MediaType.TEXT_PLAIN.equals((Object)this.getMediaType())) {
            return new RdfNTriplesWriter(writer);
        }
        if (MediaType.TEXT_RDF_NTRIPLES.equals((Object)this.getMediaType())) {
            return new RdfNTriplesWriter(writer);
        }
        if (MediaType.TEXT_TURTLE.equals((Object)this.getMediaType())) {
            return new RdfTurtleWriter(writer);
        }
        return null;
    }

    private void discoverNamespaces(Graph linkset, GraphHandler graphHandler) {
        for (Link link : linkset) {
            this.discoverNamespaces(link, graphHandler);
        }
    }

    private void discoverNamespaces(Link link, GraphHandler graphHandler) {
        if (link.hasLinkSource()) {
            this.discoverNamespaces(link.getSourceAsLink(), graphHandler);
        } else if (link.hasGraphSource()) {
            this.discoverNamespaces(link.getSourceAsGraph(), graphHandler);
        }
        this.discoverNamespaces(link.getTypeRef(), graphHandler);
        if (link.hasLinkTarget()) {
            this.discoverNamespaces(link.getTargetAsLink(), graphHandler);
        } else if (link.hasGraphSource()) {
            this.discoverNamespaces(link.getSourceAsGraph(), graphHandler);
        }
    }

    private void discoverNamespaces(Reference reference, GraphHandler graphHandler) {
        if (!Link.isBlankRef(reference)) {
            graphHandler.startPrefixMapping(null, reference);
        }
    }

    public Graph getGraph() throws IOException {
        if (this.graph == null) {
            this.graph = new Graph();
            this.parse(this.createBuilder(this.graph));
        }
        return this.graph;
    }

    public void parse(GraphHandler graphHandler) throws IOException {
        if (this.rdfRepresentation != null) {
            if (MediaType.TEXT_RDF_N3.equals((Object)this.rdfRepresentation.getMediaType())) {
                new RdfN3Reader(this.rdfRepresentation, graphHandler).parse();
            } else if (MediaType.TEXT_XML.equals((Object)this.rdfRepresentation.getMediaType())) {
                new RdfXmlReader(this.rdfRepresentation, graphHandler).parse();
            } else if (MediaType.APPLICATION_ALL_XML.includes((Metadata)this.rdfRepresentation.getMediaType())) {
                new RdfXmlReader(this.rdfRepresentation, graphHandler).parse();
            } else if (MediaType.TEXT_PLAIN.equals((Object)this.rdfRepresentation.getMediaType())) {
                new RdfNTriplesReader(this.rdfRepresentation, graphHandler).parse();
            } else if (MediaType.TEXT_RDF_NTRIPLES.equals((Object)this.rdfRepresentation.getMediaType())) {
                new RdfNTriplesReader(this.rdfRepresentation, graphHandler).parse();
            } else if (MediaType.TEXT_TURTLE.equals((Object)this.rdfRepresentation.getMediaType())) {
                new RdfTurtleReader(this.rdfRepresentation, graphHandler).parse();
            } else if (MediaType.valueOf((String)"text/rdf+n3").equals((Object)this.rdfRepresentation.getMediaType())) {
                new RdfN3Reader(this.rdfRepresentation, graphHandler).parse();
            }
        }
    }

    public void setGraph(Graph linkSet) {
        this.graph = linkSet;
    }

    public void write(GraphHandler graphHandler) throws IOException {
        try {
            if (this.graph != null) {
                this.discoverNamespaces(this.graph, graphHandler);
                graphHandler.startGraph();
                for (Link link : this.graph) {
                    if (link.hasReferenceSource()) {
                        if (link.hasReferenceTarget()) {
                            graphHandler.link(link.getSourceAsReference(), link.getTypeRef(), link.getTargetAsReference());
                            continue;
                        }
                        if (link.hasLiteralTarget()) {
                            graphHandler.link(link.getSourceAsReference(), link.getTypeRef(), link.getTargetAsLiteral());
                            continue;
                        }
                        if (link.hasLinkTarget()) {
                            Context.getCurrentLogger().warning("Cannot write the representation of a statement due to the fact that the object is neither a Reference nor a literal.");
                            continue;
                        }
                        Context.getCurrentLogger().warning("Cannot write the representation of a statement due to the fact that the object is neither a Reference nor a literal.");
                        continue;
                    }
                    if (!link.hasGraphSource()) continue;
                    if (link.hasReferenceTarget()) {
                        graphHandler.link(link.getSourceAsGraph(), link.getTypeRef(), link.getTargetAsReference());
                        continue;
                    }
                    if (link.hasLiteralTarget()) {
                        graphHandler.link(link.getSourceAsGraph(), link.getTypeRef(), link.getTargetAsLiteral());
                        continue;
                    }
                    if (link.hasLinkTarget()) {
                        Context.getCurrentLogger().warning("Cannot write the representation of a statement due to the fact that the object is neither a Reference nor a literal.");
                        continue;
                    }
                    Context.getCurrentLogger().warning("Cannot write the representation of a statement due to the fact that the object is neither a Reference nor a literal.");
                }
                graphHandler.endGraph();
            }
        }
        catch (Exception e) {
            Context.getCurrentLogger().log(Level.WARNING, "Cannot write the RDF graph due to an unexpected exception", e);
        }
    }

    public void write(Writer writer) throws IOException {
        this.write(this.createWriter(this.getMediaType(), writer));
    }
}

