/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.rdf.internal.n3;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.restlet.Context;
import org.restlet.data.Reference;
import org.restlet.ext.rdf.Graph;
import org.restlet.ext.rdf.GraphHandler;
import org.restlet.ext.rdf.Link;
import org.restlet.ext.rdf.Literal;
import org.restlet.ext.rdf.internal.RdfConstants;

public class RdfN3Writer
extends GraphHandler {
    private org.restlet.ext.rdf.internal.turtle.Context context = new org.restlet.ext.rdf.internal.turtle.Context();
    private Reference precPredicate;
    private Reference precSource;
    private Writer writer;
    private boolean writingExtraDot;

    public RdfN3Writer(Writer writer) throws IOException {
        this.writer = writer;
        Map<String, String> prefixes = this.context.getPrefixes();
        prefixes.put(RdfConstants.RDF_SCHEMA.toString(), "rdf");
        prefixes.put(RdfConstants.RDF_SYNTAX.toString(), "rdfs");
        prefixes.put("http://www.w3.org/2000/10/swap/grammar/bnf#", "cfg");
        prefixes.put("http://www.w3.org/2000/10/swap/grammar/n3#", "n3");
        prefixes.put("http://www.w3.org/2000/10/swap/list#", "list");
        prefixes.put("http://www.w3.org/2000/10/swap/pim/doc#", "doc");
        prefixes.put("http://www.w3.org/2002/07/owl#", "owl");
        prefixes.put("http://www.w3.org/2000/10/swap/log#", "log");
        prefixes.put("http://purl.org/dc/elements/1.1/", "dc");
        prefixes.put("http://www.w3.org/2001/XMLSchema#", "type");
        for (String key : prefixes.keySet()) {
            this.writer.append("@prefix ").append(prefixes.get(key)).append(": <").append(key).append(">.\n");
        }
        this.writer.append("@keywords a, is, of, has.\n");
    }

    @Override
    public void endGraph() throws IOException {
        this.writer.write(".\n");
        this.writer.flush();
    }

    @Override
    public void link(Graph source, Reference typeRef, Literal target) {
        try {
            this.writer.write("{");
            this.write(source);
            this.writer.write("} ");
            this.write(typeRef, this.context.getPrefixes());
            this.writer.write(" ");
            this.write(target);
            this.precSource = null;
            this.precPredicate = typeRef;
            this.writingExtraDot = true;
        }
        catch (IOException e) {
            Context.getCurrentLogger().warning("Cannot write the representation of a statement due to " + e.getMessage());
        }
    }

    @Override
    public void link(Graph source, Reference typeRef, Reference target) {
        try {
            this.writer.write("{");
            this.write(source);
            this.writer.write("} ");
            this.write(typeRef, this.context.getPrefixes());
            this.writer.write(" ");
            this.write(target, this.context.getPrefixes());
            this.precSource = null;
            this.precPredicate = typeRef;
            this.writingExtraDot = true;
        }
        catch (IOException e) {
            Context.getCurrentLogger().warning("Cannot write the representation of a statement due to " + e.getMessage());
        }
    }

    @Override
    public void link(Reference source, Reference typeRef, Literal target) {
        try {
            if (source.equals((Object)this.precSource)) {
                if (typeRef.equals((Object)this.precPredicate)) {
                    this.writer.write(", ");
                } else {
                    this.writer.write("; ");
                    this.write(typeRef, this.context.getPrefixes());
                    this.writer.write(" ");
                }
            } else {
                if (this.writingExtraDot) {
                    this.writer.write(".\n");
                }
                this.write(source, this.context.getPrefixes());
                this.writer.write(" ");
                this.write(typeRef, this.context.getPrefixes());
                this.writer.write(" ");
            }
            this.write(target);
            this.precSource = source;
            this.precPredicate = typeRef;
            this.writingExtraDot = true;
        }
        catch (IOException e) {
            Context.getCurrentLogger().warning("Cannot write the representation of a statement due to " + e.getMessage());
        }
    }

    @Override
    public void link(Reference source, Reference typeRef, Reference target) {
        try {
            if (source.equals((Object)this.precSource)) {
                if (typeRef.equals((Object)this.precPredicate)) {
                    this.writer.write(", ");
                } else {
                    this.writer.write("; ");
                    this.write(typeRef, this.context.getPrefixes());
                    this.writer.write(" ");
                }
            } else {
                if (this.writingExtraDot) {
                    this.writer.write(".\n");
                }
                this.write(source, this.context.getPrefixes());
                this.writer.write(" ");
                this.write(typeRef, this.context.getPrefixes());
                this.writer.write(" ");
            }
            this.write(target, this.context.getPrefixes());
            this.precSource = source;
            this.precPredicate = typeRef;
            this.writingExtraDot = true;
        }
        catch (IOException e) {
            Context.getCurrentLogger().warning("Cannot write the representation of a statement due to " + e.getMessage());
        }
    }

    private void write(Graph linkset) throws IOException {
        for (Link link : linkset) {
            if (link.hasReferenceSource()) {
                if (link.hasReferenceTarget()) {
                    this.link(link.getSourceAsReference(), link.getTypeRef(), link.getTargetAsReference());
                } else if (link.hasLiteralTarget()) {
                    this.link(link.getSourceAsReference(), link.getTypeRef(), link.getTargetAsLiteral());
                } else if (!link.hasLinkTarget()) {
                    Context.getCurrentLogger().warning("Cannot write the representation of a statement due to the fact that the object is neither a Reference nor a literal.");
                }
            } else if (link.hasGraphSource()) {
                this.writingExtraDot = false;
                if (link.hasReferenceTarget()) {
                    this.link(link.getSourceAsGraph(), link.getTypeRef(), link.getTargetAsReference());
                } else if (link.hasLiteralTarget()) {
                    this.link(link.getSourceAsGraph(), link.getTypeRef(), link.getTargetAsLiteral());
                } else if (!link.hasLinkTarget()) {
                    Context.getCurrentLogger().warning("Cannot write the representation of a statement due to the fact that the object is neither a Reference nor a literal.");
                }
                this.writer.write(".\n");
            }
            this.precSource = link.getSourceAsReference();
            this.precPredicate = link.getTypeRef();
        }
    }

    private void write(Literal literal) throws IOException {
        this.writer.write("\"");
        if (literal.getValue().contains("\n")) {
            this.writer.write("\"");
            this.writer.write("\"");
            this.writer.write(literal.getValue());
            this.writer.write("\"");
            this.writer.write("\"");
        } else {
            this.writer.write(literal.getValue());
        }
        this.writer.write("\"");
        if (literal.getDatatypeRef() != null) {
            this.writer.write("^^");
            this.write(literal.getDatatypeRef(), this.context.getPrefixes());
        }
        if (literal.getLanguage() != null) {
            this.writer.write("@");
            this.writer.write(literal.getLanguage().toString());
        }
    }

    private void write(Reference reference, Map<String, String> prefixes) throws IOException {
        String uri = reference.toString();
        if (Link.isBlankRef(reference)) {
            this.writer.write(uri);
        } else {
            boolean found = false;
            for (String key : prefixes.keySet()) {
                if (!uri.startsWith(key)) continue;
                found = true;
                this.writer.append(prefixes.get(key));
                this.writer.append(":");
                this.writer.append(uri.substring(key.length()));
                break;
            }
            if (!found) {
                this.writer.append("<");
                this.writer.append(uri);
                this.writer.append(">");
            }
        }
    }
}

