/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.rdf.internal.ntriples;

import java.io.IOException;
import java.io.Writer;
import org.restlet.Context;
import org.restlet.data.Reference;
import org.restlet.ext.rdf.Graph;
import org.restlet.ext.rdf.GraphHandler;
import org.restlet.ext.rdf.Link;
import org.restlet.ext.rdf.Literal;

public class RdfNTriplesWriter
extends GraphHandler {
    private Writer writer;

    public RdfNTriplesWriter(Writer writer) throws IOException {
        this.writer = writer;
    }

    @Override
    public void endGraph() throws IOException {
        this.writer.flush();
    }

    @Override
    public void link(Graph source, Reference typeRef, Literal target) {
        Context.getCurrentLogger().warning("Subjects as Graph are not supported in N-Triples.");
    }

    @Override
    public void link(Graph source, Reference typeRef, Reference target) {
        Context.getCurrentLogger().warning("Subjects as Graph are not supported in N-Triples.");
    }

    @Override
    public void link(Reference source, Reference typeRef, Literal target) {
        try {
            this.write(source);
            this.writer.write(" ");
            this.write(typeRef);
            this.writer.write(" ");
            this.write(target);
            this.writer.write(".\n");
        }
        catch (IOException e) {
            Context.getCurrentLogger().warning("Cannot write the representation of a statement due to: " + e.getMessage());
        }
    }

    @Override
    public void link(Reference source, Reference typeRef, Reference target) {
        try {
            this.write(source);
            this.writer.write(" ");
            this.write(typeRef);
            this.writer.write(" ");
            this.write(target);
            this.writer.write(".\n");
        }
        catch (IOException e) {
            Context.getCurrentLogger().warning("Cannot write the representation of a statement due to: " + e.getMessage());
        }
    }

    private void write(Literal literal) throws IOException {
        this.writer.write("\"");
        this.writer.write(literal.getValue());
        this.writer.write("\"");
    }

    private void write(Reference reference) throws IOException {
        String uri = reference.toString();
        if (Link.isBlankRef(reference)) {
            this.writer.write(uri);
        } else {
            this.writer.append("<");
            this.writer.append(uri);
            this.writer.append(">");
        }
    }
}

