/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.sip;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Tag;
import org.restlet.ext.sip.Address;
import org.restlet.ext.sip.Availability;
import org.restlet.ext.sip.ContactInfo;
import org.restlet.ext.sip.Event;
import org.restlet.ext.sip.EventType;
import org.restlet.ext.sip.OptionTag;
import org.restlet.ext.sip.SipRecipientInfo;
import org.restlet.ext.sip.internal.AddressWriter;

public class SipResponse
extends Response {
    private volatile Address alertInfo;
    private volatile List<EventType> allowedEventTypes;
    private volatile List<Address> calleeInfo;
    private volatile String callId;
    private volatile String commandSequence;
    private volatile List<ContactInfo> contacts;
    private volatile Address errorInfo;
    private volatile Event event;
    private volatile Address from;
    private volatile String mimeVersion;
    private volatile String minExpires;
    private volatile String organization;
    private volatile List<SipRecipientInfo> recipientsInfo;
    private volatile List<Address> recordedRoutes;
    private volatile Address replyTo;
    private volatile Availability retryAfter;
    private volatile Tag sipTag;
    private volatile List<OptionTag> supported;
    private volatile Address to;
    private volatile List<OptionTag> unsupported;

    public SipResponse(Request request) {
        super(request);
    }

    public Address getAlertInfo() {
        return this.alertInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventType> getAllowedEventTypes() {
        List<EventType> aet = this.allowedEventTypes;
        if (aet == null) {
            SipResponse sipResponse = this;
            synchronized (sipResponse) {
                aet = this.allowedEventTypes;
                if (aet == null) {
                    this.allowedEventTypes = aet = new CopyOnWriteArrayList<EventType>();
                }
            }
        }
        return aet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Address> getCalleeInfo() {
        List<Address> ci = this.calleeInfo;
        if (ci == null) {
            SipResponse sipResponse = this;
            synchronized (sipResponse) {
                ci = this.calleeInfo;
                if (ci == null) {
                    this.calleeInfo = ci = new CopyOnWriteArrayList<Address>();
                }
            }
        }
        return ci;
    }

    public String getCallId() {
        return this.callId;
    }

    public String getCommandSequence() {
        return this.commandSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ContactInfo> getContacts() {
        List<ContactInfo> c = this.contacts;
        if (c == null) {
            SipResponse sipResponse = this;
            synchronized (sipResponse) {
                c = this.contacts;
                if (c == null) {
                    this.contacts = c = new CopyOnWriteArrayList<ContactInfo>();
                }
            }
        }
        return c;
    }

    public Address getErrorInfo() {
        return this.errorInfo;
    }

    public Event getEvent() {
        return this.event;
    }

    public Address getFrom() {
        return this.from;
    }

    public String getMimeVersion() {
        return this.mimeVersion;
    }

    public String getMinExpires() {
        return this.minExpires;
    }

    public String getOrganization() {
        return this.organization;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Address> getRecordedRoutes() {
        List<Address> rr = this.recordedRoutes;
        if (rr == null) {
            SipResponse sipResponse = this;
            synchronized (sipResponse) {
                rr = this.recordedRoutes;
                if (rr == null) {
                    this.recordedRoutes = rr = new CopyOnWriteArrayList<Address>();
                }
            }
        }
        return rr;
    }

    public Address getReplyTo() {
        return this.replyTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SipRecipientInfo> getSipRecipientsInfo() {
        List<SipRecipientInfo> sri = this.recipientsInfo;
        if (sri == null) {
            SipResponse sipResponse = this;
            synchronized (sipResponse) {
                sri = this.recipientsInfo;
                if (sri == null) {
                    this.recipientsInfo = sri = new CopyOnWriteArrayList<SipRecipientInfo>();
                }
            }
        }
        return sri;
    }

    public Availability getSipRetryAfter() {
        return this.retryAfter;
    }

    public Tag getSipTag() {
        return this.sipTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OptionTag> getSupported() {
        List<OptionTag> s = this.supported;
        if (s == null) {
            SipResponse sipResponse = this;
            synchronized (sipResponse) {
                s = this.supported;
                if (s == null) {
                    this.supported = s = new CopyOnWriteArrayList<OptionTag>();
                }
            }
        }
        return s;
    }

    public Address getTo() {
        return this.to;
    }

    public String getTransactionId() {
        String result = null;
        if (this.getSipRecipientsInfo().size() > 0) {
            SipRecipientInfo recipient = this.getSipRecipientsInfo().get(0);
            result = recipient.getParameters().getFirstValue("branch");
        } else {
            result = this.getCallId() + '|' + this.getCommandSequence() + '|' + AddressWriter.write(this.getTo(), false) + '|' + AddressWriter.write(this.getFrom()) + '|';
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OptionTag> getUnsupported() {
        List<OptionTag> u = this.unsupported;
        if (u == null) {
            SipResponse sipResponse = this;
            synchronized (sipResponse) {
                u = this.unsupported;
                if (u == null) {
                    this.unsupported = u = new CopyOnWriteArrayList<OptionTag>();
                }
            }
        }
        return u;
    }

    public void setAlertInfo(Address alertInfo) {
        this.alertInfo = alertInfo;
    }

    public void setAllowedEventTypes(List<EventType> allowedEventTypes) {
        this.allowedEventTypes = allowedEventTypes;
    }

    public void setCalleeInfo(List<Address> calleeInfo) {
        this.calleeInfo = calleeInfo;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public void setCommandSequence(String commandSequence) {
        this.commandSequence = commandSequence;
    }

    public void setContacts(List<ContactInfo> contact) {
        this.contacts = contact;
    }

    public void setErrorInfo(Address errorInfo) {
        this.errorInfo = errorInfo;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public void setFrom(Address from) {
        this.from = from;
    }

    public void setMimeVersion(String mimeVersion) {
        this.mimeVersion = mimeVersion;
    }

    public void setMinExpires(String minExpires) {
        this.minExpires = minExpires;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public void setRecordedRoutes(List<Address> recordedRoutes) {
        this.recordedRoutes = recordedRoutes;
    }

    public void setReplyTo(Address replyTo) {
        this.replyTo = replyTo;
    }

    public void setSipRecipientsInfo(List<SipRecipientInfo> recipientsInfo) {
        this.recipientsInfo = recipientsInfo;
    }

    public void setSipRetryAfter(Availability retryAfter) {
        this.retryAfter = retryAfter;
    }

    public void setSipTag(Tag sipTag) {
        this.sipTag = sipTag;
    }

    public void setSupported(List<OptionTag> supported) {
        this.supported = supported;
    }

    public void setTo(Address to) {
        this.to = to;
    }

    public void setUnsupported(List<OptionTag> unsupported) {
        this.unsupported = unsupported;
    }
}

