/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.cfg;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.cfg.DominanceFrontier;
import EDU.purdue.cs.bloat.cfg.DominatorTree;
import EDU.purdue.cs.bloat.cfg.Handler;
import EDU.purdue.cs.bloat.cfg.ReplaceTarget;
import EDU.purdue.cs.bloat.cfg.Subroutine;
import EDU.purdue.cs.bloat.codegen.CodeGenerator;
import EDU.purdue.cs.bloat.editor.Instruction;
import EDU.purdue.cs.bloat.editor.Label;
import EDU.purdue.cs.bloat.editor.LocalVariable;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.Switch;
import EDU.purdue.cs.bloat.editor.TryCatch;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.tree.ArithExpr;
import EDU.purdue.cs.bloat.tree.ArrayLengthExpr;
import EDU.purdue.cs.bloat.tree.ArrayRefExpr;
import EDU.purdue.cs.bloat.tree.CastExpr;
import EDU.purdue.cs.bloat.tree.CatchExpr;
import EDU.purdue.cs.bloat.tree.ConstantExpr;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.ExprStmt;
import EDU.purdue.cs.bloat.tree.FieldExpr;
import EDU.purdue.cs.bloat.tree.GotoStmt;
import EDU.purdue.cs.bloat.tree.IfCmpStmt;
import EDU.purdue.cs.bloat.tree.IfStmt;
import EDU.purdue.cs.bloat.tree.IfZeroStmt;
import EDU.purdue.cs.bloat.tree.JsrStmt;
import EDU.purdue.cs.bloat.tree.JumpStmt;
import EDU.purdue.cs.bloat.tree.LabelStmt;
import EDU.purdue.cs.bloat.tree.LeafExpr;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.tree.MemExpr;
import EDU.purdue.cs.bloat.tree.Node;
import EDU.purdue.cs.bloat.tree.OperandStack;
import EDU.purdue.cs.bloat.tree.PhiJoinStmt;
import EDU.purdue.cs.bloat.tree.PrintVisitor;
import EDU.purdue.cs.bloat.tree.ReplaceVisitor;
import EDU.purdue.cs.bloat.tree.StackExpr;
import EDU.purdue.cs.bloat.tree.Stmt;
import EDU.purdue.cs.bloat.tree.StoreExpr;
import EDU.purdue.cs.bloat.tree.SwitchStmt;
import EDU.purdue.cs.bloat.tree.Tree;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.util.Assert;
import EDU.purdue.cs.bloat.util.Graph;
import EDU.purdue.cs.bloat.util.GraphNode;
import EDU.purdue.cs.bloat.util.ImmutableIterator;
import EDU.purdue.cs.bloat.util.ResizeableArrayList;
import EDU.purdue.cs.bloat.util.UnionFind;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class FlowGraph
extends Graph {
    public static final int PEEL_NO_LOOPS = 0;
    public static final int PEEL_ALL_LOOPS = -1;
    public static int PEEL_LOOPS_LEVEL = 1;
    public static boolean DEBUG = false;
    public static boolean DB_GRAPHS = false;
    public static boolean PRINT_GRAPH = false;
    MethodEditor method;
    Map subroutines;
    List catchBlocks;
    Map handlers;
    Block srcBlock;
    Block snkBlock;
    Block iniBlock;
    List trace;
    Graph loopTree;
    int domEdgeModCount;
    int loopEdgeModCount;
    int maxLoopDepth = 0;
    int file = 0;
    int next = 1;

    private void db(String s) {
        if (DEBUG || DB_GRAPHS) {
            System.out.println(s);
        }
    }

    public FlowGraph(MethodEditor method) {
        this.method = method;
        this.subroutines = new HashMap();
        this.catchBlocks = new ArrayList(method.tryCatches().size());
        this.handlers = new HashMap(method.tryCatches().size() * 2 + 1);
        this.trace = new LinkedList();
        this.srcBlock = this.newBlock();
        this.iniBlock = this.newBlock();
        this.snkBlock = this.newBlock();
        this.trace.add(this.iniBlock);
        if (method.codeLength() == 0) {
            this.addEdge(this.srcBlock, this.iniBlock);
            this.addEdge(this.iniBlock, this.snkBlock);
            this.addEdge(this.srcBlock, this.snkBlock);
            this.buildSpecialTrees(null, null);
            return;
        }
        HashMap labelPos = new HashMap();
        this.buildBlocks(labelPos);
        this.removeUnreachable();
        this.saveLabels();
        if (DEBUG || DB_GRAPHS) {
            System.out.println("---------- After building tree:");
            this.print(System.out);
            System.out.println("---------- end print after building tree");
        }
    }

    public int maxLoopDepth() {
        return this.maxLoopDepth;
    }

    public void initialize() {
        if (this.method.codeLength() == 0) {
            this.computeDominators();
            this.buildLoopTree();
            return;
        }
        this.computeDominators();
        if (DEBUG || DB_GRAPHS) {
            this.db("------ After computing dominators (Begin)");
            this.print(System.out);
            this.db("------ After computing dominators (End)");
        }
        this.splitPhiBlocks();
        if (DEBUG || DB_GRAPHS) {
            this.db("------ After splitting phi blocks (Begin)");
            this.print(System.out);
            this.db("------ After splitting phi blocks (End)");
        }
        this.removeUnreachable();
        if (DEBUG || DB_GRAPHS) {
            this.db("------ After removing unreachable 1 (Begin)");
            this.print(System.out);
            this.db("------ After removing unreachable 1 (End)");
        }
        this.splitIrreducibleLoops();
        if (DEBUG || DB_GRAPHS) {
            this.db("------ After splitting irreduciable loops (Begin)");
            this.print(System.out);
            this.db("------ After splitting irreducible loops (End)");
        }
        this.removeUnreachable();
        if (DEBUG || DB_GRAPHS) {
            this.db("------ After removing unreachable 2 (Begin)");
            this.print(System.out);
            this.db("------ After removing unreachable 2 (End)");
        }
        this.splitReducibleLoops();
        if (DEBUG || DB_GRAPHS) {
            this.db("------ After splitting reducible loops (Begin)");
            this.print(System.out);
            this.db("------ After splitting reducible loops (End)");
        }
        this.removeUnreachable();
        if (DEBUG || DB_GRAPHS) {
            this.db("------ After removing unreachable 3 (Begin)");
            this.print(System.out);
            this.db("------ After removing unreachable 3 (End)");
        }
        this.buildLoopTree();
        this.peelLoops(PEEL_LOOPS_LEVEL);
        this.removeCriticalEdges();
        this.removeUnreachable();
        this.insertConditionalStores();
        this.insertProtectedRegionStores();
        if (DEBUG) {
            System.out.println("---------- After splitting loops:");
            this.print(System.out);
            System.out.println("---------- end print after splitting loops");
        }
    }

    public Graph loopTree() {
        if (this.loopEdgeModCount != this.edgeModCount) {
            this.buildLoopTree();
        }
        return this.loopTree;
    }

    private void buildLoopTree() {
        LoopNode loop;
        this.db("  Building loop tree");
        this.loopEdgeModCount = this.edgeModCount;
        this.removeUnreachable();
        this.setBlockTypes();
        final LoopNode root = new LoopNode(this.srcBlock);
        this.loopTree = new Graph(){

            public Collection roots() {
                ArrayList<LoopNode> r = new ArrayList<LoopNode>(1);
                r.add(root);
                return r;
            }
        };
        this.loopTree.addNode(this.srcBlock, root);
        Iterator iter = this.nodes().iterator();
        while (iter.hasNext()) {
            Block block = (Block)iter.next();
            Block header = block.header();
            if (header == null) continue;
            LoopNode headerLoop = (LoopNode)this.loopTree.getNode(header);
            if (headerLoop == null) {
                headerLoop = new LoopNode(header);
                this.loopTree.addNode(header, headerLoop);
            }
            headerLoop.elements.add(block);
            if (block.blockType() == 0) continue;
            LoopNode loop2 = (LoopNode)this.loopTree.getNode(block);
            if (loop2 == null) {
                loop2 = new LoopNode(block);
                this.loopTree.addNode(block, loop2);
            }
            this.loopTree.addEdge(headerLoop, loop2);
        }
        iter = this.loopTree.postOrder().iterator();
        while (iter.hasNext()) {
            loop = (LoopNode)iter.next();
            int level = 0;
            Iterator succs = this.loopTree.succs(loop).iterator();
            while (succs.hasNext()) {
                LoopNode inner = (LoopNode)succs.next();
                if (level >= inner.level) continue;
                level = inner.level;
            }
            loop.level = level + 1;
        }
        iter = this.loopTree.preOrder().iterator();
        while (iter.hasNext()) {
            loop = (LoopNode)iter.next();
            Iterator preds = this.loopTree.preds(loop).iterator();
            if (preds.hasNext()) {
                LoopNode outer = (LoopNode)preds.next();
                loop.depth = outer.depth + 1;
                continue;
            }
            loop.depth = 0;
        }
    }

    private void buildBlocks(Map labelPos) {
        this.db("  Building blocks");
        ListIterator iter = this.method.code().listIterator();
        while (iter.hasNext()) {
            Label label;
            Object obj = iter.next();
            if (!(obj instanceof Label) || !(label = (Label)obj).startsBlock()) continue;
            this.trace.add(this.newBlock(label));
        }
        Instruction lastInst = null;
        Block currBlock = this.iniBlock;
        Block firstBlock = null;
        int i = 0;
        iter = this.method.code().listIterator();
        while (iter.hasNext()) {
            Subroutine sub;
            Block target;
            Object curr = iter.next();
            if (curr instanceof Label) {
                Label label = (Label)curr;
                if (label.startsBlock()) {
                    labelPos.put(label, new Integer(i));
                    Block nextBlock = (Block)this.getNode(label);
                    if (lastInst != null && lastInst.isJsr()) {
                        target = (Block)this.getNode(lastInst.operand());
                        sub = (Subroutine)this.subroutines.get(target);
                        sub.addPath(currBlock, nextBlock);
                    }
                    currBlock = nextBlock;
                    if (firstBlock == null) {
                        firstBlock = currBlock;
                    }
                }
            } else if (curr instanceof Instruction) {
                Label label;
                Instruction currInst;
                lastInst = currInst = (Instruction)curr;
                if (currInst.isJsr() && !this.subroutines.containsKey(target = (Block)this.getNode(label = (Label)currInst.operand()))) {
                    sub = new Subroutine(this);
                    this.setSubEntry(sub, target);
                }
            } else {
                throw new IllegalArgumentException();
            }
            ++i;
        }
        this.buildTrees(firstBlock, labelPos);
    }

    private void buildTrees(Block firstBlock, Map labelPos) {
        this.db("  Building trees for " + firstBlock);
        HashMap<Block, Block> catchBodies = new HashMap<Block, Block>(this.method.tryCatches().size() * 2 + 1);
        Iterator tryCatches = this.method.tryCatches().iterator();
        while (tryCatches.hasNext()) {
            TryCatch tc = (TryCatch)tryCatches.next();
            Block catchBlock = this.newBlock();
            Block catchBody = (Block)this.getNode(tc.handler());
            catchBodies.put(catchBlock, catchBody);
            Integer pos = (Integer)labelPos.get(tc.handler());
            labelPos.put(catchBlock.label(), pos);
            this.addEdge(catchBlock, catchBody);
            this.trace.add(this.trace.indexOf(catchBody), catchBlock);
            Type type = tc.type();
            if (type == null) {
                type = Type.NULL;
            }
            this.catchBlocks.add(catchBlock);
            StackExpr lhs = new StackExpr(0, Type.THROWABLE);
            CatchExpr rhs = new CatchExpr(type, Type.THROWABLE);
            StoreExpr store = new StoreExpr(lhs, rhs, Type.THROWABLE);
            Tree tree = new Tree(catchBlock, new OperandStack());
            catchBlock.setTree(tree);
            tree.addStmt(new ExprStmt(store));
            tree.addStmt(new GotoStmt(catchBody));
            Integer start = (Integer)labelPos.get(tc.start());
            Integer end = (Integer)labelPos.get(tc.end());
            Handler handler = new Handler(catchBlock, type);
            this.handlers.put(catchBlock, handler);
            Iterator blocks = this.nodes().iterator();
            while (blocks.hasNext()) {
                Block block = (Block)blocks.next();
                pos = (Integer)labelPos.get(block.label());
                if (pos == null || start > pos || end != null && pos >= end) continue;
                handler.protectedBlocks().add(block);
            }
        }
        this.addEdge(this.srcBlock, this.iniBlock);
        this.addEdge(this.srcBlock, this.snkBlock);
        this.addEdge(this.iniBlock, firstBlock);
        this.buildSpecialTrees(catchBodies, labelPos);
        this.buildTreeForBlock(firstBlock, this.iniBlock.tree().stack(), null, labelPos, catchBodies);
    }

    private void insertConditionalStores() {
        this.db("  Inserting conditional stores");
        ImmutableIterator blocks = new ImmutableIterator(this.nodes());
        while (blocks.hasNext()) {
            Expr copy;
            LocalExpr tmp;
            Expr left;
            Block target;
            JumpStmt stmt;
            Block block = (Block)blocks.next();
            Stmt last = block.tree().lastStmt();
            if (last instanceof IfCmpStmt) {
                ExprStmt insert;
                Expr copy2;
                LocalExpr tmp2;
                LocalVariable v;
                stmt = (IfCmpStmt)last;
                target = null;
                if (((IfStmt)stmt).trueTarget() == ((IfStmt)stmt).falseTarget()) continue;
                if (((IfStmt)stmt).comparison() == 0) {
                    target = ((IfStmt)stmt).trueTarget();
                } else if (((IfStmt)stmt).comparison() == 1) {
                    target = ((IfStmt)stmt).falseTarget();
                }
                if (target == null) continue;
                left = ((IfCmpStmt)stmt).left();
                Expr right = ((IfCmpStmt)stmt).right();
                if (left.type().isReference() || right.type().isReference()) continue;
                if (!(left instanceof LeafExpr)) {
                    v = this.method.newLocal(left.type());
                    tmp2 = new LocalExpr(v.index(), left.type());
                    copy2 = (Expr)left.clone();
                    copy2.setDef(null);
                    left.replaceWith(new StoreExpr(tmp2, copy2, left.type()));
                    left = tmp2;
                }
                if (!(right instanceof LeafExpr)) {
                    v = this.method.newLocal(right.type());
                    tmp2 = new LocalExpr(v.index(), right.type());
                    copy2 = (Expr)right.clone();
                    copy2.setDef(null);
                    right.replaceWith(new StoreExpr(tmp2, copy2, right.type()));
                    right = tmp2;
                }
                if (left instanceof LocalExpr) {
                    tmp = (LocalExpr)left.clone();
                    tmp.setDef(null);
                    copy = (Expr)right.clone();
                    copy.setDef(null);
                    insert = new ExprStmt(new StoreExpr(tmp, copy, left.type()));
                    target.tree().prependStmt(insert);
                    continue;
                }
                if (right instanceof LocalExpr) {
                    tmp = (LocalExpr)right.clone();
                    tmp.setDef(null);
                    copy = (Expr)left.clone();
                    copy.setDef(null);
                    insert = new ExprStmt(new StoreExpr(tmp, copy, right.type()));
                    target.tree().prependStmt(insert);
                    continue;
                }
                Assert.isTrue(left instanceof ConstantExpr && right instanceof ConstantExpr);
                continue;
            }
            if (last instanceof IfZeroStmt) {
                stmt = (IfZeroStmt)last;
                target = null;
                if (((IfStmt)stmt).trueTarget() == ((IfStmt)stmt).falseTarget()) continue;
                if (((IfStmt)stmt).comparison() == 0) {
                    target = ((IfStmt)stmt).trueTarget();
                } else if (((IfStmt)stmt).comparison() == 1) {
                    target = ((IfStmt)stmt).falseTarget();
                }
                if (target == null || (left = ((IfZeroStmt)stmt).expr()).type().isReference()) continue;
                if (!(left instanceof LeafExpr)) {
                    LocalVariable v = this.method.newLocal(left.type());
                    tmp = new LocalExpr(v.index(), left.type());
                    copy = (Expr)left.clone();
                    copy.setDef(null);
                    left.replaceWith(new StoreExpr(tmp, copy, left.type()));
                    left = tmp;
                }
                Integer value = null;
                Type type = left.type();
                if (left.type().isIntegral()) {
                    value = new Integer(0);
                } else {
                    Assert.isTrue(left.type().isReference());
                }
                if (left instanceof LocalExpr) {
                    copy = (LocalExpr)left.clone();
                    copy.setDef(null);
                    ExprStmt insert = new ExprStmt(new StoreExpr((MemExpr)copy, new ConstantExpr(value, type), left.type()));
                    target.tree().prependStmt(insert);
                    continue;
                }
                Assert.isTrue(left instanceof ConstantExpr);
                continue;
            }
            if (!(last instanceof SwitchStmt)) continue;
            stmt = (SwitchStmt)last;
            Expr index = ((SwitchStmt)stmt).index();
            if (!(index instanceof LeafExpr)) {
                LocalVariable v = this.method.newLocal(index.type());
                LocalExpr tmp3 = new LocalExpr(v.index(), index.type());
                Expr copy3 = (Expr)index.clone();
                copy3.setDef(null);
                index.replaceWith(new StoreExpr(tmp3, copy3, index.type()));
                index = tmp3;
            }
            if (!(index instanceof LocalExpr)) continue;
            Block[] targets = ((SwitchStmt)stmt).targets();
            int[] values = ((SwitchStmt)stmt).values();
            HashSet<Block> seen = new HashSet<Block>();
            HashSet<Block> duplicate = new HashSet<Block>();
            int i = 0;
            while (i < targets.length) {
                if (seen.contains(targets[i])) {
                    duplicate.add(targets[i]);
                } else {
                    seen.add(targets[i]);
                }
                ++i;
            }
            i = 0;
            while (i < targets.length) {
                Block target2 = targets[i];
                if (!duplicate.contains(target2)) {
                    this.splitEdge(block, targets[i]);
                    Assert.isTrue(targets[i] != target2);
                    LocalExpr copy4 = (LocalExpr)index.clone();
                    copy4.setDef(null);
                    ExprStmt insert = new ExprStmt(new StoreExpr(copy4, new ConstantExpr(new Integer(values[i]), index.type()), index.type()));
                    targets[i].tree().prependStmt(insert);
                }
                ++i;
            }
        }
    }

    private void insertProtectedRegionStores() {
        this.db("  Inserting protected region stores");
        HashSet tryPreds = new HashSet();
        Iterator blocks = this.catchBlocks.iterator();
        while (blocks.hasNext()) {
            Block block = (Block)blocks.next();
            Handler handler = (Handler)this.handlers.get(block);
            if (handler == null) continue;
            HashSet p = new HashSet();
            Iterator prots = handler.protectedBlocks().iterator();
            while (prots.hasNext()) {
                Block prot = (Block)prots.next();
                p.addAll(this.preds(prot));
            }
            p.removeAll(handler.protectedBlocks());
            tryPreds.addAll(p);
        }
        this.insertProtStores(this.srcBlock, tryPreds, new ResizeableArrayList());
    }

    private void insertProtStores(Block block, HashSet tryPreds, final ResizeableArrayList defs) {
        final Tree tree = block.tree();
        tree.visitChildren(new TreeVisitor(){

            public void visitLocalExpr(LocalExpr expr) {
                if (expr.isDef()) {
                    int index = expr.index();
                    if (expr.type().isWide()) {
                        defs.ensureSize(index + 2);
                        defs.set(index, expr);
                        defs.set(index + 1, null);
                    } else {
                        defs.ensureSize(index + 1);
                        defs.set(index, expr);
                    }
                }
            }
        });
        if (tryPreds.contains(block)) {
            int i = 0;
            while (i < defs.size()) {
                LocalExpr expr = (LocalExpr)defs.get(i);
                if (expr != null) {
                    Stmt last = tree.lastStmt();
                    last.visitChildren(new TreeVisitor(){

                        public void visitExpr(Expr expr) {
                            StackExpr var = tree.newStack(expr.type());
                            var.setValueNumber(expr.valueNumber());
                            Node p = expr.parent();
                            expr.setParent(null);
                            p.visit(new ReplaceVisitor(expr, var));
                            var = (StackExpr)var.clone();
                            var.setDef(null);
                            StoreExpr store = new StoreExpr(var, expr, expr.type());
                            store.setValueNumber(expr.valueNumber());
                            ExprStmt storeStmt = new ExprStmt(store);
                            storeStmt.setValueNumber(expr.valueNumber());
                            tree.addStmtBeforeJump(storeStmt);
                        }

                        public void visitStackExpr(StackExpr expr) {
                        }
                    });
                    LocalExpr copy1 = (LocalExpr)expr.clone();
                    LocalExpr copy2 = (LocalExpr)expr.clone();
                    copy1.setDef(null);
                    copy2.setDef(null);
                    StoreExpr store = new StoreExpr(copy1, copy2, expr.type());
                    tree.addStmtBeforeJump(new ExprStmt(store));
                }
                ++i;
            }
        }
        Iterator children = this.domChildren(block).iterator();
        while (children.hasNext()) {
            Block child = (Block)children.next();
            this.insertProtStores(child, tryPreds, new ResizeableArrayList((Collection)defs));
        }
    }

    private void saveLabels() {
        boolean save = false;
        ListIterator iter = this.method.code().listIterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof Label)) continue;
            Label label = (Label)obj;
            if (label.startsBlock()) {
                save = this.getNode(label) == null;
            }
            if (!save) continue;
            label.setStartsBlock(false);
            this.iniBlock.tree().addStmt(new LabelStmt(label));
        }
    }

    public void removeSub(Subroutine sub) {
        this.subroutines.remove(sub.entry());
    }

    public void addEdge(GraphNode src, GraphNode dst) {
        if (DEBUG) {
            System.out.println("    ADDING EDGE " + src + " -> " + dst);
        }
        super.addEdge(src, dst);
    }

    public void removeEdge(GraphNode v, GraphNode w) {
        Block src = (Block)v;
        Block dst = (Block)w;
        if (DEBUG) {
            System.out.println("    REMOVING EDGE " + src + " -> " + dst);
        }
        super.removeEdge(src, dst);
        this.cleanupEdge(src, dst);
    }

    private void cleanupEdge(final Block src, Block dst) {
        dst.visit(new TreeVisitor(){

            public void visitPhiJoinStmt(PhiJoinStmt stmt) {
                Expr operand = stmt.operandAt(src);
                if (operand != null) {
                    operand.cleanup();
                    stmt.setOperandAt(src, null);
                }
            }

            public void visitStmt(Stmt stmt) {
            }
        });
    }

    public Block newBlock() {
        return this.newBlock(this.method.newLabel());
    }

    Block newBlock(Label label) {
        Block block = new Block(label, this);
        this.addNode(label, block);
        if (DEBUG) {
            System.out.println("    new block " + block);
        }
        return block;
    }

    private void computeDominators() {
        this.db("  Computing Dominators");
        this.domEdgeModCount = this.edgeModCount;
        this.removeUnreachable();
        DominatorTree.buildTree(this, false);
        DominanceFrontier.buildFrontier(this, false);
        DominatorTree.buildTree(this, true);
        DominanceFrontier.buildFrontier(this, true);
    }

    private void setBlockTypes() {
        this.db("  Setting block types");
        List blocks = this.preOrder();
        Set[] nonBackPreds = new Set[blocks.size()];
        Set[] backPreds = new Set[blocks.size()];
        ListIterator iter = blocks.listIterator();
        while (iter.hasNext()) {
            HashSet<Block> back;
            HashSet<Block> nonBack;
            Block w = (Block)iter.next();
            int wn = this.preOrderIndex(w);
            nonBackPreds[wn] = nonBack = new HashSet<Block>();
            backPreds[wn] = back = new HashSet<Block>();
            w.setHeader(this.srcBlock);
            w.setBlockType(0);
            Iterator preds = this.preds(w).iterator();
            while (preds.hasNext()) {
                Block v = (Block)preds.next();
                if (this.isAncestorToDescendent(w, v)) {
                    back.add(v);
                    continue;
                }
                nonBack.add(v);
            }
        }
        this.srcBlock.setHeader(null);
        UnionFind uf = new UnionFind(blocks.size());
        iter = blocks.listIterator(blocks.size());
        while (iter.hasPrevious()) {
            Block w = (Block)iter.previous();
            int wn = this.preOrderIndex(w);
            Set nonBack = nonBackPreds[wn];
            Set back = backPreds[wn];
            HashSet<Block> body = new HashSet<Block>();
            Iterator preds = back.iterator();
            while (preds.hasNext()) {
                Block v = (Block)preds.next();
                if (v != w) {
                    int vn = this.preOrderIndex(v);
                    Block f = (Block)blocks.get(uf.find(vn));
                    body.add(f);
                    continue;
                }
                w.setBlockType(2);
            }
            if (body.size() == 0) continue;
            w.setBlockType(2);
            LinkedList<Block> worklist = new LinkedList<Block>(body);
            while (!worklist.isEmpty()) {
                Block x = (Block)worklist.removeFirst();
                int xn = this.preOrderIndex(x);
                Iterator e = nonBackPreds[xn].iterator();
                while (e.hasNext()) {
                    Block y = (Block)e.next();
                    int yn = this.preOrderIndex(y);
                    Block z = (Block)blocks.get(uf.find(yn));
                    if (!this.isAncestorToDescendent(w, z)) {
                        w.setBlockType(1);
                        nonBack.add(z);
                        continue;
                    }
                    if (body.contains(z) || z == w) continue;
                    body.add(z);
                    worklist.add(z);
                }
            }
            Iterator e = body.iterator();
            while (e.hasNext()) {
                Block x = (Block)e.next();
                int xn = this.preOrderIndex(x);
                x.setHeader(w);
                uf.union(xn, wn);
            }
        }
        Iterator<Object> e = this.subroutines.values().iterator();
        while (e.hasNext()) {
            Subroutine sub = (Subroutine)e.next();
            Iterator paths = sub.paths().iterator();
            while (paths.hasNext()) {
                Block h;
                Block[] path = (Block[])paths.next();
                if (path[0].blockType() != 0) {
                    path[0].setBlockType(1);
                }
                if (path[1].blockType() != 0) {
                    path[1].setBlockType(1);
                }
                if ((h = path[0].header()) != null) {
                    h.setBlockType(1);
                }
                if ((h = path[1].header()) == null) continue;
                h.setBlockType(1);
            }
        }
        e = this.catchBlocks.iterator();
        while (e.hasNext()) {
            Block h;
            Block catchBlock = (Block)e.next();
            if (catchBlock.blockType() != 0) {
                catchBlock.setBlockType(1);
            }
            if ((h = catchBlock.header()) == null) continue;
            h.setBlockType(1);
        }
    }

    private void splitIrreducibleLoops() {
        this.db("  Splitting irreducible loops");
        LinkedList<Block[]> removeEdges = new LinkedList<Block[]>();
        Iterator iter = this.nodes().iterator();
        while (iter.hasNext()) {
            Block w = (Block)iter.next();
            boolean hasReducibleBackIn = false;
            HashSet<Block> otherIn = new HashSet<Block>();
            Iterator preds = this.preds(w).iterator();
            while (preds.hasNext()) {
                Block v = (Block)preds.next();
                if (w.dominates(v)) {
                    hasReducibleBackIn = true;
                    continue;
                }
                otherIn.add(v);
            }
            if (!hasReducibleBackIn || otherIn.size() <= 1) continue;
            Iterator e = otherIn.iterator();
            while (e.hasNext()) {
                Block v = (Block)e.next();
                removeEdges.add(new Block[]{v, w});
            }
        }
        iter = removeEdges.iterator();
        while (iter.hasNext()) {
            Block[] edge = (Block[])iter.next();
            this.splitEdge(edge[0], edge[1]);
        }
    }

    private void splitReducibleLoops() {
        Set<Block> edges;
        Block w;
        this.db("  Splitting reducible loops");
        HashMap<Block, Set<Block>> reducibleBackIn = new HashMap<Block, Set<Block>>();
        Stack<Block> stack = new Stack<Block>();
        Iterator iter = this.nodes().iterator();
        while (iter.hasNext()) {
            w = (Block)iter.next();
            edges = new HashSet();
            Iterator preds = this.preds(w).iterator();
            while (preds.hasNext()) {
                Block v = (Block)preds.next();
                if (!w.dominates(v)) continue;
                edges.add(v);
            }
            if (edges.size() <= 1 || this.handlers.containsKey(w)) continue;
            stack.push(w);
            reducibleBackIn.put(w, edges);
        }
        while (!stack.isEmpty()) {
            w = (Block)stack.pop();
            edges = (Set)reducibleBackIn.get(w);
            Block min = null;
            ImmutableIterator preds = edges.iterator();
            while (preds.hasNext()) {
                Block v = (Block)preds.next();
                int vn = this.preOrderIndex(v);
                if (min != null && vn >= this.preOrderIndex(min)) continue;
                min = v;
            }
            Assert.isTrue(min != null);
            Assert.isFalse(this.handlers.containsKey(w));
            Assert.isFalse(this.subroutines.containsKey(w));
            Block newBlock = this.newBlock();
            this.trace.add(this.trace.indexOf(w), newBlock);
            Tree tree = new Tree(newBlock, min.tree().stack());
            newBlock.setTree(tree);
            tree.addInstruction(new Instruction(167, w.label()));
            JumpStmt newJump = (JumpStmt)tree.lastStmt();
            Iterator e = this.handlers.values().iterator();
            while (e.hasNext()) {
                Handler handler = (Handler)e.next();
                if (!handler.protectedBlocks().contains(w)) continue;
                Assert.isTrue(this.succs(w).contains(handler.catchBlock()));
                handler.protectedBlocks().add(newBlock);
                this.addEdge(newBlock, handler.catchBlock());
                newJump.catchTargets().add(handler.catchBlock());
            }
            preds = new ImmutableIterator(this.preds(w));
            while (preds.hasNext()) {
                Block v = (Block)preds.next();
                if (v == min) continue;
                this.addEdge(v, newBlock);
                this.removeEdge(v, w);
                v.visit(new ReplaceTarget(w, newBlock));
            }
            this.addEdge(newBlock, w);
            edges.remove(min);
            if (edges.size() <= 1) continue;
            stack.push(newBlock);
            reducibleBackIn.put(newBlock, edges);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void peelLoops(int level) {
        if (FlowGraph.DEBUG) {
            System.out.println("Peeling loops");
            System.out.println("  loop tree = " + this.loopTree);
        }
        hoistable = new HashSet<Block>();
        this.visit(new TreeVisitor(){

            public void visitNode(Node node) {
                if (!hoistable.contains(node.block())) {
                    node.visitChildren(this);
                }
            }

            public void visitCastExpr(CastExpr expr) {
                if (expr.castType().isReference() && expr.expr() instanceof LeafExpr) {
                    hoistable.add(expr.block());
                }
                this.visitNode(expr);
            }

            public void visitArithExpr(ArithExpr expr) {
                if ((expr.operation() == 47 || expr.operation() == 37) && expr.type().isIntegral() && expr.left() instanceof LeafExpr && expr.right() instanceof LeafExpr) {
                    hoistable.add(expr.block());
                }
                this.visitNode(expr);
            }

            public void visitArrayLengthExpr(ArrayLengthExpr expr) {
                if (expr.array() instanceof LeafExpr) {
                    hoistable.add(expr.block());
                }
                this.visitNode(expr);
            }

            public void visitArrayRefExpr(ArrayRefExpr expr) {
                if (expr.array() instanceof LeafExpr && expr.index() instanceof LeafExpr) {
                    hoistable.add(expr.block());
                }
                this.visitNode(expr);
            }

            public void visitFieldExpr(FieldExpr expr) {
                if (expr.object() instanceof LeafExpr) {
                    hoistable.add(expr.block());
                }
                this.visitNode(expr);
            }
        });
        peel = new ArrayList<Integer>(this.loopTree.size());
        headers = new ArrayList<Block>(this.loopTree.size());
        outer = new ArrayList<Integer>(this.loopTree.size());
        loops = new ArrayList<ArrayList<E>>(this.loopTree.postOrder());
        i = 0;
        while (i < loops.size()) {
            loop = (LoopNode)loops.get(i);
            if (this.loopTree.preds(loop).size() > 0 && loop.header.blockType() != 1) {
                headers.add(loop.header);
                peel.add(new Integer(i));
                outerLoop = null;
                e = this.loopTree.preds(loop).iterator();
                Assert.isTrue(e.hasNext());
                outerLoop = (LoopNode)e.next();
                Assert.isTrue(e.hasNext() == false);
                outerIndex = loops.indexOf(outerLoop);
                Assert.isTrue(outerIndex != -1);
                outer.add(new Integer(outerIndex));
            }
            ++i;
        }
        levels = new int[loops.size()];
        i = 0;
        while (i < loops.size()) {
            loop = (LoopNode)loops.get(i);
            loops.set(i, new ArrayList<E>(loop.elements));
            levels[i] = loop.level;
            this.maxLoopDepth = loop.level > this.maxLoopDepth ? loop.level : this.maxLoopDepth;
            ++i;
        }
        i = 0;
        while (i < peel.size()) {
            block36: {
                loopIndex = (Integer)peel.get(i);
                outerLoopIndex = (Integer)outer.get(i);
                header = (Block)headers.get(i);
                loop = (Collection)loops.get(loopIndex);
                outerLoop = (Collection)loops.get(outerLoopIndex);
                loop.retainAll(this.nodes());
                if (FlowGraph.DEBUG) {
                    System.out.println("  loop = " + loop);
                    System.out.println("  outer = " + outerLoop);
                }
                canPeel = false;
                canInvert = false;
                if (level != 0 && (level == -1 || level >= levels[loopIndex])) {
                    e = loop.iterator();
                    while (e.hasNext()) {
                        block = (Block)e.next();
                        if (!hoistable.contains(block)) continue;
                        canPeel = true;
                        break;
                    }
                }
                if (!canPeel) {
                    hasExitSucc = false;
                    hasLoopSucc = false;
                    succs = this.succs(header).iterator();
                    while (succs.hasNext()) {
                        succ = (Block)succs.next();
                        if (!loop.contains(succ)) {
                            hasExitSucc = true;
                            continue;
                        }
                        if (succ == header) continue;
                        hasLoopSucc = true;
                    }
                    canInvert = hasExitSucc != false && hasLoopSucc != false;
                }
                copySet = new HashSet<Block>();
                if (!canPeel) break block36;
                exits = new HashSet<Block>();
                exits.addAll(hoistable);
                exits.retainAll(loop);
                e = loop.iterator();
                block5: while (e.hasNext()) {
                    block = (Block)e.next();
                    succs = this.succs(block).iterator();
                    while (succs.hasNext()) {
                        succ = (Block)succs.next();
                        if (loop.contains(succ)) continue;
                        exits.add(block);
                        continue block5;
                    }
                }
                stack = new ArrayList<Block>(exits);
                e = exits.iterator();
                while (e.hasNext()) {
                    block = (Block)e.next();
                    copySet.add(block);
                    stack.add(block);
                }
                while (!stack.isEmpty()) {
                    block = (Block)stack.remove(stack.size() - 1);
                    preds = this.preds(block).iterator();
                    while (preds.hasNext()) {
                        pred = (Block)preds.next();
                        if (copySet.contains(pred)) continue;
                        copySet.add(pred);
                        stack.add(pred);
                    }
                }
                ** GOTO lbl121
            }
            if (!canInvert) {
                if (outerLoop != null) {
                    outerLoop.addAll(loop);
                }
            } else {
                copySet.add(header);
lbl121:
                // 2 sources

                copies = new HashMap<Block, Block>();
                e = copySet.iterator();
                while (e.hasNext()) {
                    block = (Block)e.next();
                    if (FlowGraph.DEBUG && (jump = block.tree().lastStmt()) instanceof JsrStmt) {
                        jsr = (JsrStmt)jump;
                        Assert.isTrue(copySet.contains(jsr.follow()));
                        Assert.isTrue(copySet.contains(jsr.sub().entry()));
                    }
                    if (!loop.contains(block)) continue;
                    copy = (Block)copies.get(block);
                    if (copy == null) {
                        copy = this.copyBlock(block);
                        copies.put(block, copy);
                    }
                    if (!hoistable.contains(block)) continue;
                    hoistable.add(copy);
                }
                if (FlowGraph.DEBUG) {
                    System.out.println("  copy = " + copies);
                }
                copyIndex = -1;
                e = this.preds(header).iterator();
                while (e.hasNext()) {
                    pred = (Block)e.next();
                    if (header.dominates(pred) || copyIndex > (index = this.trace.indexOf(pred))) continue;
                    copyIndex = index + 1;
                }
                if (copyIndex < 0) {
                    copyIndex = this.trace.indexOf(header);
                }
                copyTrace = new ResizeableArrayList(copies.size());
                e = this.trace.iterator();
                while (e.hasNext()) {
                    block = (Block)e.next();
                    copy = (Block)copies.get(block);
                    if (copy == null) continue;
                    copyTrace.add(copy);
                }
                this.trace.addAll(copyIndex, copyTrace);
                addEdges = new LinkedList<Block[]>();
                removeEdges = new LinkedList<Block[]>();
                e = copies.entrySet().iterator();
                while (e.hasNext()) {
                    pair = (Map.Entry)e.next();
                    block = (Block)pair.getKey();
                    copy = (Block)pair.getValue();
                    h = this.handlers.values().iterator();
                    while (h.hasNext()) {
                        handler = (Handler)h.next();
                        if (!handler.protectedBlocks().contains(block)) continue;
                        handler.protectedBlocks().add(copy);
                    }
                    succs = this.succs(block).iterator();
                    while (succs.hasNext()) {
                        succ = (Block)succs.next();
                        succCopy = (Block)copies.get(succ);
                        if (succ != header && succCopy != null) {
                            addEdges.add(new Block[]{copy, succCopy});
                            copy.visit(new ReplaceTarget(succ, succCopy));
                            continue;
                        }
                        addEdges.add(new Block[]{copy, succ});
                    }
                }
                e = copies.entrySet().iterator();
                while (e.hasNext()) {
                    pair = (Map.Entry)e.next();
                    block = (Block)pair.getKey();
                    copy = (Block)pair.getValue();
                    preds = this.preds(block).iterator();
                    while (preds.hasNext()) {
                        pred = (Block)preds.next();
                        if (loop.contains(pred)) continue;
                        addEdges.add(new Block[]{pred, copy});
                        removeEdges.add(new Block[]{pred, block});
                        pred.visit(new ReplaceTarget(block, copy));
                    }
                }
                e = addEdges.iterator();
                while (e.hasNext()) {
                    edge = (Block[])e.next();
                    this.addEdge(edge[0], edge[1]);
                }
                e = removeEdges.iterator();
                while (e.hasNext()) {
                    edge = (Block[])e.next();
                    v = edge[0];
                    w = edge[1];
                    if (!this.hasNode(v) || !this.hasNode(w) || !this.hasEdge(v, w)) continue;
                    this.removeEdge(v, w);
                }
                if (outerLoop != null) {
                    outerLoop.addAll(copies.values());
                    outerLoop.addAll(loop);
                }
            }
            ++i;
        }
        if (FlowGraph.DEBUG) {
            System.out.println("Begin after peeling:");
            System.out.println(this);
            System.out.println("End after peeling");
        }
    }

    private Block copyBlock(Block block) {
        Block copy = this.newBlock();
        Tree tree = new Tree(copy, block.tree().stack());
        copy.setTree(tree);
        Iterator stmts = block.tree().stmts().iterator();
        while (stmts.hasNext()) {
            Stmt stmt = (Stmt)stmts.next();
            if (stmt instanceof LabelStmt) continue;
            tree.addStmt((Stmt)stmt.clone());
        }
        return copy;
    }

    public Subroutine labelSub(Label label) {
        return (Subroutine)this.subroutines.get(this.getNode(label));
    }

    void setSubEntry(Subroutine sub, Block entry) {
        if (sub.entry() != null) {
            this.subroutines.remove(sub.entry());
        }
        sub.setEntry(entry);
        this.subroutines.put(entry, sub);
    }

    public Collection subroutines() {
        return this.subroutines.values();
    }

    public void print(PrintStream out) {
        this.print(new PrintWriter(out, true));
    }

    public void print(PrintWriter out) {
        String dateString = DateFormat.getDateInstance().format(new Date());
        out.println("Print " + ++this.file + " at " + dateString + " " + this.method.type() + " " + this.method.name() + ":");
        this.visit(new PrintVisitor(out));
        if (PRINT_GRAPH) {
            this.printGraph();
        }
    }

    public void printGraph() {
        try {
            PrintStream out = new PrintStream(new FileOutputStream(String.valueOf(this.method.name()) + "." + this.next++ + ".dot"));
            this.printGraph(out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void print() {
        try {
            PrintStream out = new PrintStream(new FileOutputStream(String.valueOf(this.method.name()) + "." + this.next++ + ".cfg"));
            this.print(out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void printGraph(PrintStream out) {
        this.printGraph(new PrintWriter(out, true));
    }

    public void printGraph(PrintWriter out) {
        this.printGraph(out, "cfg");
    }

    public void printGraph(PrintWriter out, String name) {
        out.println("digraph " + name + " {");
        out.println("    fontsize=8;");
        out.println("    ordering=out;");
        out.println("    center=1;");
        this.visit(new PrintVisitor(out){

            public void println() {
                super.print("\\n");
            }

            public void println(Object obj) {
                super.print(obj);
                super.print("\\n");
            }

            public void visitBlock(Block block) {
                super.print("    " + block.label() + " [shape=box,fontname=\"Courier\",fontsize=6,label=\"");
                block.visitChildren(this);
                super.print("\"];\n");
                Iterator succs = FlowGraph.this.succs(block).iterator();
                while (succs.hasNext()) {
                    Block succ = (Block)succs.next();
                    super.print("    " + block.label() + " -> " + succ.label());
                    if (FlowGraph.this.handlers.containsKey(succ)) {
                        super.print(" [style=dotted];\n");
                        continue;
                    }
                    super.print(" [style=solid];\n");
                }
            }
        });
        out.println("    page=\"8.5,11\";");
        out.println("}");
        out.close();
    }

    public void visitChildren(TreeVisitor visitor) {
        List list = this.preOrder();
        if (!visitor.reverse()) {
            ListIterator iter = list.listIterator();
            while (iter.hasNext()) {
                Block block = (Block)iter.next();
                block.visit(visitor);
            }
        } else {
            ListIterator iter = list.listIterator(list.size());
            while (iter.hasPrevious()) {
                Block block = (Block)iter.previous();
                block.visit(visitor);
            }
        }
    }

    public void visit(TreeVisitor visitor) {
        visitor.visitFlowGraph(this);
    }

    public MethodEditor method() {
        return this.method;
    }

    private void removeCriticalEdges() {
        LinkedList<Block[]> edges = new LinkedList<Block[]>();
        Iterator blocks = this.nodes().iterator();
        while (blocks.hasNext()) {
            Block dst = (Block)blocks.next();
            if (this.subroutines.containsKey(dst) || this.handlers.containsKey(dst) || this.preds(dst).size() <= 1 || dst == this.snkBlock) continue;
            Iterator preds = this.preds(dst).iterator();
            while (preds.hasNext()) {
                Block src = (Block)preds.next();
                if (this.succs(src).size() <= 1) continue;
                edges.add(new Block[]{src, dst});
            }
        }
        Iterator e = edges.iterator();
        while (e.hasNext()) {
            Block w;
            Block[] edge = (Block[])e.next();
            Block v = edge[0];
            if (!this.hasEdge(v, w = edge[1])) continue;
            if (DEBUG) {
                System.out.println("removing critical edge from " + v + " to " + w);
            }
            this.splitEdge(v, w);
            Assert.isFalse(this.hasEdge(v, w));
        }
    }

    private void splitEdge(Block src, Block dst) {
        Assert.isFalse(src == this.srcBlock || dst == this.snkBlock, "Can't split an edge from the source or to the sink");
        if (this.handlers.containsKey(dst)) {
            if (DEBUG) {
                System.out.println("not removing exception edge " + src + " -> " + dst);
            }
            return;
        }
        Block newBlock = this.newBlock();
        this.trace.add(this.trace.indexOf(dst), newBlock);
        Tree tree = new Tree(newBlock, src.tree().stack());
        newBlock.setTree(tree);
        tree.addInstruction(new Instruction(167, dst.label()));
        if (DEBUG) {
            System.out.println("add edge " + src + " -> " + newBlock);
            System.out.println("add edge " + newBlock + " -> " + dst);
            System.out.println("remove edge " + src + " -> " + dst);
        }
        src.visit(new ReplaceTarget(dst, newBlock));
        this.addEdge(src, newBlock);
        this.addEdge(newBlock, dst);
        this.removeEdge(src, dst);
        Assert.isTrue(this.hasEdge(src, newBlock));
        Assert.isTrue(this.hasEdge(newBlock, dst));
        Assert.isFalse(this.hasEdge(src, dst));
        JumpStmt newJump = (JumpStmt)newBlock.tree().lastStmt();
        Iterator e = this.handlers.values().iterator();
        while (e.hasNext()) {
            Handler handler = (Handler)e.next();
            if (!handler.protectedBlocks().contains(dst)) continue;
            Assert.isTrue(this.succs(dst).contains(handler.catchBlock()));
            handler.protectedBlocks().add(newBlock);
            this.addEdge(newBlock, handler.catchBlock());
            newJump.catchTargets().add(handler.catchBlock());
        }
    }

    private void splitPhiBlocks() {
        Iterator entries = this.subroutines.values().iterator();
        while (entries.hasNext()) {
            Subroutine entrySub = (Subroutine)entries.next();
            Block block = entrySub.entry();
            Subroutine returnSub = null;
            Block returnSubCaller = null;
            Iterator returns = this.subroutines.values().iterator();
            block1: while (returns.hasNext()) {
                returnSub = (Subroutine)returns.next();
                if (returnSub == entrySub) continue;
                Iterator paths = returnSub.paths().iterator();
                while (paths.hasNext()) {
                    Block[] path = (Block[])paths.next();
                    if (block != path[1]) continue;
                    returnSubCaller = path[0];
                    break block1;
                }
            }
            if (returnSubCaller == null) continue;
            if (DEBUG) {
                System.out.println(block + " is both an entry and a return target");
            }
            int traceIndex = this.trace.indexOf(block);
            Block newEntry = this.newBlock();
            this.trace.add(traceIndex, newEntry);
            Tree tree = new Tree(newEntry, returnSub.exit().tree().stack());
            newEntry.setTree(tree);
            tree.addInstruction(new Instruction(167, block.label()));
            this.addEdge(newEntry, block);
            Iterator paths = entrySub.paths().iterator();
            while (paths.hasNext()) {
                Block[] path = (Block[])paths.next();
                this.removeEdge(path[0], block);
                this.addEdge(path[0], newEntry);
                path[0].visit(new ReplaceTarget(block, newEntry));
            }
            this.setSubEntry(entrySub, newEntry);
            Block newTarget = this.newBlock();
            this.trace.add(traceIndex, newTarget);
            tree = new Tree(newTarget, returnSub.exit().tree().stack());
            newTarget.setTree(tree);
            tree.addInstruction(new Instruction(167, block.label()));
            returnSub.exit().visit(new ReplaceTarget(block, newTarget));
            ((JsrStmt)returnSubCaller.tree().lastStmt()).setFollow(newTarget);
            this.addEdge(newTarget, block);
            this.addEdge(returnSub.exit(), newTarget);
            this.removeEdge(returnSub.exit(), block);
            JumpStmt entryJump = (JumpStmt)newEntry.tree().lastStmt();
            JumpStmt targetJump = (JumpStmt)newTarget.tree().lastStmt();
            Iterator e = this.handlers.values().iterator();
            while (e.hasNext()) {
                Handler handler = (Handler)e.next();
                if (!handler.protectedBlocks().contains(block)) continue;
                Assert.isTrue(this.succs(block).contains(handler.catchBlock()));
                handler.protectedBlocks().add(newEntry);
                this.addEdge(newEntry, handler.catchBlock());
                entryJump.catchTargets().add(handler.catchBlock());
                handler.protectedBlocks().add(newTarget);
                this.addEdge(newTarget, handler.catchBlock());
                targetJump.catchTargets().add(handler.catchBlock());
            }
        }
    }

    private void buildSpecialTrees(Map catchBodies, Map labelPos) {
        Tree tree = new Tree(this.srcBlock, new OperandStack());
        this.srcBlock.setTree(tree);
        tree = new Tree(this.snkBlock, new OperandStack());
        this.snkBlock.setTree(tree);
        tree = new Tree(this.iniBlock, new OperandStack());
        this.iniBlock.setTree(tree);
        if (this.method.codeLength() > 0) {
            tree.initLocals(this.methodParams(this.method));
            tree.addInstruction(new Instruction(167, this.method.firstBlock()));
            if (catchBodies != null) {
                this.addHandlerEdges(this.iniBlock, catchBodies, labelPos, null, new HashSet());
            }
        }
    }

    private void addHandlerEdges(Block block, Map catchBodies, Map labelPos, Subroutine sub, Set visited) {
        if (visited.contains(block)) {
            return;
        }
        visited.add(block);
        Tree tree = block.tree();
        Assert.isTrue(tree != null);
        Iterator hiter = this.handlers.values().iterator();
        while (hiter.hasNext()) {
            Handler handler = (Handler)hiter.next();
            boolean prot = false;
            if (handler.protectedBlocks().contains(block)) {
                prot = true;
            } else {
                Iterator succs = this.succs(block).iterator();
                while (succs.hasNext()) {
                    Block succ = (Block)succs.next();
                    if (!handler.protectedBlocks().contains(succ)) continue;
                    prot = true;
                    break;
                }
            }
            if (!prot) continue;
            Block catchBlock = handler.catchBlock();
            JumpStmt jump = (JumpStmt)tree.lastStmt();
            jump.catchTargets().add(catchBlock);
            this.addEdge(block, catchBlock);
            Block catchBody = (Block)catchBodies.get(catchBlock);
            Assert.isTrue(catchBody != null);
            if (catchBody.tree() == null) {
                OperandStack s = new OperandStack();
                s.push(new StackExpr(0, Type.THROWABLE));
                this.buildTreeForBlock(catchBody, s, sub, labelPos, catchBodies);
            }
            this.addHandlerEdges(catchBlock, catchBodies, labelPos, sub, visited);
        }
    }

    private void buildTreeForBlock(Block block, OperandStack stack, Subroutine sub, Map labelPos, Map catchBodies) {
        if (block.tree() != null) {
            return;
        }
        Tree tree = new Tree(block, stack);
        block.setTree(tree);
        Integer start = (Integer)labelPos.get(block.label());
        ListIterator iter = this.method.code().listIterator(start + 1);
        while (iter.hasNext()) {
            Object ce = iter.next();
            if (ce instanceof Instruction) {
                Instruction inst = (Instruction)ce;
                Block next = null;
                if (inst.isJsr() || inst.isConditionalJump()) {
                    int save = 0;
                    while (iter.hasNext()) {
                        Object obj = iter.next();
                        ++save;
                        if (obj instanceof Label) {
                            if (!((Label)obj).startsBlock()) continue;
                            next = (Block)this.getNode(obj);
                            while (save-- > 0) {
                                iter.previous();
                            }
                            break;
                        }
                        throw new RuntimeException(inst + " not followed by a label: " + obj + " (" + obj.getClass() + ")");
                    }
                }
                if (inst.opcodeClass() == 58) {
                    tree.addInstruction(inst, sub);
                    continue;
                }
                if (inst.isRet()) {
                    sub.setExit(block);
                    tree.addInstruction(inst, sub);
                    Iterator paths = sub.paths().iterator();
                    while (paths.hasNext()) {
                        Block[] path = (Block[])paths.next();
                        this.addEdge(block, path[1]);
                    }
                    break;
                }
                if (inst.isThrow() || inst.isReturn()) {
                    tree.addInstruction(inst);
                    this.addEdge(block, this.snkBlock);
                    break;
                }
                if (inst.isJsr()) {
                    Assert.isTrue(next != null, inst + " not followed by a block");
                    tree.addInstruction(inst, next);
                    Label label = (Label)inst.operand();
                    Block target = (Block)this.getNode(label);
                    Assert.isTrue(target != null, inst + " target not found");
                    Subroutine nextSub = this.labelSub(label);
                    this.setSubEntry(nextSub, target);
                    this.buildTreeForBlock(target, tree.stack(), nextSub, labelPos, catchBodies);
                    this.addEdge(block, target);
                    if (nextSub.exit() == null) break;
                    this.buildTreeForBlock(next, nextSub.exit().tree().stack(), sub, labelPos, catchBodies);
                    this.addEdge(nextSub.exit(), next);
                    break;
                }
                if (inst.isGoto()) {
                    tree.addInstruction(inst);
                    Label label = (Label)inst.operand();
                    Block target = (Block)this.getNode(label);
                    Assert.isTrue(target != null, inst + " target not found");
                    this.addEdge(block, target);
                    this.buildTreeForBlock(target, tree.stack(), sub, labelPos, catchBodies);
                    break;
                }
                if (inst.isConditionalJump()) {
                    Assert.isTrue(next != null, inst + " not followed by a block");
                    tree.addInstruction(inst, next);
                    Label label = (Label)inst.operand();
                    Block target = (Block)this.getNode(label);
                    Assert.isTrue(target != null, inst + " target not found");
                    this.addEdge(block, target);
                    this.buildTreeForBlock(target, tree.stack(), sub, labelPos, catchBodies);
                    this.addEdge(block, next);
                    this.buildTreeForBlock(next, tree.stack(), sub, labelPos, catchBodies);
                    break;
                }
                if (inst.isSwitch()) {
                    tree.addInstruction(inst);
                    Switch sw = (Switch)inst.operand();
                    Block target = (Block)this.getNode(sw.defaultTarget());
                    this.addEdge(block, target);
                    this.buildTreeForBlock(target, tree.stack(), sub, labelPos, catchBodies);
                    int j = 0;
                    while (j < sw.targets().length) {
                        target = (Block)this.getNode(sw.targets()[j]);
                        this.addEdge(block, target);
                        Integer targetStart = (Integer)labelPos.get(target.label());
                        this.buildTreeForBlock(target, tree.stack(), sub, labelPos, catchBodies);
                        ++j;
                    }
                    break;
                }
                tree.addInstruction(inst);
                continue;
            }
            if (!(ce instanceof Label)) continue;
            Label label = (Label)ce;
            if (label.startsBlock()) {
                tree.addInstruction(new Instruction(167, label));
                Block next = (Block)this.getNode(label);
                Assert.isTrue(next != null, "Block for " + label + " not found");
                this.addEdge(block, next);
                this.buildTreeForBlock(next, tree.stack(), sub, labelPos, catchBodies);
                break;
            }
            tree.addLabel(label);
        }
        this.addHandlerEdges(block, catchBodies, labelPos, sub, new HashSet());
    }

    private ArrayList methodParams(MethodEditor method) {
        ArrayList<LocalExpr> locals = new ArrayList<LocalExpr>();
        int index = 0;
        if (!method.isStatic()) {
            Type type = method.declaringClass().type();
            LocalVariable var = method.paramAt(index++);
            locals.add(new LocalExpr(var.index(), type));
        }
        Type[] paramTypes = method.type().indexedParamTypes();
        int i = 0;
        while (i < paramTypes.length) {
            if (paramTypes[i] != null) {
                LocalVariable var = method.paramAt(index);
                locals.add(new LocalExpr(var.index(), paramTypes[i]));
            }
            ++index;
            ++i;
        }
        return locals;
    }

    public List trace() {
        Assert.isTrue(this.trace.size() == this.size() - 2, "trace contains " + this.trace.size() + " " + this.trace + " blocks, not " + (this.size() - 2) + " " + this.nodes());
        return this.trace;
    }

    public void commit() {
        this.method.clearCode();
        CodeGenerator codegen = new CodeGenerator(this.method);
        this.visit(codegen);
        Label endLabel = this.method.newLabel();
        this.method.addLabel(endLabel);
        Iterator iter = this.catchBlocks.iterator();
        while (iter.hasNext()) {
            Block catchBlock = (Block)iter.next();
            Handler handler = (Handler)this.handlers.get(catchBlock);
            Assert.isTrue(handler != null);
            Type type = handler.catchType();
            if (type.isNull()) {
                type = null;
            }
            Block begin = null;
            Iterator blocks = this.trace().iterator();
            while (blocks.hasNext()) {
                Block block = (Block)blocks.next();
                if (handler.protectedBlocks().contains(block)) {
                    if (begin != null) continue;
                    begin = block;
                    continue;
                }
                if (begin == null) continue;
                TryCatch tc = new TryCatch(begin.label(), block.label(), catchBlock.label(), type);
                this.method.addTryCatch(tc);
                begin = null;
            }
        }
    }

    public Block source() {
        return this.srcBlock;
    }

    public Block init() {
        return this.iniBlock;
    }

    public Block sink() {
        return this.snkBlock;
    }

    public Collection iteratedDomFrontier(Collection blocks) {
        return this.idf(blocks, false);
    }

    public Collection iteratedPdomFrontier(Collection blocks) {
        return this.idf(blocks, true);
    }

    private Collection idf(Collection blocks, boolean reverse) {
        if (this.domEdgeModCount != this.edgeModCount) {
            this.computeDominators();
        }
        HashSet<Block> idf = new HashSet<Block>();
        HashSet<Block> inWorklist = new HashSet<Block>(blocks);
        LinkedList<Block> worklist = new LinkedList<Block>(inWorklist);
        while (!worklist.isEmpty()) {
            Block block = (Block)worklist.removeFirst();
            Collection df = !reverse ? block.domFrontier() : block.pdomFrontier();
            Iterator iter = df.iterator();
            while (iter.hasNext()) {
                Block dfBlock = (Block)iter.next();
                idf.add(dfBlock);
                if (!inWorklist.add(dfBlock)) continue;
                worklist.add(dfBlock);
            }
        }
        return idf;
    }

    public Collection roots() {
        return new AbstractCollection(){

            public int size() {
                return 1;
            }

            public boolean contains(Object obj) {
                return obj == FlowGraph.this.srcBlock;
            }

            public Iterator iterator() {
                return new Iterator(this){
                    Object next;
                    final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                        this.next = 7.access$0(var1_1).srcBlock;
                    }

                    public boolean hasNext() {
                        return this.next != null;
                    }

                    public Object next() {
                        Object n = this.next;
                        this.next = null;
                        return n;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            static /* synthetic */ FlowGraph access$0(7 var0) {
                return var0.FlowGraph.this;
            }
        };
    }

    public Collection reverseRoots() {
        return new AbstractCollection(){

            public int size() {
                return 1;
            }

            public boolean contains(Object obj) {
                return obj == FlowGraph.this.snkBlock;
            }

            public Iterator iterator() {
                return new Iterator(this){
                    Object next;
                    final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = var1_1;
                        this.next = 9.access$0(var1_1).snkBlock;
                    }

                    public boolean hasNext() {
                        return this.next != null;
                    }

                    public Object next() {
                        Object n = this.next;
                        this.next = null;
                        return n;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            static /* synthetic */ FlowGraph access$0(9 var0) {
                return var0.FlowGraph.this;
            }
        };
    }

    public void removeNode(Object key) {
        Block block = (Block)this.getNode(key);
        this.removeBlock(block);
    }

    public Map handlersMap() {
        return this.handlers;
    }

    public Collection handlers() {
        return this.handlers.values();
    }

    public List catchBlocks() {
        return this.catchBlocks;
    }

    private void removeBlock(Block block) {
        this.trace.remove(block);
        this.subroutines.remove(block);
        this.catchBlocks.remove(block);
        this.handlers.remove(block);
        block.setDomParent(null);
        block.setPdomParent(null);
        block.domChildren().clear();
        block.pdomChildren().clear();
        block.domFrontier().clear();
        block.pdomFrontier().clear();
        Iterator<Object> iter = this.handlers.values().iterator();
        while (iter.hasNext()) {
            Handler handler = (Handler)iter.next();
            handler.protectedBlocks().remove(block);
        }
        iter = this.subroutines.values().iterator();
        while (iter.hasNext()) {
            Subroutine sub = (Subroutine)iter.next();
            sub.removePathsContaining(block);
            if (sub.exit() != block) continue;
            sub.setExit(null);
        }
        if (block.tree() != null) {
            iter = block.tree().stmts().iterator();
            while (iter.hasNext()) {
                Stmt s = (Stmt)iter.next();
                if (s instanceof LabelStmt) {
                    Label label = ((LabelStmt)s).label();
                    label.setStartsBlock(false);
                    this.iniBlock.tree().addStmt(new LabelStmt(label));
                }
                s.cleanup();
            }
        }
        super.removeNode(block.label());
    }

    public Collection domChildren(Block block) {
        if (this.domEdgeModCount != this.edgeModCount) {
            this.computeDominators();
        }
        return block.domChildren();
    }

    public Block domParent(Block block) {
        if (this.domEdgeModCount != this.edgeModCount) {
            this.computeDominators();
        }
        return block.domParent();
    }

    public int blockType(Block block) {
        if (this.loopEdgeModCount != this.edgeModCount) {
            this.buildLoopTree();
        }
        return block.blockType();
    }

    public int loopDepth(Block block) {
        if (this.loopEdgeModCount != this.edgeModCount) {
            this.buildLoopTree();
        }
        if (block == this.srcBlock || block.blockType() != 0) {
            LoopNode loop = (LoopNode)this.loopTree.getNode(block);
            Assert.isTrue(loop != null, "no loop for " + block);
            return loop.depth;
        }
        if (block.header() != null) {
            LoopNode loop = (LoopNode)this.loopTree.getNode(block.header());
            Assert.isTrue(loop != null, "no loop for " + block.header());
            return loop.depth;
        }
        throw new RuntimeException();
    }

    public int loopLevel(Block block) {
        if (this.loopEdgeModCount != this.edgeModCount) {
            this.buildLoopTree();
        }
        if (block == this.srcBlock || block.blockType() != 0) {
            LoopNode loop = (LoopNode)this.loopTree.getNode(block);
            Assert.isTrue(loop != null, "no loop for " + block);
            return loop.level;
        }
        if (block.header() != null) {
            LoopNode loop = (LoopNode)this.loopTree.getNode(block.header());
            Assert.isTrue(loop != null, "no loop for " + block.header());
            return loop.level;
        }
        throw new RuntimeException();
    }

    public Block loopHeader(Block block) {
        if (this.loopEdgeModCount != this.edgeModCount) {
            this.buildLoopTree();
        }
        return block.header();
    }

    public List preOrder() {
        return super.preOrder();
    }

    public List postOrder() {
        return super.postOrder();
    }

    public Collection pdomChildren(Block block) {
        if (this.domEdgeModCount != this.edgeModCount) {
            this.computeDominators();
        }
        return block.pdomChildren();
    }

    public Block pdomParent(Block block) {
        if (this.domEdgeModCount != this.edgeModCount) {
            this.computeDominators();
        }
        return block.pdomParent();
    }

    public Collection domFrontier(Block block) {
        if (this.domEdgeModCount != this.edgeModCount) {
            this.computeDominators();
        }
        return block.domFrontier();
    }

    public Collection pdomFrontier(Block block) {
        if (this.domEdgeModCount != this.edgeModCount) {
            this.computeDominators();
        }
        return block.pdomFrontier();
    }

    public String toString() {
        return "CFG for " + this.method;
    }

    class LoopNode
    extends GraphNode {
        Block header;
        int depth;
        int level;
        Set elements;

        public LoopNode(Block header) {
            this.header = header;
            this.depth = 1;
            this.level = 1;
            this.elements = new HashSet();
            this.elements.add(header);
        }

        public String toString() {
            return "level=" + this.level + " depth=" + this.depth + " header=" + this.header + " " + this.elements;
        }
    }
}

