/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.inline;

import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.ClassHierarchy;
import EDU.purdue.cs.bloat.editor.Instruction;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.inline.CallVisitor;
import EDU.purdue.cs.bloat.inline.InlineContext;
import EDU.purdue.cs.bloat.inline.MemberRefComparator;
import EDU.purdue.cs.bloat.reflect.MethodInfo;
import EDU.purdue.cs.bloat.util.Assert;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class CallGraph {
    public static boolean DEBUG = false;
    private static Set preLive;
    public static boolean USEPRELIVE;
    public static boolean USE1_2;
    private Set roots;
    private Map calls;
    private Set liveClasses;
    private Map resolvesTo;
    private Map blocked;
    List worklist;
    Set liveMethods;
    InlineContext context;
    private ClassHierarchy hier;

    static {
        USEPRELIVE = true;
        USE1_2 = true;
    }

    static void db(String s) {
        if (DEBUG) {
            System.out.println(s);
        }
    }

    private static void init() {
        preLive = new HashSet();
        preLive.add("java.lang.Boolean");
        preLive.add("java.lang.Class");
        preLive.add("java.lang.ClassLoader");
        preLive.add("java.lang.Compiler");
        preLive.add("java.lang.Integer");
        preLive.add("java.lang.SecurityManager");
        preLive.add("java.lang.String");
        preLive.add("java.lang.StringBuffer");
        preLive.add("java.lang.System");
        preLive.add("java.lang.StackOverflowError");
        preLive.add("java.lang.Thread");
        preLive.add("java.lang.ThreadGroup");
        preLive.add("java.io.BufferedInputStream");
        preLive.add("java.io.BufferedReader");
        preLive.add("java.io.BufferedOutputStream");
        preLive.add("java.io.BufferedWriter");
        preLive.add("java.io.File");
        preLive.add("java.io.FileDescriptor");
        preLive.add("java.io.InputStreamReader");
        preLive.add("java.io.ObjectStreamClass");
        preLive.add("java.io.OutputStreamWriter");
        preLive.add("java.io.PrintStream");
        preLive.add("java.io.PrintWriter");
        preLive.add("java.net.URL");
        preLive.add("java.security.Provider");
        preLive.add("java.security.Security");
        preLive.add("java.util.Hashtable");
        preLive.add("java.util.ListResourceBundle");
        preLive.add("java.util.Locale");
        preLive.add("java.util.Properties");
        preLive.add("java.util.Stack");
        preLive.add("java.util.Vector");
        preLive.add("java.util.zip.ZipFile");
        if (USE1_2) {
            preLive.add("java.lang.Package");
            preLive.add("java.lang.ref.Finalizer");
            preLive.add("java.lang.ref.ReferenceQueue");
            preLive.add("java.io.FilePermission");
            preLive.add("java.io.UnixFileSystem");
            preLive.add("java.net.URLClassLoader");
            preLive.add("java.security.SecureClassLoader");
            preLive.add("java.security.AccessController");
            preLive.add("java.text.resources.LocaleElements");
            preLive.add("java.text.resources.LocaleElements_en");
            preLive.add("java.util.HashMap");
            preLive.add("java.util.jar.JarFile");
        }
    }

    public static void addPreLive(String name) {
        if (preLive == null) {
            CallGraph.init();
        }
        preLive.add(name);
    }

    public static boolean removePreLive(String name) {
        if (preLive == null) {
            CallGraph.init();
        }
        return preLive.remove(name);
    }

    public CallGraph(InlineContext context, Set roots) {
        Assert.isTrue(roots != null, "A call graph must have roots");
        Assert.isTrue(roots.size() > 0, "A call graph must have roots");
        if (preLive == null) {
            CallGraph.init();
        }
        this.context = context;
        this.hier = context.getHierarchy();
        this.roots = roots;
        this.liveClasses = new HashSet();
        this.resolvesTo = new HashMap();
        this.calls = new HashMap();
        this.blocked = new HashMap();
        this.worklist = new LinkedList(this.roots);
        this.liveMethods = new HashSet();
        CallVisitor visitor = new CallVisitor(this);
        CallGraph.db("Adding pre-live classes");
        this.doPreLive();
        CallGraph.db("Constructing call graph");
        while (!this.worklist.isEmpty()) {
            MemberRef caller = (MemberRef)this.worklist.remove(0);
            if (this.liveMethods.contains(caller)) continue;
            MethodEditor callerMethod = null;
            try {
                callerMethod = context.editMethod(caller);
            }
            catch (NoSuchMethodException ex1) {
                System.err.println("** Could not find method: " + caller);
                ex1.printStackTrace(System.err);
                System.exit(1);
            }
            if (callerMethod.isAbstract()) continue;
            this.liveMethods.add(caller);
            if (callerMethod.isNative()) continue;
            CallGraph.db("\n  Examining method " + caller);
            HashSet callees = new HashSet();
            this.calls.put(caller, callees);
            if (callerMethod.isStatic() || callerMethod.isConstructor()) {
                this.addClinit(callerMethod.declaringClass().type());
            }
            Iterator code = callerMethod.code().iterator();
            visitor.setCaller(callerMethod);
            while (code.hasNext()) {
                Object o = code.next();
                if (!(o instanceof Instruction)) continue;
                Instruction inst = (Instruction)o;
                inst.visit(visitor);
            }
        }
        this.blocked = null;
    }

    private void doPreLive() {
        if (!USEPRELIVE) {
            return;
        }
        CallGraph.db("Making constructors of pre-live classes live");
        Iterator iter = preLive.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            CallGraph.db("  " + name + " is pre-live");
            name = name.replace('.', '/');
            ClassEditor ce = null;
            try {
                ce = this.context.editClass(name);
            }
            catch (ClassNotFoundException ex1) {
                System.err.println("** Cannot find pre-live class: " + name);
                ex1.printStackTrace(System.err);
                System.exit(1);
            }
            this.liveClasses.add(ce.type());
            this.addClinit(ce.type());
            MethodInfo[] methods = ce.methods();
            int i = 0;
            while (i < methods.length) {
                MethodEditor method = this.context.editMethod(methods[i]);
                if (method.name().equals("<init>")) {
                    CallGraph.db("  " + method);
                    this.worklist.add(method.memberRef());
                }
                ++i;
            }
        }
    }

    void addClinit(Type type) {
        try {
            ClassEditor ce = this.context.editClass(type);
            MethodInfo[] methods = ce.methods();
            int i = 0;
            while (i < methods.length) {
                MethodEditor clinit = this.context.editMethod(methods[i]);
                if (clinit.name().equals("<clinit>")) {
                    this.worklist.add(clinit.memberRef());
                    this.context.release(clinit.methodInfo());
                    break;
                }
                this.context.release(clinit.methodInfo());
                ++i;
            }
            this.context.release(ce.classInfo());
        }
        catch (ClassNotFoundException ex1) {
            System.err.println("** Could not find class for " + type);
            ex1.printStackTrace(System.err);
            System.exit(1);
        }
    }

    void doVirtual(MethodEditor caller, MemberRef callee) {
        Iterator resolvesToWith = this.hier.resolvesToWith(callee).iterator();
        while (resolvesToWith.hasNext()) {
            ClassHierarchy.ResolvesToWith rtw = (ClassHierarchy.ResolvesToWith)resolvesToWith.next();
            CallGraph.db("      resolves to " + rtw.method);
            this.addCall(caller, rtw.method);
            Iterator rTypes = rtw.rTypes.iterator();
            boolean isLive = false;
            while (rTypes.hasNext()) {
                Type rType = (Type)rTypes.next();
                if (!this.liveClasses.contains(rType)) continue;
                isLive = true;
                CallGraph.db("      Method " + rtw.method + " is live");
                this.worklist.add(rtw.method);
                break;
            }
            if (isLive) continue;
            rTypes = rtw.rTypes.iterator();
            StringBuffer sb = new StringBuffer();
            while (rTypes.hasNext()) {
                Type rType = (Type)rTypes.next();
                HashSet<MemberRef> blockedMethods = (HashSet<MemberRef>)this.blocked.get(rType);
                if (blockedMethods == null) {
                    blockedMethods = new HashSet<MemberRef>();
                    this.blocked.put(rType, blockedMethods);
                }
                blockedMethods.add(rtw.method);
                sb.append(rType.toString());
                if (!rTypes.hasNext()) continue;
                sb.append(',');
            }
            CallGraph.db("      Blocked " + rtw.method + " on " + sb);
        }
    }

    void addCall(MethodEditor callerMethod, MemberRef callee) {
        MemberRef caller = callerMethod.memberRef();
        HashSet<MemberRef> callees = (HashSet<MemberRef>)this.calls.get(caller);
        if (callees == null) {
            callees = new HashSet<MemberRef>();
            this.calls.put(caller, callees);
        }
        callees.add(callee);
    }

    void makeLive(Type type) {
        if (this.liveClasses.contains(type)) {
            return;
        }
        CallGraph.db("    Making " + type + " live");
        this.liveClasses.add(type);
        Set blockedMethods = (Set)this.blocked.remove(type);
        if (blockedMethods != null) {
            Iterator iter = blockedMethods.iterator();
            while (iter.hasNext()) {
                MemberRef method = (MemberRef)iter.next();
                CallGraph.db("      Unblocking " + method);
                this.worklist.add(method);
            }
        }
    }

    public Set resolvesTo(MemberRef method) {
        TreeSet<MemberRef> resolvesTo = (TreeSet<MemberRef>)this.resolvesTo.get(method);
        if (resolvesTo == null) {
            resolvesTo = new TreeSet<MemberRef>(new MemberRefComparator(this.context));
            this.resolvesTo.put(method, resolvesTo);
            Set liveMethods = this.liveMethods();
            Iterator rtws = this.hier.resolvesToWith(method).iterator();
            while (rtws.hasNext()) {
                ClassHierarchy.ResolvesToWith rtw = (ClassHierarchy.ResolvesToWith)rtws.next();
                if (!liveMethods.contains(rtw.method)) continue;
                resolvesTo.add(rtw.method);
            }
        }
        return (Set)resolvesTo.clone();
    }

    public Set resolvesTo(MemberRef method, Set rTypes) {
        if (rTypes.isEmpty()) {
            return this.resolvesTo(method);
        }
        TreeSet<MemberRef> resolvesTo = new TreeSet<MemberRef>(new MemberRefComparator(this.context));
        Set liveMethods = this.liveMethods();
        Iterator rtws = this.hier.resolvesToWith(method).iterator();
        while (rtws.hasNext()) {
            ClassHierarchy.ResolvesToWith rtw = (ClassHierarchy.ResolvesToWith)rtws.next();
            if (!liveMethods.contains(rtw.method)) continue;
            HashSet clone = (HashSet)rtw.rTypes.clone();
            clone.retainAll(rTypes);
            if (clone.isEmpty()) continue;
            resolvesTo.add(rtw.method);
        }
        return (Set)resolvesTo.clone();
    }

    public Set liveMethods() {
        return this.liveMethods;
    }

    public Set roots() {
        return this.roots;
    }

    public Set liveClasses() {
        return this.liveClasses;
    }

    public void print(PrintWriter out, boolean printLeaves) {
        Iterator callers = this.calls.keySet().iterator();
        while (callers.hasNext()) {
            MemberRef caller = (MemberRef)callers.next();
            Iterator callees = ((Set)this.calls.get(caller)).iterator();
            if (!printLeaves && !callees.hasNext()) continue;
            out.print(caller.declaringClass() + "." + caller.name() + caller.type());
            if (this.roots.contains(caller)) {
                out.print(" (root)");
            }
            out.println("");
            while (callees.hasNext()) {
                MemberRef callee = (MemberRef)callees.next();
                if (!this.calls.containsKey(callee)) continue;
                out.println("  " + callee.declaringClass() + "." + callee.name() + callee.type());
            }
            out.println("");
        }
    }

    public void printSummary(PrintWriter out) {
        out.println("Instantiated classes:");
        Iterator instantiated = this.liveClasses.iterator();
        while (instantiated.hasNext()) {
            Type type = (Type)instantiated.next();
            out.println("  " + type.toString());
        }
        out.println("\nBlocked methods:");
        if (this.blocked != null) {
            Iterator types = this.blocked.keySet().iterator();
            while (types.hasNext()) {
                Type type = (Type)types.next();
                out.println("  " + type);
                Set set = (Set)this.blocked.get(type);
                if (set == null) continue;
                Iterator methods = set.iterator();
                while (methods.hasNext()) {
                    MemberRef method = (MemberRef)methods.next();
                    out.println("    " + method);
                }
            }
        }
        out.println("\nCall graph:");
        this.print(out, false);
    }
}

