/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.trans;

import EDU.purdue.cs.bloat.editor.EditorContext;
import EDU.purdue.cs.bloat.editor.FieldEditor;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.tree.ArithExpr;
import EDU.purdue.cs.bloat.tree.ArrayLengthExpr;
import EDU.purdue.cs.bloat.tree.ArrayRefExpr;
import EDU.purdue.cs.bloat.tree.CallMethodExpr;
import EDU.purdue.cs.bloat.tree.CallStaticExpr;
import EDU.purdue.cs.bloat.tree.CastExpr;
import EDU.purdue.cs.bloat.tree.CatchExpr;
import EDU.purdue.cs.bloat.tree.FieldExpr;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.tree.MonitorStmt;
import EDU.purdue.cs.bloat.tree.NewArrayExpr;
import EDU.purdue.cs.bloat.tree.NewExpr;
import EDU.purdue.cs.bloat.tree.NewMultiArrayExpr;
import EDU.purdue.cs.bloat.tree.RCExpr;
import EDU.purdue.cs.bloat.tree.StackExpr;
import EDU.purdue.cs.bloat.tree.StackManipStmt;
import EDU.purdue.cs.bloat.tree.StaticFieldExpr;
import EDU.purdue.cs.bloat.tree.StoreExpr;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.tree.UCExpr;
import EDU.purdue.cs.bloat.tree.ZeroCheckExpr;

public class SideEffectChecker
extends TreeVisitor {
    private int sideEffects = 0;
    public static final int STACK = 1;
    public static final int THROW = 2;
    public static final int CALL = 4;
    public static final int SYNC = 8;
    public static final int ALLOC = 16;
    public static final int RC = 32;
    public static final int UC = 64;
    public static final int STORE = 128;
    public static final int ALIAS = 256;
    public static final int VOLATILE = 512;
    private EditorContext context;

    public SideEffectChecker(EditorContext context) {
        this.context = context;
    }

    public int sideEffects() {
        return this.sideEffects;
    }

    public boolean hasSideEffects() {
        return this.sideEffects != 0;
    }

    public void reset() {
        this.sideEffects = 0;
    }

    public void visitStoreExpr(StoreExpr expr) {
        this.sideEffects |= 0x80;
        expr.visitChildren(this);
    }

    public void visitLocalExpr(LocalExpr expr) {
        if (expr.isDef()) {
            this.sideEffects |= 0x80;
        }
        expr.visitChildren(this);
    }

    public void visitZeroCheckExpr(ZeroCheckExpr expr) {
        this.sideEffects |= 2;
        expr.visitChildren(this);
    }

    public void visitRCExpr(RCExpr expr) {
        this.sideEffects |= 0x20;
        expr.visitChildren(this);
    }

    public void visitUCExpr(UCExpr expr) {
        this.sideEffects |= 0x40;
        expr.visitChildren(this);
    }

    public void visitNewMultiArrayExpr(NewMultiArrayExpr expr) {
        this.sideEffects |= 0x12;
        expr.visitChildren(this);
    }

    public void visitNewArrayExpr(NewArrayExpr expr) {
        this.sideEffects |= 0x12;
        expr.visitChildren(this);
    }

    public void visitCatchExpr(CatchExpr expr) {
        this.sideEffects |= 1;
        expr.visitChildren(this);
    }

    public void visitNewExpr(NewExpr expr) {
        this.sideEffects |= 0x10;
        expr.visitChildren(this);
    }

    public void visitStackExpr(StackExpr expr) {
        this.sideEffects |= 1;
        if (expr.isDef()) {
            this.sideEffects |= 0x80;
        }
        expr.visitChildren(this);
    }

    public void visitCastExpr(CastExpr expr) {
        if (expr.castType().isReference()) {
            this.sideEffects |= 2;
        }
        expr.visitChildren(this);
    }

    public void visitArithExpr(ArithExpr expr) {
        expr.visitChildren(this);
    }

    public void visitArrayLengthExpr(ArrayLengthExpr expr) {
        this.sideEffects |= 2;
        expr.visitChildren(this);
    }

    public void visitArrayRefExpr(ArrayRefExpr expr) {
        this.sideEffects |= 2;
        if (expr.isDef()) {
            this.sideEffects |= 0x80;
        }
        this.sideEffects |= 0x100;
        expr.visitChildren(this);
    }

    public void visitFieldExpr(FieldExpr expr) {
        if (expr.isDef()) {
            this.sideEffects |= 0x80;
        }
        MemberRef field = expr.field();
        try {
            FieldEditor e = this.context.editField(field);
            if (!e.isFinal()) {
                this.sideEffects |= 0x100;
            }
            if (e.isVolatile()) {
                this.sideEffects |= 0x200;
            }
            this.context.release(e.fieldInfo());
        }
        catch (NoSuchFieldException e) {
            this.sideEffects |= 0x100;
            this.sideEffects |= 0x200;
        }
        expr.visitChildren(this);
    }

    public void visitStaticFieldExpr(StaticFieldExpr expr) {
        if (expr.isDef()) {
            this.sideEffects |= 0x80;
        }
        MemberRef field = expr.field();
        try {
            FieldEditor e = this.context.editField(field);
            if (e.isVolatile()) {
                this.sideEffects |= 0x200;
            }
            this.context.release(e.fieldInfo());
        }
        catch (NoSuchFieldException e) {
            this.sideEffects |= 0x200;
        }
        expr.visitChildren(this);
    }

    public void visitCallStaticExpr(CallStaticExpr expr) {
        this.sideEffects |= 6;
        expr.visitChildren(this);
    }

    public void visitCallMethodExpr(CallMethodExpr expr) {
        this.sideEffects |= 6;
        expr.visitChildren(this);
    }

    public void visitMonitorStmt(MonitorStmt stmt) {
        this.sideEffects |= 0xA;
        stmt.visitChildren(this);
    }

    public void visitStackManipStmt(StackManipStmt stmt) {
        this.sideEffects |= 1;
        stmt.visitChildren(this);
    }
}

