/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.revapi.configuration.ConfigurationValidator;

final class SchemaDrivenJSONToXmlConverter {
    private static final ConfigurationValidator VALIDATOR = new ConfigurationValidator();

    private SchemaDrivenJSONToXmlConverter() {
    }

    static PlexusConfiguration convertToXml(Map<String, JsonNode> extensionSchemas, JsonNode jsonConfig) throws IOException {
        if (jsonConfig.isArray()) {
            return SchemaDrivenJSONToXmlConverter.convertNewStyleConfigToXml(extensionSchemas, jsonConfig);
        }
        return SchemaDrivenJSONToXmlConverter.convertOldStyleConfigToXml(extensionSchemas, jsonConfig);
    }

    static PlexusConfiguration convert(JsonNode configuration, JsonNode jsonSchema, String extensionId, String id) {
        ConversionContext ctx = new ConversionContext();
        ctx.currentSchema = jsonSchema;
        ctx.rootSchema = jsonSchema;
        ctx.pushTag(extensionId);
        ctx.id = id;
        return SchemaDrivenJSONToXmlConverter.convert(configuration, ctx);
    }

    private static PlexusConfiguration convert(JsonNode configuration, ConversionContext ctx) {
        String valueType;
        JsonNode type = ctx.currentSchema.path("type");
        if (type.isMissingNode()) {
            if (!ctx.currentSchema.path("enum").isMissingNode()) {
                boolean containsUnsupportedTypes = StreamSupport.stream(ctx.currentSchema.path("enum").spliterator(), false).anyMatch(JsonNode::isContainerNode);
                if (containsUnsupportedTypes) {
                    throw new IllegalArgumentException("Unsupported type of enum value defined in schema.");
                }
                return SchemaDrivenJSONToXmlConverter.convertSimple(ctx.tagName, ctx.id, configuration.asText());
            }
            if (!ctx.currentSchema.path("$ref").isMissingNode()) {
                ctx.currentSchema = SchemaDrivenJSONToXmlConverter.findRef(ctx.rootSchema, ctx.currentSchema.path("$ref").asText());
                return SchemaDrivenJSONToXmlConverter.convert(configuration, ctx);
            }
            JsonNode matchingSchema = null;
            if (ctx.currentSchema.hasNonNull("oneOf")) {
                for (JsonNode s : ctx.currentSchema.get("oneOf")) {
                    if (!VALIDATOR.validate(configuration, s).isSuccessful()) continue;
                    if (matchingSchema != null) {
                        matchingSchema = null;
                        break;
                    }
                    matchingSchema = s;
                }
            } else if (ctx.currentSchema.hasNonNull("anyOf")) {
                for (JsonNode s : ctx.currentSchema.get("anyOf")) {
                    if (!VALIDATOR.validate(configuration, s).isSuccessful()) continue;
                    matchingSchema = s;
                    break;
                }
            } else if (ctx.currentSchema.hasNonNull("allOf")) {
                for (JsonNode s : ctx.currentSchema.get("allOf")) {
                    if (VALIDATOR.validate(configuration, s).isSuccessful()) {
                        matchingSchema = s;
                        continue;
                    }
                    matchingSchema = null;
                    break;
                }
            }
            if (matchingSchema != null) {
                ctx.currentSchema = matchingSchema;
                return SchemaDrivenJSONToXmlConverter.convert(configuration, ctx);
            }
            throw new IllegalArgumentException("Could not convert the configuration.");
        }
        if (!type.isTextual()) {
            throw new IllegalArgumentException("JSON schema allows for multiple possible types. This is not supported by the XML-to-JSON conversion yet.");
        }
        switch (valueType = type.asText()) {
            case "boolean": {
                return SchemaDrivenJSONToXmlConverter.convertSimple(ctx.tagName, ctx.id, configuration.asText());
            }
            case "integer": {
                return SchemaDrivenJSONToXmlConverter.convertSimple(ctx.tagName, ctx.id, configuration.asText());
            }
            case "number": {
                return SchemaDrivenJSONToXmlConverter.convertSimple(ctx.tagName, ctx.id, configuration.asText());
            }
            case "string": {
                return SchemaDrivenJSONToXmlConverter.convertSimple(ctx.tagName, ctx.id, configuration.asText());
            }
            case "array": {
                return SchemaDrivenJSONToXmlConverter.convertArray(configuration, ctx);
            }
            case "object": {
                return SchemaDrivenJSONToXmlConverter.convertObject(configuration, ctx);
            }
        }
        throw new IllegalArgumentException("Unsupported json value type: " + valueType);
    }

    private static JsonNode findRef(JsonNode rootSchema, String ref) {
        return rootSchema.at(ref.startsWith("#") ? ref.substring(1) : ref);
    }

    private static PlexusConfiguration convertObject(JsonNode configuration, ConversionContext ctx) {
        XmlPlexusConfiguration object = new XmlPlexusConfiguration(ctx.tagName);
        if (ctx.id != null) {
            object.setAttribute("id", ctx.id);
        }
        JsonNode propertySchemas = ctx.currentSchema.path("properties");
        JsonNode additionalPropSchemas = ctx.currentSchema.path("additionalProperties");
        configuration.fieldNames().forEachRemaining(key -> {
            JsonNode childConfig = configuration.path(key);
            JsonNode childSchema = propertySchemas.path(key);
            if (childSchema.isMissingNode()) {
                if (additionalPropSchemas.isBoolean()) {
                    throw new IllegalArgumentException("Cannot determine the format for the '" + key + "' JSON value during the JSON-to-XML conversion.");
                }
                childSchema = additionalPropSchemas;
            }
            ctx.currentSchema = childSchema;
            ctx.pushTag((String)key);
            ctx.id = null;
            if (childSchema.isMissingNode()) {
                if (ctx.ignorablePaths.contains(ctx.getCurrentPathString())) {
                    ctx.currentPath.pop();
                    return;
                }
                throw new IllegalArgumentException("Could not determine the format for the '" + key + "' JSON value during the JSON-to-XML conversion.");
            }
            PlexusConfiguration xmlChild = SchemaDrivenJSONToXmlConverter.convert(childConfig, ctx);
            ctx.currentPath.pop();
            object.addChild(xmlChild);
        });
        return object;
    }

    private static PlexusConfiguration convertArray(JsonNode configuration, ConversionContext ctx) {
        JsonNode itemsSchema = ctx.currentSchema.get("items");
        if (itemsSchema.isMissingNode()) {
            throw new IllegalArgumentException("No schema found for items of a list. Cannot continue with XML-to-JSON conversion.");
        }
        XmlPlexusConfiguration list = new XmlPlexusConfiguration(ctx.tagName);
        if (ctx.id != null) {
            list.setAttribute("id", ctx.id);
        }
        for (JsonNode childConfig : configuration) {
            ctx.tagName = "item";
            ctx.currentSchema = itemsSchema;
            ctx.id = null;
            ctx.currentPath.push("[]");
            PlexusConfiguration child = SchemaDrivenJSONToXmlConverter.convert(childConfig, ctx);
            ctx.currentPath.pop();
            list.addChild(child);
        }
        return list;
    }

    private static PlexusConfiguration convertSimple(String tagName, String id, String value) {
        XmlPlexusConfiguration ret = new XmlPlexusConfiguration(tagName);
        if (id != null) {
            ret.setAttribute("id", id);
        }
        ret.setValue(value);
        return ret;
    }

    private static PlexusConfiguration convertOldStyleConfigToXml(Map<String, JsonNode> extensionSchemas, JsonNode jsonConfig) {
        XmlPlexusConfiguration xmlConfig = new XmlPlexusConfiguration("analysisConfiguration");
        block0: for (Map.Entry<String, JsonNode> e : extensionSchemas.entrySet()) {
            String extensionId = e.getKey();
            JsonNode schema = e.getValue();
            String[] extensionPath = extensionId.split("\\.");
            JsonNode config = jsonConfig;
            for (String segment : extensionPath) {
                if (!config.has(segment)) continue block0;
                config = config.get(segment);
            }
            ConversionContext ctx = new ConversionContext();
            ctx.rootSchema = schema;
            ctx.currentSchema = schema;
            ctx.pushTag(extensionId);
            ctx.id = null;
            ctx.ignorablePaths = extensionSchemas.keySet().stream().filter(id -> !extensionId.equals(id) && id.startsWith(extensionId)).collect(Collectors.toList());
            PlexusConfiguration extXml = SchemaDrivenJSONToXmlConverter.convert(config, ctx);
            ctx.currentPath.pop();
            xmlConfig.addChild(extXml);
        }
        return xmlConfig;
    }

    private static PlexusConfiguration convertNewStyleConfigToXml(Map<String, JsonNode> extensionSchemas, JsonNode jsonConfig) throws IOException {
        XmlPlexusConfiguration xmlConfig = new XmlPlexusConfiguration("analysisConfiguration");
        for (JsonNode extConfig : jsonConfig) {
            String extensionId = extConfig.path("extension").asText();
            JsonNode configuration = extConfig.path("configuration");
            String id = extConfig.hasNonNull("id") ? extConfig.get("id").asText() : null;
            JsonNode schema = extensionSchemas.get(extensionId);
            if (schema == null) continue;
            ConversionContext ctx = new ConversionContext();
            ctx.rootSchema = schema;
            ctx.currentSchema = schema;
            ctx.pushTag(extensionId);
            ctx.id = id;
            PlexusConfiguration extXml = SchemaDrivenJSONToXmlConverter.convert(configuration, ctx);
            ctx.currentPath.pop();
            xmlConfig.addChild(extXml);
        }
        return xmlConfig;
    }

    private static final class ConversionContext {
        String id;
        String tagName;
        JsonNode currentSchema;
        JsonNode rootSchema;
        Collection<String> ignorablePaths;
        Deque<String> currentPath = new ArrayDeque<String>(4);

        private ConversionContext() {
        }

        void pushTag(String tag) {
            this.tagName = tag;
            this.currentPath.push(tag);
        }

        String getCurrentPathString() {
            if (this.currentPath.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            Iterator<String> it = this.currentPath.descendingIterator();
            if (it.hasNext()) {
                sb.append(it.next());
            }
            while (it.hasNext()) {
                sb.append('.').append(it.next());
            }
            return sb.toString();
        }
    }
}

