/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.revapi.AnalysisResult;
import org.revapi.Reporter;
import org.revapi.maven.Analyzer;
import org.revapi.maven.AnalyzerBuilder;
import org.revapi.maven.FailSeverity;

abstract class AbstractRevapiMojo
extends AbstractMojo {
    @Parameter(property="", defaultValue="")
    protected PlexusConfiguration analysisConfiguration;
    @Parameter(property="revapi.failOnMissingConfigurationFiles", defaultValue="true")
    protected boolean failOnMissingConfigurationFiles;
    @Parameter(property="revapi.analysisConfigurationFiles", defaultValue="")
    protected Object[] analysisConfigurationFiles;
    @Parameter(property="revapi.oldArtifacts", defaultValue="")
    protected String[] oldArtifacts;
    @Parameter(property="revapi.oldVersion", defaultValue="RELEASE")
    protected String oldVersion;
    @Parameter(property="revapi.newArtifacts", defaultValue="")
    protected String[] newArtifacts;
    @Parameter(property="revapi.newVersion", defaultValue="${project.version}")
    protected String newVersion;
    @Parameter(property="revapi.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="revapi.failSeverity", defaultValue="potentiallyBreaking")
    protected FailSeverity failSeverity;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected RepositorySystemSession repositorySystemSession;
    @Parameter(property="revapi.alwaysCheckForReleaseVersion", defaultValue="true")
    protected boolean alwaysCheckForReleaseVersion;
    @Parameter(property="revapi.failBuildOnProblemsFound", defaultValue="true")
    protected boolean failBuildOnProblemsFound;
    @Parameter(property="revapi.failOnUnresolvedArtifacts", defaultValue="false")
    protected boolean failOnUnresolvedArtifacts;
    @Parameter(property="revapi.failOnUnresolvedDependencies", defaultValue="false")
    protected boolean failOnUnresolvedDependencies;
    @Parameter(property="revapi.checkDependencies", defaultValue="true")
    protected boolean checkDependencies;
    @Parameter(property="revapi.resolveProvidedDependencies", defaultValue="true")
    protected boolean resolveProvidedDependencies;
    @Parameter(property="revapi.versionFormat", defaultValue="")
    protected String versionFormat;
    @Parameter(property="revapi.disallowedExtensions", defaultValue="")
    protected String disallowedExtensions;

    AbstractRevapiMojo() {
    }

    protected AnalysisResult analyze(Class<? extends Reporter> reporter, Object ... contextDataKeyValues) throws MojoExecutionException, MojoFailureException {
        Analyzer analyzer = this.prepareAnalyzer(this.project, reporter, this.toContextData(contextDataKeyValues));
        if (analyzer != null) {
            return analyzer.analyze();
        }
        return AnalysisResult.fakeSuccess();
    }

    protected Analyzer prepareAnalyzer(MavenProject project, Class<? extends Reporter> reporter, Map<String, Object> contextData) {
        AnalyzerBuilder.Result res = this.buildAnalyzer(project, reporter, contextData);
        if (res.skip) {
            this.skip = true;
        }
        this.oldArtifacts = res.oldArtifacts;
        this.newArtifacts = res.newArtifacts;
        return res.isOnClasspath ? res.analyzer : null;
    }

    AnalyzerBuilder.Result buildAnalyzer(MavenProject project, Class<? extends Reporter> reporter, Map<String, Object> contextData) {
        return AnalyzerBuilder.forGavs(this.oldArtifacts, this.newArtifacts).withAlwaysCheckForReleasedVersion(this.alwaysCheckForReleaseVersion).withAnalysisConfiguration(this.analysisConfiguration).withAnalysisConfigurationFiles(this.analysisConfigurationFiles).withCheckDependencies(this.checkDependencies).withResolveProvidedDependencies(this.resolveProvidedDependencies).withDisallowedExtensions(this.disallowedExtensions).withFailOnMissingConfigurationFiles(this.failOnMissingConfigurationFiles).withFailOnUnresolvedArtifacts(this.failOnUnresolvedArtifacts).withFailOnUnresolvedDependencies(this.failOnUnresolvedDependencies).withLocale(Locale.getDefault()).withLog(this.getLog()).withNewVersion(this.newVersion).withOldVersion(this.oldVersion).withProject(project).withReporter(reporter).withRepositorySystem(this.repositorySystem).withRepositorySystemSession(this.repositorySystemSession).withSkip(this.skip).withVersionFormat(this.versionFormat).withContextData(contextData).build();
    }

    protected boolean initializeComparisonArtifacts() {
        if (this.newArtifacts != null && this.newArtifacts.length == 1 && "BUILD".equals(this.newArtifacts[0])) {
            this.getLog().warn((CharSequence)"\"BUILD\" coordinates are deprecated. Just leave \"newArtifacts\" undefined and specify \"${project.version}\" as the value for \"newVersion\" (which is the default, so you don't actually have to do that either).");
            this.oldArtifacts = null;
        }
        if (this.oldArtifacts == null || this.oldArtifacts.length == 0) {
            this.oldArtifacts = new String[]{Analyzer.getProjectArtifactCoordinates(this.project, this.oldVersion)};
            if (!this.project.getArtifact().getArtifactHandler().isAddedToClasspath()) {
                return false;
            }
        }
        if (this.newArtifacts == null || this.newArtifacts.length == 0) {
            this.newArtifacts = new String[]{Analyzer.getProjectArtifactCoordinates(this.project, this.newVersion)};
            if (!this.project.getArtifact().getArtifactHandler().isAddedToClasspath()) {
                return false;
            }
        }
        return true;
    }

    private Map<String, Object> toContextData(Object ... contextDataKeyValues) {
        if (contextDataKeyValues.length % 2 != 0) {
            throw new IllegalArgumentException("Key-value pairs not balanced.");
        }
        HashMap<String, Object> ret = new HashMap<String, Object>(contextDataKeyValues.length / 2);
        boolean isKey = true;
        String key = null;
        for (Object kv : contextDataKeyValues) {
            if (isKey) {
                if (!(kv instanceof String)) {
                    throw new IllegalArgumentException("Found non-string key.");
                }
                key = (String)kv;
                isKey = false;
                continue;
            }
            ret.put(key, kv);
            isKey = true;
        }
        return ret;
    }
}

