/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.revapi.ApiAnalyzer;
import org.revapi.DifferenceTransform;
import org.revapi.ElementFilter;
import org.revapi.Reporter;
import org.revapi.Revapi;
import org.revapi.ServiceTypeLoader;
import org.revapi.maven.Analyzer;

class AnalyzerBuilder {
    private Log log;
    private Locale locale;
    private MavenProject project;
    private boolean skip;
    private String[] oldGavs;
    private String[] newGavs;
    private final Artifact[] oldArtifacts;
    private final Artifact[] newArtifacts;
    private String oldVersion;
    private String newVersion;
    private String disallowedExtensions;
    private Class<? extends Reporter> reporterType;
    private PlexusConfiguration analysisConfiguration;
    private Object[] analysisConfigurationFiles;
    private RepositorySystem repositorySystem;
    private RepositorySystemSession repositorySystemSession;
    private boolean failOnMissingConfigurationFiles;
    private boolean failOnUnresolvedArtifacts;
    private boolean failOnUnresolvedDependencies;
    private boolean alwaysCheckForReleaseVersion;
    private boolean checkDependencies;
    private boolean resolveProvidedDependencies;
    private String versionFormat;
    private Revapi revapi;
    private Map<String, Object> contextData = new HashMap<String, Object>(2);

    static AnalyzerBuilder forGavs(String[] oldGavs, String[] newGavs) {
        return new AnalyzerBuilder(oldGavs, newGavs, null, null);
    }

    static AnalyzerBuilder forArtifacts(Artifact[] oldArtifacts2, Artifact[] newArtifacts2) {
        return new AnalyzerBuilder(null, null, oldArtifacts2, newArtifacts2);
    }

    private AnalyzerBuilder(String[] oldGavs, String[] newGavs, Artifact[] oldArtifacts2, Artifact[] newArtifacts2) {
        this.oldGavs = oldGavs;
        this.newGavs = newGavs;
        this.oldArtifacts = oldArtifacts2;
        this.newArtifacts = newArtifacts2;
    }

    AnalyzerBuilder withProject(MavenProject project) {
        this.project = project;
        return this;
    }

    AnalyzerBuilder withSkip(boolean skip2) {
        this.skip = skip2;
        return this;
    }

    AnalyzerBuilder withOldVersion(String oldVersion2) {
        this.oldVersion = oldVersion2;
        return this;
    }

    AnalyzerBuilder withNewVersion(String newVersion2) {
        this.newVersion = newVersion2;
        return this;
    }

    AnalyzerBuilder withDisallowedExtensions(String disallowedExtensions2) {
        this.disallowedExtensions = disallowedExtensions2;
        return this;
    }

    AnalyzerBuilder withReporter(Class<? extends Reporter> reporter) {
        this.reporterType = reporter;
        return this;
    }

    AnalyzerBuilder withLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    AnalyzerBuilder withAnalysisConfiguration(PlexusConfiguration analysisConfiguration2) {
        this.analysisConfiguration = analysisConfiguration2;
        return this;
    }

    AnalyzerBuilder withAnalysisConfigurationFiles(Object[] analysisConfigurationFiles2) {
        this.analysisConfigurationFiles = analysisConfigurationFiles2;
        return this;
    }

    AnalyzerBuilder withRepositorySystem(RepositorySystem repositorySystem) {
        this.repositorySystem = repositorySystem;
        return this;
    }

    AnalyzerBuilder withRepositorySystemSession(RepositorySystemSession repositorySystemSession) {
        this.repositorySystemSession = repositorySystemSession;
        return this;
    }

    AnalyzerBuilder withFailOnMissingConfigurationFiles(boolean failOnMissingConfigurationFiles2) {
        this.failOnMissingConfigurationFiles = failOnMissingConfigurationFiles2;
        return this;
    }

    AnalyzerBuilder withFailOnUnresolvedDependencies(boolean failOnUnresolvedDependencies2) {
        this.failOnUnresolvedDependencies = failOnUnresolvedDependencies2;
        return this;
    }

    AnalyzerBuilder withFailOnUnresolvedArtifacts(boolean failOnUnresolvedArtifacts2) {
        this.failOnUnresolvedArtifacts = failOnUnresolvedArtifacts2;
        return this;
    }

    AnalyzerBuilder withAlwaysCheckForReleasedVersion(boolean alwaysCheckForReleaseVersion2) {
        this.alwaysCheckForReleaseVersion = alwaysCheckForReleaseVersion2;
        return this;
    }

    AnalyzerBuilder withCheckDependencies(boolean checkDependencies2) {
        this.checkDependencies = checkDependencies2;
        return this;
    }

    AnalyzerBuilder withResolveProvidedDependencies(boolean resolveProvidedDependencies2) {
        this.resolveProvidedDependencies = resolveProvidedDependencies2;
        return this;
    }

    AnalyzerBuilder withVersionFormat(String versionFormat2) {
        this.versionFormat = versionFormat2;
        return this;
    }

    AnalyzerBuilder withLog(Log log) {
        this.log = log;
        return this;
    }

    AnalyzerBuilder withRevapiInstance(Revapi revapi) {
        this.revapi = revapi;
        return this;
    }

    AnalyzerBuilder withContextData(Map<String, Object> contextData) {
        if (contextData != null) {
            this.contextData.putAll(contextData);
        }
        return this;
    }

    public Result build() {
        Result res = new Result();
        res.isOnClasspath = this.initializeComparisonArtifacts();
        res.newArtifacts = this.newGavs;
        res.oldArtifacts = this.oldGavs;
        res.skip = this.skip;
        res.analyzer = this.prepareAnalyzer();
        return res;
    }

    private Analyzer prepareAnalyzer() {
        if (this.skip) {
            return null;
        }
        List<String> disallowedExtensions2 = this.disallowedExtensions == null ? Collections.emptyList() : Arrays.asList(this.disallowedExtensions.split("\\s*,\\s*"));
        Supplier<Revapi.Builder> ctor = AnalyzerBuilder.getDisallowedExtensionsAwareRevapiConstructor(disallowedExtensions2);
        return new Analyzer(this.analysisConfiguration, this.analysisConfigurationFiles, this.oldArtifacts, this.newArtifacts, this.oldGavs, this.newGavs, this.project, this.repositorySystem, this.repositorySystemSession, this.reporterType, this.contextData, this.locale, this.log, this.failOnMissingConfigurationFiles, this.failOnUnresolvedArtifacts, this.failOnUnresolvedDependencies, this.alwaysCheckForReleaseVersion, this.checkDependencies, this.resolveProvidedDependencies, this.versionFormat, ctor, this.revapi);
    }

    private boolean initializeComparisonArtifacts() {
        if (this.oldArtifacts == null) {
            return this.initializeComparisonGavs();
        }
        String coords = Analyzer.getProjectArtifactCoordinates(this.project, null);
        boolean projectInOlds = Stream.of(this.oldArtifacts).anyMatch(a -> ArtifactIdUtils.toId((Artifact)a).equals(coords));
        boolean projectInNews = Stream.of(this.newArtifacts).anyMatch(a -> ArtifactIdUtils.toId((Artifact)a).equals(coords));
        return !projectInOlds && !projectInNews || this.project.getArtifact().getArtifactHandler().isAddedToClasspath();
    }

    private boolean initializeComparisonGavs() {
        if (this.newGavs != null && this.newGavs.length == 1 && "BUILD".equals(this.newGavs[0])) {
            this.log.warn((CharSequence)"\"BUILD\" coordinates are deprecated. Just leave \"newArtifacts\" undefined and specify \"${project.version}\" as the value for \"newVersion\" (which is the default, so you don't actually have to do that either).");
            this.oldGavs = null;
        }
        if (this.oldGavs == null || this.oldGavs.length == 0) {
            this.oldGavs = new String[]{Analyzer.getProjectArtifactCoordinates(this.project, this.oldVersion)};
            if (!this.project.getArtifact().getArtifactHandler().isAddedToClasspath()) {
                return false;
            }
        }
        if (this.newGavs == null || this.newGavs.length == 0) {
            this.newGavs = new String[]{Analyzer.getProjectArtifactCoordinates(this.project, this.newVersion)};
            if (!this.project.getArtifact().getArtifactHandler().isAddedToClasspath()) {
                return false;
            }
        }
        return true;
    }

    private static Supplier<Revapi.Builder> getDisallowedExtensionsAwareRevapiConstructor(List<String> disallowedExtensions2) {
        return () -> {
            Revapi.Builder bld = Revapi.builder();
            ArrayList analyzers = new ArrayList();
            ArrayList filters = new ArrayList();
            ArrayList transforms = new ArrayList();
            ArrayList reporters = new ArrayList();
            AnalyzerBuilder.addAllAllowed(analyzers, ServiceTypeLoader.load(ApiAnalyzer.class), disallowedExtensions2);
            AnalyzerBuilder.addAllAllowed(filters, ServiceTypeLoader.load(ElementFilter.class), disallowedExtensions2);
            AnalyzerBuilder.addAllAllowed(transforms, ServiceTypeLoader.load(DifferenceTransform.class), disallowedExtensions2);
            AnalyzerBuilder.addAllAllowed(reporters, ServiceTypeLoader.load(Reporter.class), disallowedExtensions2);
            ArrayList castTransforms = transforms;
            bld.withAnalyzers(analyzers).withFilters(filters).withTransforms(castTransforms).withReporters(reporters);
            return bld;
        };
    }

    private static <T> void addAllAllowed(List<Class<? extends T>> list, Iterable<Class<? extends T>> candidates, List<String> disallowedClassNames) {
        for (Class<T> c : candidates) {
            if (c == null || disallowedClassNames.contains(c.getName())) continue;
            list.add(c);
        }
    }

    static class Result {
        boolean skip;
        boolean isOnClasspath;
        String[] oldArtifacts;
        String[] newArtifacts;
        Analyzer analyzer;

        private Result() {
        }
    }
}

