/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import java.io.File;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.revapi.API;
import org.revapi.AnalysisResult;
import org.revapi.Revapi;
import org.revapi.maven.Analyzer;
import org.revapi.maven.AnalyzerBuilder;
import org.revapi.maven.ReportMojo;
import org.revapi.maven.ReportTimeReporter;
import org.revapi.maven.utils.ArtifactResolver;
import org.revapi.maven.utils.ScopeDependencySelector;
import org.revapi.maven.utils.ScopeDependencyTraverser;

@Mojo(name="report-aggregate", aggregator=true, defaultPhase=LifecyclePhase.SITE)
@Execute(phase=LifecyclePhase.PACKAGE)
public class ReportAggregateMojo
extends ReportMojo {
    @Component
    private MavenSession mavenSession;

    @Override
    public String getOutputName() {
        return "revapi-aggregate-report";
    }

    public File getReportOutputDirectory() {
        return new File(this.mavenSession.getTopLevelProject().getBasedir(), "target/site");
    }

    @Override
    protected String getOutputDirectory() {
        return this.getReportOutputDirectory().getAbsolutePath();
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        super.setReportOutputDirectory(this.getReportOutputDirectory());
    }

    @Override
    public String getDescription(Locale locale) {
        return null;
    }

    @Override
    public boolean canGenerateReport() {
        return "pom".equals(this.project.getArtifact().getArtifactHandler().getPackaging());
    }

    @Override
    protected void executeReport(Locale locale) throws MavenReportException {
        if (this.skip) {
            return;
        }
        if (!this.canGenerateReport()) {
            return;
        }
        List dependents = this.mavenSession.getProjectDependencyGraph().getDownstreamProjects(this.project, true);
        Collections.sort(dependents, (a, b) -> {
            String as = a.getArtifact().toString();
            String bs = b.getArtifact().toString();
            return as.compareTo(bs);
        });
        Map projectVersions = dependents.stream().collect(Collectors.toMap(Function.identity(), this::getRunConfig));
        projectVersions.put(this.project, this.getRunConfig(this.project));
        ResourceBundle messages = this.getBundle(locale);
        Sink sink = this.getSink();
        if (this.generateSiteReport) {
            this.startReport(sink, messages);
        }
        try {
            Analyzer topAnalyzer = this.prepareAnalyzer(null, this.project, locale, projectVersions.get(this.project));
            Revapi sharedRevapi = topAnalyzer == null ? null : topAnalyzer.getRevapi();
            for (MavenProject p : dependents) {
                Analyzer projectAnalyzer = this.prepareAnalyzer(sharedRevapi, p, locale, projectVersions.get(p));
                if (projectAnalyzer == null) continue;
                AnalysisResult res = projectAnalyzer.analyze();
                Throwable throwable = null;
                try {
                    res.throwIfFailed();
                    ReportTimeReporter reporter = (ReportTimeReporter)res.getExtensions().getFirstExtension(ReportTimeReporter.class, null);
                    if (!this.generateSiteReport || reporter == null) continue;
                    this.reportBody(reporter, projectAnalyzer.getResolvedOldApi(), projectAnalyzer.getResolvedNewApi(), sink, messages);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (res == null) continue;
                    if (throwable != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    res.close();
                }
            }
            if (this.generateSiteReport) {
                this.endReport(sink);
            }
        }
        catch (Exception e) {
            throw new MavenReportException("Failed to generate the report.", e);
        }
    }

    @Override
    protected void reportBody(ReportTimeReporter reporterWithResults, API oldAPI, API newAPI, Sink sink, ResourceBundle messages) {
        if (oldAPI == null || newAPI == null) {
            return;
        }
        sink.section2();
        sink.sectionTitle2();
        String title = messages.getString("report.revapi.aggregate.subTitle");
        sink.rawText(MessageFormat.format(title, this.niceList(oldAPI.getArchives()), this.niceList(newAPI.getArchives())));
        sink.sectionTitle2_();
        super.reportBody(reporterWithResults, oldAPI, newAPI, sink, messages);
        sink.section2_();
    }

    private ProjectVersions getRunConfig(MavenProject project) {
        String versionRegexString;
        String newVersion2;
        ProjectVersions ret = new ProjectVersions();
        Plugin revapiPlugin = ReportAggregateMojo.findRevapi(project);
        if (revapiPlugin == null) {
            return ret;
        }
        Xpp3Dom pluginConfig = (Xpp3Dom)revapiPlugin.getConfiguration();
        String[] oldArtifacts2 = ReportAggregateMojo.getArtifacts(pluginConfig, "oldArtifacts");
        String[] newArtifacts2 = ReportAggregateMojo.getArtifacts(pluginConfig, "newArtifacts");
        String oldVersion2 = ReportAggregateMojo.getValueOfChild(pluginConfig, "oldVersion");
        if (oldVersion2 == null) {
            oldVersion2 = System.getProperties().getProperty("revapi.oldVersion", "RELEASE");
        }
        if ((newVersion2 = ReportAggregateMojo.getValueOfChild(pluginConfig, "newVersion")) == null) {
            newVersion2 = System.getProperties().getProperty("revapi.newVersion", project.getVersion());
        }
        String defaultOldArtifact = Analyzer.getProjectArtifactCoordinates(project, oldVersion2);
        String defaultNewArtifact = Analyzer.getProjectArtifactCoordinates(project, newVersion2);
        if (oldArtifacts2 == null || oldArtifacts2.length == 0) {
            if (!project.getArtifact().getArtifactHandler().isAddedToClasspath()) {
                return ret;
            }
            oldArtifacts2 = new String[]{defaultOldArtifact};
        }
        if (newArtifacts2 == null || newArtifacts2.length == 0) {
            if (!project.getArtifact().getArtifactHandler().isAddedToClasspath()) {
                return ret;
            }
            newArtifacts2 = new String[]{defaultNewArtifact};
        }
        Pattern versionRegex = (versionRegexString = ReportAggregateMojo.getValueOfChild(pluginConfig, "versionFormat")) == null ? null : Pattern.compile(versionRegexString);
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(this.repositorySystemSession);
        session.setDependencySelector((DependencySelector)new ScopeDependencySelector(new String[]{"compile", "provided"}));
        session.setDependencyTraverser((DependencyTraverser)new ScopeDependencyTraverser(new String[]{"compile", "provided"}));
        if (this.alwaysCheckForReleaseVersion) {
            session.setUpdatePolicy("always");
        }
        ArtifactResolver resolver = new ArtifactResolver(this.repositorySystem, (RepositorySystemSession)session, this.mavenSession.getCurrentProject().getRemoteProjectRepositories());
        Function<String, Artifact> resolve = gav -> {
            try {
                return Analyzer.resolveConstrained(project, gav, versionRegex, resolver);
            }
            catch (ArtifactResolutionException | VersionRangeResolutionException e) {
                this.getLog().warn((CharSequence)("Could not resolve artifact '" + gav + "' with message: " + e.getMessage()));
                return null;
            }
        };
        ret.oldGavs = (Artifact[])Stream.of(oldArtifacts2).map(resolve).filter(f -> f != null).toArray(Artifact[]::new);
        ret.newGavs = (Artifact[])Stream.of(newArtifacts2).map(resolve).filter(f -> f != null).toArray(Artifact[]::new);
        return ret;
    }

    private Analyzer prepareAnalyzer(Revapi revapi, MavenProject project, Locale locale, ProjectVersions storedVersions) {
        Plugin runPluginConfig = ReportAggregateMojo.findRevapi(project);
        if (runPluginConfig == null) {
            return null;
        }
        Xpp3Dom runConfig = (Xpp3Dom)runPluginConfig.getConfiguration();
        Artifact[] oldArtifacts2 = storedVersions.oldGavs;
        Artifact[] newArtifacts2 = storedVersions.newGavs;
        if (oldArtifacts2 == null || oldArtifacts2.length == 0 || newArtifacts2 == null || newArtifacts2.length == 0) {
            return null;
        }
        boolean failOnMissingConfigurationFiles2 = false;
        boolean failOnMissingArchives = false;
        boolean failOnMissingSupportArchives = false;
        boolean alwaysUpdate = true;
        boolean resolveDependencies = true;
        String versionRegex = ReportAggregateMojo.getValueOfChild(runConfig, "versionFormat");
        AnalyzerBuilder bld = AnalyzerBuilder.forArtifacts(oldArtifacts2, newArtifacts2).withAlwaysCheckForReleasedVersion(alwaysUpdate).withAnalysisConfiguration(this.analysisConfiguration).withAnalysisConfigurationFiles(this.analysisConfigurationFiles).withCheckDependencies(resolveDependencies).withResolveProvidedDependencies(this.resolveProvidedDependencies).withDisallowedExtensions(this.disallowedExtensions).withFailOnMissingConfigurationFiles(failOnMissingConfigurationFiles2).withFailOnUnresolvedArtifacts(failOnMissingArchives).withFailOnUnresolvedDependencies(failOnMissingSupportArchives).withLocale(locale).withLog(this.getLog()).withProject(project).withRepositorySystem(this.repositorySystem).withRepositorySystemSession(this.repositorySystemSession).withSkip(this.skip).withVersionFormat(versionRegex);
        bld = revapi == null ? bld.withReporter(ReportTimeReporter.class) : bld.withRevapiInstance(revapi);
        HashMap<String, Object> contextData = new HashMap<String, Object>(1);
        contextData.put("org.revapi.maven.report.minSeverity", this.reportSeverity.asDifferenceSeverity());
        bld.withContextData(contextData);
        return bld.build().analyzer;
    }

    protected static Plugin findRevapi(MavenProject project) {
        return project.getBuildPlugins().stream().filter(p -> "org.revapi:revapi-maven-plugin".equals(p.getKey())).findAny().orElse(null);
    }

    protected static String[] getArtifacts(Xpp3Dom config, String artifactTag) {
        Xpp3Dom oldArtifactsXml;
        Xpp3Dom xpp3Dom = oldArtifactsXml = config == null ? null : config.getChild(artifactTag);
        if (oldArtifactsXml == null) {
            return new String[0];
        }
        if (oldArtifactsXml.getChildCount() == 0) {
            String artifact = oldArtifactsXml.getValue();
            return new String[]{artifact};
        }
        String[] ret = new String[oldArtifactsXml.getChildCount()];
        for (int i = 0; i < oldArtifactsXml.getChildCount(); ++i) {
            ret[i] = oldArtifactsXml.getChild(i).getValue();
        }
        return ret;
    }

    private static String getValueOfChild(Xpp3Dom element, String childName) {
        Xpp3Dom child = element == null ? null : element.getChild(childName);
        return child == null ? null : child.getValue();
    }

    private static final class ProjectVersions {
        Artifact[] oldGavs;
        Artifact[] newGavs;

        private ProjectVersions() {
        }
    }
}

