/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import java.io.Reader;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.AnalysisContext;
import org.revapi.CompatibilityType;
import org.revapi.Difference;
import org.revapi.DifferenceSeverity;
import org.revapi.Element;
import org.revapi.Report;
import org.revapi.Reporter;

public final class ReportTimeReporter
implements Reporter {
    static final String MIN_SEVERITY_KEY = "org.revapi.maven.report.minSeverity";
    private DifferenceSeverity minSeverity;
    EnumMap<DifferenceSeverity, EnumMap<CompatibilityType, List<DifferenceReport>>> reportsBySeverity = new EnumMap(DifferenceSeverity.class);

    public void report(@Nonnull Report report) {
        for (Difference d : report.getDifferences()) {
            this.addDifference(report.getOldElement(), report.getNewElement(), d);
        }
    }

    public void close() throws Exception {
    }

    @Nullable
    public String getExtensionId() {
        return null;
    }

    @Nullable
    public Reader getJSONSchema() {
        return null;
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        this.reportsBySeverity.clear();
        this.minSeverity = (DifferenceSeverity)analysisContext.getData(MIN_SEVERITY_KEY);
    }

    private void addDifference(Element oldElement, Element newElement, Difference difference) {
        for (Map.Entry cls : difference.classification.entrySet()) {
            List<DifferenceReport> reps;
            if (((DifferenceSeverity)cls.getValue()).compareTo((Enum)this.minSeverity) < 0) continue;
            EnumMap<CompatibilityType, List<DifferenceReport>> sevReports = this.reportsBySeverity.get(cls.getValue());
            if (sevReports == null) {
                sevReports = new EnumMap(CompatibilityType.class);
                this.reportsBySeverity.put((DifferenceSeverity)cls.getValue(), sevReports);
            }
            if ((reps = sevReports.get(cls.getKey())) == null) {
                reps = new ArrayList<DifferenceReport>();
                sevReports.put((CompatibilityType)cls.getKey(), reps);
            }
            reps.add(new DifferenceReport(oldElement, newElement, difference));
        }
    }

    public static class DifferenceReport {
        final Element oldElement;
        final Element newElement;
        final Difference difference;

        private DifferenceReport(Element oldElement, Element newElement, Difference difference) {
            this.oldElement = oldElement;
            this.newElement = newElement;
            this.difference = difference;
        }
    }
}

