/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.ant.dbupgrade;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import mazz.i18n.Msg;
import org.apache.tools.ant.BuildException;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.OracleDatabaseType;
import org.rhq.core.db.PostgresqlDatabaseType;
import org.rhq.core.db.ant.DbAntI18NFactory;
import org.rhq.core.db.ant.dbupgrade.SchemaSpecTask;
import org.rhq.core.util.StringUtil;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.jdbc.JDBCUtil;

public class SST_DropForeignKeys
extends SchemaSpecTask {
    private static final Msg MSG = DbAntI18NFactory.getMsg();
    private static final String FIND_FOREIGN_KEYS_ORACLE = "SELECT   a.constraint_name FROM all_cons_columns a   JOIN all_constraints c ON a.owner = c.owner                             AND a.constraint_name = c.constraint_name   JOIN all_constraints c_pk ON c.r_owner = c_pk.owner                                AND c.r_constraint_name = c_pk.constraint_name WHERE c.constraint_type = 'R'       AND a.table_name = ?       AND a.column_name = ?";
    private static final String FIND_FOREIGN_KEYS_POSTGRES = "SELECT   tc.constraint_name FROM   information_schema.table_constraints tc   JOIN information_schema.key_column_usage kcu     ON tc.constraint_name = kcu.constraint_name WHERE tc.constraint_type = 'FOREIGN KEY' AND tc.table_name = ?       AND kcu.column_name = ?";
    private String table;
    private String column;

    public void execute() throws BuildException {
        Set<String> foreignKeys;
        if (!this.isDBTargeted()) {
            return;
        }
        this.validateAttributes();
        DatabaseType databaseType = this.getDatabaseType();
        if (databaseType instanceof OracleDatabaseType) {
            foreignKeys = this.findForeignKeys(FIND_FOREIGN_KEYS_ORACLE, this.table.toUpperCase(Locale.US), this.column.toUpperCase(Locale.US));
        } else if (databaseType instanceof PostgresqlDatabaseType) {
            foreignKeys = this.findForeignKeys(FIND_FOREIGN_KEYS_POSTGRES, this.table.toLowerCase(Locale.US), this.column.toLowerCase(Locale.US));
        } else {
            String msg = MSG.getMsg("SchemaSpecTask.altercolumn.error", new Object[]{databaseType});
            if (!this.isIgnoreError()) {
                this.log(msg, 1);
                return;
            }
            throw new BuildException(msg);
        }
        for (String foreignKey : foreignKeys) {
            this.dropForeignKey(foreignKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> findForeignKeys(String query, String tableParam, String columnParam) {
        HashSet<String> foreignKeys;
        block7: {
            foreignKeys = new HashSet<String>();
            PreparedStatement statement = null;
            ResultSet resultSet = null;
            try {
                statement = this.getConnection().prepareStatement(query);
                statement.setString(1, tableParam);
                statement.setString(2, columnParam);
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    foreignKeys.add(resultSet.getString(1));
                }
                JDBCUtil.safeClose((Statement)statement, (ResultSet)resultSet);
            }
            catch (SQLException e) {
                if (!this.isIgnoreError()) {
                    this.log(ThrowableUtil.getAllSqlExceptionMessages((SQLException)e), 1);
                    break block7;
                }
                throw new BuildException((Throwable)e);
            }
            finally {
                JDBCUtil.safeClose((Statement)statement, resultSet);
            }
        }
        return foreignKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropForeignKey(String foreignKey) {
        block6: {
            Statement statement = null;
            try {
                String sql = "ALTER TABLE " + this.table + " DROP CONSTRAINT " + foreignKey;
                this.log(sql, 2);
                statement = this.getConnection().createStatement();
                statement.executeUpdate(sql);
                JDBCUtil.safeClose((Statement)statement);
            }
            catch (SQLException e) {
                if (!this.isIgnoreError()) {
                    this.log(ThrowableUtil.getAllSqlExceptionMessages((SQLException)e), 1);
                    break block6;
                }
                throw new BuildException((Throwable)e);
            }
            finally {
                JDBCUtil.safeClose(statement);
            }
        }
    }

    private void validateAttributes() throws BuildException {
        if (StringUtil.isBlank((String)this.table)) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.missing-attrib", new Object[]{"DropForeignKeys", "table"}));
        }
        if (StringUtil.isBlank((String)this.column)) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.missing-attrib", new Object[]{"DropForeignKeys", "column"}));
        }
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setColumn(String column) {
        this.column = column;
    }
}

