/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.ant.dbupgrade;

import java.sql.Connection;
import java.sql.SQLException;
import mazz.i18n.Msg;
import org.apache.tools.ant.BuildException;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.ant.DbAntI18NFactory;
import org.rhq.core.db.ant.dbupgrade.SchemaSpecTask;

public class SST_DropTable
extends SchemaSpecTask {
    private static final Msg MSG = DbAntI18NFactory.getMsg();
    private String table = null;

    public void setTable(String t) {
        this.table = t;
    }

    public void execute() throws BuildException {
        if (!this.isDBTargeted()) {
            return;
        }
        this.validateAttributes();
        DatabaseType db_type = this.getDatabaseType();
        Connection conn = this.getConnection();
        try {
            boolean table_exists = db_type.checkTableExists(conn, this.table);
            if (!table_exists) {
                this.log(MSG.getMsg("SchemaSpecTask.droptable.table-does-not-exist", new Object[]{this.table}));
                return;
            }
            this.log(MSG.getMsg("SchemaSpecTask.droptable.executing", new Object[]{this.table}));
            db_type.dropTable(conn, this.table);
        }
        catch (IllegalStateException e) {
            this.log(MSG.getMsg("SchemaSpecTask.droptable.table-does-not-exist", new Object[]{this.table}));
            if (this.isIgnoreError()) {
                try {
                    conn.rollback();
                }
                catch (SQLException e2) {
                    this.log("rollback() exception: " + e2.toString());
                }
            }
            return;
        }
        catch (Exception e) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.droptable.error", new Object[]{this.table, e}), (Throwable)e);
        }
    }

    private void validateAttributes() throws BuildException {
        if (this.table == null) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.missing-attrib", new Object[]{"DropTable", "table"}));
        }
    }
}

