/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.upgrade;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.util.jdbc.JDBCUtil;

public class ServerVersionColumnUpgrader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upgrade(Connection connection, String version) throws Exception {
        PreparedStatement preparedStatement;
        block2: {
            boolean bl;
            preparedStatement = null;
            try {
                DatabaseType db = DatabaseTypeFactory.getDatabaseType(connection);
                if (db.checkColumnExists(connection, "RHQ_SERVER", "VERSION")) break block2;
                db.addColumn(connection, "RHQ_SERVER", "VERSION", "VARCHAR2", "255");
                preparedStatement = connection.prepareStatement("UPDATE RHQ_SERVER SET VERSION = ?");
                preparedStatement.setString(1, "PRE-" + version);
                preparedStatement.executeUpdate();
                db.closeStatement(preparedStatement);
                db.alterColumn(connection, "RHQ_SERVER", "VERSION", "VARCHAR2", null, "255", false, false);
                bl = true;
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(null, preparedStatement, null);
                throw throwable;
            }
            JDBCUtil.safeClose(null, (Statement)preparedStatement, null);
            return bl;
        }
        JDBCUtil.safeClose(null, preparedStatement, null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setVersionForServerWithName(Connection connection, String version, String name) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("UPDATE RHQ_SERVER SET VERSION = ? WHERE NAME = ?");
            preparedStatement.setString(1, version);
            preparedStatement.setString(2, name);
            int n = preparedStatement.executeUpdate();
            return n;
        }
        finally {
            JDBCUtil.safeClose(null, (Statement)preparedStatement, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setVersionForAllServers(Connection connection, String version) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("UPDATE RHQ_SERVER SET VERSION = ?");
            preparedStatement.setString(1, version);
            int n = preparedStatement.executeUpdate();
            return n;
        }
        finally {
            JDBCUtil.safeClose(null, (Statement)preparedStatement, null);
        }
    }
}

