/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.upgrade;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.upgrade.DatabaseUpgradeTask;
import org.rhq.core.util.obfuscation.Obfuscator;

public class SystemSettingsPasswordObfuscationTask
implements DatabaseUpgradeTask {
    @Override
    public void execute(DatabaseType type, Connection connection) throws SQLException {
        this.updatePasswordField(type, connection, "CAM_LDAP_BIND_PW", "CAM_HELP_PASSWORD");
    }

    private void updatePasswordField(DatabaseType type, Connection connection, String ... names) throws SQLException {
        String sql = "SELECT id, property_value, default_property_value FROM rhq_system_config WHERE property_key IN (";
        for (String name : names) {
            sql = sql + "'" + name + "', ";
        }
        if (names.length > 0) {
            sql = sql.substring(0, sql.length() - 2);
        }
        sql = sql + ")";
        List<Object[]> results = type.executeSelectSql(connection, sql);
        for (Object[] row : results) {
            Number settingId = (Number)row[0];
            String value = (String)row[1];
            String defaultValue = (String)row[2];
            if (value == null && defaultValue == null) continue;
            sql = "UPDATE rhq_system_config SET ";
            try {
                if (value != null) {
                    value = Obfuscator.encode((String)value);
                    sql = sql + "property_value = '" + value + "'";
                }
                if (defaultValue != null) {
                    defaultValue = Obfuscator.encode((String)defaultValue);
                    sql = sql + (value != null ? ", " : "") + "default_property_value = '" + defaultValue + "'";
                }
            }
            catch (Exception e) {
                throw new SQLException("Failed to obfuscate password system settings.", e);
            }
            sql = sql + " WHERE id = " + settingId;
            try {
                type.executeSql(connection, sql);
            }
            catch (SQLException e) {
                throw new SQLException("Failed to update the password field. The SQL statement was: " + sql, e);
            }
        }
    }
}

